/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.data.WizardData;
import com.cognos.crconfig.data.WizardOption;
import com.cognos.crconfig.data.WizardPageData;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class WizardComplexPageData
extends WizardData {
    private String m_sDependencyComplexPage;
    private String m_sDependencyGroup;
    private String m_sDependencyPage;
    private ArrayList m_lOptions = new ArrayList();
    private ArrayList m_lCases = new ArrayList();

    public WizardComplexPageData(String name, String label) {
        this.setName(name);
        this.setLabel(label);
        this.m_sDependencyComplexPage = "";
        this.m_sDependencyGroup = "";
        this.m_sDependencyPage = "";
    }

    private void setDependencyInfo(String dependComplexPage, String dependGroup, String dependPage) {
        this.m_sDependencyComplexPage = dependComplexPage;
        this.m_sDependencyGroup = dependGroup;
        this.m_sDependencyPage = dependPage;
    }

    private void loadOption(Element elem) {
        WizardOption wOption = new WizardOption();
        wOption.loadChildren(elem);
        this.m_lOptions.add(wOption);
    }

    private void loadCase(Element elem) {
        WizardOption wOption = new WizardOption();
        wOption.loadChildren(elem);
        this.m_lCases.add(wOption);
    }

    public String getDependencyComplexPage() {
        return this.m_sDependencyComplexPage;
    }

    public String getDependencyGroup() {
        return this.m_sDependencyGroup;
    }

    public String getDependencyPage() {
        return this.m_sDependencyPage;
    }

    public ArrayList getOptionsList() {
        return this.m_lOptions;
    }

    public ArrayList getCasesList() {
        return this.m_lCases;
    }

    public boolean hasCases() {
        return this.m_lCases.size() > 0;
    }

    public boolean hasWizParams() {
        WizardOption op;
        for (int i = 0; i < this.m_lOptions.size(); ++i) {
            op = (WizardOption)this.m_lOptions.get(i);
            if (!op.hasWizParams()) continue;
            return true;
        }
        for (int j = 0; j < this.m_lCases.size(); ++j) {
            op = (WizardOption)this.m_lCases.get(j);
            if (!op.hasWizParams()) continue;
            return true;
        }
        return false;
    }

    public WizardPageData checkWizardPage(String complexPageName, String groupName, String name) {
        if (complexPageName.equals(this.m_sName)) {
            WizardPageData wPage;
            WizardOption wOption;
            int i;
            for (i = 0; i < this.m_lOptions.size(); ++i) {
                wOption = (WizardOption)this.m_lOptions.get(i);
                wPage = wOption.checkWizardPage(complexPageName, groupName, name);
                if (wPage == null) continue;
                return wPage;
            }
            for (i = 0; i < this.m_lCases.size(); ++i) {
                wOption = (WizardOption)this.m_lCases.get(i);
                wPage = wOption.checkWizardPage(complexPageName, groupName, name);
                if (wPage == null) continue;
                return wPage;
            }
        }
        return null;
    }

    public void loadChildren(Element elem) {
        List lChildElems = elem.elements();
        for (int i = 0; i < lChildElems.size(); ++i) {
            Element childElem = (Element)lChildElems.get(i);
            if (childElem.getQName().getName().equals("dependency")) {
                String sDependComplexPageName = childElem.attributeValue("complexPage", "");
                String sDependGroupName = childElem.attributeValue("group", "");
                String sDependPageName = childElem.attributeValue("page", "");
                this.setDependencyInfo(sDependComplexPageName, sDependGroupName, sDependPageName);
            }
            if (childElem.getQName().getName().equals("wizOption")) {
                this.loadOption(childElem);
            }
            if (!childElem.getQName().getName().equals("wizCase")) continue;
            this.loadCase(childElem);
        }
    }

    public ArrayList getValidWizardPages(WizardPageData wpData) {
        for (int i = 0; i < this.m_lOptions.size(); ++i) {
            WizardOption wOption = (WizardOption)this.m_lOptions.get(i);
            if (!wOption.validate(wpData)) continue;
            return wOption.getWizardPageList();
        }
        return null;
    }

    public WizardOption getValidWizardCase(WizardPageData wpData, int beginIndex) {
        for (int i = beginIndex; i < this.m_lCases.size(); ++i) {
            WizardOption wOption = (WizardOption)this.m_lCases.get(i);
            if (!wOption.validate(wpData)) continue;
            return wOption;
        }
        return null;
    }

    public void reloadData(boolean bReloadParamRef) {
        WizardOption wOption;
        int i;
        for (i = 0; i < this.m_lOptions.size(); ++i) {
            wOption = (WizardOption)this.m_lOptions.get(i);
            wOption.reloadData(bReloadParamRef);
        }
        for (i = 0; i < this.m_lCases.size(); ++i) {
            wOption = (WizardOption)this.m_lCases.get(i);
            wOption.reloadData(bReloadParamRef);
        }
    }
}

