/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.data.Constants;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.WizardParameterData;
import com.cognos.crconfig.data.WizardTemplatedParameterData;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class WizardOption
extends Constants {
    private ArrayList m_lValidationConditions = new ArrayList();
    private ArrayList m_lWizardPages = new ArrayList();

    private void addCondition(String name, String value, boolean checkAction) {
        WizardCondition condition = new WizardCondition(name, value, checkAction);
        this.m_lValidationConditions.add(condition);
    }

    private void addWizardPage(WizardPageData wizardPage) {
        this.m_lWizardPages.add(wizardPage);
    }

    public ArrayList getConditionList() {
        return this.m_lValidationConditions;
    }

    public ArrayList getWizardPageList() {
        return this.m_lWizardPages;
    }

    public boolean hasWizParams() {
        for (int i = 0; i < this.m_lWizardPages.size(); ++i) {
            WizardPageData wp = (WizardPageData)this.m_lWizardPages.get(i);
            if (!wp.hasWizParams()) continue;
            return true;
        }
        return false;
    }

    public boolean validate(WizardPageData wPage) {
        for (int i = 0; i < this.m_lValidationConditions.size(); ++i) {
            WizardCondition condition = (WizardCondition)this.m_lValidationConditions.get(i);
            if (condition.validate(wPage)) continue;
            return false;
        }
        return true;
    }

    public WizardPageData checkWizardPage(String complexPageName, String groupName, String name) {
        WizardPageData wPage;
        for (int i = 0; i < this.m_lWizardPages.size() && (wPage = (WizardPageData)this.m_lWizardPages.get(i)).getGroupName().equals(groupName); ++i) {
            if (!wPage.checkWizardPage(complexPageName, groupName, name)) continue;
            return wPage;
        }
        return null;
    }

    public void loadChildren(Element elem) {
        boolean isLastPage = false;
        List lChildElems = elem.elements();
        for (int i = 0; i < lChildElems.size(); ++i) {
            Element childElem = (Element)lChildElems.get(i);
            if (childElem.getQName().getName().equals("condition")) {
                String sName = childElem.attributeValue("paramName", "");
                String sValue = childElem.attributeValue("paramValue", "");
                boolean checkAction = false;
                String sCheckAction = childElem.attributeValue("action", "false");
                if (sCheckAction.equalsIgnoreCase("true")) {
                    checkAction = true;
                }
                this.addCondition(sName, sValue, checkAction);
            }
            if (!childElem.getQName().getName().equals("wizardPage")) continue;
            String sComplexPageName = childElem.attributeValue("complexPage", "");
            String sGroupName = childElem.attributeValue("group", "");
            String sName = childElem.attributeValue("name", "");
            String sLabel = CnfgUIDocResource.getMessage(childElem.attributeValue("label", ""), "config_wizard");
            String sIsLast = childElem.attributeValue("isLast", "");
            String sHelpFile = childElem.attributeValue("helpFile", "");
            isLastPage = sIsLast.equals("true");
            String sMaxParamPerPage = childElem.attributeValue("maxParamPerPage", "");
            int maxParam = 5;
            if (sMaxParamPerPage.length() != 0) {
                maxParam = new Integer(sMaxParamPerPage);
            }
            WizardPageData wPage = new WizardPageData(sComplexPageName, sGroupName, sName, sLabel, isLastPage, maxParam);
            wPage.setHelpFile(sHelpFile);
            wPage.loadChildren(childElem);
            this.addWizardPage(wPage);
        }
    }

    public void reloadData(boolean bReloadParamRef) {
        for (int i = 0; i < this.m_lWizardPages.size(); ++i) {
            WizardPageData wp = (WizardPageData)this.m_lWizardPages.get(i);
            wp.reloadData(bReloadParamRef);
        }
    }

    class WizardCondition {
        private String m_sParamName;
        private String m_sParamValue;
        private boolean m_bCheckAction;

        public WizardCondition(String name, String value, boolean checkAction) {
            this.m_sParamName = name;
            this.m_sParamValue = value;
            this.m_bCheckAction = checkAction;
        }

        public boolean validate(WizardPageData wPage) {
            if (this.m_bCheckAction) {
                boolean expectedState = true;
                if (this.m_sParamValue.equalsIgnoreCase("false")) {
                    expectedState = false;
                }
                if (this.m_sParamName.length() == 0) {
                    return wPage.getActionState() == 1 == expectedState;
                }
                ArrayList paramList = wPage.getWizardTParamList();
                for (int i = 0; i < paramList.size(); ++i) {
                    WizardTemplatedParameterData wParam = (WizardTemplatedParameterData)paramList.get(i);
                    if (!wParam.getParam().getName().equals(this.m_sParamName)) continue;
                    return wParam.checkActionState() == expectedState;
                }
                return false;
            }
            ArrayList paramList = wPage.getWizardParamList();
            for (int i = 0; i < paramList.size(); ++i) {
                WizardParameterData wParam = (WizardParameterData)paramList.get(i);
                if (!wParam.getParam().getName().equals(this.m_sParamName)) continue;
                Object paramValue = wParam.getParam().getValue();
                return paramValue != null && paramValue.toString().equals(this.m_sParamValue);
            }
            return false;
        }
    }
}

