/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.data.AbstractData;
import com.cognos.crconfig.data.BooleanParameter;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Group;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.WizardActionTarget;
import com.cognos.crconfig.data.WizardData;
import com.cognos.crconfig.data.WizardParameterData;
import com.cognos.crconfig.data.WizardTemplatedParameterData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class WizardPageData
extends WizardData
implements Cloneable {
    protected String m_sHelpFileName;
    protected String m_sComplexPageName;
    protected String m_sGroupName;
    protected ArrayList m_lOverViews = new ArrayList();
    protected ArrayList m_lActionTargets = new ArrayList();
    protected ArrayList m_lWizardParams = new ArrayList();
    protected ArrayList m_lWizardTemplatedParams = new ArrayList();
    protected int m_maxNumOfParam;
    protected boolean m_bIsLast;
    protected String m_sTransitWizardName = "";
    protected Folder m_instanceFolder = null;
    protected String m_sInstanceType = null;
    protected String m_sInstanceLabel = null;
    private int m_iActionState = 0;
    private boolean m_bActionsOnly;

    public WizardPageData(String name, String label, boolean isLast, int maxParamPerPage) {
        this.setName(name);
        this.setLabel(label);
        this.m_bIsLast = isLast;
        this.m_sGroupName = "";
        this.m_sComplexPageName = "";
        this.m_maxNumOfParam = maxParamPerPage;
    }

    public WizardPageData(String complexPage, String group, String name, String label, boolean isLast, int maxParamPerPage) {
        this.setName(name);
        this.setLabel(label);
        this.m_sComplexPageName = complexPage;
        this.m_sGroupName = group;
        this.m_bIsLast = isLast;
        this.m_maxNumOfParam = maxParamPerPage;
    }

    public WizardPageData(WizardPageData parentPage) {
        this.loadPageInfo(parentPage);
    }

    public WizardPageData(WizardPageData parentPage, Folder f, boolean bRunAction) {
        this.loadPageInfo(parentPage);
        this.setName(f.getName());
        this.setInstFolder(f);
        this.addOverView(f.getDesc(), "description");
        AbstractData opt = null;
        List<Parameter> lParams = f.getParameters();
        for (int j = 0; j < lParams.size(); ++j) {
            Parameter obj = lParams.get(j);
            if (TemplatedParameter.class.isInstance(obj)) {
                TemplatedParameter tParam = (TemplatedParameter)obj;
                if (tParam.getValue() == null) continue;
                String sVal = tParam.getValue().toString();
                this.setInstType(sVal);
                opt = tParam.getOption(sVal);
                if (opt == null) continue;
                this.setInstLabel(opt.getLabel());
                continue;
            }
            if (Group.class.isInstance(obj) || !Parameter.class.isInstance(obj)) continue;
            Parameter param = obj;
            if (param.isActionParam()) {
                this.addActionParam(param, null, false);
                continue;
            }
            this.addParam("", param, false);
        }
        if (bRunAction && opt != null) {
            ArrayList<CnfgActionOld> actionList = opt.getActions();
            for (int k = 0; k < actionList.size(); ++k) {
                CnfgActionOld action = actionList.get(k);
                if (action == null) continue;
                BooleanParameter p = new BooleanParameter("http://www.w3.org/2001/XMLSchema", "string");
                p.setFireValueChanged(false);
                p.m_sName = "action_" + action.getName();
                p.m_sLabel = action.getLabel();
                p.m_sHelp = action.getHelp();
                p.m_sDesc = action.getDesc();
                ((Parameter)p).setValue(new Boolean(true));
                this.addActionParam(p, action, true);
            }
        }
        ArrayList<TemplatedParameter> lTParams = f.getTParameters();
        for (int j = 0; j < lTParams.size(); ++j) {
            TemplatedParameter tp = lTParams.get(j);
            this.loadTemplatedParam("", tp, false, bRunAction, null, false);
        }
    }

    private void loadPageInfo(WizardPageData parentPage) {
        this.setName(parentPage.getName());
        this.setLabel(parentPage.getLabel());
        this.setMaxNumOfParam(parentPage.getMaxNumOfParam());
        this.setHelpFile(parentPage.getHelpFile());
        ArrayList<WizardOverView> lov = new ArrayList<WizardOverView>();
        for (int i = 0; i < parentPage.getOverViewList().size(); ++i) {
            WizardOverView ov = (WizardOverView)parentPage.getOverViewList().get(i);
            WizardOverView newOv = (WizardOverView)ov.clone();
            lov.add(newOv);
        }
        this.m_lOverViews = lov;
    }

    public String getComplexPageName() {
        return this.m_sComplexPageName;
    }

    public String getGroupName() {
        return this.m_sGroupName;
    }

    public ArrayList getWizardParamList() {
        return this.m_lWizardParams;
    }

    public void setWizardParamList(ArrayList paramList) {
        this.m_lWizardParams = paramList;
    }

    public ArrayList getWizardTParamList() {
        return this.m_lWizardTemplatedParams;
    }

    public ArrayList getOverViewList() {
        return this.m_lOverViews;
    }

    public void setOverViewList(ArrayList ovList) {
        this.m_lOverViews = ovList;
    }

    public ArrayList getActionTargetList() {
        return this.m_lActionTargets;
    }

    public boolean getIsLast() {
        return this.m_bIsLast;
    }

    public String getInstType() {
        return this.m_sInstanceType;
    }

    public String getInstLabel() {
        return this.m_sInstanceLabel;
    }

    public void setInstType(String type) {
        this.m_sInstanceType = type;
    }

    public void setInstLabel(String label) {
        this.m_sInstanceLabel = label;
    }

    public Folder getInstFolder() {
        return this.m_instanceFolder;
    }

    public void setInstFolder(Folder f) {
        this.m_instanceFolder = f;
    }

    public int getMaxNumOfParam() {
        return this.m_maxNumOfParam;
    }

    public void setMaxNumOfParam(int maxParam) {
        this.m_maxNumOfParam = maxParam;
    }

    public int getActionState() {
        return this.m_iActionState;
    }

    public void setActionState(int state) {
        this.m_iActionState = state;
    }

    public boolean isActionsOnly() {
        return this.m_bActionsOnly;
    }

    public String getHelpFile() {
        return this.m_sHelpFileName;
    }

    public void setHelpFile(String filename) {
        this.m_sHelpFileName = filename;
    }

    public void setTransitWizardName(String sWizName) {
        this.m_sTransitWizardName = sWizName;
    }

    public boolean isTransitPage() {
        return this.m_sTransitWizardName != null && this.m_sTransitWizardName.length() > 0;
    }

    public String getTransitWizName() {
        return this.m_sTransitWizardName;
    }

    public ArrayList getConfigParamList() {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        for (int i = 0; i < this.m_lWizardParams.size(); ++i) {
            Parameter param;
            WizardParameterData wparam = (WizardParameterData)this.m_lWizardParams.get(i);
            if (wparam.isActionParam() && wparam.getAction() != null || (param = wparam.getParam()) == null) continue;
            paramList.add(param);
        }
        return paramList;
    }

    public String toString() {
        return this.m_sName;
    }

    public boolean hasWizParams() {
        return this.m_lWizardParams.size() > 0 || this.m_lWizardTemplatedParams.size() > 0 || this.m_lActionTargets.size() > 0;
    }

    public void addOverView(String label, String style) {
        WizardOverView ov = new WizardOverView(label, style);
        this.m_lOverViews.add(ov);
    }

    public void setOverViewTitle(String label) {
        if (label.length() == 0) {
            return;
        }
        ArrayList ovList = this.getOverViewList();
        for (int i = 0; i < ovList.size(); ++i) {
            WizardOverView ov = (WizardOverView)ovList.get(i);
            if (!ov.getStyle().equals("title")) continue;
            ov.setLabel(label);
            return;
        }
        WizardOverView ov = new WizardOverView(label, "title");
        this.m_lOverViews.add(0, ov);
    }

    public void clearOverView() {
        this.m_lOverViews.clear();
    }

    public void addActionTarget(Element actionElem, boolean isAction) {
        WizardActionTarget target = new WizardActionTarget(actionElem, isAction);
        this.m_lActionTargets.add(target);
    }

    public WizardParameterData addParam(String style, Parameter param, boolean isWizardParam, Element elem) {
        WizardParameterData wParam = this.addParam(style, param, isWizardParam, false);
        wParam.updateEnums(elem);
        return wParam;
    }

    public WizardParameterData addParam(String style, Parameter param, boolean isWizardParam) {
        return this.addParam(style, param, isWizardParam, false);
    }

    public WizardParameterData addParam(String style, Parameter param, boolean isWizardParam, boolean runAction) {
        WizardParameterData wParam = new WizardParameterData(this, style, param, isWizardParam, runAction);
        this.m_lWizardParams.add(wParam);
        return wParam;
    }

    public WizardParameterData addActionParam(Parameter param, CnfgActionOld action, boolean isWizardParam, Element elem) {
        WizardParameterData wParam = this.addActionParam(param, action, isWizardParam);
        wParam.updateEnums(elem);
        return wParam;
    }

    public WizardParameterData addActionParam(Parameter param, CnfgActionOld action, boolean isWizardParam) {
        WizardParameterData wParam = new WizardParameterData(this, "", param, isWizardParam, false);
        wParam.setActionParam(true, action);
        boolean isAdded = false;
        for (int i = 0; i < this.m_lWizardParams.size(); ++i) {
            WizardParameterData wparam = (WizardParameterData)this.m_lWizardParams.get(i);
            if (wparam.isActionParam()) continue;
            this.m_lWizardParams.add(i, wParam);
            isAdded = true;
            break;
        }
        if (!isAdded) {
            this.m_lWizardParams.add(wParam);
        }
        return wParam;
    }

    public void updateParam(Parameter param, Element elem) {
        for (int i = 0; i < this.m_lWizardParams.size(); ++i) {
            WizardParameterData wParam = (WizardParameterData)this.m_lWizardParams.get(i);
            if (wParam.getParamRef() == null || param == null || !wParam.getParamRef().getName().equals(param.getName())) continue;
            wParam.updateEnums(elem);
        }
    }

    public WizardTemplatedParameterData addTemplatedParam(String style, TemplatedParameter tParam, boolean isWizardParam, boolean bRunAction, Element elem, boolean bParamRef) {
        WizardTemplatedParameterData wParam = new WizardTemplatedParameterData(this, style, tParam, isWizardParam, bRunAction, elem);
        wParam.setParamRef(bParamRef);
        this.m_lWizardTemplatedParams.add(wParam);
        return wParam;
    }

    public void loadTemplatedParam(String style, TemplatedParameter tParam, boolean isWizardParam, boolean bRunAction, Element elem, boolean bParamRef) {
        WizardTemplatedParameterData wParam = this.addTemplatedParam(style, tParam, isWizardParam, bRunAction, elem, bParamRef);
        if (wParam != null) {
            wParam.reloadTempData(false);
        }
    }

    public void updateTemplatedParam(TemplatedParameter tParam, Element elem) {
        for (int j = 0; j < this.m_lWizardTemplatedParams.size(); ++j) {
            WizardTemplatedParameterData wParam = (WizardTemplatedParameterData)this.m_lWizardTemplatedParams.get(j);
            if (wParam.getParamRef() != tParam) continue;
            wParam.loadUIInfo(elem);
            return;
        }
    }

    private void loadWizardAction(Element elem) {
        List lChildElems = elem.elements();
        for (int i = 0; i < lChildElems.size(); ++i) {
            Element childElem = (Element)lChildElems.get(i);
            if (childElem.getQName().getName().equals("target")) {
                this.addActionTarget(childElem, false);
            }
            if (!childElem.getQName().getName().equals("action")) continue;
            this.addActionTarget(childElem, true);
        }
    }

    private void loadWizardParamRef(Element elem) {
        String sRefID = elem.attributeValue("refID", "");
        if (sRefID.length() > 0) {
            String sLabel = null;
            if (elem.attribute("label") != null) {
                sLabel = elem.attributeValue("label", "");
            }
            String sDesc = null;
            if (elem.attribute("description") != null) {
                sDesc = elem.attributeValue("description", "");
            }
            String sStyle = elem.attributeValue("style", "");
            String sLayout = elem.attributeValue("layout", "");
            boolean bRunAction = false;
            String sAction = elem.attributeValue("action", "");
            if (sAction.equals("true")) {
                bRunAction = true;
            }
            Parameter p = DataManager.getInstance().findWizardParm(sRefID);
            WizardParameterData wParam = null;
            if (p != null && p.getDisabled()) {
                return;
            }
            wParam = TemplatedParameter.class.isInstance(p) ? this.addTemplatedParam(sStyle, (TemplatedParameter)p, false, bRunAction, elem, false) : this.addParam(sStyle, p, false, bRunAction);
            wParam.setLayoutSettings(sLayout);
            if (sLabel != null) {
                wParam.setParamLabel(sLabel);
            }
            if (sDesc != null) {
                wParam.setParamDesc(sDesc);
            }
            wParam.setParamRefID(sRefID);
        }
    }

    private void loadWizardParameter(Element elem) {
        String sDependencies = elem.attributeValue("dependency", "");
        if (!DataManager.getInstance().isInstalled(sDependencies)) {
            return;
        }
        Parameter p = DataManager.getInstance().createParameter(elem, "", "");
        if (p == null) {
            return;
        }
        if (p.load(null, elem)) {
            String sLabel = elem.attributeValue("label", "");
            p.setLabel(sLabel);
            Iterator itEnum = elem.elementIterator("enum");
            while (itEnum.hasNext()) {
                Element e = (Element)itEnum.next();
                String sEnumDependencies = e.attributeValue("dependency", "");
                if (!DataManager.getInstance().isInstalled(sEnumDependencies)) continue;
                String sTitle = e.attributeValue("label", "");
                String sValue = e.attributeValue("value");
                p.m_values.put(sValue, sTitle);
            }
            String sStyle = elem.attributeValue("style", "");
            String sLayout = elem.attributeValue("layout", "");
            WizardParameterData wParam = this.addParam(sStyle, p, true);
            wParam.setLayoutSettings(sLayout);
        }
    }

    private void loadWizardGroup(Element elem) {
        Group g = new Group();
        if (g == null) {
            return;
        }
        if (g.load(null, elem)) {
            String sStyle = elem.attributeValue("style", "");
            String sLayout = elem.attributeValue("layout", "");
            WizardParameterData wParam = this.addParam(sStyle, g, true);
            wParam.setLayoutSettings(sLayout);
        }
    }

    public boolean checkWizardPage(String complexPageName, String groupName, String name) {
        return complexPageName.equals(this.m_sComplexPageName) && groupName.equals(this.m_sGroupName) && name.equals(this.m_sName);
    }

    public void loadChildren(Element elem) {
        boolean bActionsOnly = true;
        List lChildElems = elem.elements();
        for (int i = 0; i < lChildElems.size(); ++i) {
            Element childElem = (Element)lChildElems.get(i);
            if (childElem.getQName().getName().equals("overView")) {
                String sStyle = childElem.attributeValue("style", "");
                String sLabel = CnfgUIDocResource.getMessage(childElem.attributeValue("label", ""), "config_wizard");
                this.addOverView(sLabel, sStyle);
                bActionsOnly = false;
            }
            if (childElem.getQName().getName().equals("group")) {
                this.loadWizardGroup(childElem);
                bActionsOnly = false;
            }
            if (childElem.getQName().getName().equals("parameter")) {
                this.loadWizardParameter(childElem);
                bActionsOnly = false;
            }
            if (childElem.getQName().getName().equals("paramRef")) {
                this.loadWizardParamRef(childElem);
                bActionsOnly = false;
            }
            if (!childElem.getQName().getName().equals("actions")) continue;
            this.loadWizardAction(childElem);
        }
        if (bActionsOnly && this.m_lActionTargets.size() > 0) {
            this.m_bActionsOnly = true;
        }
    }

    public void reloadData(boolean bReloadParamRef) {
        WizardParameterData wParam;
        for (int i = 0; i < this.m_lWizardParams.size(); ++i) {
            Parameter p;
            String sParamName;
            wParam = (WizardParameterData)this.m_lWizardParams.get(i);
            if (!wParam.isParamLoaded() && (sParamName = wParam.getParamRefID()) != null && sParamName.length() > 0 && (p = DataManager.getInstance().findWizardParm(sParamName)) != null) {
                if (p.getDisabled()) continue;
                if (TemplatedParameter.class.isInstance(p)) {
                    WizardTemplatedParameterData wtParam = this.addTemplatedParam(wParam.getStyle(), (TemplatedParameter)p, false, wParam.getIsRunAction(), null, false);
                    if (wParam.getParamLabelInWiz() != null) {
                        wtParam.setParamLabel(wParam.getParamLabelInWiz());
                    }
                    if (wParam.getParamDescInWiz() != null) {
                        wtParam.setParamDesc(wParam.getParamDescInWiz());
                    }
                    this.m_lWizardParams.remove(wParam);
                    continue;
                }
                wParam.addParam(p, false);
                if (wParam.getParamLabelInWiz() != null) {
                    wParam.setParamLabel(wParam.getParamLabelInWiz());
                }
                if (wParam.getParamDescInWiz() != null) {
                    wParam.setParamDesc(wParam.getParamDescInWiz());
                }
            }
            wParam.reloadData(bReloadParamRef);
        }
        for (int j = 0; j < this.m_lWizardTemplatedParams.size(); ++j) {
            wParam = (WizardTemplatedParameterData)this.m_lWizardTemplatedParams.get(j);
            ((WizardTemplatedParameterData)wParam).reloadTempData(bReloadParamRef);
        }
    }

    public void setConfigValues() {
        WizardParameterData wParam;
        for (int i = 0; i < this.m_lWizardParams.size(); ++i) {
            wParam = (WizardParameterData)this.m_lWizardParams.get(i);
            wParam.setConfigValues();
        }
        for (int j = 0; j < this.m_lWizardTemplatedParams.size(); ++j) {
            wParam = (WizardTemplatedParameterData)this.m_lWizardTemplatedParams.get(j);
            ((WizardTemplatedParameterData)wParam).setTempData(null);
        }
    }

    public void addNewInstanceFolder(TemplatedParameter tParam, Folder parentFolder) {
        if (tParam.getParent() != null) {
            Folder newFolder = parentFolder.addInstanceFolder(tParam, this.m_sInstanceType, this.getName(), this.getName());
            this.setInstFolder(newFolder);
            for (int i = 0; i < this.m_lWizardParams.size(); ++i) {
                WizardParameterData wp = (WizardParameterData)this.m_lWizardParams.get(i);
                Parameter wizardParam = wp.getParam();
                if (wizardParam == null) continue;
                Parameter configParam = newFolder.findParm(wizardParam.getName());
                if (configParam != null) {
                    wp.setValue(wizardParam, configParam);
                    continue;
                }
                wp.setConfigValues();
            }
            for (int j = 0; j < this.m_lWizardTemplatedParams.size(); ++j) {
                WizardTemplatedParameterData tWP = (WizardTemplatedParameterData)this.m_lWizardTemplatedParams.get(j);
                if (tWP.isParamRef()) {
                    tWP.setTempData(null);
                    continue;
                }
                tWP.setTempData(newFolder);
            }
        }
    }

    public int getNumOfParamsToDisplay() {
        int i;
        int numOfParams = 0;
        ArrayList wparamList = this.getWizardParamList();
        for (i = 0; i < wparamList.size(); ++i) {
            WizardParameterData wParam = (WizardParameterData)wparamList.get(i);
            if (wParam.isActionParam() || wParam.isGroupParam() || wParam.getParam().getDisabled()) continue;
            ++numOfParams;
        }
        for (i = 0; i < this.getWizardTParamList().size(); ++i) {
            WizardTemplatedParameterData wtp = (WizardTemplatedParameterData)this.getWizardTParamList().get(i);
            if (wtp.isTopLevel()) continue;
            ++numOfParams;
        }
        return numOfParams;
    }

    public boolean hasMoreParams(int curIdx) {
        int numOfParam = this.getNumOfParamsToDisplay();
        return curIdx + this.getMaxNumOfParam() < numOfParam;
    }

    public boolean hasActionParam() {
        for (int i = 0; i < this.m_lWizardParams.size(); ++i) {
            WizardParameterData wparam = (WizardParameterData)this.m_lWizardParams.get(i);
            if (!wparam.isActionParam()) continue;
            if (wparam.getAction() == null) {
                return true;
            }
            if (wparam.getAction().isMandatory()) continue;
            return true;
        }
        return false;
    }

    public void setActionParams(WizardPageData fromPage) {
        ArrayList fromParamList = fromPage.getWizardParamList();
        for (int i = 0; i < fromParamList.size(); ++i) {
            WizardParameterData wparam = (WizardParameterData)fromParamList.get(i);
            if (!wparam.isActionParam()) continue;
            if (wparam.getAction() == null) {
                this.m_lWizardParams.add(wparam);
                continue;
            }
            if (wparam.getAction().isMandatory()) continue;
            this.m_lWizardParams.add(wparam);
        }
    }

    public void resetParameterValues() {
        for (int i = 0; i < this.m_lWizardParams.size(); ++i) {
            WizardParameterData wParam = (WizardParameterData)this.m_lWizardParams.get(i);
            Parameter param = wParam.getParam();
            if (param == null) continue;
            param.m_currentValue = null;
        }
    }

    public Object clone() {
        try {
            int i;
            Object obj = super.clone();
            ArrayList<WizardParameterData> lWizParams = new ArrayList<WizardParameterData>();
            ArrayList<WizardTemplatedParameterData> lWizTParams = new ArrayList<WizardTemplatedParameterData>();
            for (i = 0; i < this.m_lWizardParams.size(); ++i) {
                WizardParameterData wParam = (WizardParameterData)this.m_lWizardParams.get(i);
                WizardParameterData newParam = (WizardParameterData)wParam.clone();
                lWizParams.add(newParam);
            }
            ((WizardPageData)obj).m_lWizardParams = lWizParams;
            for (i = 0; i < this.m_lWizardTemplatedParams.size(); ++i) {
                WizardTemplatedParameterData tWP = (WizardTemplatedParameterData)this.m_lWizardTemplatedParams.get(i);
                WizardTemplatedParameterData newTParam = (WizardTemplatedParameterData)tWP.clone();
                lWizTParams.add(newTParam);
            }
            ((WizardPageData)obj).m_lWizardTemplatedParams = lWizTParams;
            return obj;
        }
        catch (CloneNotSupportedException e) {
            CnfgLog.error(e);
            throw new InternalError(e.toString());
        }
    }

    public class WizardOverView
    extends WizardData
    implements Cloneable {
        public WizardOverView() {
            this.setLabel("");
            this.setStyle("");
        }

        public WizardOverView(String label, String style) {
            this.setLabel(label);
            this.setStyle(style);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                CnfgLog.error(e);
                throw new InternalError(e.toString());
            }
        }
    }
}

