/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.CnfgWizardPage;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.Constants;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Group;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.SystemPasswordParameter;
import com.cognos.crconfig.data.WizardPageData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WizardParameterData
extends Constants
implements Cloneable {
    protected WizardPageData m_parentPage;
    protected Parameter m_param;
    protected Parameter m_paramRef;
    protected ArrayList m_lEnums = new ArrayList();
    protected boolean m_isWizardParam = false;
    protected boolean m_bRunAction = false;
    protected String m_sStyle;
    protected Object m_component = null;
    protected Object[] m_choices;
    protected boolean m_bIsActionParam = false;
    protected CnfgActionOld m_actionRef;
    protected boolean m_bIsActionDone = false;
    private Hashtable m_layoutSettings = new Hashtable();
    private String m_sParamRefID = "";
    private String m_sParamRefLabelInWiz = null;
    private String m_sParamRefDescInWiz = null;

    public WizardParameterData(WizardPageData parentPage, String style, Parameter param, boolean wizardParam, boolean runAction) {
        this.m_parentPage = parentPage;
        if (param != null) {
            this.addParam(param, wizardParam);
        } else {
            this.m_param = null;
            this.m_paramRef = null;
        }
        this.m_isWizardParam = wizardParam;
        this.m_sStyle = style;
        this.m_bRunAction = runAction;
    }

    public WizardParameterData() {
    }

    public Object clone() {
        try {
            Object obj = super.clone();
            ((WizardParameterData)obj).m_param = (Parameter)this.m_param.clone();
            return obj;
        }
        catch (CloneNotSupportedException e) {
            CnfgLog.error(e);
            throw new InternalError(e.toString());
        }
    }

    public void addParam(Parameter param, boolean wizardParam) {
        this.m_param = !wizardParam ? (Parameter)param.clone() : param;
        this.m_param.setFireValueChanged(false);
        this.m_paramRef = param;
    }

    public Parameter getParam() {
        return this.m_param;
    }

    public Parameter getParamRef() {
        return this.m_paramRef;
    }

    public String getStyle() {
        return this.m_sStyle;
    }

    public boolean isWizardParam() {
        return this.m_isWizardParam;
    }

    public void addComponent(Object component) {
        this.m_component = component;
    }

    public void addComponent(Object component, Object[] choices) {
        this.m_component = component;
        this.m_choices = choices;
    }

    public String getSelectedValue(int index) {
        if (this.m_choices != null && this.m_choices[index] != null) {
            return this.m_choices[index].toString();
        }
        return null;
    }

    public Object getSelectedEditor() {
        if (this.m_choices != null && this.m_choices[0] != null) {
            return this.m_choices[0];
        }
        return null;
    }

    public Object getComponent() {
        return this.m_component;
    }

    public void clearComponent() {
        this.m_component = null;
    }

    public void setActionParam(boolean isActionParam, CnfgActionOld action) {
        this.m_bIsActionParam = isActionParam;
        this.m_actionRef = action;
    }

    public boolean isActionParam() {
        return this.m_bIsActionParam;
    }

    public boolean isGroupParam() {
        return this.m_paramRef != null && Group.class == this.m_paramRef.getClass();
    }

    public boolean isGroupEnd() {
        return this.getStyle().equalsIgnoreCase("global");
    }

    public boolean isGroupReadOnly() {
        if (this.isGroupParam()) {
            return this.m_paramRef.isReadOnly();
        }
        return false;
    }

    public int getLayoutSettings(String name) {
        int value = 0;
        if (this.m_layoutSettings.get(name) != null) {
            value = (Integer)this.m_layoutSettings.get(name);
        }
        return value;
    }

    public void setLayoutSettings(String settings) {
        if (settings == null || settings.length() == 0) {
            return;
        }
        int curPos = 0;
        int nextPos = 0;
        while (nextPos < settings.length()) {
            String str;
            nextPos = settings.indexOf(" ", curPos);
            if (nextPos < 0) {
                nextPos = settings.length();
            }
            if ((str = settings.substring(curPos, nextPos)) != null && str.length() > 0) {
                int sep = str.indexOf("_");
                if (sep > 0) {
                    int value = 0;
                    String name = str.substring(0, sep);
                    String sValue = str.substring(sep + 1);
                    try {
                        Integer iValue = new Integer(sValue);
                        value = iValue;
                    }
                    catch (Exception e) {
                        value = 0;
                    }
                    this.m_layoutSettings.put(name, new Integer(value));
                } else {
                    this.m_layoutSettings.put(str, new Integer(1));
                }
            }
            curPos = nextPos + 1;
        }
    }

    public CnfgActionOld getAction() {
        return this.m_actionRef;
    }

    public void setActionDone(boolean isDone) {
        this.m_bIsActionDone = isDone;
    }

    public ArrayList getEnumList() {
        return this.m_lEnums;
    }

    public boolean hasWizEnums() {
        return this.m_lEnums.size() > 0;
    }

    public void setValue(Parameter sourceParam, Parameter targetParam) {
        if (!this.isWizardParam() && sourceParam != null && targetParam != null) {
            if (CredentialParameter.class.isInstance(sourceParam)) {
                try {
                    Element temp_elem = DocumentHelper.createElement((String)"TEMP");
                    ArrayList errors = new ArrayList();
                    ((CredentialParameter)sourceParam).write(temp_elem, false, (List)errors);
                    ((CredentialParameter)targetParam).setValue(temp_elem);
                }
                catch (DataManagerException e) {
                    CnfgLog.error(e.getMessage());
                }
            } else if (SystemPasswordParameter.class.isInstance(sourceParam)) {
                String sPassword = ((SystemPasswordParameter)sourceParam).getPart();
                targetParam.setValue(sPassword);
            } else if (ArrayParameter.class.isInstance(sourceParam)) {
                Set<Parameter> lSourceValues = ((ArrayParameter)sourceParam).getCurrentValues();
                ArrayList<Parameter> lTargetValues = new ArrayList<Parameter>();
                for (Parameter p : lSourceValues) {
                    Parameter newParam = (Parameter)p.clone();
                    lTargetValues.add(newParam);
                }
                targetParam.setValue(lTargetValues);
            } else {
                Object oValue = sourceParam.getValue();
                if (oValue != null) {
                    targetParam.setValue(oValue);
                }
            }
        }
    }

    public void reloadData(boolean bReloadParamRef) {
        if (bReloadParamRef && !this.isWizardParam()) {
            Parameter p;
            String sParamName;
            if (this.m_param != null && (sParamName = this.m_param.getName()).length() > 0 && (p = DataManager.getInstance().findWizardParm(sParamName)) != null) {
                this.m_paramRef = p;
                this.setValue(this.m_paramRef, this.m_param);
                return;
            }
            CnfgLog.error("WizardParameterData.reloadData - The wizard parameter is invalid or couldn't be found in config tree, reloadData failed.");
        } else {
            this.setValue(this.m_paramRef, this.m_param);
        }
    }

    public void setConfigValues() {
        this.setValue(this.m_param, this.m_paramRef);
    }

    public void updateEnums(Element elem) {
        this.m_lEnums.clear();
        if (elem == null) {
            return;
        }
        List lChildrenElems = elem.elements();
        for (int j = 0; j < lChildrenElems.size(); ++j) {
            Element childElem = (Element)lChildrenElems.get(j);
            if (!childElem.getQName().getName().equals("enum")) continue;
            String sValue = childElem.attributeValue("value", "");
            String sReference = childElem.attributeValue("reference", "");
            if (sReference.equalsIgnoreCase("this") && this.getParam().getValue() != null) {
                sValue = this.getParam().getValue().toString();
            }
            WizardParamEnum wpe = new WizardParamEnum(sValue, sReference);
            if (sReference.equalsIgnoreCase("java_prop")) {
                wpe.resolveValue();
            }
            this.m_lEnums.add(wpe);
        }
    }

    public void setParamValues(HashMap values) {
        if (this.m_param != null) {
            this.m_param.m_values = values;
        }
    }

    public void setParamLabel(String sLabel) {
        if (this.m_param != null) {
            this.m_param.setLabel(sLabel);
        }
        this.m_sParamRefLabelInWiz = sLabel;
    }

    public void setParamDesc(String sDesc) {
        if (this.m_param != null) {
            this.m_param.m_sDesc = sDesc;
        }
        this.m_sParamRefDescInWiz = sDesc;
    }

    public String getParamLabelInWiz() {
        return this.m_sParamRefLabelInWiz;
    }

    public String getParamDescInWiz() {
        return this.m_sParamRefDescInWiz;
    }

    public void setParamRefID(String refID) {
        this.m_sParamRefID = refID;
    }

    protected String getParamRefID() {
        return this.m_sParamRefID;
    }

    protected boolean isParamLoaded() {
        return this.m_sParamRefID == null || this.m_sParamRefID.length() <= 0 || this.m_param != null;
    }

    protected boolean getIsRunAction() {
        return this.m_bRunAction;
    }

    public class WizardParamEnum {
        private String m_sValue = null;
        private String m_sResolvedValue = null;
        private String m_sReferenceType = null;

        public WizardParamEnum(String sValue, String sRef) {
            this.m_sValue = sValue;
            this.m_sReferenceType = sRef;
        }

        public String getResolvedValue(WizardParameterData wParam) {
            if (this.m_sResolvedValue == null) {
                this.resolveValue();
            }
            String sDataType = "";
            if (wParam.getParamRef() != null && ((sDataType = wParam.getParamRef().getDataType()).equals("filePath") || sDataType.equals("folderPath"))) {
                String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(this.m_sResolvedValue);
                File f = new File(sResolvedPath);
                this.m_sResolvedValue = f.exists() ? sResolvedPath : null;
            }
            return this.m_sResolvedValue;
        }

        public boolean renderParamEditor() {
            return this.m_sReferenceType != null && this.m_sReferenceType.equalsIgnoreCase("this");
        }

        public void resolveValue() {
            if (this.m_sReferenceType == null || this.m_sReferenceType.length() == 0 || this.m_sReferenceType.equalsIgnoreCase("this")) {
                this.m_sResolvedValue = this.m_sValue;
            } else {
                int endIdx;
                int startIdx;
                int iCurIdx = 0;
                StringBuffer resolvedVal = new StringBuffer();
                while ((startIdx = this.m_sValue.indexOf("${", iCurIdx)) != -1 && (endIdx = this.m_sValue.indexOf("}", startIdx + 2)) != -1) {
                    if (startIdx > iCurIdx) {
                        resolvedVal.append(this.m_sValue.substring(iCurIdx, startIdx));
                    }
                    String sProp = this.m_sValue.substring(startIdx + 2, endIdx);
                    String sPropValue = null;
                    if (this.m_sReferenceType.equalsIgnoreCase("java_prop")) {
                        sPropValue = System.getProperty(sProp);
                    } else if (this.m_sReferenceType.equalsIgnoreCase("wizard_prop")) {
                        sPropValue = this.getParamValue(sProp);
                    }
                    if (sPropValue != null) {
                        resolvedVal.append(sPropValue);
                    } else {
                        resolvedVal.append(this.m_sValue.substring(startIdx, endIdx) + 1);
                    }
                    iCurIdx = endIdx + 1;
                }
                if (iCurIdx == 0) {
                    this.m_sResolvedValue = this.m_sValue;
                    return;
                }
                if (iCurIdx < this.m_sValue.length()) {
                    resolvedVal.append(this.m_sValue.substring(iCurIdx, this.m_sValue.length()));
                }
                this.m_sResolvedValue = resolvedVal.toString();
            }
        }

        private String getParamValue(String sParamName) {
            Object obj;
            Parameter p = null;
            CnfgWizard cWiz = CnfgWizard.getInstance();
            if (cWiz.getWizardPages().size() > 0) {
                ArrayList lPages = cWiz.getWizardPages();
                for (int idx = lPages.size() - 1; idx >= 0; --idx) {
                    CnfgWizardPage cwp = (CnfgWizardPage)lPages.get(idx);
                    WizardPageData curPage = null;
                    curPage = cwp.isTemplatedPage() ? cwp.getWizardTPageData() : cwp.getWizardPageData();
                    if (curPage == null) continue;
                    boolean found = false;
                    ArrayList paramList = curPage.getConfigParamList();
                    for (int j = 0; j < paramList.size(); ++j) {
                        Parameter param = (Parameter)paramList.get(j);
                        if (!param.getName().equals(sParamName)) continue;
                        p = param;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
            }
            if (p == null) {
                p = DataManager.getInstance().findParm(sParamName);
            }
            if (p != null && (obj = p.getValue()) != null) {
                return obj.toString();
            }
            return null;
        }
    }
}

