/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.data.BooleanParameter;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Group;
import com.cognos.crconfig.data.Option;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.StringParameter;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.WizardParameterData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class WizardTemplatedParameterData
extends WizardParameterData {
    private ArrayList m_lInstances = new ArrayList();
    private ArrayList m_lDeletedInstances = new ArrayList();
    private WizardPageData m_curDeletedInstance = null;
    private ArrayList m_lNewInstances = new ArrayList();
    private WizardPageData m_curNewInstance = null;
    private WizardPageData m_entryPage;
    private WizardPageData m_propertyPage;
    private WizardPageData m_actionPage;
    private WizardPageData m_summaryPage;
    private boolean m_bParamRef;
    private Hashtable m_lOptions = new Hashtable();

    public WizardTemplatedParameterData(WizardPageData parentPage, String style, TemplatedParameter param, boolean wizardParam, boolean bRunAction, Element elem) {
        this.m_parentPage = parentPage;
        this.m_param = !wizardParam ? (TemplatedParameter)param.clone() : param;
        this.m_paramRef = param;
        this.m_isWizardParam = wizardParam;
        this.m_bRunAction = bRunAction;
        this.m_sStyle = style;
        this.loadUIInfo(elem);
    }

    public void loadUIInfo(Element elem) {
        Element entryPageElem = null;
        Element propPageElem = null;
        Element actionPageElem = null;
        Element summaryPageElem = null;
        if (elem != null) {
            List lChildrenElems = elem.elements();
            for (int i = 0; i < lChildrenElems.size(); ++i) {
                Element pageElem = (Element)lChildrenElems.get(i);
                if (pageElem.getQName().getName().equals("entryPage")) {
                    entryPageElem = pageElem;
                }
                if (pageElem.getQName().getName().equals("propertyPage")) {
                    propPageElem = pageElem;
                }
                if (pageElem.getQName().getName().equals("actionPage")) {
                    actionPageElem = pageElem;
                }
                if (pageElem.getQName().getName().equals("summaryPage")) {
                    summaryPageElem = pageElem;
                }
                if (!pageElem.getQName().getName().equals("option")) continue;
                this.addParameterRefToOption(pageElem);
            }
        }
        this.m_entryPage = this.generateEntryPage(entryPageElem);
        this.m_propertyPage = this.generatePropertyPage(propPageElem);
        this.m_actionPage = this.generateActionPage(actionPageElem);
        this.m_summaryPage = this.generateSummaryPage(summaryPageElem);
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        ((WizardTemplatedParameterData)obj).m_lInstances = this.cloneInstances(this.m_lInstances);
        ((WizardTemplatedParameterData)obj).m_lNewInstances = this.cloneInstances(this.m_lNewInstances);
        ((WizardTemplatedParameterData)obj).m_lDeletedInstances = this.cloneInstances(this.m_lDeletedInstances);
        return obj;
    }

    public ArrayList cloneInstances(ArrayList lInstances) {
        ArrayList<WizardPageData> lResult = new ArrayList<WizardPageData>();
        for (int i = 0; i < lInstances.size(); ++i) {
            WizardPageData wp = (WizardPageData)lInstances.get(i);
            WizardPageData newWP = (WizardPageData)wp.clone();
            lResult.add(newWP);
        }
        return lResult;
    }

    public boolean isTopLevel() {
        return this.m_sStyle.equalsIgnoreCase("maindlg");
    }

    public WizardPageData getEntryPage() {
        return this.m_entryPage;
    }

    public WizardPageData getPropertyPage() {
        return this.m_propertyPage;
    }

    public WizardPageData getActionPage() {
        return this.m_actionPage;
    }

    public WizardPageData getSummaryPage() {
        return this.m_summaryPage;
    }

    public ArrayList getInstancesList() {
        return this.m_lInstances;
    }

    public ArrayList getNewInstancesList() {
        return this.m_lNewInstances;
    }

    public ArrayList getDeletedInstancesList() {
        return this.m_lDeletedInstances;
    }

    public void setInstancesList(ArrayList list) {
        this.m_lInstances = list;
    }

    public void setNewInstancesList(ArrayList list) {
        this.m_lNewInstances = list;
    }

    public void setDeletedInstancesList(ArrayList list) {
        this.m_lDeletedInstances = list;
    }

    public String getTempParamName() {
        TemplatedParameter tp = (TemplatedParameter)this.getParam();
        if (tp != null && tp.getParameter() != null) {
            return tp.getParameter().getName();
        }
        return null;
    }

    public boolean isParamRef() {
        return this.m_bParamRef;
    }

    public void setParamRef(boolean bParamRef) {
        this.m_bParamRef = bParamRef;
    }

    public Integer numOfInstance(String type) {
        WizardPageData wp;
        int count = 0;
        for (int i = 0; i < this.m_lInstances.size(); ++i) {
            wp = (WizardPageData)this.m_lInstances.get(i);
            if (wp.getInstType().compareTo(type) != 0) continue;
            ++count;
        }
        for (int j = 0; j < this.m_lNewInstances.size(); ++j) {
            wp = (WizardPageData)this.m_lNewInstances.get(j);
            if (wp.getInstType().compareTo(type) != 0) continue;
            ++count;
        }
        return new Integer(count);
    }

    public ArrayList getAvailableOptions(boolean bIgnoreOccurs) {
        ArrayList<Option> al = new ArrayList<Option>();
        Hashtable<Option, Integer> currentCountByOption = new Hashtable<Option, Integer>();
        int totalCount = 0;
        TemplatedParameter tParam = (TemplatedParameter)this.getParam();
        List<Option> lOptions = tParam.getOptions();
        for (int i = 0; i < lOptions.size(); ++i) {
            Option option = lOptions.get(i);
            if (option == null || option.getDisabled()) continue;
            Integer currentCount = this.numOfInstance(option.getName());
            currentCountByOption.put(option, currentCount);
            totalCount += currentCount.intValue();
        }
        if (bIgnoreOccurs) {
            Set s = currentCountByOption.keySet();
            for (Option opt : s) {
                al.add(opt);
            }
            return al;
        }
        Integer parmMxO = tParam.getParameter().getMaxOccurs();
        if (parmMxO != -1 && totalCount >= parmMxO) {
            return al;
        }
        Set s = currentCountByOption.keySet();
        for (Option opt : s) {
            Integer optionMax = opt.getMaxOccurs();
            if (optionMax == -1) {
                al.add(opt);
                continue;
            }
            Integer currCount = (Integer)currentCountByOption.get(opt);
            if (optionMax - currCount <= 0) continue;
            al.add(opt);
        }
        return al;
    }

    private Parameter findParamInOption(Option opt, String sParamName) {
        List<Parameter> optParamList = opt.getParameters();
        for (int idx = 0; idx < optParamList.size(); ++idx) {
            Parameter param = optParamList.get(idx);
            if (!param.getName().equals(sParamName)) continue;
            return param;
        }
        ArrayList<TemplatedParameter> optTParamList = opt.getTParameters();
        for (int idx = 0; idx < optTParamList.size(); ++idx) {
            TemplatedParameter tparam = optTParamList.get(idx);
            if (!tparam.getName().equals(sParamName)) continue;
            return tparam;
        }
        return null;
    }

    private void addParameterRefToOption(Element elem) {
        if (elem == null || this.m_param == null) {
            return;
        }
        String sOption = elem.attributeValue("value", "");
        if (sOption.length() == 0) {
            return;
        }
        Option opt = ((TemplatedParameter)this.m_paramRef).getOption(sOption);
        if (opt == null) {
            return;
        }
        ArrayList<Object[]> lParams = new ArrayList<Object[]>();
        List lChildrenElems = elem.elements();
        for (int j = 0; j < lChildrenElems.size(); ++j) {
            String sRefID;
            Element paramRefElem = (Element)lChildrenElems.get(j);
            if (!paramRefElem.getQName().getName().equals("paramRef") || (sRefID = paramRefElem.attributeValue("refID", "")).length() <= 0) continue;
            Object[] paramRefObj = new Object[]{null, null, null};
            Parameter p = this.findParamInOption(opt, sRefID);
            if (p != null) {
                paramRefObj[0] = p;
                paramRefObj[2] = "local";
            } else {
                p = DataManager.getInstance().findWizardParm(sRefID);
                if (p == null) continue;
                paramRefObj[0] = p;
                paramRefObj[2] = "global";
            }
            if (paramRefElem.hasContent()) {
                paramRefObj[1] = paramRefElem;
            }
            lParams.add(paramRefObj);
        }
        if (lParams.size() > 0) {
            this.m_lOptions.put(sOption, lParams);
        }
    }

    private WizardPageData generateEntryPage(Element entryPageElem) {
        WizardPageData wp = new WizardPageData(this.m_parentPage);
        if (entryPageElem != null) {
            wp.clearOverView();
            StringParameter opParam = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
            opParam.m_sName = "operation";
            opParam.m_values = new HashMap();
            opParam.m_values.put("exit", "Apply");
            StringParameter newParam = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
            newParam.m_sName = "newName";
            newParam.m_sLabel = CnfgResource.getMessage("Label.DialogCreateNew.name");
            newParam.setMandatory(true);
            wp.addParam("", newParam, true);
            StringParameter newTypeParam = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
            newTypeParam.m_sName = "newType";
            newTypeParam.m_sLabel = CnfgResource.getMessage("Label.DialogCreateNew.type");
            newTypeParam.setMandatory(true);
            wp.addParam("", newTypeParam, true);
            List lChildrenElems = entryPageElem.elements();
            for (int i = 0; i < lChildrenElems.size(); ++i) {
                Element elem = (Element)lChildrenElems.get(i);
                if (elem.getQName().getName().equals("overView")) {
                    String sLabel = CnfgUIDocResource.getMessage(elem.attributeValue("label", ""), "config_wizard");
                    String sStyle = elem.attributeValue("style", "");
                    wp.addOverView(sLabel, sStyle);
                }
                if (!elem.getQName().getName().equals("parameter")) continue;
                String sName = elem.attributeValue("name", "");
                String sLabel = elem.attributeValue("label", "");
                if (sName.equals("create")) {
                    opParam.m_values.put("create", sLabel);
                    continue;
                }
                if (sName.equals("switch")) {
                    opParam.m_values.put("switch", sLabel);
                    continue;
                }
                if (sName.equals("edit")) {
                    opParam.m_values.put("edit", sLabel);
                    StringParameter editParam = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
                    editParam.m_sName = "editName";
                    wp.addParam("", editParam, true);
                    continue;
                }
                if (!sName.equals("delete")) continue;
                opParam.m_values.put("delete", sLabel);
                StringParameter delParam = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
                delParam.m_sName = "delName";
                wp.addParam("", delParam, true);
            }
            wp.addParam("radiobutton", opParam, true);
        } else {
            wp.addOverView(this.m_param.getDesc(), "description");
            StringParameter p = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
            p.m_sName = "operation";
            p.m_values = new HashMap();
            p.m_values.put("create", CnfgResource.getMessage("Label.DialogWizard.CreateNew"));
            p.m_values.put("edit", CnfgResource.getMessage("Label.DialogWizard.EditInst"));
            p.m_values.put("delete", CnfgResource.getMessage("Label.DialogWizard.DelInst"));
            p.m_values.put("exit", CnfgResource.getMessage("Label.ButtonApply"));
            wp.addParam("radiobutton", p, true);
            p = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
            p.m_sName = "newName";
            p.m_sLabel = CnfgResource.getMessage("Label.DialogCreateNew.name");
            p.setMandatory(true);
            wp.addParam("", p, true);
            p = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
            p.m_sName = "newType";
            p.m_sLabel = CnfgResource.getMessage("Label.DialogCreateNew.type");
            p.setMandatory(true);
            wp.addParam("", p, true);
            p = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
            p.m_sName = "editName";
            wp.addParam("", p, true);
            p = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
            p.m_sName = "delName";
            wp.addParam("", p, true);
        }
        return wp;
    }

    private WizardPageData generateTemplatePage(Element pageElem) {
        if (pageElem != null) {
            int maxParam = this.m_parentPage.getMaxNumOfParam();
            String sMaxParamPerPage = pageElem.attributeValue("maxParamPerPage", "");
            if (sMaxParamPerPage.length() != 0) {
                maxParam = new Integer(sMaxParamPerPage);
            }
            WizardPageData wp = new WizardPageData(this.m_parentPage.getName(), this.m_parentPage.getLabel(), false, maxParam);
            List lChildrenElems = pageElem.elements();
            for (int i = 0; i < lChildrenElems.size(); ++i) {
                Element elem = (Element)lChildrenElems.get(i);
                if (!elem.getQName().getName().equals("overView")) continue;
                String sLabel = CnfgUIDocResource.getMessage(elem.attributeValue("label", ""), "config_wizard");
                String sStyle = elem.attributeValue("style", "");
                wp.addOverView(sLabel, sStyle);
            }
            return wp;
        }
        return null;
    }

    private WizardPageData generatePropertyPage(Element propPageElem) {
        return this.generateTemplatePage(propPageElem);
    }

    private WizardPageData generateActionPage(Element actionPageElem) {
        WizardPageData wp = this.generateTemplatePage(actionPageElem);
        if (wp == null) {
            wp = new WizardPageData(this.m_parentPage);
        }
        return wp;
    }

    private WizardPageData generateSummaryPage(Element summaryPageElem) {
        WizardPageData wp = this.generateTemplatePage(summaryPageElem);
        if (wp == null) {
            wp = new WizardPageData(this.m_parentPage);
        }
        return wp;
    }

    public void setPropertyPageTitle(String title) {
        if (this.m_propertyPage != null) {
            this.m_propertyPage.setOverViewTitle(title);
        }
    }

    private void addWizParamFromOption(String sOptionValue, WizardPageData wp) {
        ArrayList lParamRefs = (ArrayList)this.m_lOptions.get(sOptionValue);
        if (lParamRefs != null) {
            for (int idx = 0; idx < lParamRefs.size(); ++idx) {
                Element elem;
                Object[] objArr = (Object[])lParamRefs.get(idx);
                Object paramObj = objArr[0];
                Object paramScope = objArr[2];
                String sParamScope = "";
                if (paramScope != null && String.class.isInstance(paramScope)) {
                    sParamScope = (String)paramScope;
                }
                if (paramObj == null) continue;
                if (TemplatedParameter.class.isInstance(paramObj)) {
                    TemplatedParameter tparam = (TemplatedParameter)paramObj;
                    elem = (Element)objArr[1];
                    if (sParamScope.equals("local")) {
                        wp.updateTemplatedParam(tparam, elem);
                        continue;
                    }
                    if (!sParamScope.equals("global")) continue;
                    wp.loadTemplatedParam("", tparam, false, this.m_bRunAction, elem, true);
                    continue;
                }
                if (!Parameter.class.isInstance(paramObj)) continue;
                Parameter param = (Parameter)paramObj;
                elem = (Element)objArr[1];
                if (sParamScope.equals("local")) {
                    wp.updateParam(param, elem);
                    continue;
                }
                if (!sParamScope.equals("global")) continue;
                if (param.isActionParam()) {
                    wp.addActionParam(param, null, this.m_isWizardParam, elem);
                    continue;
                }
                wp.addParam("", param, this.m_isWizardParam, elem);
            }
        }
    }

    private Element getElementFromOption(String sOptionName, Parameter param) {
        ArrayList lParamRefs = (ArrayList)this.m_lOptions.get(sOptionName);
        if (lParamRefs != null) {
            for (int idx = 0; idx < lParamRefs.size(); ++idx) {
                Object[] objArr = (Object[])lParamRefs.get(idx);
                Object paramObj = objArr[0];
                if (paramObj == null || !Parameter.class.isInstance(paramObj) || paramObj != param) continue;
                return (Element)objArr[1];
            }
        }
        return null;
    }

    public WizardPageData addNewInstance(String name, Option option) {
        WizardPageData wp = null;
        if (option != null) {
            wp = new WizardPageData(this.m_parentPage);
            wp.setName(name);
            wp.setInstType(option.getName());
            wp.setInstLabel(option.getLabel());
            if (this.m_propertyPage != null) {
                ArrayList ovList = this.m_propertyPage.getOverViewList();
                if (ovList != null) {
                    wp.setOverViewList(ovList);
                }
                wp.setMaxNumOfParam(this.m_propertyPage.getMaxNumOfParam());
            } else {
                wp.addOverView(option.getDesc(), "description");
            }
            List<Parameter> lParams = ((TemplatedParameter)this.m_param).cloneParms(option.getName());
            for (int i = 0; i < lParams.size(); ++i) {
                Parameter obj = lParams.get(i);
                if (TemplatedParameter.class.isInstance(obj) || Group.class.isInstance(obj)) continue;
                Parameter param = obj;
                if (param.isActionParam()) {
                    wp.addActionParam(param, null, this.m_isWizardParam);
                    continue;
                }
                wp.addParam("", param, this.m_isWizardParam);
            }
            this.addWizParamFromOption(option.getName(), wp);
            if (this.m_bRunAction) {
                ArrayList<CnfgActionOld> actionList = option.getActions();
                for (int k = 0; k < actionList.size(); ++k) {
                    CnfgActionOld action = actionList.get(k);
                    if (action == null) continue;
                    BooleanParameter p = new BooleanParameter("http://www.w3.org/2001/XMLSchema", "string");
                    p.m_sName = "action_" + action.getName();
                    p.m_sLabel = action.getLabel();
                    p.m_sHelp = action.getHelp();
                    p.m_sDesc = action.getDesc();
                    ((Parameter)p).setValue(new Boolean(true));
                    wp.addActionParam(p, action, true);
                }
            }
            ArrayList<TemplatedParameter> lTParams = option.cloneTParms();
            for (int j = 0; j < lTParams.size(); ++j) {
                TemplatedParameter tp = lTParams.get(j);
                Element elem = this.getElementFromOption(option.getName(), tp);
                wp.addTemplatedParam("", tp, this.m_isWizardParam, this.m_bRunAction, elem, false);
            }
            this.m_lNewInstances.add(wp);
            this.m_curNewInstance = wp;
        }
        return wp;
    }

    public void deleteInstance(WizardPageData deletedPage, boolean isSwitch) {
        if (this.m_lInstances.indexOf(deletedPage) != -1) {
            if (this.m_lInstances.remove(deletedPage)) {
                this.m_lDeletedInstances.add(deletedPage);
                this.m_curDeletedInstance = isSwitch ? deletedPage : null;
            }
        } else if (this.m_lNewInstances.indexOf(deletedPage) != -1) {
            this.m_lNewInstances.remove(deletedPage);
            this.m_curDeletedInstance = null;
        }
    }

    public void resetCurInstance() {
        this.m_curDeletedInstance = null;
        this.m_curNewInstance = null;
    }

    public void resetInstancesList() {
        this.m_lInstances.clear();
        this.m_lDeletedInstances.clear();
        this.m_lNewInstances.clear();
        this.resetCurInstance();
    }

    public void revalidateInstancesList() {
        if (this.m_curNewInstance != null) {
            this.m_lNewInstances.remove(this.m_curNewInstance);
            this.m_curNewInstance = null;
        }
        if (this.m_curDeletedInstance != null) {
            this.m_lDeletedInstances.remove(this.m_curDeletedInstance);
            this.m_lInstances.add(this.m_curDeletedInstance);
            this.m_curDeletedInstance = null;
        }
    }

    public void reloadTempData(boolean bReloadParamRef) {
        if (bReloadParamRef && !this.isWizardParam()) {
            Parameter p;
            String sParamName;
            boolean bFound = false;
            if (this.m_param != null && (sParamName = this.m_param.getName()).length() > 0 && (p = DataManager.getInstance().findWizardParm(sParamName)) != null) {
                this.m_paramRef = p;
                bFound = true;
            }
            if (!bFound) {
                CnfgLog.error("WizardTemplatedParameterData.reloadTempData - The wizard parameter is invalid or couldn't be found in config tree, reloadTempData failed.");
                return;
            }
        }
        if (!this.isWizardParam() && this.m_param != null && this.m_paramRef != null) {
            this.resetInstancesList();
            if (this.m_paramRef.getParent() != null) {
                List<Folder> lFolers = this.m_paramRef.getParent().getFolders();
                for (int i = 0; i < lFolers.size(); ++i) {
                    Folder f = lFolers.get(i);
                    TemplatedParameter tp = f.getTemplatedParameter();
                    if (tp == null || !tp.getName().equals(this.m_paramRef.getName())) continue;
                    WizardPageData wp = new WizardPageData(this.m_parentPage, f, this.m_bRunAction);
                    if (this.m_propertyPage != null) {
                        ArrayList ovList = this.m_propertyPage.getOverViewList();
                        if (ovList != null) {
                            wp.setOverViewList(ovList);
                        }
                        wp.setMaxNumOfParam(this.m_propertyPage.getMaxNumOfParam());
                    }
                    this.addWizParamFromOption(wp.getInstType(), wp);
                    this.m_lInstances.add(wp);
                }
            }
        }
    }

    public void setTempData(Folder parentFolder) {
        if (!this.isWizardParam() && this.m_param != null && this.m_paramRef != null) {
            int j;
            WizardPageData wp;
            for (int i = 0; i < this.m_lDeletedInstances.size(); ++i) {
                wp = (WizardPageData)this.m_lDeletedInstances.get(i);
                Folder deletedFolder = wp.getInstFolder();
                if (deletedFolder == null) continue;
                deletedFolder.getParent().remove(deletedFolder);
            }
            this.m_lDeletedInstances.clear();
            for (j = 0; j < this.m_lNewInstances.size(); ++j) {
                wp = (WizardPageData)this.m_lNewInstances.get(j);
                if (parentFolder != null) {
                    wp.addNewInstanceFolder((TemplatedParameter)this.m_paramRef, parentFolder);
                    continue;
                }
                wp.addNewInstanceFolder((TemplatedParameter)this.m_paramRef, this.m_paramRef.getParent());
            }
            for (j = 0; j < this.m_lInstances.size(); ++j) {
                wp = (WizardPageData)this.m_lInstances.get(j);
                wp.setConfigValues();
            }
            this.m_lInstances.addAll(this.m_lNewInstances);
            this.m_lNewInstances.clear();
        }
    }

    public boolean checkActionState() {
        WizardPageData wp;
        int j;
        for (j = 0; j < this.m_lNewInstances.size(); ++j) {
            wp = (WizardPageData)this.m_lNewInstances.get(j);
            if (wp.getActionState() != -1) continue;
            return false;
        }
        for (j = 0; j < this.m_lInstances.size(); ++j) {
            wp = (WizardPageData)this.m_lInstances.get(j);
            if (wp.getActionState() != -1) continue;
            return false;
        }
        return true;
    }
}

