/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.service;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.service.CnfgServiceUtils;
import com.cognos.crconfig.data.service.ServiceFolder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class BootstrapServiceFolder
extends ServiceFolder {
    private String m_sCnfgServiceName;
    private String m_sRegServiceName;
    private Boolean m_bThisIsCBS = null;
    private String m_regFileName = "../configuration/cogconfig_reg.txt";
    private String m_sServiceClass;

    public BootstrapServiceFolder(String name, boolean unregOnDel, String sServiceClass) {
        super(name, unregOnDel);
        if (name != null && !name.equalsIgnoreCase("IBM Cognos")) {
            this.m_regFileName = "../configuration/" + name.replace(' ', '_') + ".txt";
        }
        this.setServiceClass(sServiceClass != null ? sServiceClass : "");
    }

    @Override
    public ICnfgTask[] createStartTasks(CnfgActionOld action, boolean bSaveConfig) {
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        CnfgServiceUtils.createStartTask(tasklist, bSaveConfig, this);
        return CnfgTask.createTaskArray(tasklist);
    }

    @Override
    public ICnfgTask[] createStopTasks(CnfgActionOld action) {
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        CnfgServiceUtils.createStopTask(tasklist, this);
        return CnfgTask.createTaskArray(tasklist);
    }

    @Override
    public ICnfgTask[] createRestartTasks(boolean bSaveConfig) {
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        CnfgServiceUtils.createStopTask(tasklist, this);
        CnfgServiceUtils.createStartTask(tasklist, bSaveConfig, this);
        return CnfgTask.createTaskArray(tasklist);
    }

    @Override
    public ICnfgTask[] createUnregisterTasks(CnfgActionOld action) {
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        CnfgServiceUtils.createUnregisterTask(tasklist, this);
        return CnfgTask.createTaskArray(tasklist);
    }

    @Override
    public void createRestartTasks(List<ICnfgTask> stopList, List<ICnfgTask> startList, boolean bSaveConfig) {
        ArrayList<ICnfgTask> stopTasklist = new ArrayList<ICnfgTask>();
        CnfgServiceUtils.createStopTask(stopTasklist, this);
        ArrayList<ICnfgTask> startTasklist = new ArrayList<ICnfgTask>();
        CnfgServiceUtils.createStartTask(startTasklist, bSaveConfig, this);
        if (stopTasklist != null) {
            stopList.addAll(stopTasklist);
        }
        if (startTasklist != null) {
            startList.addAll(startTasklist);
        }
    }

    public String getNewServiceName() {
        if (this.isThisCBS()) {
            return CnfgServiceUtils.getCBSNewServiceName(this);
        }
        return this.getName();
    }

    public String getCnfgServiceName() {
        return this.m_sCnfgServiceName;
    }

    public void setCnfgServiceName(String serviceName) {
        this.m_sCnfgServiceName = serviceName;
    }

    public boolean isThisCBS() {
        if (this.m_bThisIsCBS == null) {
            Folder f = DataManager.getInstance().getCBS();
            this.m_bThisIsCBS = f != null && f == this ? new Boolean(true) : new Boolean(false);
        }
        return this.m_bThisIsCBS;
    }

    public String getRegFile() {
        return this.m_regFileName;
    }

    public void setRegServiceName(String name) {
        if (null == name) {
            this.m_sRegServiceName = null;
            String customServiceName = null;
            try {
                File serviceName = DataManager.getInstance().resolveEffectiveFilePath(this.getRegFile());
                if (this.isThisCBS()) {
                    customServiceName = (String)CnfgPreferences.getInstance().getProperty("CustomServiceName", String.class);
                }
                if (customServiceName != null) {
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(serviceName.getAbsolutePath(), false), "UTF-8");
                    if (customServiceName.length() > 0) {
                        this.m_sRegServiceName = customServiceName;
                    } else {
                        this.m_sRegServiceName = "IBM Cognos";
                        CnfgLog.error("The customServiceName preference is empty. Using the default service name \"" + this.m_sRegServiceName + "\".");
                    }
                    osw.write(this.m_sRegServiceName);
                    osw.close();
                } else if (serviceName.exists()) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(serviceName), "UTF-8"));
                    this.m_sRegServiceName = reader.readLine();
                    reader.close();
                }
            }
            catch (DataManagerException e) {
                CnfgLog.error(e);
            }
            catch (FileNotFoundException e) {
                CnfgLog.error(e);
            }
            catch (IOException e) {
                CnfgLog.error(e);
            }
        } else {
            this.m_sRegServiceName = name;
        }
    }

    public String getRegServiceName() {
        return this.m_sRegServiceName;
    }

    public void setServiceClass(String sServiceClass) {
        this.m_sServiceClass = sServiceClass;
    }

    public String getServiceClass() {
        return this.m_sServiceClass;
    }
}

