/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.service;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.Constants;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.service.BootstrapServiceFolder;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;
import java.util.ArrayList;
import java.util.List;

public class CnfgServiceUtils
extends Constants {
    public static void createStartTask(List<ICnfgTask> list, boolean bSaveConfig, BootstrapServiceFolder btsvFolder) {
        CnfgServiceUtils.createStartTask(list, bSaveConfig, btsvFolder, true);
    }

    public static void createStartTask(List<ICnfgTask> list, boolean bSaveConfig, BootstrapServiceFolder btsvFolder, boolean bRunVerify) {
        boolean bPerformStart = false;
        BootstrapServiceFolder curFolder = btsvFolder;
        if (curFolder == null) {
            curFolder = (BootstrapServiceFolder)DataManager.getInstance().getCBS();
        }
        if (bRunVerify) {
            DataManager.getInstance().getVerifyConfig().createVerifyPortsTask(list);
            DataManager.getInstance().getVerifyConfig().createVerifyFolderPathTask(list);
        }
        CnfgServiceUtils.createUnregisterServiceTask(list, bSaveConfig, curFolder);
        CnfgServiceUtils.createRegisterServiceTask(list, bSaveConfig, curFolder);
        String serviceName = "";
        if (bSaveConfig) {
            if (curFolder != null) {
                serviceName = curFolder.getNewServiceName();
                bPerformStart = true;
            }
        } else {
            serviceName = curFolder != null ? curFolder.getCnfgServiceName() : DataManager.getInstance().getCRNServiceName();
            if (serviceName != null && serviceName.length() > 0) {
                bPerformStart = true;
            }
        }
        if (bPerformStart) {
            final String servName = serviceName;
            final boolean bIsCBS = curFolder != null ? curFolder.isThisCBS() : true;
            final BootstrapServiceFolder srvFolder = curFolder;
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.startservice");
                }

                @Override
                public String getDescription() {
                    Object[] args = new Object[]{servName};
                    return CnfgResource.getMessage("Message.silent.start", args);
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    String output;
                    if (bIsCBS) {
                        ArrayList statistics = new ArrayList();
                        if (DataManager.getInstance().isUpgradeRequired(statistics) || DataManager.getInstance().isIPFUpgradeRequired()) {
                            DataManager.getInstance().updateUpgradeFile(true);
                            ServiceManager.start(srvFolder, new Integer(Integer.MAX_VALUE));
                        } else {
                            DataManager.getInstance().updateUpgradeFile(false);
                            ServiceManager.start(srvFolder);
                        }
                    } else {
                        ServiceManager.start(srvFolder);
                    }
                    if (srvFolder != null && (output = ServiceManager.getMessagesFromLogs(srvFolder.getServiceClass())) != null && output.length() > 0) {
                        feedback.showInformational(output);
                    }
                    return true;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }
            });
        }
    }

    public static void createStopTask(List<ICnfgTask> list, BootstrapServiceFolder btsvFolder) {
        String serviceName = "";
        serviceName = btsvFolder != null ? btsvFolder.getRegServiceName() : ServiceManager.getCBSRegName();
        final String curServName = serviceName;
        final BootstrapServiceFolder srvFolder = btsvFolder;
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.task.stopservice");
            }

            @Override
            public boolean isMandatory() {
                return false;
            }

            @Override
            public String getDescription() {
                Object[] args = new Object[]{curServName};
                return CnfgResource.getMessage("Message.silent.stopping", args);
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                String output;
                if (ServiceManager.isRunning(srvFolder)) {
                    ServiceManager.stop(srvFolder);
                }
                if (srvFolder != null && (output = ServiceManager.getMessagesFromLogs(srvFolder.getServiceClass())) != null && output.length() > 0) {
                    feedback.showInformational(output);
                }
                return true;
            }
        });
    }

    private static void createRegisterServiceTask(List<ICnfgTask> list, boolean bSaveConfig, BootstrapServiceFolder btsvFolder) {
        boolean bPerformRegister = false;
        String cbsNewName = "";
        BootstrapServiceFolder curFolder = btsvFolder;
        if (btsvFolder == null) {
            curFolder = (BootstrapServiceFolder)DataManager.getInstance().getCBS();
        }
        if (bSaveConfig) {
            if (curFolder != null) {
                cbsNewName = curFolder.getNewServiceName();
            }
        } else {
            cbsNewName = curFolder != null ? curFolder.getCnfgServiceName() : DataManager.getInstance().getCRNServiceName();
        }
        if (cbsNewName != null && cbsNewName.length() > 0) {
            String regName = "";
            regName = curFolder == null ? ServiceManager.getCBSRegName() : curFolder.getRegServiceName();
            if (!ServiceManager.isRegistered(cbsNewName, curFolder) || regName == null) {
                bPerformRegister = true;
            }
        }
        if (bPerformRegister) {
            final String servName = cbsNewName;
            final BootstrapServiceFolder srvFolder = curFolder;
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.registerservice");
                }

                @Override
                public String getDescription() {
                    Object[] args = new Object[]{servName};
                    return CnfgResource.getMessage("Message.silent.registering", args);
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    if (servName != null && servName.length() > 0) {
                        ServiceManager.isDuplicateService(servName, srvFolder);
                        ServiceManager.setRegServiceName(servName, srvFolder);
                        ServiceManager.install(true, srvFolder);
                        ServiceManager.fireServiceStatusChanged(srvFolder);
                    }
                    return true;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }
            });
        }
    }

    public static void createUnregisterTask(List<ICnfgTask> list, BootstrapServiceFolder btsvFolder) {
        String regName = "";
        if (btsvFolder != null) {
            regName = btsvFolder.getRegServiceName();
            if (ServiceManager.isRegistered(regName, btsvFolder)) {
                CnfgServiceUtils.addUnregisterServiceTask(list, null, regName, btsvFolder);
            } else {
                CnfgLog.debug("The service '" + regName + "' is not registered, no need to unregister it. ");
            }
        }
    }

    public static void createUnregisterServiceTask(List<ICnfgTask> list, boolean bSaveConfig, BootstrapServiceFolder btsvFolder) {
        boolean bPerformUnregister = false;
        BootstrapServiceFolder curFolder = btsvFolder;
        if (btsvFolder == null) {
            curFolder = (BootstrapServiceFolder)DataManager.getInstance().getCBS();
        }
        String cbsNewName = "";
        String cbsCurName = "";
        cbsCurName = curFolder != null ? curFolder.getRegServiceName() : ServiceManager.getCBSRegName();
        if (null != cbsCurName) {
            if (bSaveConfig) {
                if (curFolder != null) {
                    cbsNewName = curFolder.getNewServiceName();
                    if (!cbsNewName.equals(cbsCurName)) {
                        bPerformUnregister = true;
                    }
                } else {
                    bPerformUnregister = true;
                }
            } else {
                cbsNewName = curFolder != null ? curFolder.getCnfgServiceName() : DataManager.getInstance().getCRNServiceName();
                if (cbsNewName != null && cbsNewName.length() > 0) {
                    if (!cbsNewName.equals(cbsCurName)) {
                        bPerformUnregister = true;
                    }
                } else {
                    bPerformUnregister = true;
                }
            }
        }
        if (bPerformUnregister) {
            CnfgServiceUtils.addUnregisterServiceTask(list, cbsNewName, cbsCurName, curFolder);
        }
    }

    private static void addUnregisterServiceTask(List<ICnfgTask> list, String regNewName, String curRegName, BootstrapServiceFolder btsvFolder) {
        final String servName = regNewName;
        final String curName = curRegName;
        final BootstrapServiceFolder srvFolder = btsvFolder;
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.task.unregisterservice");
            }

            @Override
            public String getDescription() {
                Object[] args = new Object[]{curName};
                return CnfgResource.getMessage("Message.silent.unregistering", args);
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                ServiceManager.isDuplicateService(servName, srvFolder);
                ServiceManager.uninstall(srvFolder);
                ServiceManager.setRegServiceName(null, srvFolder);
                ServiceManager.fireServiceStatusChanged(srvFolder);
                return true;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
    }

    public static String getCBSNewServiceName(BootstrapServiceFolder cbsFolder) {
        String srvNewName = null;
        String customServiceName = (String)CnfgPreferences.getInstance().getProperty("CustomServiceName", String.class);
        if (customServiceName == null || customServiceName.length() == 0) {
            srvNewName = cbsFolder.getName();
            int port = CnfgDataUtils.getBasePortNumber("internalDispatcher");
            if (port <= 0) {
                port = CnfgDataUtils.getBasePortNumber("externalDispatcher");
            }
            if (port <= 0) {
                port = CnfgDataUtils.getBasePortNumber("DSSOAPServerURI");
            }
            if (port <= 0) {
                port = CnfgDataUtils.getStandalonePortNumber();
            }
            if (port <= 0) {
                srvNewName = srvNewName + ":" + new Integer(9300).toString();
            } else if (port != 9300) {
                srvNewName = srvNewName + ":" + new Integer(port).toString();
            }
        } else {
            srvNewName = customServiceName;
        }
        return srvNewName;
    }

    public static void createCMUpgradeTask(List list, String sSource) {
        if (!DataManager.getInstance().getDoPromoptForCMUpgrade()) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::createCMUpgradeTask() - the user has been prompted already in this session, then skip.");
            }
            return;
        }
        DataManager.getInstance().addCMUpgradeTask(list, sSource);
    }

    public static void createStartUpgradeTask(List<ICnfgTask> list) {
        String serviceName = DataManager.getInstance().getCRNServiceName();
        if (DataManager.getInstance().isInstalled("CM") && serviceName != null && serviceName.length() > 0) {
            CnfgServiceUtils.createCMUpgradeTask(list, "start");
        }
        CnfgServiceUtils.createStartTask(list, false, null);
    }

    public static void getCBSServiceRestartActionTasksLists(boolean bIncludeCMUpgradeTask, ArrayList<ICnfgTask> stopTaskList, ArrayList<ICnfgTask> startTaskList) {
        if (DataManager.getInstance().isBTSVInstalled()) {
            if (ServiceManager.isRunning()) {
                CnfgServiceUtils.createStopTask(stopTaskList, null);
            }
            if (bIncludeCMUpgradeTask) {
                CnfgServiceUtils.createStartUpgradeTask(startTaskList);
            } else {
                CnfgServiceUtils.createStartTask(startTaskList, true, null);
            }
        }
    }

    public static ICnfgTask[] getServiceTasks(int service) {
        ArrayList<ICnfgTask> list = new ArrayList<ICnfgTask>();
        switch (service) {
            case 1: {
                CnfgServiceUtils.createStartUpgradeTask(list);
                break;
            }
            case 2: {
                CnfgServiceUtils.createStopTask(list, null);
                break;
            }
            case 3: {
                CnfgServiceUtils.createStopTask(list, null);
                CnfgServiceUtils.createStartUpgradeTask(list);
                break;
            }
            case 4: {
                DataManager.getInstance().getSaveTasks(list);
                CnfgServiceUtils.createStartTask(list, true, null);
                break;
            }
            case 5: {
                CnfgServiceUtils.createStopTask(list, null);
                DataManager.getInstance().getSaveTasks(list);
                CnfgServiceUtils.createStartTask(list, true, null);
            }
        }
        ICnfgTask[] tasks = new ICnfgTask[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tasks[i] = list.get(i);
        }
        return tasks;
    }

    private static void getAllServiceFoldersRestartActionsLists(String sAction, List<ICnfgTask> stopTaskList, List<ICnfgTask> startTaskList) {
        List<ServiceFolder> lServices = DataManager.getInstance().getServiceFolders(true);
        Folder cbsFolder = DataManager.getInstance().getCBS();
        for (ServiceFolder srvFolder : lServices) {
            CnfgActionOld svAction;
            if (srvFolder == null || srvFolder == cbsFolder || srvFolder.getDisabled() || !srvFolder.getVisibility()) continue;
            ICnfgTask[] lTasks = null;
            if (srvFolder.isRunning()) {
                srvFolder.createRestartTasks(stopTaskList, startTaskList, false);
                continue;
            }
            if (srvFolder.isRunning() || (svAction = srvFolder.findAction("start")) == null || (lTasks = srvFolder.createStartTasks(svAction, false)) == null) continue;
            for (int j = 0; j < lTasks.length; ++j) {
                startTaskList.add(lTasks[j]);
            }
            if (sAction.equals("stop")) continue;
            ServiceManager.removeFromRestartServicesList(srvFolder.getName());
        }
    }

    public static void getRestartActionTasks(ArrayList<ICnfgTask> tasklist, boolean bIncludeCMUpgradeTask) {
        ArrayList<ICnfgTask> cbsStopTaskList = new ArrayList<ICnfgTask>();
        ArrayList<ICnfgTask> cbsStartTaskList = new ArrayList<ICnfgTask>();
        CnfgServiceUtils.getCBSServiceRestartActionTasksLists(bIncludeCMUpgradeTask, cbsStopTaskList, cbsStartTaskList);
        ArrayList<ICnfgTask> allOtherStopTaskList = new ArrayList<ICnfgTask>();
        ArrayList<ICnfgTask> allOtherStartTaskList = new ArrayList<ICnfgTask>();
        CnfgServiceUtils.getAllServiceFoldersRestartActionsLists("restart", allOtherStopTaskList, allOtherStartTaskList);
        tasklist.addAll(cbsStopTaskList);
        tasklist.addAll(allOtherStopTaskList);
        tasklist.addAll(allOtherStartTaskList);
        tasklist.addAll(cbsStartTaskList);
    }

    public static void getCBSServiceActionTasks(DataManager dm, String sAction, int res, ArrayList<ICnfgTask> tasklist) {
        if (dm.isBTSVInstalled()) {
            if (ServiceManager.isRunning() && sAction.equals("stop")) {
                CnfgServiceUtils.createStopTask(tasklist, null);
            } else if (!ServiceManager.isRunning() && sAction.equals("start")) {
                if (res == 0) {
                    CnfgServiceUtils.createStartTask(tasklist, true, null);
                } else {
                    CnfgServiceUtils.createStartUpgradeTask(tasklist);
                }
            }
        }
    }
}

