/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.service;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgTaskFeedback;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgNodeRenamedEvent;
import com.cognos.crconfig.data.CnfgNodeRenamedListener;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.service.BootstrapServiceFolder;
import com.cognos.crconfig.data.service.CnfgServiceFolderChangedEvent;
import com.cognos.crconfig.data.service.ICnfgServiceOperation;
import com.cognos.crconfig.data.service.ServiceManager;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class ServiceFolder
extends Folder
implements ServiceManager.ServiceManagerListener,
CnfgNodeRenamedListener,
ICnfgServiceOperation {
    private Integer m_isRunning = null;
    protected ArrayList<CnfgActionOld> m_lActionIsRunning = new ArrayList();
    private String m_sServiceName;
    private boolean m_bUnregisterOnDelete = false;

    public ServiceFolder(String name, boolean unregOnDel) {
        this.m_sServiceName = name;
        this.m_bUnregisterOnDelete = unregOnDel;
    }

    public void setUnregisterOnDelete(boolean unreg) {
        this.m_bUnregisterOnDelete = unreg;
    }

    public boolean getUnregisterOnDelete() {
        return this.m_bUnregisterOnDelete;
    }

    @Override
    public String getIcon() {
        if (this.m_icon != null) {
            return this.m_icon;
        }
        return "resource";
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        boolean bRet = super.load(parentFolder, elem);
        if (bRet) {
            this.findRunningActions();
        }
        return bRet;
    }

    public CnfgActionOld findAction(String name) {
        if (name == null) {
            return null;
        }
        ArrayList<CnfgActionOld> alist = this.getActions();
        for (int i = 0; i < alist.size(); ++i) {
            CnfgActionOld action = (CnfgActionOld)alist.get(i);
            if (!action.getName().equalsIgnoreCase(name)) continue;
            return action;
        }
        return null;
    }

    public void findRunningActions() {
        ArrayList<CnfgActionOld> lActions = new ArrayList<CnfgActionOld>();
        ArrayList<CnfgActionOld> alist = this.getActions();
        for (int i = 0; i < alist.size(); ++i) {
            CnfgActionOld action = (CnfgActionOld)alist.get(i);
            if (!action.getName().equalsIgnoreCase("isRunning")) continue;
            lActions.add(action);
        }
        this.m_lActionIsRunning = lActions;
    }

    private boolean isServiceRegistered() {
        boolean bRegistered = false;
        CnfgActionOld isRegAction = this.findAction("isRegistered");
        if (isRegAction != null) {
            ICnfgTask checkRegisteredTask = isRegAction.getTasks(null, new CnfgSilentActionFeedback())[0];
            try {
                bRegistered = checkRegisteredTask.run(null, (ICnfgFeedback)new CnfgSilentActionFeedback(this.m_sServiceName));
            }
            catch (Exception e) {
                bRegistered = false;
            }
        }
        return bRegistered;
    }

    @Override
    public ICnfgTask[] createStartTasks(CnfgActionOld action, boolean bSaveConfig) {
        if (action == null) {
            return null;
        }
        ICnfgTask[] startTasks = action.getTasks(null, new CnfgTaskFeedback());
        ICnfgTask[] regTaskList = null;
        if (CnfgUtils.isWindowsPlatform() && !action.requiresNoRegistration()) {
            if (!this.isServiceRegistered()) {
                CnfgActionOld regAction = this.findAction("register");
                if (regAction == null) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("No register action is defined for service folder '" + this.getName() + "'.");
                    }
                } else {
                    regTaskList = regAction.getTasks(null, new CnfgTaskFeedback());
                    if (regTaskList == null || regTaskList.length == 0) {
                        CnfgLog.error("No register action is defined for service folder '" + this.getName() + "'.");
                    }
                }
            }
            return DataManager.getInstance().mergeTaskList(regTaskList, startTasks);
        }
        return startTasks;
    }

    @Override
    public ICnfgTask[] createStopTasks(CnfgActionOld action) {
        if (action == null) {
            return null;
        }
        if (this.isRunning()) {
            return action.getTasks(null, new CnfgTaskFeedback());
        }
        CnfgLog.error("The service '" + this.m_sServiceName + "' is not running. ");
        return null;
    }

    @Override
    public ICnfgTask[] createUnregisterTasks(CnfgActionOld action) {
        if (action == null) {
            return null;
        }
        if (this.isServiceRegistered()) {
            return action.getTasks(null, new CnfgTaskFeedback());
        }
        CnfgLog.debug("The service '" + this.m_sServiceName + "' is not registered, no need to unregister it. ");
        return null;
    }

    @Override
    public ICnfgTask[] createRestartTasks(boolean bSaveConfig) {
        ICnfgTask[] stopList = this.createStopTasks(this.findAction("stop"));
        ICnfgTask[] startList = this.createStartTasks(this.findAction("start"), bSaveConfig);
        return DataManager.getInstance().mergeTaskList(stopList, startList);
    }

    @Override
    public void createRestartTasks(List<ICnfgTask> stopList, List<ICnfgTask> startList, boolean bSaveConfig) {
        ICnfgTask[] stopTaskList = this.createStopTasks(this.findAction("stop"));
        ICnfgTask[] startTaskList = this.createStartTasks(this.findAction("start"), bSaveConfig);
        if (stopTaskList != null) {
            for (int i = 0; i < stopTaskList.length; ++i) {
                stopList.add(stopTaskList[i]);
            }
        }
        if (startTaskList != null) {
            for (int j = 0; j < startTaskList.length; ++j) {
                startList.add(startTaskList[j]);
            }
        }
    }

    private Integer getRunningState(int CBSState, int CDSState) {
        int iRunning = 1;
        if (CBSState == -1) {
            iRunning = CDSState == 0 ? 0 : 1;
        } else if (CBSState == 0) {
            iRunning = CDSState == 1 ? 2 : 0;
        } else if (CBSState == 1) {
            iRunning = CDSState == 0 ? 2 : 1;
        }
        return new Integer(iRunning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServiceStatus() throws InterruptedException {
        int iCBSState = -1;
        int iCDSState = -1;
        if (this.m_lActionIsRunning.size() > 0) {
            for (int i = 0; i < this.m_lActionIsRunning.size(); ++i) {
                CnfgActionOld action = this.m_lActionIsRunning.get(i);
                if (action.getType().equals("cnfg") && this instanceof BootstrapServiceFolder) {
                    boolean bCBSRunning = ServiceManager.checkServiceStatus((BootstrapServiceFolder)this);
                    iCBSState = bCBSRunning ? 0 : 1;
                    if (!CnfgLog.isDebugEnabled()) continue;
                    CnfgLog.debug("ServiceFolder::checkServiceStatus() -- launch ServiceManager.checkServiceStatus(), iCBSState=" + iCBSState + " Folder name=" + super.getLabel());
                    continue;
                }
                ICnfgTask checkStatusTask = action.getTasks(null, new CnfgSilentActionFeedback())[0];
                try {
                    iCDSState = checkStatusTask.run(null, (ICnfgFeedback)new CnfgSilentActionFeedback(this.m_sServiceName)) ? 0 : 1;
                }
                catch (Exception e) {
                    iCDSState = 1;
                }
                if (!CnfgLog.isDebugEnabled()) continue;
                CnfgLog.debug("ServiceFolder::checkServiceStatus() -- launch user defined isRunning action, iCDSState=" + iCDSState + " Folder name=" + super.getLabel());
            }
            boolean bNotify = false;
            Integer iRunning = this.getRunningState(iCBSState, iCDSState);
            if (null == this.m_isRunning) {
                this.m_isRunning = iRunning;
                bNotify = true;
            } else {
                Integer n = this.m_isRunning;
                synchronized (n) {
                    if (this.m_isRunning.intValue() != iRunning.intValue()) {
                        this.m_isRunning = iRunning;
                        bNotify = true;
                    }
                }
            }
            if (bNotify) {
                this.serviceFolderStatusChanged(iRunning);
                if (this.getParent() != null && this.getParent().getName().equals("CBS")) {
                    ServiceManager.updateRunningStatus(this.m_isRunning != 1);
                }
            }
        }
    }

    @Override
    public void serviceStatusChecking(String msg) throws InterruptedException {
        if (msg == null || msg.length() == 0) {
            return;
        }
        this.checkServiceStatus();
    }

    private void serviceFolderStatusChanged(Integer iRunning) {
        int iState = iRunning;
        if (iState == 1) {
            this.m_icon = "resource_stop";
        } else if (iState == 0) {
            this.m_icon = "resource_start";
        } else if (iState == 2) {
            this.m_icon = "resource_mixed";
        }
        CnfgServiceFolderChangedEvent e = new CnfgServiceFolderChangedEvent(this);
        DataManager.getInstance().fireServiceFolderChanged(e);
    }

    public void serviceFolderStatusChanged() {
        this.serviceFolderStatusChanged(this.m_isRunning != null ? this.m_isRunning : new Integer(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        if (null == this.m_isRunning) {
            try {
                this.checkServiceStatus();
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        if (null == this.m_isRunning) {
            return false;
        }
        Integer n = this.m_isRunning;
        synchronized (n) {
            return this.m_isRunning != 1;
        }
    }

    public void resetIsRunning() {
        this.m_isRunning = null;
    }

    @Override
    public void nodeRenamed(CnfgNodeRenamedEvent e) {
        this.serviceFolderStatusChanged();
    }

    private class CnfgSilentActionFeedback
    implements ICnfgFeedback {
        private String m_sDbgId;

        public CnfgSilentActionFeedback() {
            this.m_sDbgId = "[No debug id]";
        }

        public CnfgSilentActionFeedback(String sIdentifier) {
            this.m_sDbgId = sIdentifier;
        }

        public void showError(String message) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(this.m_sDbgId + " " + message);
            }
        }

        public void showInformational(String message) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(this.m_sDbgId + " " + message);
            }
        }

        public void showWarning(String message) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(this.m_sDbgId + " " + message);
            }
        }

        public void invalidateParameter(String parameterPath) {
        }

        public boolean promptForConfirmation(String message) {
            return false;
        }

        public String prompt(String arg) {
            return null;
        }
    }
}

