/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.service;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.ResourceIdentifiers;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.service.BootstrapServiceFolder;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.data.service.ServiceManagerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ServiceManager {
    private static String m_sCBSRegName;
    private static String m_sCBSServiceClass;
    private static Boolean m_isRunning;
    private static CheckStatusThread m_runThread;
    private static ArrayList m_smListeners;
    private static boolean m_windows;
    private static ArrayList m_lRestartServices;
    public static final String COGCONFIG_REG_FILE = "../configuration/cogconfig_reg.txt";
    public static final String SERVELET_GATEWAY_LOGFILE = "../logs/servletGW_";
    public static final String SERVELET_GATEWAY_TYPE = "ServletGateway";
    private static StringBuffer m_inputMsg;
    private static StringBuffer m_errorMsg;
    private static final Map<String, String[]> m_DefaultArgumentsTable;
    private static Integer m_maxTries;
    private static Integer m_waitInterval;
    private static Integer m_testCBSMaxTries;
    private static int m_lTimeOut;
    private static String m_processName;
    private static String m_sBinDir;
    private static String m_sOpSuffix;
    private static Boolean m_hasOtherServicesInstalled;
    public static final int DEFAULT_PORT = 9300;
    private static final int CBS_FAILED = -1;
    private static final int CBS_SUCCESS = 0;
    private static final int CBS_AUTOMATIC = 2;
    private static final int CBS_MANUAL = 3;
    private static final int CBS_DISABLED = 4;
    private static final String OP_START = "start";
    private static final String OP_STOP = "stop";
    private static final String OP_ISRUNNING = "isrunning";
    private static final String OP_INSTALL = "install";
    private static final String OP_UNINSTALL = "uninstall";
    private static final String OP_ISREGISTERED = "isregistered";
    private static final String OP_CBS_CNFGTEST = "cbs_cnfgtest";
    private static final String DEFAULT_WAIT_INTERVAL = "120";
    private static final String SERVICE_NAME = "%SERVICE_NAME%";
    private static final String SERVICE_CLASS = "%SERVICE_CLASS%";
    private static final String SERVICE_DESCRIPTION = "%SERVICE_DESCRIPTION%";
    private static final String SERVICE_TYPE = "%SERVICE_TYPE%";
    private static final String INSTALL_ROOT = "%INSTALL_ROOT%";
    private static final String TIME_OUT = "%TIME_OUT%";
    private static final String POLLING_NUMBER = "%POLLING_NUMBER%";
    private static final String POLLING_INTERVAL = "%POLLING_INTERVAL%";
    private static final String TEST_CONFIG_FILE = "%TEST_CONFIG_FILE%";
    private static final String TEST_LOGCONFIG_FILE = "%TEST_LOGCONFIG_FILE%";
    private static final String CBS_CONFIG_FILE = "%CBS_CONFIG_FILE%";
    private static final String SERVICE_WAIT_INTERVAL = "500";
    private static final String SERVICE_MAX_TRIES = "1800";
    private static final String TEST_CBS_MAX_TRIES = "100";
    private static String m_serviceJavaHome;
    static final String[][] m_errCmd;

    public static String getCBSRegName() {
        return m_sCBSRegName;
    }

    public static void resetName() {
        m_sCBSRegName = null;
        m_sCBSServiceClass = "";
        List<ServiceFolder> lServices = DataManager.getInstance().getServiceFolders(true);
        for (int i = 0; i < lServices.size(); ++i) {
            ServiceFolder srvFolder = lServices.get(i);
            if (!(srvFolder instanceof BootstrapServiceFolder)) continue;
            BootstrapServiceFolder btsvSrvFolder = (BootstrapServiceFolder)srvFolder;
            btsvSrvFolder.setRegServiceName(null);
            if (!btsvSrvFolder.isThisCBS()) continue;
            m_sCBSRegName = btsvSrvFolder.getRegServiceName();
            m_sCBSServiceClass = btsvSrvFolder.getServiceClass();
        }
    }

    public static void setRegServiceName(String name, BootstrapServiceFolder srvFolder) {
        if (srvFolder != null) {
            srvFolder.setRegServiceName(name);
            if (srvFolder.isThisCBS()) {
                m_sCBSRegName = name;
                m_sCBSServiceClass = srvFolder.getServiceClass();
            }
        } else {
            m_sCBSRegName = name;
            m_sCBSServiceClass = "";
        }
    }

    public static boolean isDirty() {
        return m_lRestartServices != null && m_lRestartServices.size() > 0;
    }

    public static void setDirty(ArrayList lRestartServices) {
        m_lRestartServices = lRestartServices;
    }

    public static ArrayList getRestartServices() {
        return m_lRestartServices;
    }

    public static void removeFromRestartServicesList(String sName) {
        if (m_lRestartServices != null && m_lRestartServices.size() > 0) {
            m_lRestartServices.remove(sName);
        }
    }

    public static void resetIsRunning() {
        m_isRunning = null;
        ServiceFolder cbsFolder = (ServiceFolder)DataManager.getInstance().getCBS();
        if (cbsFolder != null) {
            cbsFolder.resetIsRunning();
        }
    }

    private static String[] resolveArguments(String sOperation, String sServiceName, boolean bIsAutoStart, Integer iTimeOut, String sServiceClass) throws ServiceManagerException {
        return ServiceManager.resolveArguments(sOperation, sServiceName, bIsAutoStart, iTimeOut, null, sServiceClass);
    }

    private static String[] resolveArguments(String sOperation, String sServiceName, boolean bIsAutoStart, Integer iTimeOut, ArrayList additionArgList, String sServiceClass) throws ServiceManagerException {
        String[] args = null;
        String sArgsPropertyName = "Service_" + sOperation + m_sOpSuffix;
        String overrideArgs = (String)CnfgPreferences.getInstance().getProperty(sArgsPropertyName, String.class);
        if (null == overrideArgs) {
            String[] argsTemps = m_DefaultArgumentsTable.get(sArgsPropertyName);
            if (additionArgList == null) {
                args = new String[argsTemps.length + 2];
                System.arraycopy(argsTemps, 0, args, 1, argsTemps.length);
            } else {
                args = new String[argsTemps.length + additionArgList.size() + 2];
                System.arraycopy(argsTemps, 0, args, 1, argsTemps.length);
                System.arraycopy(additionArgList.toArray(), 0, args, argsTemps.length + 1, additionArgList.size());
            }
        } else {
            StringTokenizer tokens = new StringTokenizer(overrideArgs);
            int numTokens = tokens.countTokens();
            args = new String[numTokens + 1];
            for (int iTokens = 1; iTokens < numTokens; ++iTokens) {
                args[iTokens] = tokens.nextToken();
            }
        }
        if (null == args || 0 == args.length) {
            throw new ServiceManagerException("Couldn't find argument template for service operation: " + sOperation);
        }
        for (int i = 1; i < args.length - 1; ++i) {
            StringBuffer sbArgBuffer = new StringBuffer(args[i]);
            int index = args[i].indexOf(SERVICE_NAME);
            if (-1 != index) {
                sbArgBuffer.replace(index, index + SERVICE_NAME.length(), sServiceName);
            }
            if (-1 != (index = args[i].indexOf(SERVICE_DESCRIPTION))) {
                sbArgBuffer.replace(index, index + SERVICE_DESCRIPTION.length(), CnfgResource.getMessage("Message.service.description", CnfgResource.getJVMInitialLocale()));
            }
            if (-1 != (index = args[i].indexOf(SERVICE_TYPE))) {
                sbArgBuffer.replace(index, index + SERVICE_TYPE.length(), bIsAutoStart ? "a" : "m");
            }
            if (-1 != (index = args[i].indexOf(SERVICE_CLASS))) {
                sbArgBuffer.replace(index, index + SERVICE_CLASS.length(), sServiceClass);
            }
            if (-1 != (index = args[i].indexOf(INSTALL_ROOT))) {
                sbArgBuffer.replace(index, index + INSTALL_ROOT.length(), ServiceManager.getBinDirectory());
            }
            if (-1 != (index = args[i].indexOf(TIME_OUT))) {
                int timeOut = iTimeOut != null ? iTimeOut : m_lTimeOut;
                sbArgBuffer.replace(index, index + TIME_OUT.length(), 0 == timeOut ? DEFAULT_WAIT_INTERVAL : String.valueOf(timeOut));
            }
            if (-1 != (index = args[i].indexOf(POLLING_NUMBER))) {
                int iTries = iTimeOut != null ? iTimeOut : m_lTimeOut;
                sbArgBuffer.replace(index, index + POLLING_NUMBER.length(), 0 == iTries ? DEFAULT_WAIT_INTERVAL : String.valueOf(iTries));
            }
            if (-1 != (index = args[i].indexOf(POLLING_INTERVAL))) {
                sbArgBuffer.replace(index, index + POLLING_INTERVAL.length(), "1");
            }
            if (-1 != (index = args[i].indexOf(TEST_CONFIG_FILE))) {
                sbArgBuffer.replace(index, index + TEST_CONFIG_FILE.length(), ServiceManager.getTestConfigFile());
            }
            if (-1 != (index = args[i].indexOf(TEST_LOGCONFIG_FILE))) {
                sbArgBuffer.replace(index, index + TEST_LOGCONFIG_FILE.length(), ServiceManager.getTestLogConfigFile());
            }
            args[i] = sbArgBuffer.toString();
        }
        args[args.length - 1] = "-java_home=" + ServiceManager.getServiceJavaHome();
        return args;
    }

    private static String getServiceJavaHome() {
        if (null == m_serviceJavaHome) {
            String curJavaHome = System.getProperty("java.home");
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("ServiceManager::getServiceJavaHome() - System.getProperty('java.home') = " + curJavaHome);
            }
            String adjustedJavaHome = curJavaHome + File.separator + "..";
            File jreDir = new File(adjustedJavaHome + File.separator + "jre");
            File jdkexeFile = CnfgUtils.isWindowsPlatform() ? new File(adjustedJavaHome + File.separator + "bin" + File.separator + "java.exe") : new File(adjustedJavaHome + File.separator + "bin" + File.separator + "java");
            File libDir = new File(adjustedJavaHome + File.separator + "lib");
            if (jreDir.exists() && jreDir.isDirectory() && jdkexeFile.exists() && libDir.exists() && libDir.isDirectory()) {
                File file = new File(adjustedJavaHome);
                try {
                    adjustedJavaHome = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                m_serviceJavaHome = adjustedJavaHome;
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("ServiceManager::getServiceJavaHome() - JDK folder was found, java home = " + adjustedJavaHome);
                }
            } else {
                m_serviceJavaHome = curJavaHome;
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("ServiceManager::getServiceJavaHome() - JDK folder was not found , java home = " + curJavaHome);
                }
            }
        }
        return m_serviceJavaHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getBinDirectory() {
        if (null != m_sBinDir) return m_sBinDir;
        Class<ServiceManager> clazz = ServiceManager.class;
        synchronized (ServiceManager.class) {
            if (null != m_sBinDir) return m_sBinDir;
            m_sBinDir = CCLConfigurationFactory.getInstance().resolveEffectivePath(".");
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_sBinDir;
        }
    }

    private static String getTestConfigFile() {
        Object type;
        String sTestCBSConfigFile = "./cbs_cnfgtest_${platform}.xml";
        Folder cbsFolder = DataManager.getInstance().getCBS();
        if (null != cbsFolder && (type = cbsFolder.getTemplatedParameter().getValue()).equals("WebSphereLiberty")) {
            sTestCBSConfigFile = "./cbs_cnfgtest_wlp_${platform}.xml";
        }
        return CCLConfigurationFactory.getInstance().resolveEffectivePath(sTestCBSConfigFile);
    }

    private static String getTestLogConfigFile() {
        return CCLConfigurationFactory.getInstance().resolveEffectivePath("./cbs_cnfgtest_logconfig.xml");
    }

    public static void start(BootstrapServiceFolder btsvSrvFolder) throws ServiceManagerException {
        ServiceManager.start(btsvSrvFolder, m_maxTries);
    }

    public static void start(BootstrapServiceFolder btsvSrvFolder, Integer iTimeOut) throws ServiceManagerException {
        try {
            String serviceName = btsvSrvFolder != null ? btsvSrvFolder.getRegServiceName() : m_sCBSRegName;
            String serviceClass = btsvSrvFolder != null ? btsvSrvFolder.getServiceClass() : m_sCBSServiceClass;
            ServiceManager.start(serviceName, iTimeOut, serviceClass);
            if (btsvSrvFolder != null) {
                btsvSrvFolder.checkServiceStatus();
            } else {
                Folder cbsFolder = DataManager.getInstance().getCBS();
                if (cbsFolder != null) {
                    ((ServiceFolder)cbsFolder).checkServiceStatus();
                }
            }
        }
        catch (InterruptedException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
            }
        }
        catch (ServiceManagerException e) {
            throw e;
        }
        if (btsvSrvFolder == null || btsvSrvFolder.isThisCBS()) {
            ServiceManager.removeFromRestartServicesList("CBS");
        } else {
            ServiceManager.removeFromRestartServicesList(btsvSrvFolder.getName());
        }
    }

    public static void start(String sServiceName, Integer iTimeOut, String sServiceClass) throws ServiceManagerException {
        ServiceManager.pauseCheckServiceStatus();
        try {
            int retVal = ServiceManager.executeExternalProcess(OP_START, ServiceManager.resolveArguments(OP_START, sServiceName, false, iTimeOut, sServiceClass), iTimeOut);
            if (retVal != 0) {
                throw ServiceManager.createError(OP_START, retVal);
            }
        }
        catch (InterruptedException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
            }
        }
        catch (ServiceManagerException e) {
            ServiceManager.resumeCheckServiceStatus();
            throw e;
        }
        ServiceManager.resumeCheckServiceStatus();
    }

    public static void testCBS(ArrayList additionArgList, String serviceClass) throws ServiceManagerException {
        ServiceManager.pauseCheckServiceStatus();
        try {
            int retValTest = ServiceManager.executeExternalProcess(OP_CBS_CNFGTEST, ServiceManager.resolveArguments(OP_CBS_CNFGTEST, m_sCBSRegName, false, m_maxTries, additionArgList, serviceClass), m_testCBSMaxTries, true);
            if (retValTest != 0) {
                throw ServiceManager.createError(OP_CBS_CNFGTEST, retValTest);
            }
            if (m_errorMsg.length() > 0 || m_inputMsg.length() > 0) {
                Object[] details = new Object[]{m_errorMsg.length() > 0 ? m_errorMsg.toString() : m_inputMsg.toString()};
                String sMsg = CnfgResource.getMessage("Message.testcbs.fail", details);
                CnfgLog.error(sMsg);
                throw new ServiceManagerException(sMsg);
            }
        }
        catch (InterruptedException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
            }
        }
        catch (ServiceManagerException e) {
            ServiceManager.resumeCheckServiceStatus();
            throw e;
        }
        ServiceManager.resumeCheckServiceStatus();
    }

    public static void stop(String sServiceName, String sServiceClass) throws ServiceManagerException {
        ServiceManager.pauseCheckServiceStatus();
        try {
            int retVal = ServiceManager.executeExternalProcess(OP_STOP, ServiceManager.resolveArguments(OP_STOP, sServiceName, false, null, sServiceClass), m_maxTries);
            if (retVal != 0) {
                throw ServiceManager.createError(OP_STOP, retVal);
            }
        }
        catch (InterruptedException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
            }
        }
        catch (ServiceManagerException e) {
            ServiceManager.resumeCheckServiceStatus();
            throw e;
        }
        ServiceManager.resumeCheckServiceStatus();
    }

    public static void stop(BootstrapServiceFolder btsvSrvFolder) throws ServiceManagerException {
        try {
            String serviceName = btsvSrvFolder != null ? btsvSrvFolder.getRegServiceName() : m_sCBSRegName;
            String serviceClass = btsvSrvFolder != null ? btsvSrvFolder.getServiceClass() : m_sCBSServiceClass;
            ServiceManager.stop(serviceName, serviceClass);
            if (btsvSrvFolder != null) {
                btsvSrvFolder.checkServiceStatus();
            } else {
                Folder cbsFolder = DataManager.getInstance().getCBS();
                if (cbsFolder != null) {
                    ((ServiceFolder)cbsFolder).checkServiceStatus();
                }
            }
        }
        catch (InterruptedException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
            }
        }
        catch (ServiceManagerException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning() {
        ServiceFolder cbsFolder;
        if (null == m_isRunning && (cbsFolder = (ServiceFolder)DataManager.getInstance().getCBS()) != null) {
            m_isRunning = new Boolean(cbsFolder.isRunning());
        }
        if (null != m_isRunning) {
            Boolean bl = m_isRunning;
            synchronized (bl) {
                return m_isRunning;
            }
        }
        return false;
    }

    public static boolean isRunning(BootstrapServiceFolder btsvSrvFolder) {
        if (btsvSrvFolder != null) {
            return btsvSrvFolder.isRunning();
        }
        return ServiceManager.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRunningStatus(boolean bIsRunning) {
        if (null == m_isRunning) {
            m_isRunning = new Boolean(bIsRunning);
        } else {
            Boolean bl = m_isRunning;
            synchronized (bl) {
                m_isRunning = bIsRunning ? Boolean.TRUE : Boolean.FALSE;
            }
        }
    }

    public static void install(boolean autostart, BootstrapServiceFolder srvFolder) throws ServiceManagerException {
        String regServiceName = "";
        String sClass = "";
        if (srvFolder == null) {
            regServiceName = m_sCBSRegName;
            sClass = m_sCBSServiceClass;
        } else {
            regServiceName = srvFolder.getRegServiceName();
            sClass = srvFolder.getServiceClass();
        }
        if (m_windows) {
            ServiceManager.pauseCheckServiceStatus();
            try {
                int retVal = ServiceManager.executeExternalProcess(OP_INSTALL, ServiceManager.resolveArguments(OP_INSTALL, regServiceName, autostart, null, sClass), m_maxTries);
                if (retVal != 0) {
                    throw ServiceManager.createError(OP_INSTALL, retVal);
                }
            }
            catch (InterruptedException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug(e);
                }
            }
            catch (ServiceManagerException e) {
                ServiceManager.resumeCheckServiceStatus();
                throw e;
            }
            ServiceManager.resumeCheckServiceStatus();
        }
        try {
            String regFile = "";
            regFile = srvFolder == null ? COGCONFIG_REG_FILE : srvFolder.getRegFile();
            File serviceName = DataManager.getInstance().resolveEffectiveFilePath(regFile);
            if (serviceName != null) {
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(serviceName.getAbsolutePath(), false), "UTF-8");
                osw.write(regServiceName);
                osw.close();
            }
        }
        catch (IOException e) {
            throw new ServiceManagerException(e.getLocalizedMessage());
        }
        catch (DataManagerException e) {
            CnfgLog.error(e);
            throw new ServiceManagerException(e.getMessage());
        }
    }

    public static void uninstall(BootstrapServiceFolder srvFolder) throws ServiceManagerException {
        if (m_windows) {
            String regServiceName = "";
            String serviceClass = "";
            if (srvFolder == null) {
                regServiceName = m_sCBSRegName;
                serviceClass = m_sCBSServiceClass;
            } else {
                regServiceName = srvFolder.getRegServiceName();
                serviceClass = srvFolder.getServiceClass();
            }
            ServiceManager.pauseCheckServiceStatus();
            try {
                int retVal = ServiceManager.executeExternalProcess(OP_UNINSTALL, ServiceManager.resolveArguments(OP_UNINSTALL, regServiceName, false, null, serviceClass), m_maxTries);
                if (retVal != 0) {
                    throw ServiceManager.createError(OP_UNINSTALL, retVal);
                }
            }
            catch (InterruptedException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug(e);
                }
            }
            catch (ServiceManagerException e) {
                ServiceManager.resumeCheckServiceStatus();
                throw e;
            }
        }
        try {
            String regFile = "";
            regFile = srvFolder == null ? COGCONFIG_REG_FILE : srvFolder.getRegFile();
            File serviceName = DataManager.getInstance().resolveEffectiveFilePath(regFile);
            if (serviceName != null) {
                serviceName.delete();
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("ServiceManager::uninstall(srvFolder) - The reg file '" + regFile + "' is deleted.");
                }
            }
        }
        catch (DataManagerException e) {
            CnfgLog.error(e);
            throw new ServiceManagerException(e.getMessage());
        }
    }

    public static void isDuplicateService(String newServName, BootstrapServiceFolder srvFolder) throws ServiceManagerException {
        if (m_windows && newServName != null && ServiceManager.isRegistered(newServName, srvFolder)) {
            Object[] args = new Object[]{newServName};
            StringBuffer sMessage = new StringBuffer(CnfgResource.getMessage("Message.errorExistingServiceName.notification", args));
            sMessage.append("\n").append(CnfgResource.getMessage("Message.errorExistingServiceName.resolution"));
            if (m_errorMsg.length() != 0) {
                sMessage.append("\n").append(m_errorMsg);
            }
            throw new ServiceManagerException(sMessage.toString());
        }
    }

    public static boolean isRegistered() {
        return ServiceManager.isRegistered(m_sCBSRegName, null);
    }

    public static boolean isRegistered(String name, BootstrapServiceFolder srvFolder) {
        if (m_windows && null != name) {
            int retVal;
            block6: {
                String serviceClass = "";
                serviceClass = srvFolder != null ? srvFolder.getServiceClass() : m_sCBSServiceClass;
                retVal = -1;
                ServiceManager.pauseCheckServiceStatus();
                try {
                    retVal = ServiceManager.executeExternalProcess(OP_ISREGISTERED, ServiceManager.resolveArguments(OP_ISREGISTERED, name, false, null, serviceClass), m_maxTries);
                }
                catch (InterruptedException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                }
                catch (ServiceManagerException e) {
                    if (!CnfgLog.isDebugEnabled()) break block6;
                    CnfgLog.debug(e);
                }
            }
            ServiceManager.resumeCheckServiceStatus();
            return retVal != 0;
        }
        String regName = "";
        regName = srvFolder != null ? srvFolder.getRegServiceName() : m_sCBSRegName;
        if (regName != null) {
            return name.compareTo(regName) == 0;
        }
        return false;
    }

    public static boolean hasOtherServicesInstalled() {
        if (m_hasOtherServicesInstalled == null) {
            m_hasOtherServicesInstalled = Boolean.FALSE;
            ArrayList lServiceFolders = (ArrayList)DataManager.getInstance().getServiceFolders(true);
            for (int i = 0; i < lServiceFolders.size(); ++i) {
                ServiceFolder f = (ServiceFolder)lServiceFolders.get(i);
                if (f.getParent() != null && f.getParent().getName().equals("CBS") || f.getDisabled() || !f.getVisibility()) continue;
                m_hasOtherServicesInstalled = Boolean.TRUE;
                break;
            }
        }
        return m_hasOtherServicesInstalled;
    }

    public static void startCheckServiceStatus() {
        if (null == m_runThread && (DataManager.getInstance().isBTSVInstalled() || ServiceManager.hasOtherServicesInstalled())) {
            m_runThread = new CheckStatusThread();
            m_runThread.start();
            if (null != m_sCBSRegName || ServiceManager.hasOtherServicesInstalled()) {
                m_runThread.resumePolling();
            }
        }
    }

    public static void stopCheckServiceStatus() {
        if (null != m_runThread) {
            block3: {
                m_runThread.stopPolling();
                m_runThread.interrupt();
                try {
                    m_runThread.join();
                }
                catch (InterruptedException e) {
                    if (!CnfgLog.isDebugEnabled()) break block3;
                    CnfgLog.debug(e);
                }
            }
            m_runThread = null;
        }
    }

    public static void pauseCheckServiceStatus() {
        if (null != m_runThread) {
            m_runThread.pausePolling();
        }
    }

    public static void resumeCheckServiceStatus() {
        if (null != m_runThread) {
            m_runThread.resumePolling();
        }
    }

    public static void addListener(ServiceManagerListener sml) {
        m_smListeners.add(sml);
    }

    public static void removeListeners() {
        for (int i = 0; i < m_smListeners.size(); ++i) {
            ServiceManagerListener curSml = (ServiceManagerListener)m_smListeners.get(i);
            if (!(curSml instanceof ServiceFolder)) continue;
            m_smListeners.remove(curSml);
        }
    }

    public static void removeListener(Object sml) {
        if (sml == null || !(sml instanceof ServiceFolder)) {
            return;
        }
        for (int i = 0; i < m_smListeners.size(); ++i) {
            ServiceManagerListener curSml = (ServiceManagerListener)m_smListeners.get(i);
            if (curSml != sml) continue;
            m_smListeners.remove(curSml);
            break;
        }
    }

    private static int executeExternalProcess(String sOperation, String[] sArgs, Integer iMaxTries) throws ServiceManagerException, InterruptedException {
        return ServiceManager.executeExternalProcess(sOperation, sArgs, iMaxTries, false);
    }

    private static int executeExternalProcess(String sOperation, String[] sArgs, Integer iMaxTries, boolean bKillAfterTimeout) throws ServiceManagerException, InterruptedException {
        Process process = null;
        int retVal = 0;
        try {
            sArgs[0] = m_processName;
            if (CnfgLog.isDebugEnabled()) {
                StringBuffer debugCmdLine = new StringBuffer(1024);
                for (int j = 0; j < sArgs.length; ++j) {
                    if (-1 != sArgs[j].indexOf(32)) {
                        debugCmdLine.append('\"').append(sArgs[j]).append('\"');
                    } else {
                        debugCmdLine.append(sArgs[j]);
                    }
                    if (j >= sArgs.length - 1) continue;
                    debugCmdLine.append(" ");
                }
                CnfgLog.debug("Command line: " + debugCmdLine.toString());
            }
            process = Runtime.getRuntime().exec(sArgs, CnfgUtils.getEnv());
            InputStream input = process.getInputStream();
            m_inputMsg.setLength(0);
            InputStream error = process.getErrorStream();
            m_errorMsg.setLength(0);
            boolean alive = true;
            int tries = 0;
            while (alive && tries < iMaxTries) {
                block34: {
                    try {
                        retVal = process.exitValue();
                        alive = false;
                    }
                    catch (IllegalThreadStateException e) {
                        if (!CnfgLog.isDebugEnabled()) break block34;
                        CnfgLog.debug("No response from the process (" + process.toString() + ") , so keep polling. This is attempt # " + tries + " out of " + iMaxTries);
                    }
                }
                int n = tries = ServiceManager.captureOutput(input, error) ? 0 : tries + 1;
                if (!alive) {
                    if (!CnfgLog.isDebugEnabled()) break;
                    CnfgLog.debug("Process (" + process.toString() + ") is done, retval = " + retVal + ", number of tries = " + tries);
                    break;
                }
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("Sleeping " + m_waitInterval.longValue() + ". Process: " + process.toString());
                }
                Thread.sleep(m_waitInterval.longValue());
            }
            if (tries >= iMaxTries && !bKillAfterTimeout) {
                StringBuffer sMessage = new StringBuffer(CnfgResource.getMessage("CFG_ERR_TIMEOUT"));
                sMessage.append("\n").append(CnfgResource.getMessage("Message.service.failed.resolution"));
                CnfgLog.error(sMessage.toString());
                throw new ServiceManagerException(sMessage.toString());
            }
            if (bKillAfterTimeout && process != null) {
                ServiceManager.captureOutput(input, error);
                process.destroy();
            }
        }
        catch (InterruptedException ie) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(ie);
            }
            if (process != null) {
                block36: {
                    try {
                        ServiceManager.captureOutput(process.getInputStream(), process.getErrorStream());
                    }
                    catch (IOException e) {
                        if (!CnfgLog.isDebugEnabled()) break block36;
                        CnfgLog.debug("Tried to capture remaining stdout/stderr and an exception occurred, e is " + e.getMessage());
                    }
                }
                process.destroy();
            }
            throw ie;
        }
        catch (IOException e) {
            CnfgLog.error(e);
            StringBuffer sMessage = new StringBuffer(CnfgResource.getMessage(ResourceIdentifiers.findID(m_errCmd, sOperation)));
            sMessage.append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.service.failed.resolution"));
            throw new ServiceManagerException(sMessage.toString(), e);
        }
        finally {
            block39: {
                if (null != process) {
                    block38: {
                        block37: {
                            try {
                                process.getOutputStream().close();
                            }
                            catch (IOException e) {
                                if (!CnfgLog.isDebugEnabled()) break block37;
                                CnfgLog.debug("Exception occurred while closing input stream for Process (" + process.toString() + ").");
                            }
                        }
                        try {
                            process.getInputStream().close();
                        }
                        catch (IOException e) {
                            if (!CnfgLog.isDebugEnabled()) break block38;
                            CnfgLog.debug("Exception occurred while closing output stream for Process (" + process.toString() + ").");
                        }
                    }
                    try {
                        process.getErrorStream().close();
                    }
                    catch (IOException e) {
                        if (!CnfgLog.isDebugEnabled()) break block39;
                        CnfgLog.debug("Exception occurred while closing error stream for Process (" + process.toString() + ").");
                    }
                }
            }
        }
        return retVal;
    }

    private static boolean captureOutput(InputStream input, InputStream error) throws IOException {
        String str;
        int r;
        boolean bHasOutput = false;
        byte[] b = new byte[512];
        if (input.available() > 0 && (r = input.read(b)) > 0) {
            str = new String(b, 0, r);
            m_inputMsg.append(str);
            bHasOutput = true;
        }
        if (error.available() > 0 && (r = error.read(b)) > 0) {
            str = new String(b, 0, r);
            m_errorMsg.append(str);
            bHasOutput = true;
        }
        return bHasOutput;
    }

    private static ServiceManagerException createError(String operation, int retval) {
        Object[] args = new Object[]{new Integer(retval)};
        StringBuffer sMessage = new StringBuffer(CnfgResource.getMessage(ResourceIdentifiers.findID(m_errCmd, operation)));
        sMessage.append("\n").append(CnfgResource.getMessage("Message.service.failed.explanation", args));
        if (m_errorMsg.length() != 0) {
            sMessage.append("\n").append(m_errorMsg);
        }
        return new ServiceManagerException(sMessage.toString());
    }

    public static boolean checkServiceStatus(BootstrapServiceFolder srvFolder) throws InterruptedException {
        int retVal;
        String sName = "";
        String sClass = "";
        if (srvFolder != null) {
            sName = srvFolder.getRegServiceName();
            sClass = srvFolder.getServiceClass();
        } else {
            sName = m_sCBSRegName;
            sClass = m_sCBSServiceClass;
        }
        try {
            retVal = sName != null ? ServiceManager.executeExternalProcess(OP_ISRUNNING, ServiceManager.resolveArguments(OP_ISRUNNING, sName, false, null, sClass), m_maxTries) : -1;
        }
        catch (ServiceManagerException e) {
            retVal = -1;
        }
        boolean bRunning = retVal == 0;
        return bRunning;
    }

    public static void fireServiceStatusChanged() {
        Folder cbsFolder = DataManager.getInstance().getCBS();
        if (cbsFolder != null) {
            ServiceManager.fireServiceStatusChanged((BootstrapServiceFolder)cbsFolder);
        }
    }

    public static void fireServiceStatusChanged(BootstrapServiceFolder srvFolder) {
        if (srvFolder != null) {
            srvFolder.serviceFolderStatusChanged();
        }
    }

    protected static void fireServiceStatusChecking(String msg) throws InterruptedException {
        for (int i = 0; i < m_smListeners.size(); ++i) {
            ServiceManagerListener sml = (ServiceManagerListener)m_smListeners.get(i);
            sml.serviceStatusChecking(msg);
        }
    }

    public static void checkAllServicesStatus() {
        block5: {
            try {
                if (ServiceManager.hasOtherServicesInstalled()) {
                    ServiceManager.fireServiceStatusChecking(CnfgResource.getMessage("Message.silent.isrunning2"));
                } else if (null != ServiceManager.getCBSRegName()) {
                    Object[] args = new Object[]{ServiceManager.getCBSRegName()};
                    ServiceManager.fireServiceStatusChecking(CnfgResource.getMessage("Message.silent.isrunning", args));
                }
                ServiceManager.fireServiceStatusChecking("");
            }
            catch (InterruptedException e) {
                if (!CnfgLog.isDebugEnabled()) break block5;
                CnfgLog.debug("checking all services status is interrupted.");
            }
        }
    }

    public static String getMessagesFromLogs(String serviceType) {
        StringBuffer outpurStr;
        block10: {
            File logFile;
            BufferedReader bfLog = null;
            outpurStr = new StringBuffer();
            String filePath = "";
            if (serviceType.equals(SERVELET_GATEWAY_TYPE)) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String timeStamp = formatter.format(new Date());
                ICCLConfiguration cf = CCLConfigurationFactory.createConfiguration();
                filePath = cf.resolveEffectivePath(SERVELET_GATEWAY_LOGFILE + timeStamp + ".log");
            }
            if (!(logFile = new File(filePath)).exists()) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("getMessagesFromLogs - the log file " + filePath + " doesn't exist.");
                }
                return "";
            }
            try {
                bfLog = new BufferedReader(new FileReader(filePath));
                String str = bfLog.readLine();
                while (str != null) {
                    String delims;
                    String[] tokens;
                    if (str.length() > 0 && (tokens = str.split(delims = "[ ]+")).length > 3) {
                        String dateStr = tokens[0];
                        String timeStr = tokens[1];
                        String levelStr = tokens[2];
                        if (levelStr != null && levelStr.equalsIgnoreCase("INFO")) {
                            outpurStr.append(str).append("\n");
                        }
                    }
                    str = bfLog.readLine();
                }
            }
            catch (Exception e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("getMessagesFromLogs exception, e is " + e.getMessage());
                }
            }
            catch (Error e) {
                if (!CnfgLog.isDebugEnabled()) break block10;
                CnfgLog.debug("getMessagesFromLogs error, e is " + e.getMessage());
            }
        }
        return outpurStr.toString();
    }

    static {
        m_sCBSServiceClass = "";
        m_smListeners = new ArrayList();
        m_lRestartServices = new ArrayList();
        m_inputMsg = new StringBuffer();
        m_errorMsg = new StringBuffer();
        if (CnfgUtils.isWindowsPlatform()) {
            m_windows = true;
            m_sOpSuffix = "_win";
        } else {
            m_windows = false;
            m_sOpSuffix = "_unix";
        }
        m_DefaultArgumentsTable = new Hashtable<String, String[]>();
        m_DefaultArgumentsTable.put("Service_start_win", new String[]{"-start", "-name=%SERVICE_NAME%", "-timeLimitSec=%TIME_OUT%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_stop_win", new String[]{"-stop", "-name=%SERVICE_NAME%", "-timeLimitSec=%TIME_OUT%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_install_win", new String[]{"-i%SERVICE_TYPE%", "-name=%SERVICE_NAME%", "-description=%SERVICE_DESCRIPTION%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_uninstall_win", new String[]{"-u", "-name=%SERVICE_NAME%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_isrunning_win", new String[]{"-isrunning", "-name=%SERVICE_NAME%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_isregistered_win", new String[]{"-isregistered", "-name=%SERVICE_NAME%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_cbs_cnfgtest_win", new String[]{"-d", "-config=%TEST_CONFIG_FILE%", "-logconfig=%TEST_LOGCONFIG_FILE%", "-name=cbs_cnfgtest", "-timeLimitSec=%TIME_OUT%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_start_unix", new String[]{"-start", "-install_root=%INSTALL_ROOT%", "-testReadyTries=%POLLING_NUMBER%", "-testReadyInterval=%POLLING_INTERVAL%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_stop_unix", new String[]{"-stop", "-install_root=%INSTALL_ROOT%", "-testDeadTries=%POLLING_NUMBER%", "-testDeadInterval=%POLLING_INTERVAL%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_isrunning_unix", new String[]{"-isrunning", "-install_root=%INSTALL_ROOT%", "-serviceClass=%SERVICE_CLASS%"});
        m_DefaultArgumentsTable.put("Service_cbs_cnfgtest_unix", new String[]{"-d", "-config=%TEST_CONFIG_FILE%", "-logconfig=%TEST_LOGCONFIG_FILE%", "-install_root=%INSTALL_ROOT%", "-testReadyTries=%POLLING_NUMBER%", "-testReadyInterval=%POLLING_INTERVAL%", "-serviceClass=%SERVICE_CLASS%"});
        m_waitInterval = (Integer)CnfgPreferences.getInstance().getProperty("ServiceWaitInterval", SERVICE_WAIT_INTERVAL, Integer.class);
        m_maxTries = (Integer)CnfgPreferences.getInstance().getProperty("ServiceMaxTries", SERVICE_MAX_TRIES, Integer.class);
        m_lTimeOut = m_waitInterval * m_maxTries / 1000;
        m_processName = CCLConfigurationFactory.getInstance().resolveEffectivePath((String)CnfgPreferences.getInstance().getProperty("ServiceName", "./cogbootstrapservice", String.class));
        m_testCBSMaxTries = (Integer)CnfgPreferences.getInstance().getProperty("TestCBSMaxTries", TEST_CBS_MAX_TRIES, Integer.class);
        m_errCmd = new String[][]{{OP_START, "CFG_ERR_START_FAILED"}, {OP_STOP, "CFG_ERR_STOP_FAILED"}, {OP_INSTALL, "CFG_ERR_INSTALL_FAILED"}, {OP_UNINSTALL, "CFG_ERR_UNINSTALL_FAILED"}, {OP_ISRUNNING, "CFG_ERR_ISRUNNING_FAILED"}, {OP_CBS_CNFGTEST, "CFG_ERR_CBS_CNFGTEST"}};
    }

    public static interface ServiceManagerListener {
        public void serviceStatusChecking(String var1) throws InterruptedException;
    }

    static class CheckStatusThread
    extends Thread {
        volatile boolean m_bPaused = true;
        volatile boolean m_bKeepRunning = true;

        CheckStatusThread() {
        }

        @Override
        public void run() {
            while (true) {
                CheckStatusThread.yield();
                if (this.isInterrupted() || !this.m_bKeepRunning) {
                    return;
                }
                try {
                    if (!this.m_bPaused && (null != m_sCBSRegName || ServiceManager.hasOtherServicesInstalled())) {
                        if (ServiceManager.hasOtherServicesInstalled()) {
                            ServiceManager.fireServiceStatusChecking(CnfgResource.getMessage("Message.silent.isrunning2"));
                        } else if (null != m_sCBSRegName) {
                            Object[] args = new Object[]{m_sCBSRegName};
                            ServiceManager.fireServiceStatusChecking(CnfgResource.getMessage("Message.silent.isrunning", args));
                        }
                        CheckStatusThread.sleep(5000L);
                        ServiceManager.fireServiceStatusChecking("");
                    }
                    CheckStatusThread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void pausePolling() {
            block2: {
                this.m_bPaused = true;
                try {
                    ServiceManager.fireServiceStatusChecking("");
                }
                catch (InterruptedException e) {
                    if (!CnfgLog.isDebugEnabled()) break block2;
                    CnfgLog.debug(e);
                }
            }
        }

        public void resumePolling() {
            this.m_bPaused = false;
        }

        public void stopPolling() {
            this.m_bKeepRunning = false;
        }
    }
}

