/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.tenancy;

import com.cognos.crconfig.State;
import com.cognos.crconfig.data.tenancy.ProviderType;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class TenancyInfoProvider {
    private Map<String, ProviderType> typeMap;
    private ProviderType type;
    private String value;

    public TenancyInfoProvider() {
        this.typeMap = new TreeMap<String, ProviderType>();
        this.type = new ProviderType();
        this.value = "";
    }

    public TenancyInfoProvider(TenancyInfoProvider toCopy) {
        this.typeMap = new TreeMap<String, ProviderType>(toCopy.typeMap);
        this.type = new ProviderType(toCopy.type.getName(), toCopy.type.getLabel());
        this.value = toCopy.value;
    }

    public void addTypeChoice(String name, String label) {
        ProviderType type = new ProviderType(name, label);
        this.typeMap.put(name, type);
    }

    public Collection<ProviderType> getTypeChoices() {
        return this.typeMap.values();
    }

    public ProviderType getType() {
        return this.type;
    }

    public void setType(ProviderType type) {
        this.type = type;
    }

    public void setTypeByName(String type) {
        this.type = this.typeMap.get(type);
        if (this.type == null) {
            Map.Entry[] entryArray = new Map.Entry[2];
            entryArray = this.typeMap.entrySet().toArray(entryArray);
            this.type = (ProviderType)entryArray[0].getValue();
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public State validate() {
        return new State();
    }

    public String getDisplayValue() {
        return this.value;
    }

    public TenancyInfoProvider clone() {
        return new TenancyInfoProvider(this);
    }

    public String toString() {
        return this.value;
    }
}

