/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.tenancy;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.State;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.tenancy.TenancyInfoProvider;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class TenancyInfoProviderParameter
extends Parameter {
    private TenancyInfoProvider provider = new TenancyInfoProvider();
    private TenancyInfoProvider m_defaultProvider = null;
    private State validationState = new State(State.OK);

    public TenancyInfoProviderParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    @Override
    public Object getValue() {
        return this.provider;
    }

    @Override
    public void setToDefault() {
        this.setValue(this.m_defaultProvider);
    }

    @Override
    public boolean setValue(Object value) {
        boolean validationResult = true;
        this.m_sBadValue = null;
        this.clearErrorMsg();
        this.provider = (TenancyInfoProvider)value;
        validationResult = this.validate(this.provider);
        if (!validationResult) {
            this.m_sBadValue = this.provider.toString();
        }
        if (this.m_bFireValueChanged) {
            CnfgValueChangedEvent vce = new CnfgValueChangedEvent(this);
            DataManager.getInstance().fireValueChanged(vce);
        }
        return validationResult;
    }

    @Override
    public boolean hasWarnings() {
        return this.validationState.isWarning();
    }

    @Override
    public boolean setValue(Element value_elem) {
        Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
        QName qnITEM = new QName("item", nsCRN);
        Element itemElement = value_elem.element(qnITEM);
        if (itemElement != null) {
            String name = itemElement.attributeValue("name");
            String text = itemElement.getText();
            if (name == null || text == null || name.isEmpty()) {
                return false;
            }
            this.provider.setTypeByName(name);
            this.provider.setValue(text);
        }
        this.setValue(this.provider);
        return true;
    }

    @Override
    public boolean hasDefault() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return this.provider.isEmpty();
    }

    @Override
    public Object clone() {
        TenancyInfoProviderParameter np = (TenancyInfoProviderParameter)super.clone();
        np.provider = this.provider.clone();
        np.m_defaultProvider = this.m_defaultProvider.clone();
        np.validationState = this.validationState;
        return np;
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        boolean success = super.load(parentFolder, elem);
        if (!success) {
            return false;
        }
        for (Map.Entry entry : this.m_values.entrySet()) {
            this.provider.addTypeChoice((String)entry.getKey(), (String)entry.getValue());
        }
        String defaultType = elem.attributeValue("default", "");
        this.provider.setTypeByName(defaultType);
        if (this.m_defaultProvider == null) {
            this.m_defaultProvider = this.provider.clone();
        }
        return true;
    }

    @Override
    public void write(Element value_elem, boolean bEncrypt, List<String> errors) throws DataManagerException {
        if (this.isBadValue()) {
            this.recordBadValue(errors);
        }
        Element parent = value_elem.getParent();
        parent.addAttribute("opaque", "true");
        this.addItemElement(value_elem, this.provider.getType().getName(), this.provider.getValue());
    }

    public boolean validate(TenancyInfoProvider provider) {
        this.validationState = provider.validate();
        if (this.validationState.isError()) {
            this.addErrorMsg(this.validationState.getMessage());
            return false;
        }
        if (this.validationState.isWarning()) {
            this.addErrorMsg(this.validationState.getMessage());
        }
        return true;
    }

    void addItemElement(Element valueElement, String name, String uri) throws DataManagerException {
        Element itemElem = valueElement.addElement("crn:item");
        if (itemElem == null) {
            throw new DataManagerException(CnfgResource.getMessage("Message.errorOutOfMemory"));
        }
        itemElem.addAttribute("name", name);
        itemElem.addAttribute("xsi:type", "xsd:string");
        Element value = itemElem.addText(uri);
        if (value == null) {
            throw new DataManagerException(CnfgResource.getMessage("Message.errorOutOfMemory"));
        }
    }

    List<String> recordBadValue(List<String> errors) throws DataManagerException {
        Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
        if (errors != null) {
            String sMessage = CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args);
            errors.add(sMessage);
            return errors;
        }
        StringBuffer sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args));
        throw new DataManagerException(sMessage.toString());
    }
}

