/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.verification;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.CnfgValueChangedListener;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.verification.VerifyConfigurationGroup;
import com.cognos.crconfig.data.verification.VerifyFolderPath;
import com.cognos.crconfig.data.verification.VerifyHTTPClient;
import com.cognos.crconfig.data.verification.VerifyParameterRelation;
import com.cognos.crconfig.data.verification.VerifyPorts;
import com.cognos.crconfig.data.verification.VerifyURLConnection;
import com.ibm.bi.json.JsonObject;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VerifyConfiguration
implements CnfgValueChangedListener {
    private VerifyParameterRelation m_paramRelation = null;
    private VerifyPorts m_verifyPorts = new VerifyPorts();
    private VerifyConfigurationGroup m_verifyConfigGroup = new VerifyConfigurationGroup();
    private VerifyURLConnection m_verifyURLs = new VerifyURLConnection();
    private VerifyFolderPath m_verifyFolderPath = new VerifyFolderPath();

    private void init() {
        this.m_paramRelation = new VerifyParameterRelation();
    }

    @Override
    public void valueChanged(CnfgValueChangedEvent e) {
        Parameter param;
        String pName;
        Object source;
        if (this.m_paramRelation == null) {
            this.init();
        }
        if ((source = e.getSource()) != null && Parameter.class.isInstance(source) && (pName = (param = (Parameter)source).getName()) != null && (pName.equals("webServicePort") || pName.equals("enableWebServiceSSL") || pName.equals("webServiceHostName"))) {
            this.m_paramRelation.populateWebServiceURI();
        }
    }

    public void populateParameters() {
        if (this.m_paramRelation == null) {
            this.init();
        }
        this.m_paramRelation.populateWebServiceURI();
    }

    public void registerRequiredFolderParameter(Parameter pathParam) {
        if (this.m_verifyFolderPath != null) {
            this.m_verifyFolderPath.addRequiredPathParam(pathParam);
        }
    }

    public void createVerifyPortsTask(List<ICnfgTask> list) {
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.task.verify");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Label.DialogSave.verificationPortsTask");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                ArrayList<String> errors = new ArrayList<String>();
                VerifyConfiguration.this.m_verifyPorts.verifyPortsAvailibility(errors);
                Iterator<String> it = errors.iterator();
                while (it.hasNext()) {
                    feedback.showError(it.next());
                }
                return errors.size() <= 0;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
    }

    public void createVerifyFolderPathTask(List<ICnfgTask> list) {
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.task.verify");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Label.DialogSave.verificationFolderPathTask");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                ArrayList<String> errors = new ArrayList<String>();
                boolean bValid = VerifyConfiguration.this.m_verifyFolderPath.verifyIfFolderPathExist(true, errors);
                if (bValid) {
                    Iterator<String> it = errors.iterator();
                    while (it.hasNext()) {
                        feedback.showInformational(it.next());
                    }
                    return true;
                }
                Iterator<String> it = errors.iterator();
                while (it.hasNext()) {
                    feedback.showError(it.next());
                }
                return false;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
    }

    public void createCheckFlipperTask(List<ICnfgTask> list) {
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.task.verify");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Label.DialogSave.verificationConfigGroupTask");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                ArrayList<String> errors = new ArrayList<String>();
                ArrayList<String> outputMsgs = new ArrayList<String>();
                boolean isValid = VerifyConfiguration.this.m_verifyConfigGroup.checkFlipper(errors, outputMsgs);
                if (isValid) {
                    boolean isWarning = errors.size() > 0;
                    Iterator<String> it = outputMsgs.iterator();
                    while (it.hasNext()) {
                        if (isWarning) {
                            feedback.showWarning(it.next());
                            continue;
                        }
                        feedback.showInformational(it.next());
                    }
                    return !isWarning;
                }
                Iterator<String> it = errors.iterator();
                while (it.hasNext()) {
                    feedback.showError(it.next());
                }
                return false;
            }

            @Override
            public boolean isMandatory() {
                return false;
            }
        });
    }

    public void createVerifyCMURLsTask(List<ICnfgTask> list) {
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.task.verify");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Label.DialogSave.verificationURLsTask");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                ArrayList<String> errors = new ArrayList<String>();
                ArrayList<String> info = new ArrayList<String>();
                VerifyConfiguration.this.m_verifyURLs.checkCMURLs(errors, info);
                Iterator<String> it = info.iterator();
                while (it.hasNext()) {
                    feedback.showInformational(it.next());
                }
                Iterator<String> errit = errors.iterator();
                while (errit.hasNext()) {
                    feedback.showError(errit.next());
                }
                return errors.size() <= 0;
            }

            @Override
            public boolean isMandatory() {
                return false;
            }
        });
    }

    public VerifyURLConnection getVerifyURLs() {
        return this.m_verifyURLs;
    }

    public boolean populateAAASettings(boolean encrypt) {
        CnfgLog.info("populateAAASettings() is called.");
        try {
            Element aaa_elem = DocumentHelper.createElement((String)"tempaaaroot");
            Folder aaaFolder = DataManager.getInstance().findFolder("AAA", true);
            if (aaaFolder != null && !aaaFolder.getDisabled()) {
                aaaFolder.serialize(aaa_elem, encrypt, null, false, false);
                String aaastr = aaa_elem.asXML();
                aaastr = StringUtils.removeStart((String)aaastr, (String)"<tempaaaroot>");
                aaastr = StringUtils.removeEnd((String)aaastr, (String)"</tempaaaroot>");
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("populateAAASettings() - AAA settings are: \n" + aaastr + "\n");
                }
                if (this.setAAAToFlipper(aaastr)) {
                    CnfgLog.info("populateAAASettings() - Succeed.");
                    return true;
                }
            } else {
                CnfgLog.error("populateAAASettings() - AAA folder is null or disabled.");
            }
        }
        catch (Exception e) {
            CnfgLog.error("populateAAASettings() - Exception happend when try to serialize and populte AAA to flipper: " + e.getMessage());
        }
        CnfgLog.error("populateAAASettings() - Failed.");
        return false;
    }

    public boolean setAAAToFlipper(String aaaStr) {
        boolean res = false;
        JsonObject objectIn = new JsonObject();
        objectIn.put("AAA.global", (Object)aaaStr);
        try {
            URL exterDispURL = CnfgDataUtils.getURLParamValue("externalDispatcher");
            if (exterDispURL != null) {
                URL external = CnfgDataUtils.getHostPortFromURL(exterDispURL.toString());
                String configNSURL = external + "/bi/v1/configuration/namespaces/trust/AAA";
                int status = this.createResource(configNSURL, objectIn);
                if (status <= 0 || status >= 400) {
                    CnfgLog.error("setAAAToFlipper() - Failed to populate AAA settings via URL '" + configNSURL + "', response code = " + status);
                    res = false;
                } else {
                    CnfgLog.info("setAAAToFlipper() - Succeed to populate AAA settings via URL '" + configNSURL + "', response code = " + status);
                    res = true;
                }
            } else {
                CnfgLog.error("setAAAToFlipper() - Failed, external disp URL param is null.");
                res = false;
            }
        }
        catch (Exception e) {
            CnfgLog.error("setAAAToFlipper() - Failed to populate AAA settings with exception: " + e.getMessage());
            res = false;
        }
        return res;
    }

    public int createResource(String url, JsonObject objectIn) throws Exception {
        return VerifyHTTPClient.createResource(url, objectIn);
    }
}

