/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.verification;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.service.ServiceManager;
import com.cognos.crconfig.data.verification.VerifyHTTPClient;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.net.URL;
import java.util.ArrayList;

public class VerifyConfigurationGroup {
    private String FLIPPER_DIAG_BI = "/bi/v1/flipper/diag";

    public boolean checkFlipper(ArrayList<String> errors, ArrayList<String> outputMsgs) {
        Object[] args;
        ArrayList<URL> cmURLs = CnfgDataUtils.getURIListOfCM();
        ArrayList<String> cmurlsMsg = new ArrayList<String>();
        boolean bCMIsLocalStopped = false;
        URL exterDispURL = CnfgDataUtils.getURLParamValue("externalDispatcher");
        for (URL url : cmURLs) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Checking configuration group via Content Manager URL: " + url);
            }
            cmurlsMsg.add(url.toString());
            if (url != null && exterDispURL != null && this.isLocalCAServer(url, exterDispURL) && !ServiceManager.isRunning()) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("The Content Manager URL '" + url + "' is local server and not running, skip verification for this url.");
                }
                bCMIsLocalStopped = true;
                Object[] args2 = new Object[]{url};
                outputMsgs.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.failconn.localcm.resolution", args2));
                continue;
            }
            String surl = url + this.FLIPPER_DIAG_BI;
            JsonObject jsonResp = VerifyHTTPClient.getResource(surl);
            if (jsonResp == null) continue;
            boolean isValid = this.verifyFlipperGroupInfo(errors, jsonResp);
            if (isValid) {
                Object[] args3 = new Object[]{url};
                outputMsgs.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.goodconn.resolution", args3));
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("Check configuration group via Content Manager URL: " + url + " - Succeed.");
                }
                errors.clear();
                return true;
            }
            Object[] args4 = new Object[]{url};
            errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.failconn.resolution", args4));
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Check configuration group via Content Manager URL: " + url + " - Failed.");
            }
            return false;
        }
        if (bCMIsLocalStopped) {
            if (cmURLs.size() == 1) {
                outputMsgs.clear();
                boolean bValid = this.verifyFlipperOnFirstCM(errors);
                Object[] args5 = new Object[]{cmURLs.get(0).toString()};
                if (bValid) {
                    outputMsgs.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.localcm.valid.resolution", args5));
                } else {
                    errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.localcm.invalid.resolution", args5));
                }
                return bValid;
            }
            args = new Object[]{cmurlsMsg.toString()};
            String msg = CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.failconn.allcm.resolution", args);
            outputMsgs.add(msg);
            errors.add(msg);
            return true;
        }
        args = new Object[]{cmurlsMsg.toString()};
        errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.failconn.allcm.resolution", args));
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("Failed to check configuration group, the CM urls are invalid or not running: " + cmurlsMsg.toString());
        }
        return false;
    }

    protected boolean verifyFlipperOnFirstCM(ArrayList<String> errors) {
        CnfgLog.info("verifyFlipperOnFirstCM - This is first CM node and not running. Need to verify flipper group settings against local member settings.");
        Parameter memHostparm = DataManager.getInstance().findParm("configGroupMemberHost");
        Parameter memPortparm = DataManager.getInstance().findParm("configGroupMemberCoordinationPort");
        if (memHostparm != null && memPortparm != null) {
            String hostDM = (String)memHostparm.getValue();
            Object objPort = memPortparm.getValue();
            String memHostPort = (hostDM != null ? hostDM : "") + ":" + (objPort != null ? objPort.toString() : "");
            ArrayList<String> members = new ArrayList<String>();
            members.add(memHostPort);
            return this.isGroupHostPortValid(members, errors);
        }
        errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.members.notexist.resolution"));
        CnfgLog.error("verifyFlipperOnFirstCM - Unable to find configGroupMemberHost or configGroupMemberCoordinationPort. ");
        return false;
    }

    protected boolean isLocalCAServer(URL cmURL, URL exterDispURL) {
        boolean res = false;
        try {
            if (CnfgDataUtils.isLocal(cmURL.getHost())) {
                String cmprotocol = cmURL.getProtocol();
                String dispprotocol = exterDispURL.getProtocol();
                int cmport = cmURL.getPort();
                int dispport = exterDispURL.getPort();
                res = cmprotocol != null && cmprotocol.equalsIgnoreCase(dispprotocol) && cmport > 0 && cmport == dispport;
            }
        }
        catch (Exception e) {
            CnfgLog.error("CnfgDataUtils::isLocalCAServer() - cmURL '" + cmURL + "', externalDispURL '" + exterDispURL + "' - Exception: '" + e.getClass() + "' message is '" + e.getMessage() + "'.");
            res = false;
        }
        return res;
    }

    protected boolean verifyFlipperGroupInfo(ArrayList<String> errors, JsonObject resp) {
        ArrayList<String> members = this.getFlipperClusterMembers(resp, errors);
        String groupName = this.getFlipperGroupName(resp, errors);
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("verifyFlipperGroupInfo() - groupName = " + groupName + ", members = '" + members.toString() + "'.");
        }
        return this.isGroupNameValid(groupName, errors) && this.isGroupHostPortValid(members, errors);
    }

    protected boolean isGroupNameValid(String grpName, ArrayList<String> errors) {
        if (grpName == null || grpName.isEmpty()) {
            CnfgLog.error("isGroupNameValid - group name is empty, return false.");
            return false;
        }
        Parameter parm = DataManager.getInstance().findParm("configGroupName");
        if (parm != null) {
            String gnameDM = (String)parm.getValue();
            if (gnameDM != null && gnameDM.equals(grpName)) {
                return true;
            }
            Object[] args = new Object[]{gnameDM, grpName};
            errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.groupname.invalid.resolution", args));
            CnfgLog.error("isGroupNameValid - The group name '" + gnameDM + "' doesn't match with the group name '" + grpName + "' from leader.");
        } else {
            Object[] args = new Object[]{"null", grpName};
            errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.groupname.invalid.resolution", args));
            CnfgLog.error("isGroupNameValid - Unable to find the group name parameter.");
        }
        return false;
    }

    protected boolean isGroupHostPortValid(ArrayList<String> members, ArrayList<String> errors) {
        if (members.isEmpty()) {
            CnfgLog.error("isGroupHostPortValid - the members is empty, return false.");
            return false;
        }
        String curHostPort = "";
        Parameter grpHostparm = DataManager.getInstance().findParm("configGroupContactHost");
        Parameter grpPortparm = DataManager.getInstance().findParm("configGroupContactPort");
        if (grpHostparm != null && grpPortparm != null) {
            String ghostDM = (String)grpHostparm.getValue();
            Object objPort = grpPortparm.getValue();
            curHostPort = (ghostDM != null ? ghostDM : "") + ":" + (objPort != null ? objPort.toString() : "");
            if (!members.contains(curHostPort)) {
                Object[] args = new Object[]{curHostPort, members.toString()};
                errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.members.invalid.resolution", args));
                CnfgLog.error("isGroupHostPortValid - The specified group host port '" + curHostPort + "' is not in the members list from leader: " + members.toString());
                return false;
            }
            return true;
        }
        errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.members.group.notexist.resolution"));
        CnfgLog.error("isGroupHostPortValid - Unable to find the group contact host or group contact port parameters.");
        return false;
    }

    protected ArrayList<String> getFlipperClusterMembers(JsonObject resp, ArrayList<String> errors) {
        ArrayList<String> memberList = new ArrayList<String>();
        try {
            Object clusterDesp = resp.get("clusterDescription");
            if (clusterDesp != null) {
                JsonObject jsonClusterDesp = (JsonObject)clusterDesp;
                Object membersObj = jsonClusterDesp.get("members");
                if (membersObj != null && membersObj instanceof JsonArray) {
                    JsonArray jsonMembers = (JsonArray)membersObj;
                    for (Object obj : jsonMembers) {
                        JsonObject jobj = (JsonObject)obj;
                        String hostStr = (String)jobj.get("groupMemberHost");
                        Long port = (Long)jobj.get("groupMemberPort");
                        if (hostStr == null || hostStr.isEmpty() || port == null) continue;
                        memberList.add(hostStr + ":" + String.valueOf(port));
                    }
                } else {
                    Object[] args = new Object[]{"members"};
                    errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.members.fail.resolution", args));
                    CnfgLog.error("getFlipperClusterMembers - The 'members' doesn't exist or not valid. in response.");
                }
            } else {
                Object[] args = new Object[]{"clusterDescription"};
                errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.members.fail.resolution", args));
                CnfgLog.error("getFlipperClusterMembers - The 'clusterDescription' doesn't exist in response.");
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getMessage()};
            errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.members.fail.resolution", args));
            CnfgLog.error("getFlipperClusterMembers - Unable to get group members from clusterDescription. Exception - " + e.getMessage());
        }
        return memberList;
    }

    protected String getFlipperGroupName(JsonObject resp, ArrayList<String> errors) {
        String groupName;
        block8: {
            groupName = "";
            try {
                Object configDesp = resp.get("configuration");
                if (configDesp != null) {
                    JsonObject jsonConfig = (JsonObject)configDesp;
                    Object groupNameObj = jsonConfig.get("groupName");
                    if (groupNameObj != null) {
                        groupName = (String)groupNameObj;
                    } else {
                        Object[] args = new Object[]{"groupName"};
                        errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.groupname.fail.resolution", args));
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("The 'groupName' doesn't exist in response.");
                        }
                    }
                } else {
                    Object[] args = new Object[]{"configuration"};
                    errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.groupname.fail.resolution", args));
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("The 'configuration' doesn't exist in response.");
                    }
                }
            }
            catch (Exception e) {
                Object[] args = new Object[]{e.getMessage()};
                errors.add(CnfgResource.getMessage("Message.errorOnVerifyConfigGroup.groupname.fail.resolution", args));
                if (!CnfgLog.isDebugEnabled()) break block8;
                CnfgLog.debug("Unable to get group name from response. Exception - " + e.getMessage());
            }
        }
        return groupName;
    }

    public void queryFlipperGroupInfo(ArrayList<String> errors) {
        ArrayList<String> cmURLs = new ArrayList<String>();
        cmURLs.add("https://tpxiwendy10:4350");
        errors.add("QUERY flipper group info.");
        String flipperPath = "/config-service/keys/CFS?keys=configGroupName,configGroupPassword,configGroupContactPort,configGroupContactHost,configGroupMemberSyncPort,configGroupMemberCoordinationPort";
        for (String url : cmURLs) {
            String queryurl = url + flipperPath;
            errors.add("Query URL: " + queryurl);
            JsonObject jsonResp = VerifyHTTPClient.getResource(queryurl);
            if (jsonResp == null) continue;
            errors.add("flipper config: " + jsonResp.toString());
        }
    }
}

