/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.verification;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.PathParameter;
import com.cognos.crconfig.data.verification.VerifyConfigCommons;
import java.io.File;
import java.util.ArrayList;

public class VerifyFolderPath
extends VerifyConfigCommons {
    ArrayList<PathParameter> m_requiredPathParamList = new ArrayList();

    public void addRequiredPathParam(Parameter pathParam) {
        if (pathParam instanceof PathParameter) {
            this.m_requiredPathParamList.add((PathParameter)pathParam);
        }
    }

    public boolean verifyIfFolderPathExist(boolean bCreate, ArrayList<String> errors) {
        boolean bResult = true;
        for (PathParameter param : this.m_requiredPathParamList) {
            if (this.checkFolderParameter(errors, param, bCreate)) continue;
            bResult = false;
        }
        return bResult;
    }

    protected boolean checkFolderParameter(ArrayList<String> errors, PathParameter folderParam, boolean bCreate) {
        return this.verifyFolderParameter(errors, folderParam, bCreate);
    }

    protected boolean verifyFolderParameter(ArrayList<String> errors, PathParameter folderParam, boolean bCreate) {
        if (null != folderParam && !folderParam.getDisabled() && folderParam.getVisibility()) {
            int res;
            String paramName = folderParam.getName();
            String folderPath = "null";
            Object objfolder = folderParam.getValue();
            if (objfolder != null && (res = this.isFolderPathExist(folderPath = (String)objfolder, bCreate)) >= 0) {
                if (res == 1) {
                    this.addFolderVerifyErrorMessage(errors, paramName, folderParam, folderPath, "Message.errorOnVerifyFolderPath.create.resolution");
                }
                return true;
            }
            this.addFolderVerifyErrorMessage(errors, paramName, folderParam, folderPath, "Message.errorOnVerifyFolderPath.notexist.resolution");
            return false;
        }
        CnfgLog.info("The folder '" + (folderParam == null ? "null" : folderParam.getName()) + "' is invalid or disabled, just ignore it.");
        return true;
    }

    protected int isFolderPathExist(String sFolderPath, boolean bCreate) {
        String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sFolderPath);
        File curFile = new File(sResolvedPath);
        if (!curFile.isDirectory()) {
            if (bCreate) {
                if (this.createFolder(curFile, sResolvedPath)) {
                    return 1;
                }
                return -1;
            }
            CnfgLog.error("The folder with resolved path '" + sResolvedPath + "' doesn't exist.");
            return -1;
        }
        return 0;
    }

    protected boolean createFolder(File curFile, String sResolvedPath) {
        try {
            if (curFile.mkdirs()) {
                CnfgLog.info("The folder with resolved path '" + sResolvedPath + "' is created.");
                return true;
            }
            CnfgLog.error("Unable to create folder with resolved path '" + sResolvedPath + "'.");
        }
        catch (Exception e) {
            CnfgLog.error("Exception when try to create folder with resolved path '" + sResolvedPath + "' - " + e.getMessage());
        }
        return false;
    }

    protected void addFolderVerifyErrorMessage(ArrayList<String> errors, String paramName, Parameter param, String sPath, String resId) {
        Object[] args = new Object[]{sPath, paramName, param != null && param.getParent() != null ? param.getParent().getLabel() : "null"};
        this.addErrorMessage(errors, args, resId);
    }
}

