/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.verification;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.data.DataManager;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;

public class VerifyHTTPClient {
    public static final String HTTPHEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HTTPHEADER_VALUE_NO_CACHE = "no-cache";
    public static final String HTTPHEADER_ACCEPT = "Accept";
    public static final String HTTPHEADER_CONTENT_TYPE = "Content-Type";
    public static final String HTTPHEADER_VALUE_APPJSON = "application/json";
    public static final String CONFIG_SERVICE_NAME = "config-service";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject getResource(String resurl) {
        try (RESTClient rest = VerifyHTTPClient.getRESTClient();){
            boolean res = rest.makeTrusted(CONFIG_SERVICE_NAME);
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("rest.makeTrusted return: " + res);
            }
            rest.setRequestHeader(HTTPHEADER_CACHE_CONTROL, HTTPHEADER_VALUE_NO_CACHE);
            rest.setRequestHeader(HTTPHEADER_ACCEPT, HTTPHEADER_VALUE_APPJSON);
            rest.setRequestHeader(HTTPHEADER_CONTENT_TYPE, HTTPHEADER_VALUE_APPJSON);
            JsonObject respobj = rest.getResource(resurl, HTTPHEADER_VALUE_APPJSON);
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("getResource(" + resurl + ")" + " - result = " + (respobj != null ? respobj.toString() : "null"));
            }
            JsonObject jsonObject = respobj;
            return jsonObject;
        }
        catch (Exception e) {
            CnfgLog.error("getResource() - failed resurl=" + resurl + " with Exception: " + e.getMessage());
            return null;
        }
    }

    public static RESTClient getRESTClient() {
        DataManager.getInstance().initRESTClient();
        return RESTClientFactory.getInstance().getClient(new RESTClientConfig());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int createResource(String resurl, JsonObject objectIn) {
        try (RESTClient rest = VerifyHTTPClient.getRESTClient();){
            boolean res = rest.makeTrusted(CONFIG_SERVICE_NAME);
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("createResource() - rest.makeTrusted return: " + res);
            }
            rest.setRequestHeader(HTTPHEADER_CACHE_CONTROL, HTTPHEADER_VALUE_NO_CACHE);
            rest.setRequestHeader(HTTPHEADER_ACCEPT, HTTPHEADER_VALUE_APPJSON);
            rest.setRequestHeader(HTTPHEADER_CONTENT_TYPE, HTTPHEADER_VALUE_APPJSON);
            int status = rest.createResource(resurl, HTTPHEADER_VALUE_APPJSON, objectIn);
            CnfgLog.error("createResource(" + resurl + ")" + " - response code = " + status);
            int n = status;
            return n;
        }
        catch (Exception e) {
            CnfgLog.error("createResource() - failed resurl=" + resurl + " with Exception: " + e.getMessage());
            return 500;
        }
    }
}

