/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.verification;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import java.math.BigInteger;

public class VerifyParameterRelation {
    private Parameter m_wsURIParam = null;
    private Parameter m_wsEnableSSLParam = null;
    private Parameter m_wsPortParam = null;
    private Parameter m_wsHostParam = null;

    public VerifyParameterRelation() {
        this.initParameters();
    }

    private void initParameters() {
        Parameter pHostName;
        Parameter portParam;
        Parameter enableSSLParam;
        Parameter wsURIParam = DataManager.getInstance().findParam("webServiceURI");
        if (wsURIParam != null && !wsURIParam.getDisabled() && wsURIParam.getVisibility()) {
            this.m_wsURIParam = wsURIParam;
            CnfgLog.debug("Parameter 'webServiceURI' is enabled.");
        }
        if ((enableSSLParam = DataManager.getInstance().findParam("enableWebServiceSSL")) != null && !enableSSLParam.getDisabled() && enableSSLParam.getVisibility()) {
            this.m_wsEnableSSLParam = enableSSLParam;
            CnfgLog.debug("Parameter 'enableWebServiceSSL' is enabled.");
        }
        if ((portParam = DataManager.getInstance().findParam("webServicePort")) != null && !portParam.getDisabled() && portParam.getVisibility()) {
            this.m_wsPortParam = portParam;
            CnfgLog.debug("Parameter 'webServicePort' is enabled.");
        }
        if ((pHostName = DataManager.getInstance().findParm("webServiceHostName")) != null && !pHostName.getDisabled() && pHostName.getVisibility()) {
            this.m_wsHostParam = pHostName;
            CnfgLog.debug("Parameter 'webServiceHostName' is enabled.");
        }
    }

    public void populateWebServiceURI() {
        if (this.m_wsURIParam == null || this.m_wsEnableSSLParam == null || this.m_wsPortParam == null || this.m_wsHostParam == null) {
            return;
        }
        String urlstr = "";
        boolean bEnableSSL = (Boolean)this.m_wsEnableSSLParam.getValue();
        urlstr = urlstr + (bEnableSSL ? "https://" : "http://");
        urlstr = urlstr + (String)this.m_wsHostParam.getValue();
        int iPort = ((BigInteger)this.m_wsPortParam.getValue()).intValue();
        urlstr = urlstr + ":" + iPort;
        String orgURI = (String)this.m_wsURIParam.getValue();
        if (orgURI == null || !orgURI.equalsIgnoreCase(urlstr)) {
            this.m_wsURIParam.setValue(urlstr);
        }
    }
}

