/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.verification;

import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.verification.VerifyConfigCommons;
import java.math.BigInteger;
import java.util.ArrayList;

public class VerifyPorts
extends VerifyConfigCommons {
    public void verifyPortsAvailibility(ArrayList<String> errors) {
        this.checkLocalURLParameter(errors, "internalDispatcher");
        this.checkLocalURLParameter(errors, "externalDispatcher");
        this.checkPortParameterWithZero(errors, "datasetServicePort");
        this.checkPortParameter(errors, "logServerPort");
        this.checkPortParameter(errors, "configGroupMemberSyncPort");
        this.checkPortParameter(errors, "configGroupMemberCoordinationPort");
    }

    protected void checkLocalURLParameter(ArrayList<String> errors, String paramName) {
        this.verifyPortInLocalURLParameter(errors, DataManager.getInstance().findParam(paramName), paramName);
    }

    protected void verifyPortInLocalURLParameter(ArrayList<String> errors, Parameter urlParam, String paramName) {
        if (null != urlParam && !urlParam.getDisabled() && urlParam.getVisibility()) {
            int iPort = CnfgDataUtils.extractPortFromLocalURL(urlParam);
            if (iPort > 0 && !this.isAvailable(iPort)) {
                this.addPortInUseErrorMessage(errors, String.valueOf(iPort), paramName, urlParam);
            } else if (iPort <= 0) {
                this.addPortInvalidErrorMessage(errors, String.valueOf(iPort), paramName, urlParam);
            }
        }
    }

    protected void checkPortParameter(ArrayList<String> errors, String paramName) {
        this.verifyPortParameter(errors, DataManager.getInstance().findParam(paramName), paramName, false);
    }

    protected void checkPortParameterWithZero(ArrayList<String> errors, String paramName) {
        this.verifyPortParameter(errors, DataManager.getInstance().findParam(paramName), paramName, true);
    }

    protected void verifyPortParameter(ArrayList<String> errors, Parameter portParam, String paramName, boolean allowZero) {
        if (null != portParam && !portParam.getDisabled() && portParam.getVisibility()) {
            Object objPort = portParam.getValue();
            if (objPort != null) {
                try {
                    int iPort = ((BigInteger)objPort).intValue();
                    if (iPort == 0 && allowZero) {
                        return;
                    }
                    if (this.isValidPort(iPort, allowZero) && !this.isAvailable(iPort)) {
                        this.addPortInUseErrorMessage(errors, String.valueOf(iPort), paramName, portParam);
                    } else if (!this.isValidPort(iPort, allowZero)) {
                        this.addPortInvalidErrorMessage(errors, String.valueOf(iPort), paramName, portParam);
                    }
                }
                catch (Exception e) {
                    this.addPortInvalidErrorMessage(errors, objPort.toString(), paramName, portParam);
                }
            } else {
                this.addPortInvalidErrorMessage(errors, "null", paramName, portParam);
            }
        }
    }

    private boolean isValidPort(int iPort, boolean allowZero) {
        return allowZero ? iPort >= 0 : iPort > 0;
    }

    protected void addPortInvalidErrorMessage(ArrayList<String> errors, String sPort, String paramName, Parameter portParam) {
        Object[] args = new Object[]{sPort, paramName, portParam != null && portParam.getParent() != null ? portParam.getParent().getLabel() : "null"};
        this.addErrorMessage(errors, args, "Message.errorOnVerification.badport.invalid.resolution");
    }

    protected void addPortInUseErrorMessage(ArrayList<String> errors, String sPort, String paramName, Parameter portParam) {
        Object[] args = new Object[]{sPort, paramName, portParam != null && portParam.getParent() != null ? portParam.getParent().getLabel() : "null"};
        this.addErrorMessage(errors, args, "Message.errorOnVerification.badport.inuse.resolution");
    }

    /*
     * Exception decompiling
     */
    protected boolean isAvailable(int iPort) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

