/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.wlpconfig;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.wlpconfig.WLPConfigCommons;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class WLPConfigBIServices
extends WLPConfigCommons {
    private static final String BISERVICE_XML_FILENAME = "../configuration/bi-services/bi-service.xml";
    private static final String XPATH_SECURITY_ROLE_SUBJECT = "//application/application-bnd/security-role[@name='COGNOS_USER']/special-subject";
    private static final String EVERYONE_TYPE = "EVERYONE";
    private static final String ALL_AUTH_USERS_TYPE = "ALL_AUTHENTICATED_USERS";
    private static final String LTPAISENABLED_PARAM_NAME = "ltpaIsEnabled";
    private Document m_biServiceDoc = null;
    private InputStream m_biServiceXMLInputStream = null;
    private OutputStream m_biServiceXMLOutputStream = null;

    public void setBiServiceXMLStreams(InputStream is, OutputStream os) {
        this.m_biServiceXMLInputStream = is;
        this.m_biServiceXMLOutputStream = os;
    }

    protected void saveBIServiceXML() throws DataManagerException {
        try {
            Element serverElem;
            if (this.m_biServiceDoc == null) {
                this.m_biServiceDoc = this.getConfigXMLDoc(this.m_biServiceXMLInputStream, BISERVICE_XML_FILENAME);
            }
            if (null == (serverElem = this.m_biServiceDoc.getRootElement())) {
                Object[] args = new Object[]{"<server>"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadBIServiceXML.failed.missingnode", args));
            }
            this.updateBIServiceXML(serverElem, true);
            OutputStream os = this.m_biServiceXMLOutputStream;
            if (os == null) {
                File biServiceFile = DataManager.getInstance().resolveEffectiveFilePath(BISERVICE_XML_FILENAME);
                os = new FileOutputStream(biServiceFile);
            }
            OutputStreamWriter osw = new OutputStreamWriter(os);
            OutputFormat prettyPrintFormat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)osw, prettyPrintFormat);
            writer.write(this.m_biServiceDoc);
            writer.close();
            osw.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadBIServiceXML.failed.ioexception", args));
        }
    }

    protected boolean needUpdateBIServiceXML() throws DataManagerException {
        Element serverElem;
        if (this.m_biServiceDoc == null) {
            this.m_biServiceDoc = this.getConfigXMLDoc(this.m_biServiceXMLInputStream, BISERVICE_XML_FILENAME);
        }
        if (null == (serverElem = this.m_biServiceDoc.getRootElement())) {
            Object[] args = new Object[]{"<server>"};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadBIServiceXML.failed.missingnode", args));
        }
        return this.updateBIServiceXML(serverElem, false);
    }

    protected boolean updateBIServiceXML(Element serverElem, boolean bUpdateFile) throws DataManagerException {
        Element securityRoleSubElem;
        Attribute typeAttr;
        Boolean bLtpaEnabled = this.isLTPAEnabled();
        if (bLtpaEnabled == null) {
            return false;
        }
        Node securityRoleSubNode = serverElem.selectSingleNode(XPATH_SECURITY_ROLE_SUBJECT);
        if (securityRoleSubNode == null) {
            this.throwDMEWithErrorMsgs("<security-role name=\"COGNOS_USER\">");
        }
        if ((typeAttr = (securityRoleSubElem = (Element)securityRoleSubNode).attribute("type")) != null) {
            String attrValue = typeAttr.getValue();
            if (attrValue != null) {
                if (bLtpaEnabled.booleanValue() && attrValue.equalsIgnoreCase(ALL_AUTH_USERS_TYPE)) {
                    return false;
                }
                if (!bLtpaEnabled.booleanValue() && attrValue.equalsIgnoreCase(EVERYONE_TYPE)) {
                    return false;
                }
            }
            if (bUpdateFile) {
                typeAttr.setValue(bLtpaEnabled != false ? ALL_AUTH_USERS_TYPE : EVERYONE_TYPE);
            }
            return true;
        }
        this.throwDMEWithErrorMsgs("<special-subject type=\"xxx\">");
        return false;
    }

    protected void throwDMEWithErrorMsgs(String msgStr) throws DataManagerException {
        Object[] args = new Object[]{msgStr};
        this.throwDME(CnfgResource.getMessage("Message.loadBIServiceXML.failed.missingnode", args));
    }

    protected Boolean isLTPAEnabled() {
        Parameter isLTPAEnabledParam = DataManager.getInstance().findParam(LTPAISENABLED_PARAM_NAME);
        if (isLTPAEnabledParam != null && !isLTPAEnabledParam.getDisabled()) {
            return (Boolean)isLTPAEnabledParam.getValue();
        }
        return null;
    }
}

