/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.wlpconfig;

import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.wlpconfig.WLPConfigBIServices;
import com.cognos.crconfig.data.wlpconfig.WLPConfigUpgrade;
import com.cognos.crconfig.data.wlpconfig.WLPConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class WLPConfigCognosserverSettings
extends WLPConfigUpgrade {
    public static final String WLP_CONF_FILENAME_BOOTSTRAP = "../wlp/usr/servers/cognosserver/bootstrap.properties";
    public static final String WLP_CONF_FILENAME_JVMOPTIONS = "../wlp/usr/servers/cognosserver/jvm.options";
    public static final String WLP_CONF_FILENAME_SERVER = "../wlp/usr/servers/cognosserver/server.xml";
    private WLPConfiguration m_wlp = null;
    private Document m_wlpDoc = null;
    private WLPConfigBIServices m_wlpBiServices = null;
    protected boolean m_bBootstrapPropsChanged = false;
    protected boolean m_bJVMOptionsChanged = false;
    protected boolean m_bServerSettingsChanged = false;
    protected boolean m_bKeystorePasswordChanged = false;
    protected boolean m_bBiServiceXmlChanged = false;
    protected String m_confServerXmlFileName = "../wlp/usr/servers/cognosserver/server.xml";
    protected String m_confJvmOptionsFileName = "../wlp/usr/servers/cognosserver/jvm.options";
    protected String m_confBootstrapFileName = "../wlp/usr/servers/cognosserver/bootstrap.properties";
    private InputStream m_bootstrapPropsInputStream = null;
    private InputStream m_jvmOptionsInputStream = null;
    private InputStream m_serverConfigInputStream = null;
    private OutputStream m_bootstrapPropsOutputStream = null;
    private OutputStream m_jvmOptionsOutputStream = null;
    protected OutputStream m_serverConfigOutputStream = null;

    public WLPConfigCognosserverSettings(WLPConfiguration wlpInst) {
        this.m_wlp = wlpInst;
        this.m_wlpBiServices = new WLPConfigBIServices();
    }

    public void setServerConfigStreams(InputStream is, OutputStream os) {
        this.m_serverConfigInputStream = is;
        this.m_serverConfigOutputStream = os;
    }

    public void setBootstrapPropsStreams(InputStream is, OutputStream os) {
        this.m_bootstrapPropsInputStream = is;
        this.m_bootstrapPropsOutputStream = os;
    }

    public void setJVMOptionsStreams(InputStream is, OutputStream os) {
        this.m_jvmOptionsInputStream = is;
        this.m_jvmOptionsOutputStream = os;
    }

    public void setServerXmlFileName(String filename) {
        this.m_confServerXmlFileName = filename;
    }

    public void setJvmOptionsFileName(String filename) {
        this.m_confJvmOptionsFileName = filename;
    }

    public void setBootstrapFileName(String filename) {
        this.m_confBootstrapFileName = filename;
    }

    public boolean saveWLPConfFiles(String cmdOpt, String fileName) {
        try {
            if (cmdOpt.equals("-serverxml")) {
                this.setServerXmlFileName(fileName);
                this.saveServerSettings();
            } else if (cmdOpt.equals("-bootstrap")) {
                this.setBootstrapFileName(fileName);
                this.saveBootstrapProperties();
            } else if (cmdOpt.equals("-jvmoptions")) {
                this.setJvmOptionsFileName(fileName);
                this.saveJVMOptions();
            }
            CnfgLog.info("WLPConfigCognosserverSettings::saveWLPConfFiles(" + cmdOpt + "," + fileName + ") - succeed.");
            return true;
        }
        catch (DataManagerException e) {
            CnfgLog.error("WLPConfigCognosserverSettings::saveWLPConfFiles(" + cmdOpt + "," + fileName + ") - failed with exception : " + e.getMessage());
            return false;
        }
    }

    public Document getAppSvrConfigDoc() throws DataManagerException {
        return this.getConfigXMLDoc(this.m_serverConfigInputStream, this.m_confServerXmlFileName);
    }

    public void saveSettings() throws DataManagerException {
        if (this.m_bBootstrapPropsChanged) {
            this.saveBootstrapProperties();
            this.m_bBootstrapPropsChanged = false;
        }
        if (this.m_bJVMOptionsChanged) {
            this.saveJVMOptions();
            this.m_bJVMOptionsChanged = false;
        }
        if (this.m_bServerSettingsChanged) {
            this.saveServerSettings();
            this.m_bServerSettingsChanged = false;
            this.m_wlp.setSSLProtocoChanged(false);
        }
        if (this.m_bBiServiceXmlChanged) {
            this.m_wlpBiServices.saveBIServiceXML();
            this.m_bBiServiceXmlChanged = false;
        }
    }

    public void saveServerSettings() throws DataManagerException {
        if (this.m_wlp.isDispInstalled()) {
            this.saveServerSettingsFull();
        } else if (this.m_wlp.isStandAloneInstalled()) {
            this.saveServerSettingsStandalone();
        }
    }

    protected void saveServerSettingsFull() throws DataManagerException {
        Parameter internalURI = this.m_wlp.getRootFolder().findParm("internalDispatcher");
        Parameter externalURI = this.m_wlp.getRootFolder().findParm("externalDispatcher");
        String sInternalURI = null;
        String sExternalURI = null;
        if (this.m_wlp.isDispInstalled()) {
            if (null == internalURI || internalURI.getDisabled() || !internalURI.getVisibility()) {
                String sMsg = "Unexpected error. The internal dispatcher URI was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
            sInternalURI = (String)internalURI.getValue();
            if (null != externalURI && !externalURI.getDisabled() && externalURI.getVisibility()) {
                sExternalURI = (String)externalURI.getValue();
            } else {
                String sMsg = "Unexpected error. The external dispatcher URI was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
        }
        if (sInternalURI == null && sExternalURI == null) {
            return;
        }
        try {
            Element serverElem;
            if (this.m_wlpDoc == null) {
                this.m_wlpDoc = this.getAppSvrConfigDoc();
            }
            if (null == (serverElem = this.m_wlpDoc.getRootElement())) {
                Object[] args = new Object[]{"<server>"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
            }
            this.addHTTPEndpoints(serverElem, sInternalURI, sExternalURI);
            this.addExecutor(serverElem);
            this.upgradeServerSettings(serverElem);
            OutputStream os = this.m_serverConfigOutputStream;
            if (os == null) {
                File wlpFile = DataManager.getInstance().resolveEffectiveFilePath(this.m_confServerXmlFileName);
                os = new FileOutputStream(wlpFile);
            }
            OutputStreamWriter osw = new OutputStreamWriter(os);
            OutputFormat prettyPrintFormat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)osw, prettyPrintFormat);
            writer.write(this.m_wlpDoc);
            writer.close();
            osw.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.ioexception", args));
        }
        DataManager.getInstance().setWLPServerDirtyFlag(false);
    }

    protected void saveServerSettingsStandalone() throws DataManagerException {
        Parameter enableSSLParam = this.m_wlp.getRootFolder().findParm("enableWebServiceSSL");
        Boolean bEnableSSL = null;
        if (enableSSLParam == null || enableSSLParam.getDisabled() || !enableSSLParam.getVisibility()) {
            this.throwDME("Unexpected error. The enableWebServiceSSL parameter was not found in the data model");
        } else {
            bEnableSSL = (Boolean)enableSSLParam.getValue();
        }
        Parameter portParam = this.m_wlp.getRootFolder().findParm("webServicePort");
        int iPort = 0;
        if (portParam == null || portParam.getDisabled() || !portParam.getVisibility()) {
            this.throwDME("Unexpected error. The webServicePort parameter was not found in the data model");
        } else {
            iPort = ((BigInteger)portParam.getValue()).intValue();
        }
        try {
            Element serverElem;
            if (this.m_wlpDoc == null) {
                this.m_wlpDoc = this.getAppSvrConfigDoc();
            }
            if (null == (serverElem = this.m_wlpDoc.getRootElement())) {
                Object[] args = new Object[]{"<server>"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
            }
            this.addHTTPEndpointsStandalone(serverElem, bEnableSSL, iPort);
            this.addExecutor(serverElem);
            this.upgradeServerSettings(serverElem);
            OutputStream os = this.m_serverConfigOutputStream;
            if (os == null) {
                File wlpFile = DataManager.getInstance().resolveEffectiveFilePath(this.m_confServerXmlFileName);
                os = new FileOutputStream(wlpFile);
            }
            OutputStreamWriter osw = new OutputStreamWriter(os);
            OutputFormat prettyPrintFormat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)osw, prettyPrintFormat);
            writer.write(this.m_wlpDoc);
            writer.close();
            osw.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.ioexception", args));
        }
        DataManager.getInstance().setWLPServerDirtyFlag(false);
    }

    private void addHTTPEndpoints(Element serverElem, String sInternalURI, String sExternalURI) throws DataManagerException {
        int i;
        boolean bInternalSSL = sInternalURI.startsWith("https://");
        String sInternalPort = this.getPortFromURI(sInternalURI);
        boolean bExternalSSL = sExternalURI.startsWith("https://");
        String sExternalPort = this.getPortFromURI(sExternalURI);
        boolean bNeedOneConnector = false;
        if (bInternalSSL == bExternalSSL) {
            if (sInternalPort.equals(sExternalPort)) {
                bNeedOneConnector = true;
            }
        } else if (sInternalPort.equals(sExternalPort)) {
            Object[] args = new Object[]{sInternalPort};
            throw new DataManagerException(CnfgResource.getMessage("Message.saveTomcat.failed.identical.portnumber", args));
        }
        Element internalHttpEndpointElem = null;
        Element externalHttpEndpointElem = null;
        List httpEndpointElems = serverElem.selectNodes("httpEndpoint");
        int size = httpEndpointElems.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                Element elem = (Element)httpEndpointElems.get(i);
                String id = elem.attributeValue("id");
                if (id.equals("internal") || id.equals("defaultHttpEndpoint")) {
                    internalHttpEndpointElem = elem;
                    continue;
                }
                if (id.equals("external")) {
                    externalHttpEndpointElem = elem;
                    continue;
                }
                serverElem.remove(elem);
            }
        } else {
            internalHttpEndpointElem = DocumentHelper.createElement((String)"httpEndpoint");
            internalHttpEndpointElem.addAttribute("id", "internal");
            serverElem.add(internalHttpEndpointElem);
        }
        Attribute attr = internalHttpEndpointElem.attribute("host");
        if (attr != null) {
            internalHttpEndpointElem.remove(attr);
        }
        if ((attr = internalHttpEndpointElem.attribute("httpPort")) != null) {
            internalHttpEndpointElem.remove(attr);
        }
        if ((attr = internalHttpEndpointElem.attribute("httpsPort")) != null) {
            internalHttpEndpointElem.remove(attr);
        }
        if (!bInternalSSL) {
            internalHttpEndpointElem.addAttribute("httpPort", sInternalPort);
        } else {
            internalHttpEndpointElem.addAttribute("httpsPort", sInternalPort);
            internalHttpEndpointElem.addAttribute("httpPort", "-1");
        }
        if (!bNeedOneConnector) {
            if (externalHttpEndpointElem == null) {
                externalHttpEndpointElem = DocumentHelper.createElement((String)"httpEndpoint");
                externalHttpEndpointElem.addAttribute("id", "external");
                serverElem.add(externalHttpEndpointElem);
            }
            if ((attr = externalHttpEndpointElem.attribute("host")) != null) {
                externalHttpEndpointElem.remove(attr);
            }
            if ((attr = externalHttpEndpointElem.attribute("httpPort")) != null) {
                externalHttpEndpointElem.remove(attr);
            }
            if ((attr = externalHttpEndpointElem.attribute("httpsPort")) != null) {
                externalHttpEndpointElem.remove(attr);
            }
            if (!bExternalSSL) {
                externalHttpEndpointElem.addAttribute("httpPort", sExternalPort);
            } else {
                externalHttpEndpointElem.addAttribute("httpsPort", sExternalPort);
            }
            internalHttpEndpointElem.addAttribute("host", "localhost");
            externalHttpEndpointElem.addAttribute("host", "*");
        } else {
            if (externalHttpEndpointElem != null) {
                serverElem.remove(externalHttpEndpointElem);
            }
            internalHttpEndpointElem.addAttribute("host", "*");
        }
        httpEndpointElems = serverElem.selectNodes("httpEndpoint");
        size = httpEndpointElems.size();
        for (i = 0; i < size; ++i) {
            List httpOptionsElems = ((Node)httpEndpointElems.get(i)).selectNodes("httpOptions");
            if (!httpOptionsElems.isEmpty()) continue;
            Element httpOptionsElem = DocumentHelper.createElement((String)"httpOptions");
            httpOptionsElem.addAttribute("CookiesConfigureNoCache", "false");
            ((Element)httpEndpointElems.get(i)).add(httpOptionsElem);
        }
        this.removeSSLSettings(serverElem);
        if (bInternalSSL || bExternalSSL) {
            this.addSSLSettings(serverElem);
        }
        this.addSSLSettingsForMA(serverElem);
    }

    private void addExecutor(Element serverElem) throws DataManagerException {
        Parameter wlpPropertiesParam = this.m_wlp.getRootFolder().findParm("wlpProperties");
        String coreThreadsInConfig = this.getWLPAdvancedPropertyValue("coreThreads", wlpPropertiesParam);
        String maxThreadsInConfig = this.getWLPAdvancedPropertyValue("maxThreads", wlpPropertiesParam);
        Element executorElem = (Element)serverElem.selectSingleNode("executor");
        if (executorElem == null) {
            executorElem = DocumentHelper.createElement((String)"executor");
            serverElem.add(executorElem);
        }
        if (coreThreadsInConfig != null) {
            Attribute attr_core = executorElem.attribute("coreThreads");
            if (attr_core != null) {
                executorElem.remove(attr_core);
            }
            executorElem.addAttribute("coreThreads", coreThreadsInConfig);
        }
        if (maxThreadsInConfig != null) {
            Attribute attr_max = executorElem.attribute("maxThreads");
            if (attr_max != null) {
                executorElem.remove(attr_max);
            }
            executorElem.addAttribute("maxThreads", maxThreadsInConfig);
        }
    }

    private void addHTTPEndpointsStandalone(Element serverElem, boolean bEnableSSL, int iPort) throws DataManagerException {
        int i;
        Element wsHttpEndpointElem = null;
        List httpEndpointElems = serverElem.selectNodes("httpEndpoint");
        int size = httpEndpointElems.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                Element elem = (Element)httpEndpointElems.get(i);
                String id = elem.attributeValue("id");
                if (id.equals("defaultHttpEndpoint")) {
                    wsHttpEndpointElem = elem;
                    continue;
                }
                serverElem.remove(elem);
            }
        } else {
            wsHttpEndpointElem = DocumentHelper.createElement((String)"httpEndpoint");
            wsHttpEndpointElem.addAttribute("id", "defaultHttpEndpoint");
            serverElem.add(wsHttpEndpointElem);
        }
        Attribute attr = wsHttpEndpointElem.attribute("host");
        if (attr != null) {
            wsHttpEndpointElem.remove(attr);
        }
        if ((attr = wsHttpEndpointElem.attribute("httpPort")) != null) {
            wsHttpEndpointElem.remove(attr);
        }
        if ((attr = wsHttpEndpointElem.attribute("httpsPort")) != null) {
            wsHttpEndpointElem.remove(attr);
        }
        if (!bEnableSSL) {
            wsHttpEndpointElem.addAttribute("httpPort", String.valueOf(iPort));
        } else {
            wsHttpEndpointElem.addAttribute("httpsPort", String.valueOf(iPort));
            wsHttpEndpointElem.addAttribute("httpPort", "-1");
        }
        wsHttpEndpointElem.addAttribute("host", "*");
        httpEndpointElems = serverElem.selectNodes("httpEndpoint");
        size = httpEndpointElems.size();
        for (i = 0; i < size; ++i) {
            List httpOptionsElems = ((Node)httpEndpointElems.get(i)).selectNodes("httpOptions");
            if (!httpOptionsElems.isEmpty()) continue;
            Element httpOptionsElem = DocumentHelper.createElement((String)"httpOptions");
            httpOptionsElem.addAttribute("CookiesConfigureNoCache", "false");
            ((Element)httpEndpointElems.get(i)).add(httpOptionsElem);
        }
        this.removeSSLSettings(serverElem);
        if (bEnableSSL) {
            this.addSSLSettings(serverElem);
        }
        if (this.m_wlp.isFlipperInstalled()) {
            this.addSSLSettingsForMA(serverElem);
        }
    }

    private void addSSLSettingsForMA(Element serverElem) {
        Node httpEndpointElem_MA;
        Node feature_ssl = serverElem.selectSingleNode("//featureManager/feature[text()='ssl-1.0']");
        if (feature_ssl == null) {
            this.addSSLFeature(serverElem);
        }
        if ((httpEndpointElem_MA = serverElem.selectSingleNode("//httpEndpoint[@id='MutualAuthSSLHttpEndpoint']")) != null) {
            serverElem.remove(httpEndpointElem_MA);
        }
        this.addHTTPEndPointForMASSL(serverElem);
        Node sslElem_MA = serverElem.selectSingleNode("//ssl[@id='MutualAuthSSL']");
        if (sslElem_MA != null) {
            serverElem.remove(sslElem_MA);
        }
        sslElem_MA = this.getSSLElem("MutualAuthSSL");
        ((Element)sslElem_MA).addAttribute("clientAuthentication", "true");
        serverElem.add(sslElem_MA);
        if (serverElem.selectNodes("keyStore").size() == 0) {
            serverElem.add(this.getKeyStoreElem(this.m_wlp.getRootFolder()));
        }
    }

    private void addHTTPEndPointForMASSL(Element serverElem) {
        Element maEndPointElem = DocumentHelper.createElement((String)"httpEndpoint");
        maEndPointElem.addAttribute("id", "MutualAuthSSLHttpEndpoint");
        maEndPointElem.addAttribute("sslOptionsRef", "MutualAuthSSL");
        String sMASSLPort = "${mutAuthSSLPort}";
        if (this.m_wlp.getRootFolder() != null) {
            sMASSLPort = this.m_wlp.getRootFolder().findParm("configGroupMemberSyncPort").getValue().toString();
        }
        maEndPointElem.addAttribute("httpsPort", sMASSLPort);
        maEndPointElem.addAttribute("httpPort", "-1");
        maEndPointElem.addAttribute("host", "*");
        Element httpOptionsElem = DocumentHelper.createElement((String)"httpOptions");
        httpOptionsElem.addAttribute("CookiesConfigureNoCache", "false");
        httpOptionsElem.addAttribute("AutoDecompression", "false");
        httpOptionsElem.addAttribute("keepAliveEnabled", "false");
        maEndPointElem.add(httpOptionsElem);
        Element sslOptionsElem = DocumentHelper.createElement((String)"sslOptions");
        sslOptionsElem.addAttribute("sslRef", "MutualAuthSSL");
        maEndPointElem.add(sslOptionsElem);
        serverElem.add(maEndPointElem);
    }

    private void addSSLSettings(Element serverElem) {
        this.addSSLFeature(serverElem);
        Element elem = DocumentHelper.createElement((String)"sslDefault");
        elem.addAttribute("sslRef", "CAM");
        serverElem.add(elem);
        elem = this.getSSLElem("CAM");
        this.addMutualAuthenticationSetting(elem);
        serverElem.add(elem);
        elem = this.getKeyStoreElem(this.m_wlp.getRootFolder());
        serverElem.add(elem);
        this.m_bKeystorePasswordChanged = false;
    }

    private void addMutualAuthenticationSetting(Element sslElem) {
        boolean clientAuthentication = (Boolean)this.m_wlp.getRootFolder().findParm("SSLMutualAuthentication").getValue();
        if (clientAuthentication) {
            sslElem.addAttribute("clientAuthentication", "true");
        }
    }

    private String getWLPAdvancedPropertyValue(String propName, Parameter propsArrayParam) {
        String propValue = null;
        if (propsArrayParam != null && propsArrayParam instanceof ArrayParameter) {
            Set<Parameter> values = ((ArrayParameter)propsArrayParam).getCurrentValues();
            for (Parameter p : values) {
                String paramName;
                if (p == null || (paramName = p.getName()) == null || !paramName.equalsIgnoreCase(propName)) continue;
                propValue = (String)p.getValue();
                break;
            }
        }
        return propValue;
    }

    protected void saveBootstrapProperties() throws DataManagerException {
        try {
            InputStream is = this.m_bootstrapPropsInputStream;
            OutputStream os = this.m_bootstrapPropsOutputStream;
            String curBinPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(".");
            String curinstallPath = CCLConfigurationFactory.getInstance().resolveEffectivePath("..");
            if (curinstallPath == null || curBinPath == null || curinstallPath.length() == 0 || curBinPath.length() == 0) {
                CnfgLog.error("Couldn't resolve the effective path for current working directory and install root, the file '" + this.m_confBootstrapFileName + "' is not updated.");
                return;
            }
            File propFile = DataManager.getInstance().resolveEffectiveFilePath(this.m_confBootstrapFileName);
            if (is == null) {
                if (!propFile.exists()) {
                    Object[] args = new Object[]{propFile.getCanonicalFile()};
                    CnfgLog.debug(CnfgResource.getMessage("Message.loadWLP.failed.bootstrap.filenotfound", args));
                }
                is = new FileInputStream(propFile);
            } else {
                is.reset();
            }
            Properties bootstrapProps = new Properties();
            bootstrapProps.load(new InputStreamReader(is, "UTF8"));
            is.close();
            String installPath = bootstrapProps.getProperty("install.dir");
            if (installPath == null || !installPath.equals(curinstallPath)) {
                bootstrapProps.setProperty("install.dir", curinstallPath);
            }
            this.setPropCMDISABLED(bootstrapProps);
            this.setPropDLS(bootstrapProps);
            if (os == null) {
                os = new FileOutputStream(propFile);
            }
            bootstrapProps.store(new OutputStreamWriter(os, "UTF8"), null);
            os.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.bootstrap.ioexception", args));
        }
    }

    protected void setPropCMDISABLED(Properties bootstrapProps) {
        if (bootstrapProps == null) {
            return;
        }
        if (DataManager.getInstance().isCMInstalled()) {
            boolean cmEnabled = DataManager.getInstance().getCMIsEnabled();
            bootstrapProps.setProperty("com.cognos.cm.service.disabled", String.valueOf(!cmEnabled));
        } else {
            bootstrapProps.remove("com.cognos.cm.service.disabled");
        }
    }

    protected void setPropDLS(Properties bootstrapProps) {
        if (bootstrapProps == null) {
            return;
        }
        if (!bootstrapProps.containsKey("mail.mime.encodefilename")) {
            CnfgLog.info("setPropDLS() - set entry in bootstrap.properties: mail.mime.encodefilename=true");
            bootstrapProps.setProperty("mail.mime.encodefilename", "true");
        }
        if (!bootstrapProps.containsKey("mail.mime.encodeparameters")) {
            CnfgLog.info("setPropDLS() - set entry in bootstrap.properties: mail.mime.encodeparameters=false");
            bootstrapProps.setProperty("mail.mime.encodeparameters", "false");
        }
    }

    protected void saveJVMOptions() throws DataManagerException {
        try {
            String rmiSvrHost;
            InputStream is = this.m_jvmOptionsInputStream;
            OutputStream os = this.m_jvmOptionsOutputStream;
            String curBinPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(".");
            String curinstallPath = CCLConfigurationFactory.getInstance().resolveEffectivePath("..");
            if (curinstallPath == null || curBinPath == null || curinstallPath.length() == 0 || curBinPath.length() == 0) {
                CnfgLog.error("Couldn't resolve the effective path for current working directory and install root, the file '" + this.m_confJvmOptionsFileName + "' is not updated.");
                return;
            }
            File propFile = DataManager.getInstance().resolveEffectiveFilePath(this.m_confJvmOptionsFileName);
            if (is == null) {
                if (!propFile.exists()) {
                    Object[] args = new Object[]{propFile.getCanonicalFile()};
                    CnfgLog.debug(CnfgResource.getMessage("Message.loadWLP.failed.jvmoptions.filenotfound", args));
                }
                is = new FileInputStream(propFile);
            } else {
                is.reset();
            }
            Properties jvmOptions = new Properties();
            jvmOptions.load(new InputStreamReader(is, "UTF8"));
            is.close();
            String jreLibPath = jvmOptions.getProperty("-Djava.library.path");
            if (jreLibPath == null || !jreLibPath.equals(curBinPath)) {
                jvmOptions.setProperty("-Djava.library.path", curBinPath);
            }
            if ((rmiSvrHost = jvmOptions.getProperty("-Djava.rmi.server.hostname")) == null || rmiSvrHost.isEmpty()) {
                try {
                    Parameter pHostName = DataManager.getInstance().findParm("hostName");
                    rmiSvrHost = null != pHostName && !pHostName.getDisabled() ? (String)pHostName.getValue() : "";
                }
                catch (Exception e) {
                    CnfgLog.error("Failed to find hostName parameter: " + e.toString());
                    rmiSvrHost = "";
                }
                jvmOptions.setProperty("-Djava.rmi.server.hostname", rmiSvrHost != null ? rmiSvrHost : "");
            }
            if (os == null) {
                os = new FileOutputStream(propFile);
            }
            PrintStream ps = new PrintStream(os, true, "UTF8");
            Enumeration<?> props = jvmOptions.propertyNames();
            while (props.hasMoreElements()) {
                String key = (String)props.nextElement();
                ps.println(key + "=" + jvmOptions.getProperty(key));
            }
            ps.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.jvmoptions.ioexception", args));
        }
    }

    protected boolean settingsChanged() {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("settingsChanged() - m_bBootstrapPropsChanged=" + this.m_bBootstrapPropsChanged + ", m_bJVMOptionsChanged=" + this.m_bJVMOptionsChanged + ", m_bServerSettingsChanged=" + this.m_bServerSettingsChanged + ", m_bBiServiceXmlChanged=" + this.m_bBiServiceXmlChanged);
        }
        return this.m_bBootstrapPropsChanged || this.m_bJVMOptionsChanged || this.m_bServerSettingsChanged || this.m_bBiServiceXmlChanged;
    }

    protected void checkCognosserverSettings() throws DataManagerException {
        this.m_bBootstrapPropsChanged = this.checkBootstrapProps();
        this.m_bJVMOptionsChanged = this.checkJVMOptions();
        this.m_bServerSettingsChanged = this.checkServerSettings();
        this.m_bBiServiceXmlChanged = this.m_wlpBiServices.needUpdateBIServiceXML();
    }

    public boolean checkServerSettings() throws DataManagerException {
        if (this.m_wlp.isDispInstalled()) {
            return this.checkServerSettingsFull();
        }
        if (this.m_wlp.isStandAloneInstalled()) {
            return this.checkServerSettingsStandalone();
        }
        return false;
    }

    protected boolean checkServerSettingsFull() throws DataManagerException {
        List keystoreElems;
        Element serverElem;
        if (this.m_wlpDoc == null) {
            this.m_wlpDoc = this.getAppSvrConfigDoc();
        }
        if (null == (serverElem = this.m_wlpDoc.getRootElement())) {
            Object[] args = new Object[]{"<server>"};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
        }
        if (this.checkHttpEndpointSettings(serverElem)) {
            return true;
        }
        if (this.checkExecutorThreadSettings(serverElem)) {
            return true;
        }
        if (this.checkMutualAuthSSLHttpEndpoint(serverElem)) {
            return true;
        }
        Node featureElem = serverElem.selectSingleNode("//featureManager/feature[text()='ssl-1.0']");
        if (featureElem == null) {
            return true;
        }
        Element sslMA = (Element)serverElem.selectSingleNode("//ssl[@id='MutualAuthSSL']");
        if (sslMA == null || this.checkCipherSuitesSetting(sslMA)) {
            return true;
        }
        Element sslElem = (Element)serverElem.selectSingleNode("//ssl[@id='CAM']");
        if (sslElem != null) {
            if (this.checkMutualAuthenticationSetting(sslElem)) {
                return true;
            }
            if (this.checkCipherSuitesSetting(sslElem)) {
                return true;
            }
        }
        if ((keystoreElems = serverElem.selectNodes("keyStore")) != null) {
            if (this.checkKeystoreSettings(keystoreElems)) {
                return true;
            }
        } else {
            return true;
        }
        if (this.m_wlp.isSSLProtocoChanged()) {
            return true;
        }
        return this.needUpgradeCognosserverSetting(serverElem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkHttpEndpointSettings(Element serverElem) throws DataManagerException {
        List httpEndpointElems;
        int size;
        if (this.MASSLPortChanged(serverElem)) {
            return true;
        }
        int internalPortNumber = this.getBasePortNumber("internalDispatcher", this.m_wlp.getRootFolder());
        int externalPortNumber = this.getBasePortNumber("externalDispatcher", this.m_wlp.getRootFolder());
        Parameter internalURIParam = this.m_wlp.getRootFolder().findParm("internalDispatcher");
        Parameter externalURIParam = this.m_wlp.getRootFolder().findParm("externalDispatcher");
        String sExternalURI = null;
        String sInternalURI = null;
        if (null == externalURIParam || externalURIParam.getDisabled() || !externalURIParam.getVisibility()) {
            String sMsg = "Unexpected error. The external dispatcher URI was not found in the data model";
            CnfgLog.error(sMsg);
            throw new DataManagerException(sMsg);
        }
        sExternalURI = (String)externalURIParam.getValue();
        if (null == internalURIParam || internalURIParam.getDisabled() || !internalURIParam.getVisibility()) {
            String sMsg = "Unexpected error. The internal dispatcher URI was not found in the data model";
            CnfgLog.error(sMsg);
            throw new DataManagerException(sMsg);
        }
        sInternalURI = (String)internalURIParam.getValue();
        boolean bInternalCurSSL = sInternalURI.startsWith("https://");
        boolean bExternalCurSSL = sExternalURI.startsWith("https://");
        boolean bMatchingURIs = false;
        if (bInternalCurSSL == bExternalCurSSL && internalPortNumber == externalPortNumber) {
            bMatchingURIs = true;
        }
        if ((size = (httpEndpointElems = serverElem.selectNodes("httpEndpoint")).size()) > 0) {
            boolean bExternalEndpointExists;
            Element internalHttpEndpointElem = this.getInternalHttpEndPoint(serverElem);
            Element externalHttpEndpointElem = this.getExternalHttpEndPoint(serverElem);
            boolean bInternalEndpointExists = internalHttpEndpointElem != null;
            boolean bl = bExternalEndpointExists = externalHttpEndpointElem != null;
            if (bMatchingURIs && bInternalEndpointExists && bExternalEndpointExists) {
                return true;
            }
            if (!bMatchingURIs && this.onlyOneExists(bInternalEndpointExists, bExternalEndpointExists)) {
                return true;
            }
            for (int i = 0; i < size; ++i) {
                List httpOptionsElems = ((Node)httpEndpointElems.get(i)).selectNodes("httpOptions");
                if (!httpOptionsElems.isEmpty()) continue;
                return true;
            }
            if (this.uriMatchesEndpoint(internalHttpEndpointElem, sInternalURI)) {
                if (externalHttpEndpointElem == null) return false;
                if (this.uriMatchesEndpoint(externalHttpEndpointElem, sExternalURI)) return false;
                return true;
            }
            if (this.uriMatchesEndpoint(internalHttpEndpointElem, sExternalURI)) {
                if (externalHttpEndpointElem == null) return true;
                if (this.uriMatchesEndpoint(externalHttpEndpointElem, sExternalURI)) return false;
                return true;
            }
            if (externalHttpEndpointElem == null) return true;
            if (!this.uriMatchesEndpoint(externalHttpEndpointElem, sInternalURI)) return true;
            if (this.uriMatchesEndpoint(internalHttpEndpointElem, sExternalURI)) return false;
            return true;
        }
        Object[] args = new Object[]{"<httpEndpoint>"};
        throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
    }

    private boolean uriMatchesEndpoint(Element elem, String sURI) {
        if (sURI == null || elem == null) {
            return false;
        }
        String sCurrentPort = this.getPortFromURI(sURI);
        Attribute httpPort = elem.attribute("httpPort");
        Attribute httpsPort = elem.attribute("httpsPort");
        boolean bCurSSL = sURI.startsWith("https://");
        if (bCurSSL) {
            if (httpsPort == null) {
                return false;
            }
            String sSavedPort = httpsPort.getValue();
            if (sSavedPort != null && !sSavedPort.equals(sCurrentPort)) {
                return false;
            }
        } else {
            if (httpPort == null) {
                return false;
            }
            String sSavedPort = httpPort.getValue();
            if (sSavedPort != null && !sSavedPort.equals(sCurrentPort)) {
                return false;
            }
        }
        return true;
    }

    private boolean uriMatchesEndpointStandalone(Element elem, boolean bSSL, int iPort) {
        if (elem == null) {
            return false;
        }
        Attribute httpPort = elem.attribute("httpPort");
        Attribute httpsPort = elem.attribute("httpsPort");
        if (bSSL) {
            if (httpsPort == null) {
                return false;
            }
            String sSavedPort = httpsPort.getValue();
            if (sSavedPort != null && !sSavedPort.equals(String.valueOf(iPort))) {
                return false;
            }
        } else {
            if (httpPort == null) {
                return false;
            }
            String sSavedPort = httpPort.getValue();
            if (sSavedPort != null && !sSavedPort.equals(String.valueOf(iPort))) {
                return false;
            }
        }
        return true;
    }

    public boolean checkMutualAuthSSLHttpEndpoint(Element serverElem) {
        Element httpEndpointMA = (Element)serverElem.selectSingleNode("//httpEndpoint[@id='MutualAuthSSLHttpEndpoint']");
        if (httpEndpointMA == null) {
            return true;
        }
        List httpOptionsElems = httpEndpointMA.selectNodes("httpOptions");
        if (httpOptionsElems.size() > 0) {
            Element httpOptionElem = (Element)httpOptionsElems.get(0);
            String attrKeepAliveEnabled = httpOptionElem.attributeValue("keepAliveEnabled");
            return attrKeepAliveEnabled == null || attrKeepAliveEnabled.isEmpty();
        }
        return true;
    }

    protected boolean checkCipherSuitesSetting(Element sslElem) {
        Attribute attr = sslElem.attribute("enabledCiphers");
        if (attr != null) {
            String enabledCiphers = "";
            String[] suites = null;
            if (Configuration.getInstance() != null && (suites = Configuration.getInstance().getJSSECipherSuitesList()) != null) {
                for (String suite : suites) {
                    enabledCiphers = enabledCiphers + suite + " ";
                }
                return attr.getValue().compareTo(enabledCiphers.trim()) != 0;
            }
        }
        return false;
    }

    private boolean checkExecutorThreadSettings(Element serverElem) throws DataManagerException {
        int maxServerxml;
        int maxConfig;
        int coreServerxml;
        int coreConfig;
        boolean bChanged = false;
        Parameter wlpPropertiesParam = this.m_wlp.getRootFolder().findParm("wlpProperties");
        String coreThreadsInConfig = this.getWLPAdvancedPropertyValue("coreThreads", wlpPropertiesParam);
        String maxThreadsInConfig = this.getWLPAdvancedPropertyValue("maxThreads", wlpPropertiesParam);
        if (coreThreadsInConfig == null && maxThreadsInConfig == null) {
            return bChanged;
        }
        Element executorElem = (Element)serverElem.selectSingleNode("executor");
        String coreThreadsInServerxml = null;
        String maxThreadsInServerxml = null;
        if (executorElem != null) {
            Attribute attr_max;
            Attribute attr_core = executorElem.attribute("coreThreads");
            if (attr_core != null) {
                coreThreadsInServerxml = attr_core.getValue();
            }
            if ((attr_max = executorElem.attribute("maxThreads")) != null) {
                maxThreadsInServerxml = attr_max.getValue();
            }
        }
        if (coreThreadsInServerxml == null && maxThreadsInServerxml == null) {
            String sMsg = "Unexpected error. The 'executor' element or thread attributes don't exist in server.xml. ";
            CnfgLog.error(sMsg);
            throw new DataManagerException(sMsg);
        }
        bChanged = coreThreadsInConfig != null && coreThreadsInServerxml != null ? (coreConfig = Integer.parseInt(coreThreadsInConfig)) != (coreServerxml = Integer.parseInt(coreThreadsInServerxml)) : coreThreadsInConfig != null || coreThreadsInServerxml != null;
        if (bChanged) {
            return true;
        }
        bChanged = maxThreadsInConfig != null && maxThreadsInServerxml != null ? (maxConfig = Integer.parseInt(maxThreadsInConfig)) != (maxServerxml = Integer.parseInt(maxThreadsInServerxml)) : maxThreadsInConfig != null || maxThreadsInServerxml != null;
        return bChanged;
    }

    private boolean checkHttpEndpointSettingsStandalone(Element serverElem, boolean bEnableSSL, int iPort) throws DataManagerException {
        List httpEndpointElems = serverElem.selectNodes("httpEndpoint");
        int size = httpEndpointElems.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                List httpOptionsElems = ((Node)httpEndpointElems.get(i)).selectNodes("httpOptions");
                if (!httpOptionsElems.isEmpty()) continue;
                return true;
            }
            Element defaultHttpEndpointElem = this.getInternalHttpEndPoint(serverElem);
            return !this.uriMatchesEndpointStandalone(defaultHttpEndpointElem, bEnableSSL, iPort);
        }
        Object[] args = new Object[]{"<httpEndpoint>"};
        throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
    }

    private boolean MASSLPortChanged(Element serverElem) {
        Node sslElem_MA = serverElem.selectSingleNode("//httpEndpoint[@id='MutualAuthSSLHttpEndpoint']");
        if (sslElem_MA == null) {
            return true;
        }
        if (this.m_wlp.getRootFolder() != null) {
            Parameter syncPortParm = this.m_wlp.getRootFolder().findParm("configGroupMemberSyncPort");
            if (syncPortParm == null) {
                return false;
            }
            String portInConfig = syncPortParm.getValue().toString();
            String portInServer = ((Element)sslElem_MA).attributeValue("httpsPort");
            if (portInServer == null || portInServer.isEmpty() || !portInServer.equals(portInConfig)) {
                return true;
            }
        }
        return false;
    }

    private boolean onlyOneExists(boolean internal, boolean external) {
        boolean ret = true;
        if (internal && external) {
            ret = false;
        } else if (!internal && !external) {
            ret = false;
        }
        return ret;
    }

    private Element getExternalHttpEndPoint(Element serverElem) {
        Element elem = null;
        Node endPoint = serverElem.selectSingleNode("//httpEndpoint[@id='external']");
        if (endPoint != null) {
            elem = (Element)endPoint;
        }
        return elem;
    }

    private Element getInternalHttpEndPoint(Element serverElem) {
        Element elem = null;
        Node endPoint = serverElem.selectSingleNode("//httpEndpoint[@id='defaultHttpEndpoint']");
        if (endPoint != null) {
            elem = (Element)endPoint;
        } else {
            endPoint = serverElem.selectSingleNode("//httpEndpoint[@id='internal']");
            if (endPoint != null) {
                // empty if block
            }
        }
        return elem;
    }

    private boolean checkKeystoreSettings(List<?> keystoreElems) {
        if (this.isKeystorePasswordChanged()) {
            return true;
        }
        for (int idx = 0; idx < keystoreElems.size(); ++idx) {
            String keyFile;
            Element keystore = (Element)keystoreElems.get(idx);
            if (keystore.attribute("id").getValue().equals("CAMEncKeyStore")) {
                if (!this.isKeystorePolled(keystore)) {
                    return true;
                }
                keyFile = this.generateLocation((String)this.m_wlp.getRootFolder().findParm("certificateLocation").getValue() + "/CAMKeystore.jks");
            } else {
                keyFile = this.generateLocation((String)this.m_wlp.getRootFolder().findParm("certificateLocation").getValue() + "/CAMKeystore");
            }
            if (keyFile.equals(keystore.attribute("location").getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isKeystorePolled(Element keystoreElem) {
        return "polled".equals(keystoreElem.attributeValue("updateTrigger")) && "60s".equals(keystoreElem.attributeValue("pollingRate"));
    }

    protected InputStream loadBootstrapFileToStream() throws Exception {
        File propFile = DataManager.getInstance().resolveEffectiveFilePath(this.m_confBootstrapFileName);
        if (!propFile.exists()) {
            Object[] args = new Object[]{this.m_confBootstrapFileName};
            CnfgLog.debug(CnfgResource.getMessage("Message.loadWLP.failed.filenotfound", args));
            return null;
        }
        return new FileInputStream(propFile);
    }

    protected boolean checkBootstrapProps() throws DataManagerException {
        try {
            InputStream is = this.m_bootstrapPropsInputStream;
            if (is == null) {
                is = this.loadBootstrapFileToStream();
                if (is == null) {
                    return true;
                }
            } else {
                is.reset();
            }
            Properties bootstrapProps = new Properties();
            bootstrapProps.load(new InputStreamReader(is, "UTF8"));
            is.close();
            String installPath = bootstrapProps.getProperty("install.dir");
            String curinstallPath = CCLConfigurationFactory.getInstance().resolveEffectivePath("..");
            if (installPath == null || !installPath.equals(curinstallPath)) {
                return true;
            }
            if (this.checkCMEnabledChanged(bootstrapProps)) {
                return true;
            }
            if (this.areDLSEntriesMissing(bootstrapProps)) {
                return true;
            }
        }
        catch (Exception e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.ioexception", args));
        }
        return false;
    }

    protected boolean checkCMEnabledChanged(Properties bootstrapProps) {
        String cmIsDisabled = bootstrapProps.getProperty("com.cognos.cm.service.disabled");
        return DataManager.getInstance().isCMInstalled() ? cmIsDisabled == null || !String.valueOf(!DataManager.getInstance().getCMIsEnabled()).equals(cmIsDisabled) : cmIsDisabled != null;
    }

    protected boolean checkJVMOptions() throws DataManagerException {
        try {
            InputStream is = this.m_jvmOptionsInputStream;
            if (is == null) {
                File propFile = DataManager.getInstance().resolveEffectiveFilePath(this.m_confJvmOptionsFileName);
                if (!propFile.exists()) {
                    Object[] args = new Object[]{this.m_confJvmOptionsFileName};
                    CnfgLog.debug(CnfgResource.getMessage("Message.loadWLP.failed.filenotfound", args));
                    return true;
                }
                is = new FileInputStream(propFile);
            } else {
                is.reset();
            }
            Properties jvmOptions = new Properties();
            jvmOptions.load(new InputStreamReader(is, "UTF8"));
            is.close();
            String jreLibPath = jvmOptions.getProperty("-Djava.library.path");
            String curBinPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(".");
            if (jreLibPath == null || !jreLibPath.equals(curBinPath)) {
                return true;
            }
            String rmiSvrHost = jvmOptions.getProperty("-Djava.rmi.server.hostname");
            if (rmiSvrHost == null || rmiSvrHost.isEmpty()) {
                return true;
            }
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.ioexception", args));
        }
        return false;
    }

    protected boolean checkServerSettingsStandalone() throws DataManagerException {
        Element serverElem;
        if (this.m_wlpDoc == null) {
            this.m_wlpDoc = this.getAppSvrConfigDoc();
        }
        if (null == (serverElem = this.m_wlpDoc.getRootElement())) {
            Object[] args = new Object[]{"<server>"};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
        }
        Parameter portParam = this.m_wlp.getRootFolder().findParm("webServicePort");
        int iPort = 0;
        if (portParam == null || portParam.getDisabled() || !portParam.getVisibility()) {
            this.throwDME("Unexpected error. The webServicePort parameter was not found in the data model");
        } else {
            iPort = ((BigInteger)portParam.getValue()).intValue();
        }
        Parameter enableSSLParam = this.m_wlp.getRootFolder().findParm("enableWebServiceSSL");
        Boolean bEnableSSL = null;
        if (enableSSLParam == null || enableSSLParam.getDisabled() || !enableSSLParam.getVisibility()) {
            this.throwDME("Unexpected error. The enableWebServiceSSL parameter was not found in the data model");
        } else {
            bEnableSSL = (Boolean)enableSSLParam.getValue();
        }
        if (this.checkHttpEndpointSettingsStandalone(serverElem, bEnableSSL, iPort)) {
            return true;
        }
        if (this.checkExecutorThreadSettings(serverElem)) {
            return true;
        }
        if (bEnableSSL.booleanValue() || this.m_wlp.isFlipperInstalled()) {
            List keystoreElems;
            Node featureElem = serverElem.selectSingleNode("//featureManager/feature[text()='ssl-1.0']");
            if (featureElem == null) {
                return true;
            }
            Element sslElem = (Element)serverElem.selectSingleNode("//ssl[@id='CAM']");
            if (sslElem != null) {
                if (this.checkMutualAuthenticationSetting(sslElem)) {
                    return true;
                }
                if (this.checkCipherSuitesSetting(sslElem)) {
                    return true;
                }
            }
            if ((keystoreElems = serverElem.selectNodes("keyStore")) != null) {
                if (this.checkKeystoreSettings(keystoreElems)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (this.m_wlp.isFlipperInstalled()) {
            if (this.checkMutualAuthSSLHttpEndpoint(serverElem)) {
                return true;
            }
            Element sslMA = (Element)serverElem.selectSingleNode("//ssl[@id='MutualAuthSSL']");
            if (sslMA == null || this.checkCipherSuitesSetting(sslMA)) {
                return true;
            }
        }
        if (this.m_wlp.isSSLProtocoChanged()) {
            return true;
        }
        return this.needUpgradeCognosserverSetting(serverElem);
    }

    private boolean checkMutualAuthenticationSetting(Element sslElem) {
        Attribute attr = sslElem.attribute("clientAuthentication");
        boolean currentSetting = (Boolean)this.m_wlp.getRootFolder().findParm("SSLMutualAuthentication").getValue();
        return attr == null ? currentSetting : !currentSetting;
    }

    protected boolean checkCognosServerUpgrade() {
        try {
            if (this.m_wlpDoc == null) {
                this.m_wlpDoc = this.getAppSvrConfigDoc();
            }
            return this.needUpgradeServerXml(this.m_wlpDoc, "11.1.2.0", "Cognos Analytics ver_");
        }
        catch (Exception e) {
            CnfgLog.error(e);
            return true;
        }
    }

    protected boolean checkBootstrapPropsUpgrade() {
        try {
            InputStream is = this.m_bootstrapPropsInputStream;
            if (is == null) {
                is = this.loadBootstrapFileToStream();
                if (is == null) {
                    return true;
                }
            } else {
                is.reset();
            }
            Properties bootstrapProps = new Properties();
            bootstrapProps.load(new InputStreamReader(is, "UTF8"));
            is.close();
            if (DataManager.getInstance().isCMInstalled() && bootstrapProps.getProperty("com.cognos.cm.service.disabled") == null) {
                return true;
            }
            if (this.areDLSEntriesMissing(bootstrapProps)) {
                return true;
            }
        }
        catch (Exception e) {
            CnfgLog.error(e);
            return true;
        }
        return false;
    }

    protected boolean areDLSEntriesMissing(Properties bootstrapProps) {
        if (bootstrapProps.getProperty("mail.mime.encodefilename") == null || bootstrapProps.getProperty("mail.mime.encodeparameters") == null) {
            CnfgLog.info("areDLSEntriesMissing() - one or two MAIL_MIME entries are missing in bootstrap.properties, returen true.");
            return true;
        }
        return false;
    }

    public boolean bootstrapPropsChanged() {
        return this.m_bBootstrapPropsChanged;
    }

    public boolean jvmOptionsChanged() {
        return this.m_bJVMOptionsChanged;
    }

    public boolean serverSettingsChanged() {
        return this.m_bServerSettingsChanged;
    }

    public boolean isKeystorePasswordChanged() {
        return this.m_bKeystorePasswordChanged;
    }

    public void setKeystorePasswordChanged(boolean isChanged) {
        this.m_bKeystorePasswordChanged = isChanged;
    }

    public void backWLPConfigurationFiles(String timeStamp) throws DataManagerException {
        if (this.bootstrapPropsChanged()) {
            DataManager.getInstance().backupFile(timeStamp, this.m_confBootstrapFileName, ".properties");
        }
        if (this.jvmOptionsChanged()) {
            DataManager.getInstance().backupFile(timeStamp, this.m_confJvmOptionsFileName, ".options");
        }
        if (this.serverSettingsChanged()) {
            DataManager.getInstance().backupFile(timeStamp, this.m_confServerXmlFileName);
        }
    }

    protected void populateFromSAProperties() {
        if (!this.m_wlp.isStandAloneInstalled()) {
            return;
        }
        Properties saBoostrapProperties = new Properties();
        DataManager dm = DataManager.getInstance();
        try {
            File propFile = dm.resolveEffectiveFilePath("../configuration/ca_standalone_bootstrap.properties");
            if (propFile.exists()) {
                String curPingPath;
                FileInputStream is = new FileInputStream(propFile);
                saBoostrapProperties.load(new InputStreamReader((InputStream)is, "UTF8"));
                is.close();
                String pingpath = saBoostrapProperties.getProperty("ping.path");
                if (pingpath == null || pingpath.isEmpty()) {
                    CnfgLog.error("The property 'ping.path' doesn't exist in file '../configuration/ca_standalone_bootstrap.properties'.");
                    return;
                }
                Parameter saPingParam = dm.findParam("webServicePingPath");
                if (saPingParam != null && ((curPingPath = (String)saPingParam.getValue()) == null || curPingPath.isEmpty())) {
                    saPingParam.setValue(pingpath);
                }
            } else {
                CnfgLog.error("The file '../configuration/ca_standalone_bootstrap.properties' doesn't exist.");
            }
        }
        catch (Exception e) {
            CnfgLog.error("Exception when try to load '../configuration/ca_standalone_bootstrap.properties' file." + e.toString());
        }
    }
}

