/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.wlpconfig;

import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.Constants;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.ExternalProcess;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WLPConfigCommons
extends Constants {
    protected static final String WLP_COGNOSSERVER_SERVER_XML_VER = "11.1.2.0";
    protected static final String WLP_DATASETSERVICE_SERVER_XML_VER = "11.1.2.0";
    protected static final String WLP_COGNOSSERVER_SERVER_XML_VER_PREFIX = "Cognos Analytics ver_";
    protected static final String WLP_DATASETSERVICE_SERVER_XML_VER_PREFIX = "Dataset Service ver_";
    protected static final String WLP_BOOTSTRAP_PROP_INSTALLDIR = "install.dir";
    protected static final String WLP_BOOTSTRAP_PROP_CMDISABLED = "com.cognos.cm.service.disabled";
    protected static final String WLP_BOOTSTRAP_PROP_MAIL_MIME_ENCODEFILENAME = "mail.mime.encodefilename";
    protected static final String WLP_BOOTSTRAP_PROP_MAIL_MIME_ENCODEPARAMS = "mail.mime.encodeparameters";
    protected static final String WLP_HTTPENDPOINT_HOST_ATTR = "host";
    protected static final String WLP_HTTPENDPOINT_HTTPPORT_ATTR = "httpPort";
    protected static final String WLP_HTTPENDPOINT_HTTPSPORT_ATTR = "httpsPort";
    protected static final String WLP_HTTPENDPOINT_SSLOPTREF_ATTR = "sslOptionsRef";
    protected static final String WLP_SSLOPTIONS_ELM = "sslOptions";
    protected static final String WLP_HTTPOPTIONS_COOKIESCONFIGURENOCACHE_ATR = "CookiesConfigureNoCache";
    protected static final String WLP_HTTPOPTIONS_AUTODECOMPRESSION_ATR = "AutoDecompression";
    protected static final String WLP_HTTPOPTIONS_KEEPALIVEENABLED_ATR = "keepAliveEnabled";
    protected static final String WLP_JVMOPTIONS_PROP_LIBPATH = "-Djava.library.path";
    protected static final String WLP_JVMOPTIONS_PROP_RMISERVERHOST = "-Djava.rmi.server.hostname";
    protected static final String CFG_ENC_JKS_KEYSTORE_NAME = "/CAMKeystore.jks";
    protected static final String CFG_ENC_KEYSTORE_REF = "CAMEncKeyStore";
    protected static final String CFG_PROTOCOL_IBM = "SSL_TLSv2";
    protected static final String CFG_ENDPOINT_LOCAL = "localhost";
    protected static final String CFG_ENDPOINT_GLOBAL = "*";
    protected static final String CFG_SERVERKEY_ALIAS = "encryption";
    protected static final String CFG_SIGN_KEYSTORE_NAME = "/CAMKeystore";
    protected static final String CFG_ENC_KEYSTORE_PASSWORD = "keystoreFilePassword";
    protected static final String CFG_MUTUAL_AUTHENTICATION = "SSLMutualAuthentication";
    protected static final String CFG_CERTIFICATE_LOCATION = "certificateLocation";
    protected static final String WLP_KEYSTORE_ELEM = "keyStore";
    protected static final String WLP_KEYSTORE_ID_ATTR = "id";
    protected static final String WLP_KEYSTORE_LOCATION_ATTR = "location";
    protected static final String WLP_KEYSTORE_PASSWORD_ATTR = "password";
    protected static final String WLP_SSL_ID_ATTR = "id";
    protected static final String WLP_SSL_CLIENTAUTHENTICATION_ATTR = "clientAuthentication";
    protected static final String WLP_SSL_ENABLEDCIPHERS_ATTR = "enabledCiphers";
    protected static final String WLP_SSL_PROTOCOL_ATTR = "sslProtocol";
    protected static final String WLP_SSL_KEYSTOREREF_ATTR = "keyStoreRef";
    protected static final String WLP_SSL_SERVERKEYALIAS_ATTR = "serverKeyAlias";
    protected static final String WLP_SSL_KEYSTORE_POLLING_RATE_ATTR = "pollingRate";
    protected static final String WLP_SSL_KEYSTORE_POLLING_RATE = "60s";
    protected static final String WLP_SSL_KEYSTORE_UPDATE_TRIGGER_ATTR = "updateTrigger";
    protected static final String WLP_SSL_KEYSTORE_UPDATE_TRIGGER = "polled";
    protected static final String WLP_SSLDEFAULT_ELEM = "sslDefault";
    protected static final String WLP_SSLDEFAULT_SSLREF_ATTR = "sslRef";
    protected static final String WLP_NASSLPORT_ATTR = "mutAuthSSLPort";
    protected static final String WLP_TRUE = "true";
    protected static final String WLP_FALSE = "false";
    protected static final String WLP_EXECUTOR_ELEM = "executor";
    protected static final String WLP_CORETHREADS_ATTR = "coreThreads";
    protected static final String WLP_MAXTHREADS_ATTR = "maxThreads";
    protected static final String WLP_DATASET_BOOTSTRAP_PROP_HTTPPORT = "http.port";
    protected static final String WLP_STANDALONE_BOOTSTRAP_PROP_PINGPATH = "ping.path";
    protected static final String WLP_STANDALON_FILENAME_BOOTSTRAP = "../configuration/ca_standalone_bootstrap.properties";
    protected static final String WLP_APPLICATION_ELEM = "application";
    protected static final String WLP_DESCRIPTION_ATTR = "description";
    protected static final String WLP_LOCATION_ATTR = "location";
    protected static final String WLP_TYPE_ATTR = "type";
    protected static final String WLP_TYPE_VALUE_WAR = "war";
    protected static final String WLP_HTTPENDPOINT_ELEM = "httpEndpoint";
    protected static final String WLP_HTTPOPTIONS_ELEM = "httpOptions";
    protected static final String WLP_SSL_ELEM = "ssl";
    protected static final String WLP_HTTPENDPOINT_ID_ATTR = "id";
    protected static final String WLP_MASSL_ATTR_VALUE = "MutualAuthSSL";
    protected static final String WLP_HTTPENDPOINT_MA_ATTR_VALUE = "MutualAuthSSLHttpEndpoint";
    protected static final String WLP_CDI12_ATTR = "enableImplicitBeanArchives";
    protected static final String CFG_CAM = "CAM";
    protected static final String CFG_ENDPOINT_DEFAULT = "defaultHttpEndpoint";
    protected static final String CFG_ENDPOINT_INTERNAL = "internal";
    protected static final String CFG_ENDPOINT_EXTERNAL = "external";
    protected static final String WLP_CLASSLOADING_ELEM = "classloading";
    protected static final String WLP_USEJARURLS_ATTR = "useJarUrls";
    protected static final String WLP_HTTPDISPATCHER_ELEM = "httpDispatcher";
    protected static final String WLP_ENABLEWELCOMEPAGE_ATTR = "enableWelcomePage";
    protected static final String WLP_REMOVESERVERHEADER_ATTR = "removeServerHeader";
    protected static final String WLP_DISABLEXPOWERDBY_ATTR = "disableXPoweredBy";
    protected static final String WLP_DISPLAYTEXTWHENNOERRORPAGEDEFINED_ATTR = "displaytextwhennoerrorpagedefined";
    protected static final String WLP_WEBCONTAINER_ELEM = "webContainer";
    protected static final String WLP_FEATURE_ELEM = "feature";
    protected static final String WLP_FEATUREMANAGER_ELEM = "featureManager";
    protected static final String WLP_CDI12_ELEM = "cdi12";
    protected static final String WLP_SSL_FEATURE = "ssl-1.0";
    protected static final String WLP_JAXRS1_1_FEATURE = "jaxrs-1.1";
    protected static final String WLP_JAXRS2_0_FEATURE = "jaxrs-2.0";
    protected static final String WLP_CDI1_0_FEATURE = "cdi-1.0";
    protected static final String WLP_CDI1_2_FEATURE = "cdi-1.2";
    protected static final String WLP_JSP2_2_FEATURE = "jsp-2.2";
    protected static final String WLP_JSP2_3_FEATURE = "jsp-2.3";
    protected static final String WLP_BI_LOGGING1_0_FEATURE = "usr:com.ibm.bi.logging-1.0";
    protected static final String WLP_BI_HEALTH1_0_FEATURE = "usr:com.ibm.bi.health-1.0";
    protected static final String WLP_BI_LOGGING4J2_1_0_FEATURE = "usr:com.ibm.bi.logging4j2-1.0";
    protected static final String WLP_WAR_NAME_QUERYSERVICE = "${install.dir}/webapps/query-service.war";
    protected static final String WLP_WAR_NAME_DATASETSERVICE = "${install.dir}/webapps/dataset-service-ws.war";
    protected static final String XPATH_SSL_CAM = "//ssl[@id='CAM']";
    protected static final String XPATH_SSL_MA = "//ssl[@id='MutualAuthSSL']";
    protected static final String XPATH_HTTPENDPOINT_LEAD = "//httpEndpoint[@id='";
    protected static final String XPATH_HTTPENDPOINT_END = "']";
    protected static final String XPATH_HTTPENDPOINT_MA = "//httpEndpoint[@id='MutualAuthSSLHttpEndpoint']";
    protected static final String XPATH_HTTPENDPOINT_EXT = "//httpEndpoint[@id='external']";
    protected static final String XPATH_HTTPENDPOINT_INT = "//httpEndpoint[@id='internal']";
    protected static final String XPATH_HTTPENDPOINT_DEFAULT = "//httpEndpoint[@id='defaultHttpEndpoint']";
    protected static final String XPATH_HTTPENDPOINT_DEFAULT_HTTPOPTIONS = "//httpEndpoint[@id='defaultHttpEndpoint']/httpOptions";
    protected static final String XPATH_FEATURE_SSL = "//featureManager/feature[text()='ssl-1.0']";
    protected static final String XPATH_FEATURE_JAXRS1_1 = "//featureManager/feature[text()='jaxrs-1.1']";
    protected static final String XPATH_FEATURE_LOGGING1_0 = "//featureManager/feature[text()='usr:com.ibm.bi.logging-1.0']";
    protected static final String XPATH_FEATURE_HEALTH1_0 = "//featureManager/feature[text()='usr:com.ibm.bi.health-1.0']";
    protected static final String XPATH_FEATURE_LOGGING4J2_1_0 = "//featureManager/feature[text()='usr:com.ibm.bi.logging4j2-1.0']";
    protected static final String XPATH_WARNAME_QUERYSERVICE = "//application[@type='war' and @location='${install.dir}/webapps/query-service.war']";
    protected static final String XPATH_WARNAME_DATASETSERVICE = "//application[@type='war' and @location='${install.dir}/webapps/dataset-service-ws.war']";
    private boolean m_bRelativeLocations = false;

    public void setRelativeLocations(boolean relativeLocations) {
        this.m_bRelativeLocations = relativeLocations;
    }

    public Document getConfigXMLDoc(InputStream configxmlStream, String xmlFileName) throws DataManagerException {
        Document configxmlDoc = null;
        SAXReader reader = new SAXReader();
        if (configxmlStream == null) {
            File configXMLFile = DataManager.getInstance().resolveEffectiveFilePath(xmlFileName);
            if (configXMLFile.exists()) {
                try {
                    configxmlDoc = reader.read(configXMLFile);
                }
                catch (DocumentException e) {
                    throw new DataManagerException((Exception)((Object)e));
                }
            }
            Object[] args = new Object[]{xmlFileName};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.filenotfound", args));
        }
        try {
            configxmlDoc = reader.read(configxmlStream);
        }
        catch (DocumentException e) {
            throw new DataManagerException((Exception)((Object)e));
        }
        return configxmlDoc;
    }

    public int getBasePortNumber(String sDispParam, Folder rootFolder) {
        StringTokenizer tokens;
        String dispURI;
        Parameter p;
        if (sDispParam != null && rootFolder != null && null != (p = rootFolder.findParm(sDispParam)) && !p.getDisabled() && p.getVisibility() && null != (dispURI = (String)p.getValue()) && (tokens = new StringTokenizer(dispURI, ":")).countTokens() >= 3) {
            tokens.nextToken();
            String hostName = tokens.nextToken().substring(2);
            if (hostName.startsWith("[")) {
                hostName = hostName + tokens.nextToken("]") + "]";
            }
            boolean local = false;
            try {
                local = CnfgDataUtils.isLocal(hostName);
            }
            catch (Exception e) {
                CnfgLog.error(e);
            }
            if (local) {
                StringTokenizer tokens2;
                String portAndRest = tokens.nextToken(":");
                if (hostName.startsWith("[")) {
                    portAndRest = tokens.nextToken();
                }
                if ((tokens2 = new StringTokenizer(portAndRest, "/")).countTokens() > 0) {
                    return Integer.parseInt(tokens2.nextToken());
                }
            }
        }
        return -1;
    }

    public String getPortFromURI(String sURL) {
        int nextIdx = sURL.indexOf("://");
        int bracketIdx = sURL.indexOf("]", nextIdx += 3);
        int colonIdx = bracketIdx != -1 ? sURL.indexOf(":", bracketIdx) : sURL.indexOf(":", nextIdx);
        String sServer = sURL.substring(nextIdx, colonIdx);
        int separatorIdx = sURL.indexOf("/", nextIdx += sServer.length() + 1);
        return sURL.substring(nextIdx, separatorIdx);
    }

    public void removeSSLSettings(Element serverElem) {
        int idx;
        Element featureManager = (Element)serverElem.selectSingleNode(WLP_FEATUREMANAGER_ELEM);
        List elems = featureManager.selectNodes(WLP_FEATURE_ELEM);
        for (idx = 0; idx < elems.size(); ++idx) {
            Element elem = (Element)elems.get(idx);
            if (!elem.getText().equals(WLP_SSL_FEATURE)) continue;
            featureManager.remove(elem);
            break;
        }
        elems = serverElem.selectNodes(WLP_SSLDEFAULT_ELEM);
        for (idx = 0; idx < elems.size(); ++idx) {
            serverElem.remove((Element)elems.get(idx));
        }
        elems = serverElem.selectNodes(WLP_SSL_ELEM);
        for (idx = 0; idx < elems.size(); ++idx) {
            serverElem.remove((Element)elems.get(idx));
        }
        elems = serverElem.selectNodes(WLP_KEYSTORE_ELEM);
        for (idx = 0; idx < elems.size(); ++idx) {
            serverElem.remove((Element)elems.get(idx));
        }
    }

    public String generateLocation(String location) {
        String generatedLocation = "";
        try {
            if (!this.m_bRelativeLocations) {
                File fp = new File(location);
                generatedLocation = fp.getCanonicalPath().replace(File.separator, "/");
            } else {
                generatedLocation = location;
            }
        }
        catch (Exception e) {
            CnfgLog.error(e);
        }
        return generatedLocation;
    }

    public void addSSLFeature(Element serverElem) {
        Element featureManager = (Element)serverElem.selectSingleNode(WLP_FEATUREMANAGER_ELEM);
        this.addFeature(featureManager, WLP_SSL_FEATURE);
    }

    public void addFeature(Element featureManager, String featureName) {
        Element elem = DocumentHelper.createElement((String)WLP_FEATURE_ELEM);
        elem.setText(featureName);
        featureManager.add(elem);
    }

    public Element getKeyStoreElem(Folder rootFolder) {
        Element elem = DocumentHelper.createElement((String)WLP_KEYSTORE_ELEM);
        elem.addAttribute("id", CFG_ENC_KEYSTORE_REF);
        elem.addAttribute(WLP_KEYSTORE_PASSWORD_ATTR, this.encryptValue(rootFolder.findParm(CFG_ENC_KEYSTORE_PASSWORD).getDecryptedValue()));
        elem.addAttribute("location", this.generateLocation((String)rootFolder.findParm(CFG_CERTIFICATE_LOCATION).getValue() + CFG_ENC_JKS_KEYSTORE_NAME));
        elem.addAttribute(WLP_SSL_KEYSTORE_POLLING_RATE_ATTR, WLP_SSL_KEYSTORE_POLLING_RATE);
        elem.addAttribute(WLP_SSL_KEYSTORE_UPDATE_TRIGGER_ATTR, WLP_SSL_KEYSTORE_UPDATE_TRIGGER);
        return elem;
    }

    public Element getSSLElem(String idValue) {
        Element elem = DocumentHelper.createElement((String)WLP_SSL_ELEM);
        elem.addAttribute("id", idValue);
        elem.addAttribute(WLP_SSL_KEYSTOREREF_ATTR, CFG_ENC_KEYSTORE_REF);
        elem.addAttribute(WLP_SSL_SERVERKEYALIAS_ATTR, CFG_SERVERKEY_ALIAS);
        this.addCipherSuitesSetting(elem);
        String jsseProtocol = CFG_PROTOCOL_IBM;
        try {
            if (Configuration.getInstance() != null) {
                jsseProtocol = Configuration.getInstance().getJSSEProtocolName();
            }
        }
        catch (Exception e) {
            CnfgLog.error(e);
        }
        elem.addAttribute(WLP_SSL_PROTOCOL_ATTR, jsseProtocol);
        return elem;
    }

    public void addCipherSuitesSetting(Element sslElem) {
        String enabledCiphers = "";
        String[] suites = null;
        Configuration instance = Configuration.getInstance();
        if (instance != null) {
            for (String suite : suites = instance.getJSSECipherSuitesList()) {
                enabledCiphers = enabledCiphers + suite + " ";
            }
            sslElem.addAttribute(WLP_SSL_ENABLEDCIPHERS_ATTR, enabledCiphers.trim());
        }
    }

    public String encryptValue(String value) {
        String encryptedValue = "";
        try {
            String jre = DataManager.getLocalJavaHome();
            if (jre == null) {
                jre = DataManager.getCurrentJavaHome();
            }
            if (jre != null) {
                jre = jre + "/bin/java";
                String[] arguments = new String[]{jre, "-jar", DataManager.getPathToBinDir() + "../wlp/bin/tools/ws-securityutil.jar", "encode", "--encoding=aes", value};
                ExternalProcess p = new ExternalProcess(arguments[0], arguments);
                if (p.executeExternalProcess(CnfgUtils.getEnvForWLP()) == 0) {
                    encryptedValue = p.getErrorMsg().replaceAll("[\r\n]", "");
                }
            }
        }
        catch (Exception e) {
            CnfgLog.error(e);
        }
        return encryptedValue;
    }

    public void throwDME(String errMsg) throws DataManagerException {
        CnfgLog.error(errMsg);
        throw new DataManagerException(errMsg);
    }

    public boolean needUpgradeServerXml(Document serverxmlDoc, String latestVer, String verInfoPrefix) throws Exception {
        if (serverxmlDoc == null) {
            return true;
        }
        Element serverElem = serverxmlDoc.getRootElement();
        if (null == serverElem) {
            Object[] args = new Object[]{"<server>"};
            this.throwDME(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
        }
        return this.needUpgradeServerXmlElem(serverElem, latestVer, verInfoPrefix);
    }

    public boolean needUpgradeServerXmlElem(Element serverElem, String latestVer, String verInfoPrefix) throws DataManagerException {
        String verStr;
        String descStr;
        Attribute descAttr = serverElem.attribute(WLP_DESCRIPTION_ATTR);
        return descAttr == null || (descStr = descAttr.getText()) == null || !descStr.startsWith(verInfoPrefix) || CnfgUtils.compareVersions(verStr = descStr.substring(verInfoPrefix.length()), latestVer) < 0;
    }
}

