/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.wlpconfig;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.wlpconfig.WLPConfigUpgrade;
import com.cognos.crconfig.data.wlpconfig.WLPConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class WLPConfigDatasetserviceSettings
extends WLPConfigUpgrade {
    public static final String WLP_CONF_FILENAME_DATASETSERVICE_SERVER = "../wlp/usr/servers/dataset-service/server.xml";
    private static final String WLP_CONF_FILENAME_DATASETSERCICE_BOOTSTRAP = "../wlp/usr/servers/dataset-service/bootstrap.properties";
    private WLPConfiguration m_wlp = null;
    private Document m_datasetServiceWLPDoc = null;
    private InputStream m_serverDatasetServiceConfigInputStream = null;
    private InputStream m_datasetServiceBootstrapPropsInputStream = null;
    private OutputStream m_datasetServiceBootstrapPropsOutputStream = null;
    protected OutputStream m_datasetServiceConfigOutputStream = null;
    protected boolean m_bDatasetHttpPortChanged = false;
    protected boolean m_bDatasetServerSettingChanged = false;
    protected String m_confServerXmlFileName = "../wlp/usr/servers/dataset-service/server.xml";
    protected String m_confBootstrapFileName = "../wlp/usr/servers/dataset-service/bootstrap.properties";

    public WLPConfigDatasetserviceSettings(WLPConfiguration wlpInst) {
        this.m_wlp = wlpInst;
    }

    public void setServerXmlFileName(String filename) {
        this.m_confServerXmlFileName = filename;
    }

    public void setBootstrapFileName(String filename) {
        this.m_confBootstrapFileName = filename;
    }

    public boolean saveWLPConfFiles(String cmdOpt, String fileName) {
        try {
            if (cmdOpt.equals("-serverxml")) {
                this.setServerXmlFileName(fileName);
                this.saveDatasetServiceSettings();
            } else if (cmdOpt.equals("-bootstrap")) {
                this.setBootstrapFileName(fileName);
                this.saveDatasetServiceBootstrapProperties();
            } else if (cmdOpt.equals("-jvmoptions")) {
                // empty if block
            }
            CnfgLog.info("WLPConfigDatasetserviceSettings::saveWLPConfFiles(" + cmdOpt + "," + fileName + ") - succeed.");
            return true;
        }
        catch (DataManagerException e) {
            CnfgLog.error("WLPConfigDatasetserviceSettings::saveWLPConfFiles(" + cmdOpt + "," + fileName + ") - failed with exception : " + e.getMessage());
            return false;
        }
    }

    public Document getDatasetServiceSvrConfigDoc() throws DataManagerException {
        return this.getConfigXMLDoc(this.m_serverDatasetServiceConfigInputStream, this.m_confServerXmlFileName);
    }

    public void saveSettings() throws DataManagerException {
        if (this.m_bDatasetServerSettingChanged) {
            try {
                this.saveDatasetServiceSettings();
            }
            catch (Exception e) {
                CnfgLog.info(e);
            }
            this.m_bDatasetServerSettingChanged = false;
        }
        if (this.m_bDatasetHttpPortChanged) {
            this.saveDatasetServiceBootstrapProperties();
            this.m_bDatasetHttpPortChanged = false;
        }
    }

    protected void saveDatasetServiceSettings() throws DataManagerException {
        Parameter internalURI = this.m_wlp.getRootFolder().findParm("internalDispatcher");
        String sInternalURI = null;
        if (this.m_wlp.isDispInstalled()) {
            if (null != internalURI && !internalURI.getDisabled() && internalURI.getVisibility()) {
                sInternalURI = (String)internalURI.getValue();
            } else {
                String sMsg = "Unexpected error. The internal dispatcher URI was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
        }
        if (sInternalURI == null) {
            return;
        }
        try {
            Element serverElem;
            if (this.m_datasetServiceWLPDoc == null) {
                try {
                    this.m_datasetServiceWLPDoc = this.getDatasetServiceSvrConfigDoc();
                }
                catch (Exception e) {
                    CnfgLog.error(e);
                    return;
                }
            }
            if (null == (serverElem = this.m_datasetServiceWLPDoc.getRootElement())) {
                Object[] args = new Object[]{"<server>"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
            }
            this.upgradeDatasetServerSettings(serverElem);
            this.modifyHTTPEndpointForDatasetService(serverElem, sInternalURI);
            OutputStream os = this.m_datasetServiceConfigOutputStream;
            if (os == null) {
                File wlpFile = DataManager.getInstance().resolveEffectiveFilePath(this.m_confServerXmlFileName);
                os = new FileOutputStream(wlpFile);
            }
            OutputStreamWriter osw = new OutputStreamWriter(os);
            OutputFormat prettyPrintFormat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)osw, prettyPrintFormat);
            writer.write(this.m_datasetServiceWLPDoc);
            writer.close();
            osw.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
        }
    }

    private void modifyHTTPEndpointForDatasetService(Element serverElem, String sInternalURI) {
        this.removeSSLSettings(serverElem);
        Element httpEndpointElement = (Element)serverElem.selectSingleNode("httpEndpoint");
        Attribute httpPortAttribute = httpEndpointElement.attribute("httpPort");
        if ("-1".compareTo(httpPortAttribute.getValue()) == 0) {
            Attribute httpsPortAttribute = httpEndpointElement.attribute("httpsPort");
            String httpsPortValue = httpsPortAttribute.getValue();
            httpPortAttribute.setValue(httpsPortValue);
            httpEndpointElement.remove(httpsPortAttribute);
        }
        List commentNodeshttp = httpEndpointElement.selectNodes("//comment()");
        for (Node comment : commentNodeshttp) {
            httpEndpointElement.remove(comment);
        }
        String comment = "NOTE: The port definition is auto-generated by the Cognos Configuration.\nModifying it manually in this file will cause product to fail.\nPlease modify the port number using the Cognos Configuration tool.";
        httpEndpointElement.addComment(comment);
        Element classloadingElement = (Element)serverElem.selectSingleNode("classloading");
        List commentNodescl = classloadingElement.selectNodes("//comment()");
        for (Node commentcl : commentNodescl) {
            classloadingElement.remove(commentcl);
        }
        comment = "This setting will ensure that URL's use the \"jar\" protocol rather than \"wsjar\", which is the default in WLP. Some 3rd party libraries rely on this.";
        classloadingElement.addComment(comment);
        if (sInternalURI.startsWith("https")) {
            String httpPortValue = httpPortAttribute.getValue();
            httpPortAttribute.setValue("-1");
            httpEndpointElement.addAttribute("httpsPort", httpPortValue);
            this.addSSLFeature(serverElem);
            Element elem = DocumentHelper.createElement((String)"sslDefault");
            elem.addAttribute("sslRef", "CAM");
            serverElem.add(elem);
            elem = this.getSSLElem("CAM");
            serverElem.add(elem);
            elem = this.getKeyStoreElem(this.m_wlp.getRootFolder());
            serverElem.add(elem);
        }
    }

    protected void saveDatasetServiceBootstrapProperties() throws DataManagerException {
        DataManager dm = DataManager.getInstance();
        try {
            Object httpport;
            InputStream is = this.m_datasetServiceBootstrapPropsInputStream;
            OutputStream os = this.m_datasetServiceBootstrapPropsOutputStream;
            String sHttpPort = "";
            Parameter dsPortParam = dm.findParam("datasetServicePort");
            if (dsPortParam != null && (httpport = dsPortParam.getValue()) != null) {
                sHttpPort = httpport.toString();
            }
            if (sHttpPort.isEmpty()) {
                CnfgLog.error("The dataset service http port is not set , the file 'datasetServicePort' is not updated.");
                return;
            }
            File propFile = DataManager.getInstance().resolveEffectiveFilePath(this.m_confBootstrapFileName);
            if (is == null) {
                if (!propFile.exists()) {
                    CnfgLog.error("The file '" + this.m_confBootstrapFileName + "' doesn't exist.");
                }
                is = new FileInputStream(propFile);
            }
            Properties dsBoostrapProperties = new Properties();
            dsBoostrapProperties.load(new InputStreamReader(is, "UTF8"));
            is.close();
            dsBoostrapProperties.setProperty("http.port", sHttpPort);
            if (os == null) {
                os = new FileOutputStream(propFile);
            }
            dsBoostrapProperties.store(new OutputStreamWriter(os, "UTF8"), null);
            os.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.bootstrap.ioexception", args));
        }
    }

    protected boolean settingsChanged() {
        return this.m_bDatasetHttpPortChanged || this.m_bDatasetServerSettingChanged;
    }

    protected void setDatasetHttpPortChanged(boolean portChanged) {
        this.m_bDatasetHttpPortChanged = portChanged;
    }

    protected void setDatasetServerSettingChanged(boolean settingChanged) {
        this.m_bDatasetServerSettingChanged = settingChanged;
    }

    protected void checkDatasetserviceSettings() throws DataManagerException {
        this.m_bDatasetServerSettingChanged = this.checkServerSettings();
    }

    protected boolean checkServerSettings() throws DataManagerException {
        Element serverElem;
        if (this.m_datasetServiceWLPDoc == null) {
            try {
                this.m_datasetServiceWLPDoc = this.getDatasetServiceSvrConfigDoc();
            }
            catch (Exception e) {
                CnfgLog.error(e);
                return false;
            }
        }
        if (null == (serverElem = this.m_datasetServiceWLPDoc.getRootElement())) {
            Object[] args = new Object[]{"<server>"};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
        }
        if (this.checkDatasetServiceProtocol()) {
            return true;
        }
        return this.needUpgradeDatasetServiceSetting(serverElem);
    }

    private boolean checkDatasetServiceProtocol() {
        block15: {
            try {
                Element serverElem;
                Parameter internalURI = this.m_wlp.getRootFolder().findParm("internalDispatcher");
                String sInternalURI = null;
                if (this.m_wlp.isDispInstalled() && null != internalURI && !internalURI.getDisabled() && internalURI.getVisibility()) {
                    sInternalURI = (String)internalURI.getValue();
                }
                if (this.m_datasetServiceWLPDoc == null) {
                    try {
                        this.m_datasetServiceWLPDoc = this.getDatasetServiceSvrConfigDoc();
                    }
                    catch (Exception e) {
                        CnfgLog.error(e);
                        return false;
                    }
                }
                if (null == (serverElem = this.m_datasetServiceWLPDoc.getRootElement())) {
                    Object[] args = new Object[]{"<server>"};
                    throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
                }
                List httpEndpointElems = serverElem.selectNodes("httpEndpoint");
                int size = httpEndpointElems.size();
                if (size == 1) {
                    Element httpEndpointElement = (Element)httpEndpointElems.get(0);
                    Attribute httpPortAttribute = httpEndpointElement.attribute("httpPort");
                    Attribute httpsPortAttribute = httpEndpointElement.attribute("httpsPort");
                    if (null != sInternalURI && sInternalURI.startsWith("http:")) {
                        if (httpPortAttribute == null || httpsPortAttribute != null) {
                            return true;
                        }
                        String portValue = httpPortAttribute.getValue();
                        if (portValue == null || "${http.port}".compareTo(portValue) != 0) {
                            return true;
                        }
                    } else if (null != sInternalURI && sInternalURI.startsWith("https:")) {
                        if (httpPortAttribute == null || httpsPortAttribute == null) {
                            return true;
                        }
                        String httpPortValue = httpPortAttribute.getValue();
                        String httpsPortValue = httpsPortAttribute.getValue();
                        if (httpPortValue == null || httpsPortValue == null || "${http.port}".compareTo(httpsPortValue) != 0 || "-1".compareTo(httpPortValue) != 0) {
                            return true;
                        }
                    }
                    break block15;
                }
                Object[] args = new Object[]{"<httpEndpoint>"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.missingnode", args));
            }
            catch (Exception e) {
                CnfgLog.error(e);
            }
        }
        return false;
    }

    protected boolean checkDatasetServiceUpgrade() throws DataManagerException {
        try {
            try {
                if (this.m_datasetServiceWLPDoc == null) {
                    this.m_datasetServiceWLPDoc = this.getDatasetServiceSvrConfigDoc();
                }
            }
            catch (DataManagerException e) {
                CnfgLog.error(e);
                return false;
            }
            return this.needUpgradeServerXml(this.m_datasetServiceWLPDoc, "11.1.2.0", "Dataset Service ver_");
        }
        catch (Exception e) {
            CnfgLog.error(e);
            return true;
        }
    }

    public void populateFromWLPProperties() {
        Properties dsBoostrapProperties = new Properties();
        DataManager dm = DataManager.getInstance();
        if (!this.m_wlp.isDispInstalled()) {
            return;
        }
        try {
            File propFile = dm.resolveEffectiveFilePath(this.m_confBootstrapFileName);
            if (propFile.exists()) {
                FileInputStream is = new FileInputStream(propFile);
                dsBoostrapProperties.load(new InputStreamReader((InputStream)is, "UTF8"));
                is.close();
                String httpport = dsBoostrapProperties.getProperty("http.port");
                Parameter dsPortParam = dm.findParam("datasetServicePort");
                if (dsPortParam != null) {
                    if (httpport == null || httpport.isEmpty() || httpport.trim().equals("0")) {
                        int internalPortNumber = this.getBasePortNumber("internalDispatcher", this.m_wlp.getRootFolder());
                        if (internalPortNumber > 0) {
                            httpport = String.valueOf(internalPortNumber + 1);
                            this.m_bDatasetHttpPortChanged = true;
                            dsPortParam.setValue(httpport);
                        }
                    } else {
                        dsPortParam.setFireValueChanged(false);
                        dsPortParam.setValue(httpport);
                        dsPortParam.setFireValueChanged(true);
                        this.m_bDatasetHttpPortChanged = false;
                    }
                }
            } else {
                CnfgLog.error("The file '" + this.m_confBootstrapFileName + "' doesn't exist.");
            }
        }
        catch (Exception e) {
            CnfgLog.error("Exception when try to load '" + this.m_confBootstrapFileName + "' file." + e.toString());
        }
    }

    public boolean datasetServiceBootstrapPropsChanged() {
        return this.m_bDatasetHttpPortChanged;
    }

    public void backWLPConfigurationFiles(String timeStamp) throws DataManagerException {
        if (this.m_wlp.cognosserverSettingsChanged()) {
            try {
                DataManager.getInstance().backupFile(timeStamp, this.m_confServerXmlFileName);
            }
            catch (Exception e) {
                CnfgLog.info(e);
            }
        }
        if (this.datasetServiceBootstrapPropsChanged()) {
            DataManager.getInstance().backupFile(timeStamp, this.m_confBootstrapFileName, ".properties");
        }
    }
}

