/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.wlpconfig;

import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.wlpconfig.WLPConfigCommons;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class WLPConfigUpgrade
extends WLPConfigCommons {
    public void upgradeServerSettings(Element serverElem) throws DataManagerException {
        this.upgradeServerSettings(serverElem, "Cognos Analytics ver_11.1.2.0");
        this.upgradeWebContainerForErrorPage(serverElem);
    }

    public void upgradeServerSettings(Element serverElem, String descVerStr) throws DataManagerException {
        this.upgradeJAXRSFeatures(serverElem);
        this.upgradeClassLoadingSetting(serverElem);
        this.upgradeHttpOptions(serverElem);
        this.upgradeWebContainer(serverElem);
        this.upgradeServerXMLVersion(serverElem, descVerStr);
    }

    public void upgradeDatasetServerSettings(Element serverElem) throws DataManagerException {
        this.upgradeServerSettings(serverElem, "Dataset Service ver_11.1.2.0");
        this.upgradeLoggingFeature(serverElem);
        this.upgradeHealthFeature(serverElem);
        this.upgradeWarName(serverElem);
        this.upgradeHttpDispatcher(serverElem);
    }

    public void upgradeServerXMLVersion(Element serverElem, String descVerStr) {
        Attribute descAttr = serverElem.attribute("description");
        if (descAttr == null) {
            serverElem.addAttribute("description", descVerStr);
        } else {
            descAttr.setText(descVerStr);
        }
    }

    public void upgradeJAXRSFeatures(Element serverElem) throws DataManagerException {
        Node jaxrs11Feature = serverElem.selectSingleNode("//featureManager/feature[text()='jaxrs-1.1']");
        if (jaxrs11Feature == null) {
            return;
        }
        Element featureManager = (Element)serverElem.selectSingleNode("featureManager");
        List elems = featureManager.selectNodes("feature");
        for (int idx = 0; idx < elems.size(); ++idx) {
            Element elem = (Element)elems.get(idx);
            if (elem.getText().equals("jaxrs-1.1")) {
                elem.setText("jaxrs-2.0");
                continue;
            }
            if (elem.getText().equals("cdi-1.0")) {
                elem.setText("cdi-1.2");
                continue;
            }
            if (!elem.getText().equals("jsp-2.2")) continue;
            elem.setText("jsp-2.3");
        }
        Node cdi12Elem = serverElem.selectSingleNode("cdi12");
        if (cdi12Elem == null) {
            Element newElem = DocumentHelper.createElement((String)"cdi12");
            newElem.addAttribute("enableImplicitBeanArchives", "false");
            serverElem.add(newElem);
        }
    }

    public void upgradeClassLoadingSetting(Element serverElem) throws DataManagerException {
        Element classLoadingElem = (Element)serverElem.selectSingleNode("classloading");
        if (classLoadingElem == null) {
            this.addClassLoadingSetting(serverElem);
        } else {
            Attribute useJarUrlsAttr = classLoadingElem.attribute("useJarUrls");
            if (useJarUrlsAttr == null) {
                classLoadingElem.addAttribute("useJarUrls", "true");
            } else {
                String attrValue = useJarUrlsAttr.getValue();
                if (attrValue == null || !attrValue.equals("true")) {
                    useJarUrlsAttr.setValue("true");
                }
            }
        }
    }

    protected void addClassLoadingSetting(Element serverElem) {
        Element newElem = DocumentHelper.createElement((String)"classloading");
        newElem.addAttribute("useJarUrls", "true");
        serverElem.add(newElem);
    }

    protected void upgradeHealthFeature(Element serverElem) throws DataManagerException {
        Node health1_0Feature = serverElem.selectSingleNode("//featureManager/feature[text()='usr:com.ibm.bi.health-1.0']");
        if (health1_0Feature == null) {
            Element featureManager = (Element)serverElem.selectSingleNode("featureManager");
            this.addFeature(featureManager, "usr:com.ibm.bi.health-1.0");
        }
    }

    protected void upgradeLoggingFeature(Element serverElem) throws DataManagerException {
        Node logging1_0Feature = serverElem.selectSingleNode("//featureManager/feature[text()='usr:com.ibm.bi.logging-1.0']");
        if (logging1_0Feature == null) {
            return;
        }
        logging1_0Feature.setText("usr:com.ibm.bi.logging4j2-1.0");
    }

    protected void upgradeWarName(Element serverElem) throws DataManagerException {
        Node warname_dataset = serverElem.selectSingleNode("//application[@type='war' and @location='${install.dir}/webapps/dataset-service-ws.war']");
        if (warname_dataset == null) {
            return;
        }
        Attribute locationAtt = ((Element)warname_dataset).attribute("location");
        locationAtt.setText("${install.dir}/webapps/query-service.war");
    }

    protected void upgradeHttpDispatcher(Element serverElem) throws DataManagerException {
        Element httpDispatcherElem = (Element)serverElem.selectSingleNode("httpDispatcher");
        if (httpDispatcherElem == null) {
            Element newElem = DocumentHelper.createElement((String)"httpDispatcher");
            newElem.addAttribute("enableWelcomePage", "false");
            serverElem.add(newElem);
        } else {
            this.updateAttrIfNotMatch(httpDispatcherElem, "enableWelcomePage", "false");
        }
    }

    protected void upgradeWebContainerForErrorPage(Element serverElem) throws DataManagerException {
        Element webContainerElem = (Element)serverElem.selectSingleNode("webContainer");
        if (webContainerElem == null) {
            return;
        }
        this.updateAttrIfNotMatch(webContainerElem, "displaytextwhennoerrorpagedefined", "error, see logs");
    }

    protected void upgradeWebContainer(Element serverElem) throws DataManagerException {
        Element webContainerElem = (Element)serverElem.selectSingleNode("webContainer");
        if (webContainerElem == null) {
            return;
        }
        this.updateAttrIfNotMatch(webContainerElem, "disableXPoweredBy", "true");
    }

    protected void upgradeHttpOptions(Element serverElem) throws DataManagerException {
        Element httpOptionsInDefaultHttpEndpointElem = (Element)serverElem.selectSingleNode("//httpEndpoint[@id='defaultHttpEndpoint']/httpOptions");
        if (httpOptionsInDefaultHttpEndpointElem == null) {
            return;
        }
        Attribute removeServerHeaderAttr = httpOptionsInDefaultHttpEndpointElem.attribute("removeServerHeader");
        if (removeServerHeaderAttr == null) {
            this.updateAttrIfNotMatch(httpOptionsInDefaultHttpEndpointElem, "removeServerHeader", "true");
        }
    }

    protected void updateAttrIfNotMatch(Element elem, String attrName, String attrValue) {
        Attribute newAtt = elem.attribute(attrName);
        if (newAtt == null) {
            elem.addAttribute(attrName, attrValue);
        } else {
            String avalue = newAtt.getValue();
            if (avalue == null || !avalue.equals(attrValue)) {
                newAtt.setValue(attrValue);
            }
        }
    }

    public boolean needUpgradeClassLoadingSetting(Element serverElem) throws DataManagerException {
        Element classLoadingElem = (Element)serverElem.selectSingleNode("classloading");
        if (classLoadingElem == null) {
            return true;
        }
        Attribute useJarUrlsAttr = classLoadingElem.attribute("useJarUrls");
        if (useJarUrlsAttr == null) {
            return true;
        }
        String attrValue = useJarUrlsAttr.getValue();
        return attrValue == null || !attrValue.equals("true");
    }

    public boolean needUpgradeJAXRSSettings(Element serverElem) throws DataManagerException {
        Element featureManager = (Element)serverElem.selectSingleNode("featureManager");
        List elems = featureManager.selectNodes("feature");
        for (int idx = 0; idx < elems.size(); ++idx) {
            Element elem = (Element)elems.get(idx);
            if (!elem.getText().equals("jaxrs-1.1")) continue;
            return true;
        }
        return false;
    }

    protected boolean needUpgradeHttpOptions(Element serverElem) {
        Element httpOptionsInDefaultHttpEndpointElem = (Element)serverElem.selectSingleNode("//httpEndpoint[@id='defaultHttpEndpoint']/httpOptions");
        if (httpOptionsInDefaultHttpEndpointElem == null) {
            return false;
        }
        Attribute removeServerHeaderAttr = httpOptionsInDefaultHttpEndpointElem.attribute("removeServerHeader");
        return removeServerHeaderAttr == null;
    }

    protected boolean needUpgradeHealthFeature(Element serverElem) throws DataManagerException {
        Node health1_0Feature = serverElem.selectSingleNode("//featureManager/feature[text()='usr:com.ibm.bi.health-1.0']");
        return health1_0Feature == null;
    }

    protected boolean needUpgradeLoggingFeature(Element serverElem) throws DataManagerException {
        Node logging1_0Feature = serverElem.selectSingleNode("//featureManager/feature[text()='usr:com.ibm.bi.logging-1.0']");
        return logging1_0Feature != null;
    }

    protected boolean needUpgradeWarName(Element serverElem) throws DataManagerException {
        Node warname_dataset = serverElem.selectSingleNode("//application[@type='war' and @location='${install.dir}/webapps/dataset-service-ws.war']");
        return warname_dataset != null;
    }

    protected boolean needUpgradeHttpDispatcher(Element serverElem) throws DataManagerException {
        Element httpDispatcherElem = (Element)serverElem.selectSingleNode("httpDispatcher");
        return httpDispatcherElem == null;
    }

    protected boolean needUpgradeWebContainer(Element serverElem) throws DataManagerException {
        Element webContainerElem = (Element)serverElem.selectSingleNode("webContainer");
        if (webContainerElem == null) {
            return false;
        }
        Attribute newAtt = webContainerElem.attribute("disableXPoweredBy");
        return newAtt == null;
    }

    protected boolean needUpgradeWebContainerForErrorPage(Element serverElem) throws DataManagerException {
        Element webContainerElem = (Element)serverElem.selectSingleNode("webContainer");
        if (webContainerElem == null) {
            return false;
        }
        Attribute newAtt = webContainerElem.attribute("displaytextwhennoerrorpagedefined");
        return newAtt == null;
    }

    protected boolean needUpgradeDatasetServiceSetting(Element serverElem) throws DataManagerException {
        return this.needUpgradeJAXRSSettings(serverElem) || this.needUpgradeClassLoadingSetting(serverElem) || this.needUpgradeHttpOptions(serverElem) || this.needUpgradeLoggingFeature(serverElem) || this.needUpgradeHealthFeature(serverElem) || this.needUpgradeWarName(serverElem) || this.needUpgradeHttpDispatcher(serverElem) || this.needUpgradeWebContainer(serverElem) || this.needUpgradeServerXmlElem(serverElem, "11.1.2.0", "Dataset Service ver_");
    }

    protected boolean needUpgradeCognosserverSetting(Element serverElem) throws DataManagerException {
        return this.needUpgradeJAXRSSettings(serverElem) || this.needUpgradeClassLoadingSetting(serverElem) || this.needUpgradeHttpOptions(serverElem) || this.needUpgradeWebContainer(serverElem) || this.needUpgradeWebContainerForErrorPage(serverElem) || this.needUpgradeServerXmlElem(serverElem, "11.1.2.0", "Cognos Analytics ver_");
    }
}

