/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data.wlpconfig;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.CnfgValueChangedListener;
import com.cognos.crconfig.data.Constants;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.EnvVarArrayParameter;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.wlpconfig.WLPConfigCognosserverSettings;
import com.cognos.crconfig.data.wlpconfig.WLPConfigDatasetserviceSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;

public class WLPConfiguration
extends Constants
implements CnfgValueChangedListener {
    private static final String CFG_CRYPTO_KEYSTORE_PASSWORD_NAME = "keystoreFilePassword";
    private static final String WLP_CBSENVVARS_FILENAME = "../configuration/cbsEnvironmentVars.ini";
    protected Folder m_rootFolder = null;
    private boolean m_bDispInstalled = false;
    private boolean m_bStandAloneInstalled = false;
    private boolean m_bFlipperInstalled = false;
    protected Document m_datasetServiceWLPDoc = null;
    protected boolean m_bRecheckSettings = false;
    protected boolean m_bSSLProtocolsChanged = false;
    protected boolean m_bEnvVarsChanged = false;
    private WLPConfigCognosserverSettings m_wlpCognosserver = new WLPConfigCognosserverSettings(this);
    private WLPConfigDatasetserviceSettings m_wlpDatasetservice = new WLPConfigDatasetserviceSettings(this);
    private InputStream m_envVarsIniInputStream = null;
    private OutputStream m_envVarsIniOutputStream = null;

    public boolean checkWLPServerUpgrade() throws DataManagerException {
        return this.m_wlpCognosserver.checkCognosServerUpgrade() || this.m_wlpCognosserver.checkBootstrapPropsUpgrade() || this.m_wlpDatasetservice.checkDatasetServiceUpgrade();
    }

    public void populateFromProperties() {
        this.m_wlpDatasetservice.populateFromWLPProperties();
        this.populateFromEnvVars();
        this.m_wlpCognosserver.populateFromSAProperties();
    }

    protected void populateFromEnvVars() {
        Properties envVarsProperties = new Properties();
        DataManager dm = DataManager.getInstance();
        if (!dm.isBTSVInstalled()) {
            return;
        }
        try {
            File propFile = dm.resolveEffectiveFilePath(WLP_CBSENVVARS_FILENAME);
            if (propFile.exists()) {
                FileInputStream is = new FileInputStream(propFile);
                envVarsProperties.load(new InputStreamReader((InputStream)is, "UTF8"));
                is.close();
                Parameter envVarParam = dm.findParam("cbsEnvVar");
                if (envVarParam != null) {
                    EnvVarArrayParameter envVarsParam = (EnvVarArrayParameter)envVarParam;
                    envVarsParam.setFireValueChanged(false);
                    envVarsParam.loadEnvVars(envVarsProperties);
                    envVarsParam.setFireValueChanged(true);
                }
            } else {
                CnfgLog.error("The file '../configuration/cbsEnvironmentVars.ini' doesn't exist.");
            }
        }
        catch (Exception e) {
            CnfgLog.error("Exception when try to load '../configuration/cbsEnvironmentVars.ini' file." + e.toString());
        }
    }

    protected boolean checkSettings() {
        try {
            if ((this.m_bDispInstalled || this.m_bStandAloneInstalled) && this.m_rootFolder != null) {
                this.m_wlpCognosserver.checkCognosserverSettings();
                this.m_wlpDatasetservice.checkDatasetserviceSettings();
            }
        }
        catch (DataManagerException e) {
            CnfgLog.error(e);
        }
        return this.m_wlpCognosserver.settingsChanged() || this.m_wlpDatasetservice.settingsChanged() || this.m_bEnvVarsChanged;
    }

    public synchronized Document getAppSvrConfigDoc() throws DataManagerException {
        return this.m_wlpCognosserver.getAppSvrConfigDoc();
    }

    public synchronized Document getDatasetServiceSvrConfigDoc() throws DataManagerException {
        return this.m_wlpDatasetservice.getDatasetServiceSvrConfigDoc();
    }

    protected void saveEnvVarIni() throws DataManagerException {
        DataManager dm = DataManager.getInstance();
        try {
            InputStream is = this.m_envVarsIniInputStream;
            OutputStream os = this.m_envVarsIniOutputStream;
            Parameter envVarParam = dm.findParam("cbsEnvVar");
            if (envVarParam == null) {
                CnfgLog.error("The parameter 'cbsEnvVar' doesn't exist. No need to update file ../configuration/cbsEnvironmentVars.ini");
                return;
            }
            File envvarFile = DataManager.getInstance().resolveEffectiveFilePath(WLP_CBSENVVARS_FILENAME);
            if (is == null) {
                if (!envvarFile.exists()) {
                    CnfgLog.error("The file '../configuration/cbsEnvironmentVars.ini' doesn't exist.");
                }
                is = new FileInputStream(envvarFile);
            }
            Properties envVarsProperties = new Properties();
            envVarsProperties.load(new InputStreamReader(is, "UTF8"));
            is.close();
            this.setArrayParamsToProperties((ArrayParameter)envVarParam, envVarsProperties);
            if (os == null) {
                os = new FileOutputStream(envvarFile);
            }
            CnfgUtils.storeProperties(envVarsProperties, os, null);
            os.close();
        }
        catch (Exception e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadWLP.failed.bootstrap.ioexception", args));
        }
    }

    protected void setArrayParamsToProperties(ArrayParameter arrayParam, Properties listProp) {
        Set<Parameter> values = arrayParam.getCurrentValues();
        for (Parameter p : values) {
            String propValue;
            String paramName;
            if (p == null || (paramName = p.getName()) == null || paramName.isEmpty() || (propValue = (String)p.getValue()) == null || propValue.isEmpty()) continue;
            listProp.setProperty(paramName, propValue);
        }
    }

    public boolean cognosserverSettingsChanged() {
        return this.m_wlpCognosserver.serverSettingsChanged();
    }

    public void backWLPConfigurationFiles(String timeStamp) throws DataManagerException {
        this.m_wlpCognosserver.backWLPConfigurationFiles(timeStamp);
        this.m_wlpDatasetservice.backWLPConfigurationFiles(timeStamp);
    }

    public boolean checkSettings(boolean cryptoChanged) {
        if (cryptoChanged) {
            this.m_bRecheckSettings = true;
        }
        return this.m_bRecheckSettings || this.checkSettings();
    }

    public boolean envVarsChanged() {
        return this.m_bEnvVarsChanged;
    }

    public void setEnvVarsChanged(boolean changed) {
        this.m_bEnvVarsChanged = changed;
    }

    public void saveSettings() throws DataManagerException {
        boolean save;
        if ((this.m_bDispInstalled || this.m_bStandAloneInstalled) && this.m_rootFolder != null && (save = this.settingsChanged())) {
            if (this.m_wlpCognosserver.serverSettingsChanged()) {
                this.m_wlpDatasetservice.setDatasetServerSettingChanged(true);
            }
            this.m_wlpCognosserver.saveSettings();
            this.m_wlpDatasetservice.saveSettings();
            if (this.m_bEnvVarsChanged) {
                this.saveEnvVarIni();
                this.m_bEnvVarsChanged = false;
            }
        }
    }

    public void setDispInstalled(boolean bDispInstalled) {
        this.m_bDispInstalled = bDispInstalled;
    }

    public boolean isDispInstalled() {
        return this.m_bDispInstalled;
    }

    public void setStandAloneInstalled(boolean bSAInstalled) {
        this.m_bStandAloneInstalled = bSAInstalled;
    }

    public boolean isStandAloneInstalled() {
        return this.m_bStandAloneInstalled;
    }

    public void setFlipperInstalled(boolean bFlipperInstalled) {
        this.m_bFlipperInstalled = bFlipperInstalled;
    }

    public boolean isFlipperInstalled() {
        return this.m_bFlipperInstalled;
    }

    public void setJVMOptionsStreams(InputStream is, OutputStream os) {
        this.m_wlpCognosserver.setJVMOptionsStreams(is, os);
    }

    public void setBootstrapPropsStreams(InputStream is, OutputStream os) {
        this.m_wlpCognosserver.setBootstrapPropsStreams(is, os);
    }

    public void setRelativeLocations(boolean relativeLocations) {
        this.m_wlpCognosserver.setRelativeLocations(relativeLocations);
    }

    public void setRootFolder(Folder rootFolder) {
        this.m_rootFolder = rootFolder;
    }

    public Folder getRootFolder() {
        return this.m_rootFolder;
    }

    public void setServerConfigStreams(InputStream is, OutputStream os) {
        this.m_wlpCognosserver.setServerConfigStreams(is, os);
    }

    public boolean settingsChanged() {
        if (this.m_bRecheckSettings) {
            this.checkSettings();
            this.m_bRecheckSettings = false;
        }
        return this.m_wlpCognosserver.settingsChanged() || this.m_wlpDatasetservice.settingsChanged() || this.m_bEnvVarsChanged;
    }

    public String getEnvVarsFilePath() {
        return WLP_CBSENVVARS_FILENAME;
    }

    public boolean isSSLProtocoChanged() {
        return this.m_bSSLProtocolsChanged;
    }

    public void setSSLProtocoChanged(boolean isChanged) {
        this.m_bSSLProtocolsChanged = isChanged;
    }

    public WLPConfigCognosserverSettings getCognosserver() {
        return this.m_wlpCognosserver;
    }

    public WLPConfigDatasetserviceSettings getDatasetservice() {
        return this.m_wlpDatasetservice;
    }

    @Override
    public void valueChanged(CnfgValueChangedEvent e) {
        Parameter param;
        String pName;
        Object source = e.getSource();
        if (source != null && Parameter.class.isInstance(source) && (pName = (param = (Parameter)source).getName()) != null) {
            if (pName.equals(CFG_CRYPTO_KEYSTORE_PASSWORD_NAME)) {
                this.m_wlpCognosserver.setKeystorePasswordChanged(true);
            } else if (pName.equals("datasetServicePort")) {
                this.m_wlpDatasetservice.setDatasetHttpPortChanged(true);
            } else if (pName.equals("cbsEnvVar")) {
                this.m_bEnvVarsChanged = true;
            }
        }
    }
}

