/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.editors;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgEditorBorder;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class EditorBase
extends DefaultCellEditor
implements MouseListener,
KeyListener {
    protected JTextField m_textField;
    protected JComboBox m_comboField;
    protected String[] m_choices;
    protected Map m_sortedList;
    static final int MAX_ROW_COUNT = 6;
    protected Container m_parent;
    protected FocusListener m_focusListener;

    public EditorBase(Container owner, JTextField textField) {
        super(textField);
        this.setClickCountToStart(1);
        this.m_parent = owner;
        this.m_textField = textField;
        this.m_textField.setBorder(new CnfgEditorBorder(Color.black));
        this.m_textField.addMouseListener(this);
        this.m_textField.addKeyListener(this);
        this.m_focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EditorBase.this.stopCellEditing();
            }
        };
        this.getComponent().addFocusListener(this.m_focusListener);
    }

    public EditorBase(Container owner, JComboBox comboField) {
        super(comboField);
        this.setClickCountToStart(1);
        this.m_parent = owner;
        this.m_comboField = comboField;
        this.m_comboField.addMouseListener(this);
        this.m_comboField.setMaximumRowCount(6);
        this.m_comboField.setLightWeightPopupEnabled(false);
        this.m_comboField.registerKeyboardAction(new ComboBoxCancelListener(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.m_textField != null) {
            this.m_textField.selectAll();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    protected void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Point p1 = this.getComponent().getLocationOnScreen();
            Point p2 = this.m_parent.getLocation();
            CRConfigFrame.getInstance().getTablePopupMenu().show(this.m_parent, p1.x - p2.x + e.getX(), p1.y - p2.y + e.getY());
        }
    }

    protected static Map sort(Locale locale, Map map) {
        if (map instanceof SortedMap) {
            TreeMap specialMap = new TreeMap(((SortedMap)map).comparator());
            for (Map.Entry pair : map.entrySet()) {
                specialMap.put(pair.getKey(), pair);
            }
            return specialMap;
        }
        if (map instanceof LinkedHashMap) {
            LinkedHashMap specialMap = new LinkedHashMap();
            for (Map.Entry pair : map.entrySet()) {
                specialMap.put(pair.getKey(), pair);
            }
            return specialMap;
        }
        Collator collator = Collator.getInstance(locale);
        TreeMap sortedMap = new TreeMap();
        for (Map.Entry pair : map.entrySet()) {
            String name = (String)pair.getValue() + ":" + pair.getKey();
            CollationKey key = collator.getCollationKey(name);
            sortedMap.put(key, pair);
        }
        return sortedMap;
    }

    protected void loadList(Map values, Object curValue) {
        String _curValue;
        if (this.m_sortedList == null) {
            this.m_sortedList = EditorBase.sort(CnfgResource.getLocale(), values);
        }
        this.m_comboField.removeAllItems();
        int index = 0;
        this.m_choices = new String[this.m_sortedList.size()];
        Iterator it = this.m_sortedList.values().iterator();
        String string = _curValue = curValue != null ? curValue.toString() : "";
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            String key = pair.getKey().toString();
            String value = pair.getValue().toString();
            this.m_comboField.insertItemAt(value, index);
            this.m_choices[index] = key;
            if (_curValue.compareTo(key) == 0) {
                this.m_comboField.setSelectedIndex(index);
            }
            ++index;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.m_comboField != null) {
            if (value == null) {
                return this.m_comboField;
            }
            Parameter p = (Parameter)value;
            Map values = p.getValues();
            if (values != null) {
                this.loadList(values, p.getValue());
            }
            return this.m_comboField;
        }
        if (value == null) {
            return this.m_textField;
        }
        if (this.m_textField.getClass() == JPasswordField.class) {
            this.m_textField.setText(null);
            return this.m_textField;
        }
        Object obj = Parameter.class.isInstance(value) ? ((Parameter)value).getValue() : value.toString();
        if (obj != null) {
            this.m_textField.setText(obj.toString());
        }
        return this.m_textField;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.m_comboField != null) {
            int index;
            if (this.m_choices != null && (index = this.m_comboField.getSelectedIndex()) != -1) {
                return this.m_choices[index];
            }
        } else {
            if (this.m_textField.getClass() == JPasswordField.class) {
                return new String(((JPasswordField)this.m_textField).getPassword());
            }
            return this.m_textField.getText();
        }
        return "";
    }

    public void setTextFieldText(String text) {
        this.m_textField.setText(text);
    }

    class ComboBoxCancelListener
    implements ActionListener {
        ComboBoxCancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == EditorBase.this.m_comboField) {
                EditorBase.this.cancelCellEditing();
            }
        }
    }
}

