/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.editors;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.DialogGetCredential;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.SystemPasswordParameter;
import com.cognos.crconfig.editors.EditorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import javax.swing.JTextField;

public class EditorCredential
extends EditorDialog {
    protected String m_username = null;
    protected String m_password = null;
    protected Parameter m_param = null;

    public EditorCredential(Container owner, JTextField textField, boolean isTextFieldEditable) {
        super(owner, textField, isTextFieldEditable);
    }

    public EditorCredential(Container owner, JTextField textField, boolean isTextFieldEditable, CnfgButton button) {
        super(owner, textField, isTextFieldEditable, button);
    }

    public EditorCredential(Container owner, JTextField textField, boolean isTextFieldEditable, CnfgButton button, Parameter parm) {
        super(owner, textField, isTextFieldEditable, button);
        this.m_param = parm;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String sUserName = null;
        String sPassword = null;
        String sParamLabel = "";
        if (this.isInTable()) {
            Parameter parm;
            int row = CRConfigFrame.getInstance().getCnfgTable().getSelectionModel().getMinSelectionIndex();
            if (row != -1 && (parm = CRConfigFrame.getInstance().getCnfgTableModel().getItem(row)) != null && parm.getClass() == CredentialParameter.class) {
                sParamLabel = parm.getLabel();
                sUserName = ((CredentialParameter)parm).getPart(true);
                sPassword = ((CredentialParameter)parm).getPart(false);
            }
        } else {
            sUserName = this.m_username;
            sPassword = this.m_password;
            if ((sUserName == null || sPassword == null) && this.m_param != null && this.m_param.getClass() == CredentialParameter.class) {
                sParamLabel = this.m_param.getLabel();
                sUserName = ((CredentialParameter)this.m_param).getPart(true);
                sPassword = ((CredentialParameter)this.m_param).getPart(false);
            }
        }
        Object[] args = new Object[]{sParamLabel};
        String sTitle = CnfgResource.getMessage("Title.DialogEditValue.Parameter", args);
        DialogGetCredential dlg = Frame.class.isInstance(this.m_parent) ? new DialogGetCredential((Frame)this.m_parent, sTitle, "Label.DialogEditCredential.username", "Label.DialogEditCredential.password", "Label.DialogEditCredential.confirm", false, sUserName, sPassword) : (Dialog.class.isInstance(this.m_parent) ? new DialogGetCredential((Dialog)this.m_parent, sTitle, "Label.DialogEditCredential.username", "Label.DialogEditCredential.password", "Label.DialogEditCredential.confirm", false, sUserName, sPassword) : null);
        if (dlg != null && dlg.isOk()) {
            this.m_username = dlg.getUserName();
            this.m_password = dlg.getPassword();
            this.m_parent.requestFocus();
            this.stopCellEditing();
            return;
        }
        this.m_parent.requestFocus();
        this.cancelCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return CnfgDataUtils.buildCredentialValueElem(this.m_username, this.m_password);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null || value.getClass() != CredentialParameter.class && value.getClass() != SystemPasswordParameter.class || this.m_displayPanel == null) {
            return this.m_textField;
        }
        this.m_textField.setText("***************");
        Rectangle rect = table.getCellRect(row, column, true);
        this.m_button.setPreferredSize(new Dimension(rect.height - 2, rect.height - 2));
        return this.m_displayPanel;
    }
}

