/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.editors;

import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.editors.EditorBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public abstract class EditorDialog
extends EditorBase
implements ActionListener {
    protected CnfgButton m_button;
    protected EditorDialogPanel m_displayPanel;
    protected boolean m_bInTable = true;

    public EditorDialog(Container owner, JTextField textField, boolean isTextFieldEditable) {
        super(owner, textField);
        CnfgButton button = new CnfgButton("...", CnfgFontSetting.controlHeight - 2, CnfgFontSetting.controlHeight - 2);
        this.commonInit(owner, textField, isTextFieldEditable, button);
    }

    public EditorDialog(Container owner, JTextField textField, boolean isTextFieldEditable, CnfgButton button) {
        super(owner, textField);
        this.commonInit(owner, textField, isTextFieldEditable, button);
    }

    public EditorDialog(Container owner, JComboBox comboField, boolean isComboFieldEditable, CnfgButton button) {
        super(owner, comboField);
        this.commonInit(owner, comboField, isComboFieldEditable, button);
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    @Override
    public Object getCellEditorValue() {
        return new String(this.m_textField.getText());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Object obj;
        if (value == null) {
            return this.m_displayPanel;
        }
        if (Parameter.class.isInstance(value) && (obj = ((Parameter)value).getValue()) != null) {
            this.m_textField.setText(obj.toString());
        }
        Rectangle rect = table.getCellRect(row, column, true);
        this.m_button.setPreferredSize(new Dimension(rect.height - 2, rect.height - 2));
        return this.m_displayPanel;
    }

    public JPanel getEditorPanel() {
        return this.m_displayPanel;
    }

    public void setInTable(boolean bInTable) {
        this.m_bInTable = bInTable;
    }

    public boolean isInTable() {
        return this.m_bInTable;
    }

    private void commonInit(Container owner, JTextField textField, boolean isTextFieldEditable, CnfgButton button) {
        this.m_button = button;
        this.getComponent().removeFocusListener(this.m_focusListener);
        if (isTextFieldEditable) {
            this.m_textField.setEditable(true);
        } else {
            this.m_textField.setEditable(false);
            this.m_textField.setForeground(SystemColor.textInactiveText);
        }
        this.m_button.setDim(new Dimension(CnfgFontSetting.controlHeight - 2, CnfgFontSetting.controlHeight - 2));
        this.m_button.setOpaque(true);
        this.m_button.addActionListener(this);
        this.m_displayPanel = new EditorDialogPanel(textField, this.m_button);
        this.setClickCountToStart(1);
    }

    private void commonInit(Container owner, JComboBox comboField, boolean isComboFieldEditable, CnfgButton button) {
        this.m_button = button;
        this.getComponent().removeFocusListener(this.m_focusListener);
        if (isComboFieldEditable) {
            this.m_comboField.setEditable(true);
        } else {
            this.m_comboField.setEditable(false);
        }
        this.m_comboField.addActionListener(this);
        this.m_button.setDim(new Dimension(CnfgFontSetting.controlHeight - 2, CnfgFontSetting.controlHeight - 2));
        this.m_button.setOpaque(true);
        this.m_button.addActionListener(this);
        this.m_displayPanel = new EditorDialogPanel(comboField, this.m_button);
        this.setClickCountToStart(1);
    }

    public class EditorDialogPanel
    extends JPanel {
        protected JComponent m_leftJObject;
        protected JComponent m_rightJObject;

        public EditorDialogPanel(JComponent leftJObject, JComponent rightJObject) {
            this.commonInit(leftJObject, rightJObject);
        }

        private void commonInit(JComponent leftJObject, JComponent rightJObject) {
            this.m_leftJObject = leftJObject;
            this.m_rightJObject = rightJObject;
            this.setBackground(SystemColor.window);
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_leftJObject, "Center");
            Box p2 = new Box(0);
            this.add((Component)p2, "East");
            p2.add(Box.createHorizontalStrut(1));
            p2.add(this.m_rightJObject);
            this.setOpaque(true);
        }
    }
}

