/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.editors;

import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgField;
import com.cognos.crconfig.CnfgLabel;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.editors.EditorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditorFontBrowser
extends EditorDialog {
    public EditorFontBrowser(Container owner, JTextField textField, boolean isTextFieldEditable) {
        super(owner, textField, isTextFieldEditable);
    }

    public EditorFontBrowser(Container owner, JTextField textField, boolean isTextFieldEditable, CnfgButton button) {
        super(owner, textField, isTextFieldEditable, button);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FontChooserDialog dlg = Frame.class.isInstance(this.m_parent) ? new FontChooserDialog((Frame)this.m_parent, this.m_textField.getText()) : (Dialog.class.isInstance(this.m_parent) ? new FontChooserDialog((Dialog)this.m_parent, this.m_textField.getText()) : null);
        if (dlg != null) {
            dlg.show();
            if (dlg.m_bOK) {
                this.m_parent.requestFocus();
                this.stopCellEditing();
                return;
            }
        }
        this.m_parent.requestFocus();
        this.cancelCellEditing();
    }

    static {
        System.loadLibrary("cogconfig_jni");
    }

    public static class FontMapperListModel
    implements ListModel {
        private static String[] m_fonts;
        private static ListDataListener m_ldl;

        public void search(String paths) {
            DataManager dm = DataManager.getInstance();
            Parameter fontPaths = dm.findParm("fontPaths");
            fontPaths.setValue(paths);
            m_fonts = FNTM_FontMapper.getListOfFonts(paths);
            if (m_fonts.length > 0) {
                if (m_ldl != null) {
                    ListDataEvent e = new ListDataEvent(this, 0, 0, 0);
                    m_ldl.contentsChanged(e);
                }
            } else if (m_fonts.length == 0) {
                m_fonts = null;
                if (m_ldl != null) {
                    ListDataEvent e = new ListDataEvent(this, 2, 0, 0);
                    m_ldl.intervalRemoved(e);
                }
            }
        }

        public static boolean isValidFont(String sFontName) {
            if (sFontName == null) {
                return false;
            }
            if (m_fonts == null || m_fonts.length == 0) {
                ListDataEvent e;
                DataManager dm = DataManager.getInstance();
                Parameter fontPaths = dm.findParm("fontPaths");
                String sPaths = (String)fontPaths.getValue();
                m_fonts = FNTM_FontMapper.getListOfFonts(sPaths);
                if (m_fonts.length > 0) {
                    if (m_ldl != null) {
                        e = new ListDataEvent(null, 0, 0, 0);
                        m_ldl.contentsChanged(e);
                    }
                } else if (m_fonts.length == 0) {
                    m_fonts = null;
                    if (m_ldl != null) {
                        e = new ListDataEvent(null, 2, 0, 0);
                        m_ldl.intervalRemoved(e);
                    }
                }
            }
            if (m_fonts != null && m_fonts.length > 0) {
                for (int i = 0; i < m_fonts.length; ++i) {
                    if (m_fonts[i].compareTo(sFontName) != 0) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public int findIndex(String name) {
            if (m_fonts != null) {
                for (int i = 0; i < m_fonts.length; ++i) {
                    if (m_fonts[i].compareTo(name) != 0) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            m_ldl = l;
        }

        public Object getElementAt(int index) {
            if (m_fonts != null) {
                return m_fonts[index];
            }
            return null;
        }

        @Override
        public int getSize() {
            return m_fonts == null ? 0 : m_fonts.length;
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            if (m_ldl == l) {
                m_ldl = null;
            }
        }
    }

    static class FNTM_FontMapper {
        public static final int FNTM_UNKNOWN_FONT_TYPE = 0;
        public static final int FNTM_ADOBE_BASE14_FONT_TYPE = 1;
        public static final int FNTM_TRUETYPE_FONT_TYPE = 2;

        FNTM_FontMapper() {
        }

        public static native String[] getListOfFonts(String var0);
    }

    class FontChooserDialog
    extends JDialog
    implements ActionListener,
    ListSelectionListener,
    MouseListener {
        public boolean m_bOK;
        private CnfgButton m_buttonOK;
        private CnfgButton m_buttonCancel;
        private JList m_list;
        private CnfgField m_pathsField;
        private FontMapperListModel m_model;
        private CnfgButton m_buttonSearch;

        public FontChooserDialog(Frame owner, String fontName) {
            super(owner, CnfgResource.getMessage("Title.DialogFontBrowser"), true);
            this.m_model = new FontMapperListModel();
            this.commonInit(fontName);
        }

        public FontChooserDialog(Dialog owner, String fontName) {
            super(owner, CnfgResource.getMessage("Title.DialogFontBrowser"), true);
            this.m_model = new FontMapperListModel();
            this.commonInit(fontName);
        }

        private void commonInit(String fontName) {
            Insets margin = new Insets(5, 10, 5, 10);
            JPanel client = new JPanel();
            client.setBorder(new EmptyBorder(margin));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            client.setLayout(gridbag);
            this.m_buttonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
            this.m_buttonOK.setEnabled(false);
            this.m_buttonOK.addActionListener(this);
            this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
            this.m_buttonCancel.addActionListener(this);
            Box boxOKCancel = new Box(0);
            boxOKCancel.add(Box.createGlue());
            boxOKCancel.add(this.m_buttonOK);
            boxOKCancel.add(Box.createHorizontalStrut(6));
            boxOKCancel.add(this.m_buttonCancel);
            JLabel labelHeader = new JLabel(CnfgResource.getMessage("Label.DialogFontBrowser.header"));
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(10, 10, 5, 5);
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 11;
            c.fill = 2;
            gridbag.setConstraints(labelHeader, c);
            client.add(labelHeader);
            c.insets = margin;
            DataManager dm = DataManager.getInstance();
            Parameter fontPaths = dm.findParm("fontPaths");
            String paths = fontPaths.getValue().toString();
            this.m_pathsField = new CnfgField(150, paths, 300);
            CnfgLabel labelPaths = new CnfgLabel(300, CnfgResource.getMessage("Label.DialogFontBrowser.paths"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.m_pathsField);
            ++c.gridy;
            c.insets = new Insets(5, 10, 0, 5);
            gridbag.setConstraints(labelPaths, c);
            client.add(labelPaths);
            c.insets = margin;
            ++c.gridy;
            gridbag.setConstraints(this.m_pathsField, c);
            client.add(this.m_pathsField);
            this.m_buttonSearch = new CnfgButton(CnfgResource.getMessage("Label.DialogFontBrowser.buttonSearch"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
            this.m_buttonSearch.addActionListener(this);
            Box boxSearch = new Box(0);
            boxSearch.add(Box.createGlue());
            boxSearch.add(this.m_buttonSearch);
            ++c.gridy;
            gridbag.setConstraints(boxSearch, c);
            client.add(boxSearch);
            this.m_list = new JList(this.m_model);
            this.m_list.addListSelectionListener(this);
            this.m_list.setSelectionMode(0);
            this.m_list.addMouseListener(this);
            CnfgLabel labelResults = new CnfgLabel(300, CnfgResource.getMessage("Label.DialogFontBrowser.selectFont"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.m_list);
            ++c.gridy;
            c.insets = new Insets(5, 10, 0, 5);
            gridbag.setConstraints(labelResults, c);
            client.add(labelResults);
            c.insets = margin;
            JScrollPane scrollList = new JScrollPane(this.m_list);
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 11;
            c.fill = 1;
            gridbag.setConstraints(scrollList, c);
            client.add(scrollList);
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(5, 5, 10, 10);
            c.anchor = 15;
            c.fill = 2;
            gridbag.setConstraints(boxOKCancel, c);
            client.add(boxOKCancel);
            this.getContentPane().add((Component)client, "Center");
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    FontChooserDialog.this.terminate();
                }
            };
            this.addWindowListener(l);
            CnfgUtils.pack(this);
            this.setLocationRelativeTo(EditorFontBrowser.this.m_parent);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (FontChooserDialog.this.m_list.getSelectedIndex() != -1) {
                        FontChooserDialog.this.m_list.requestFocus();
                    } else {
                        FontChooserDialog.this.m_buttonCancel.requestFocus();
                    }
                }
            });
            int index = this.m_model.findIndex(fontName);
            if (index != -1) {
                this.m_list.ensureIndexIsVisible(index);
                this.m_list.setSelectedIndex(index);
            }
        }

        @Override
        protected JRootPane createRootPane() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontChooserDialog.this.dispose();
                }
            };
            JRootPane rootPane = new JRootPane();
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            rootPane.registerKeyboardAction(actionListener, stroke, 2);
            return rootPane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.getRootPane()) {
                this.terminate();
            } else if (e.getSource() == this.m_buttonOK) {
                this.action_OK();
            } else if (e.getSource() == this.m_buttonCancel) {
                this.terminate();
            } else if (e.getSource() == this.m_buttonSearch) {
                this.action_Search();
            }
        }

        private void action_Search() {
            String paths = this.m_pathsField.getText();
            this.m_model.search(paths);
            if (this.m_model.getSize() != 0) {
                this.m_buttonOK.setEnabled(true);
                this.m_list.setSelectedIndex(0);
            } else {
                this.m_buttonOK.setEnabled(false);
            }
        }

        private void action_OK() {
            if (this.m_list.getSelectedValue() != null) {
                EditorFontBrowser.this.m_textField.setText(this.m_list.getSelectedValue().toString());
                this.m_bOK = true;
            }
            this.dispose();
        }

        private void terminate() {
            this.dispose();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index = this.m_list.getSelectedIndex();
            this.m_buttonOK.setEnabled(index != -1);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.action_OK();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

