/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.editors;

import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgField;
import com.cognos.crconfig.CnfgLabel;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.FontsEmbedParameter;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.editors.EditorFontBrowser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class EditorFontEmbedBrowser
extends EditorFontBrowser {
    private String m_sTitle;
    private Parameter m_parm1;
    private Parameter m_parm2;

    public EditorFontEmbedBrowser(Container owner, JTextField textField, boolean isTextFieldEditable, String sTitle, Parameter parm1, Parameter parm2) {
        super(owner, textField, isTextFieldEditable);
        this.m_sTitle = sTitle;
        this.m_parm1 = parm1;
        this.m_parm2 = parm2;
    }

    public EditorFontEmbedBrowser(Container owner, JTextField textField, boolean isTextFieldEditable, CnfgButton button, String sTitle, Parameter parm1, Parameter parm2) {
        super(owner, textField, isTextFieldEditable, button);
        this.m_sTitle = sTitle;
        this.m_parm1 = parm1;
        this.m_parm2 = parm2;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Dialog dlg;
        String sCaption = "";
        if (this.m_parm1 != null) {
            sCaption = this.m_parm1.getName().compareToIgnoreCase("brsPDFEmbeddableFonts") == 0 ? "Title.DialogFontEmbedBrowser.Brs" : "Title.DialogFontEmbedBrowser.Rs";
        }
        if ((dlg = Frame.class.isInstance(this.m_parent) ? new FontChooserDialog((Frame)this.m_parent, this.m_textField.getText(), this.m_parm1, this.m_parm2, sCaption) : (Dialog.class.isInstance(this.m_parent) ? new FontChooserDialog((Dialog)this.m_parent, this.m_textField.getText(), this.m_parm1, this.m_parm2, sCaption) : null)) != null) {
            dlg.show();
            if (((FontChooserDialog)dlg).m_bOK) {
                this.m_parent.requestFocus();
                this.stopCellEditing();
                return;
            }
        }
        this.m_parent.requestFocus();
        this.cancelCellEditing();
    }

    class FontChooserDialog
    extends JDialog
    implements ActionListener,
    MouseListener {
        public boolean m_bOK;
        private CnfgButton m_buttonOK;
        private CnfgButton m_buttonCancel;
        private fontTable m_table;
        private CnfgField m_pathsField;
        private boolean bAlways;
        private boolean bNever;
        private CnfgButton m_buttonSearch;
        private String m_tableFont;
        FontEmbedTableModel m_model;

        public FontChooserDialog(Frame owner, String fontName, Parameter parm1, Parameter parm2, String sCaption) {
            super(owner, CnfgResource.getMessage(sCaption), true);
            this.bAlways = false;
            this.bNever = false;
            this.m_tableFont = "";
            this.m_model = new FontEmbedTableModel(this.m_tableFont, this.bAlways, this.bNever);
            this.commonInit(fontName, parm1, parm2);
        }

        public FontChooserDialog(Dialog owner, String fontName, Parameter parm1, Parameter parm2, String sCaption) {
            super(owner, CnfgResource.getMessage(sCaption), true);
            this.bAlways = false;
            this.bNever = false;
            this.m_tableFont = "";
            this.m_model = new FontEmbedTableModel(this.m_tableFont, this.bAlways, this.bNever);
            this.commonInit(fontName, parm1, parm2);
        }

        private void commonInit(String fontName, Parameter parm1, Parameter parm2) {
            Insets margin = new Insets(5, 10, 5, 10);
            JPanel client = new JPanel();
            client.setBorder(new EmptyBorder(margin));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            client.setLayout(gridbag);
            this.m_buttonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
            this.m_buttonOK.setEnabled(false);
            this.m_buttonOK.addActionListener(this);
            this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
            this.m_buttonCancel.addActionListener(this);
            Box boxOKCancel = new Box(0);
            boxOKCancel.add(Box.createGlue());
            boxOKCancel.add(this.m_buttonOK);
            boxOKCancel.add(Box.createHorizontalStrut(6));
            boxOKCancel.add(this.m_buttonCancel);
            JLabel labelHeader = new JLabel(CnfgResource.getMessage("Label.DialogFontEmbedBrowser.header"));
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(10, 10, 5, 5);
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.anchor = 11;
            c.fill = 2;
            gridbag.setConstraints(labelHeader, c);
            client.add(labelHeader);
            c.insets = margin;
            DataManager dm = DataManager.getInstance();
            Parameter fontPaths = dm.findParm("fontPaths");
            String paths = "";
            if (fontPaths != null && fontPaths.getValue() != null) {
                paths = fontPaths.getValue().toString();
            }
            this.m_pathsField = new CnfgField(150, paths, 300);
            CnfgLabel labelPaths = new CnfgLabel(300, CnfgResource.getMessage("Label.DialogFontBrowser.paths"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.m_pathsField);
            ++c.gridy;
            c.insets = new Insets(5, 10, 0, 5);
            gridbag.setConstraints(labelPaths, c);
            client.add(labelPaths);
            c.insets = margin;
            ++c.gridy;
            gridbag.setConstraints(this.m_pathsField, c);
            client.add(this.m_pathsField);
            this.m_buttonSearch = new CnfgButton(CnfgResource.getMessage("Label.DialogFontBrowser.buttonSearch"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex());
            this.m_buttonSearch.addActionListener(this);
            Box boxSearch = new Box(0);
            boxSearch.add(Box.createGlue());
            boxSearch.add(this.m_buttonSearch);
            ++c.gridy;
            gridbag.setConstraints(boxSearch, c);
            client.add(boxSearch);
            this.m_table = new fontTable(this.m_model);
            this.m_table.addMouseListener(this);
            this.m_model.initArraySize();
            this.m_model.setArrayValues(EditorFontEmbedBrowser.this.m_parm1, EditorFontEmbedBrowser.this.m_parm2);
            CnfgLabel labelResults = new CnfgLabel(300, CnfgResource.getMessage("Label.DialogFontEmbedBrowser.selectFont"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.m_table);
            ++c.gridy;
            c.insets = new Insets(5, 10, 0, 5);
            gridbag.setConstraints(labelResults, c);
            client.add(labelResults);
            c.insets = margin;
            JScrollPane scrollTable = new JScrollPane(this.m_table);
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(10, 10, 5, 5);
            c.anchor = 11;
            c.fill = 1;
            gridbag.setConstraints(scrollTable, c);
            client.add(scrollTable);
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(5, 5, 10, 10);
            c.anchor = 15;
            c.fill = 2;
            gridbag.setConstraints(boxOKCancel, c);
            client.add(boxOKCancel);
            this.getContentPane().add((Component)client, "Center");
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    FontChooserDialog.this.terminate();
                }
            };
            this.addWindowListener(l);
            CnfgUtils.pack(this);
            this.setLocationRelativeTo(EditorFontEmbedBrowser.this.m_parent);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (FontChooserDialog.this.m_table.getSelectedRow() != -1) {
                        FontChooserDialog.this.m_table.requestFocus();
                        FontChooserDialog.this.m_buttonOK.requestFocus();
                        FontChooserDialog.this.m_buttonOK.setEnabled(true);
                    } else {
                        FontChooserDialog.this.m_buttonCancel.requestFocus();
                    }
                }
            });
        }

        @Override
        protected JRootPane createRootPane() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontChooserDialog.this.dispose();
                }
            };
            JRootPane rootPane = new JRootPane();
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            rootPane.registerKeyboardAction(actionListener, stroke, 2);
            return rootPane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.getRootPane()) {
                this.terminate();
            } else if (e.getSource() == this.m_buttonOK) {
                this.action_OK();
            } else if (e.getSource() == this.m_buttonCancel) {
                this.terminate();
            } else if (e.getSource() == this.m_buttonSearch) {
                this.action_Search();
            }
        }

        private void action_Search() {
            String paths = this.m_pathsField.getText();
            this.m_model.searchFont(paths);
            if (this.m_model.m_fonts.length != 0) {
                this.m_model.initArraySize();
                this.m_model.setArrayValues(EditorFontEmbedBrowser.this.m_parm1, EditorFontEmbedBrowser.this.m_parm2);
                this.m_buttonOK.setEnabled(true);
                this.m_model.fireTableDataChanged();
            } else {
                this.m_buttonOK.setEnabled(false);
            }
        }

        private void action_OK() {
            this.m_model.fireTableDataChanged();
            this.m_model.setParameterValue(EditorFontEmbedBrowser.this.m_parm1, EditorFontEmbedBrowser.this.m_parm2);
            this.m_bOK = true;
            this.dispose();
        }

        private void terminate() {
            this.dispose();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.action_OK();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        class fontTable
        extends JTable {
            private final FontEmbedTableModel m_fontModel;

            public fontTable(FontEmbedTableModel model) {
                super(model);
                this.setColumnSelectionAllowed(false);
                this.setSelectionMode(0);
                this.setCellSelectionEnabled(true);
                this.m_fontModel = model;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                return super.getCellEditor(row, column);
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                return super.getCellRenderer(row, column);
            }

            @Override
            public void editingStopped(ChangeEvent ce) {
                super.editingStopped(ce);
                this.repaint();
            }
        }

        class FontEmbedTableModel
        extends AbstractTableModel {
            int COL_FONTS = 0;
            int COL_ALWAYS = 1;
            int COL_NEVER = 2;
            int COL_SIZE = 3;
            String sTitleFont = "Label.DialogFontEmbedBrowser.FontTitle";
            String sTitleAlways = "Label.DialogFontEmbedBrowser.AlwaysTitle";
            String sTitleNever = "Label.DialogFontEmbedBrowser.NeverTitle";
            private int m_rowSize;
            private String[] m_fonts;
            private boolean[] m_alwaysFonts;
            private boolean[] m_neverFonts;
            int ALWAYS_FLAG = 1;
            int NEVER_FLAG = 2;

            public FontEmbedTableModel(String sFont, boolean bAlwaysEmbed, boolean bNeverEmbed) {
            }

            public void initArraySize() {
                DataManager dm = DataManager.getInstance();
                Parameter fontPaths = dm.findParm("fontPaths");
                if (fontPaths != null && fontPaths.getValue() != null) {
                    String paths = fontPaths.getValue().toString();
                    this.searchFont(paths);
                    this.m_rowSize = this.m_fonts != null ? this.m_fonts.length : 0;
                    this.m_alwaysFonts = new boolean[this.m_rowSize];
                    this.m_neverFonts = new boolean[this.m_rowSize];
                    for (int i = 0; i < this.m_rowSize; ++i) {
                        this.m_alwaysFonts[i] = false;
                        this.m_neverFonts[i] = false;
                    }
                }
            }

            public void setArrayValues(Parameter parm1, Parameter parm2) {
                String sValue1 = ((FontsEmbedParameter)parm1).getParmValue() == null ? "" : ((FontsEmbedParameter)parm1).getParmValue().toString();
                String sValue2 = ((FontsEmbedParameter)parm2).getParmValue() == null ? "" : ((FontsEmbedParameter)parm2).getParmValue().toString();
                this.populateArray(sValue1, this.ALWAYS_FLAG);
                this.populateArray(sValue2, this.NEVER_FLAG);
            }

            public int findIndex(String name) {
                if (name.length() != 0 && this.m_fonts != null) {
                    for (int i = 0; i < this.m_fonts.length; ++i) {
                        if (this.m_fonts[i].compareTo(name) != 0) continue;
                        return i;
                    }
                }
                return -1;
            }

            public void setValues(int index, int iFlag) {
                if (index >= 0 && index <= this.m_rowSize) {
                    if (iFlag == 1) {
                        this.m_alwaysFonts[index] = true;
                    } else if (iFlag == 2) {
                        this.m_neverFonts[index] = true;
                    }
                }
            }

            public void populateArray(String sValue, int iFlag) {
                if (sValue.length() == 0 && iFlag == 1) {
                    for (int i = 0; i < this.m_rowSize; ++i) {
                        this.m_alwaysFonts[i] = false;
                    }
                } else if (sValue.length() == 0 && iFlag == 2) {
                    for (int j = 0; j < this.m_rowSize; ++j) {
                        this.m_neverFonts[j] = false;
                    }
                } else {
                    StringTokenizer tFonts = new StringTokenizer(sValue, ";");
                    while (tFonts.hasMoreTokens()) {
                        String font = tFonts.nextToken();
                        if (font.length() <= 0) continue;
                        int i = this.findIndex(font);
                        this.setValues(i, iFlag);
                    }
                }
            }

            public void getParameterValue(StringBuffer buffer, int iFlag) {
                buffer.setLength(0);
                if (iFlag == this.ALWAYS_FLAG) {
                    for (int i = 0; i < this.m_rowSize; ++i) {
                        if (!this.m_alwaysFonts[i]) continue;
                        if (buffer.length() == 0) {
                            buffer.append(this.m_fonts[i]);
                            continue;
                        }
                        buffer.append(";").append(this.m_fonts[i]);
                    }
                } else {
                    for (int j = 0; j < this.m_rowSize; ++j) {
                        if (!this.m_neverFonts[j]) continue;
                        if (buffer.length() == 0) {
                            buffer.append(this.m_fonts[j]);
                            continue;
                        }
                        buffer.append(";").append(this.m_fonts[j]);
                    }
                }
            }

            public void setParameterValue(Parameter parm1, Parameter parm2) {
                StringBuffer buffer = new StringBuffer();
                this.getParameterValue(buffer, this.ALWAYS_FLAG);
                if (parm1 != null) {
                    if (buffer.length() > 0) {
                        if (!((FontsEmbedParameter)parm1).setValue(buffer.toString())) {
                            parm1.setValue("");
                        }
                    } else {
                        parm1.setValue("");
                    }
                    buffer.setLength(0);
                }
                this.getParameterValue(buffer, this.NEVER_FLAG);
                if (parm2 != null) {
                    if (buffer.length() > 0) {
                        if (!((FontsEmbedParameter)parm2).setValue(buffer.toString())) {
                            parm2.setValue("");
                        }
                    } else {
                        parm2.setValue("");
                    }
                    buffer.setLength(0);
                }
            }

            @Override
            public int getRowCount() {
                return this.m_rowSize;
            }

            @Override
            public int getColumnCount() {
                return this.COL_SIZE;
            }

            @Override
            public String getColumnName(int column) {
                if (column == this.COL_FONTS) {
                    return CnfgResource.getMessage(this.sTitleFont);
                }
                if (column == this.COL_ALWAYS) {
                    return CnfgResource.getMessage(this.sTitleAlways);
                }
                if (column == this.COL_NEVER) {
                    return CnfgResource.getMessage(this.sTitleNever);
                }
                return null;
            }

            @Override
            public Object getValueAt(int row, int col) {
                boolean bAlways = false;
                boolean bNever = false;
                if (col == this.COL_FONTS) {
                    String obj = this.m_fonts[row];
                    return obj;
                }
                if (col == this.COL_ALWAYS) {
                    bAlways = this.m_alwaysFonts[row];
                    return new Boolean(bAlways);
                }
                if (col == this.COL_NEVER) {
                    bNever = this.m_neverFonts[row];
                    return new Boolean(bNever);
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == this.COL_ALWAYS || col == this.COL_NEVER;
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                Boolean bool = (Boolean)aValue;
                if (col == this.COL_ALWAYS) {
                    this.m_alwaysFonts[row] = bool;
                    if (this.m_neverFonts[row] && bool.booleanValue()) {
                        this.m_neverFonts[row] = false;
                    }
                } else if (col == this.COL_NEVER) {
                    this.m_neverFonts[row] = bool;
                    if (this.m_alwaysFonts[row] && bool.booleanValue()) {
                        this.m_alwaysFonts[row] = false;
                    }
                }
                FontChooserDialog.this.m_buttonOK.setEnabled(true);
                this.fireTableRowsUpdated(row, row);
            }

            public Class getColumnClass(int col) {
                if (col == this.COL_ALWAYS || col == this.COL_NEVER) {
                    return Boolean.class;
                }
                return String.class;
            }

            public void searchFont(String paths) {
                DataManager dm = DataManager.getInstance();
                Parameter fontPaths = dm.findParm("fontPaths");
                fontPaths.setValue(paths);
                this.m_fonts = EditorFontBrowser.FNTM_FontMapper.getListOfFonts(paths);
                if (this.m_fonts != null && this.m_fonts.length == 0) {
                    this.m_fonts = null;
                }
            }
        }
    }
}

