/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.editors;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgFileChooser;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.DialogMessage;
import com.cognos.crconfig.data.PathParameter;
import com.cognos.crconfig.editors.EditorDialog;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class EditorPathParameter
extends EditorDialog {
    private PathParameter m_param;

    public EditorPathParameter(Container owner, JTextField textField, boolean isTextFieldEditable, PathParameter param) {
        super(owner, textField, isTextFieldEditable);
        this.m_param = param;
    }

    public EditorPathParameter(Container owner, JTextField textField, boolean isTextFieldEditable, CnfgButton button, PathParameter param) {
        super(owner, textField, isTextFieldEditable, button);
        this.m_param = param;
    }

    public EditorPathParameter(Container owner, JComboBox comboField, boolean isComboFieldEditable, CnfgButton button, PathParameter param) {
        super(owner, comboField, isComboFieldEditable, button);
        this.m_param = param;
    }

    private void setCurrentBrowseLocation(CnfgFileChooser browseDlg, boolean bIsFile) {
        String sDefaultPath = this.getCellEditorValue().toString();
        boolean bFound = false;
        String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sDefaultPath);
        File curFile = new File(sResolvedPath);
        File curDir = bIsFile ? new File(curFile.getParent()) : curFile;
        if (!curDir.isDirectory()) {
            String sPath = "";
            try {
                sPath = curDir.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object[] args1 = new Object[]{sPath};
            Object[] msgs = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.errorOnEditPath.pathnotexist.notification", args1)).append("\n").toString(), CnfgResource.getMessage("Message.errorOnEditPath.pathnotexist.resolution")};
            if (DialogMessage.showDialog(msgs, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) == 0) {
                if (!curDir.mkdirs()) {
                    Object[] args2 = new Object[]{sResolvedPath};
                    String sErrorMessage = CnfgResource.getMessage("Message.saveConfig.failed.unableToMkdir.explanation", args2);
                    DialogMessage.showDialog(sErrorMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                    bFound = false;
                } else {
                    bFound = true;
                }
            } else {
                bFound = false;
            }
        } else {
            bFound = true;
        }
        if (bFound) {
            if (bIsFile) {
                browseDlg.setSelectedFile(curFile);
            } else {
                browseDlg.setCurrentDirectory(curDir);
            }
        } else {
            curDir = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath("."));
            browseDlg.setCurrentDirectory(curDir);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CnfgFileChooser browseDlg = new CnfgFileChooser(){

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (EditorPathParameter.this.m_param.isFolderPath() && !file.isDirectory()) {
                    String sErrorMessage = CnfgResource.getMessage("Message.errorOnEditPath.selectionwrong.resolution");
                    DialogMessage.showDialog(sErrorMessage, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_OK, 1);
                } else if (EditorPathParameter.this.m_param.isFilePath()) {
                    if (EditorPathParameter.this.m_param.getFileFilterExtList() != null && EditorPathParameter.this.m_param.getFileFilterExtList().size() == 1) {
                        String sExt = CnfgUtils.getFileExtension(file);
                        String sFilterExt = EditorPathParameter.this.m_param.getFileFilterExtList().get(0);
                        if (sExt == null || !sExt.equalsIgnoreCase(sFilterExt)) {
                            file = new File(file.getAbsolutePath() + "." + sFilterExt.toLowerCase());
                            this.setSelectedFile(file);
                        }
                    }
                    if (!file.isFile() && !file.isDirectory()) {
                        String sPath = "";
                        try {
                            sPath = file.getCanonicalPath();
                        }
                        catch (Exception sFilterExt) {
                            // empty catch block
                        }
                        Object[] args = new Object[]{sPath};
                        Object[] msgs = new Object[]{new StringBuffer(CnfgResource.getMessage("Message.errorOnEditPath.filenotexist.notification", args)).append("\n").toString(), CnfgResource.getMessage("Message.errorOnEditPath.selectionnotexist.resolution")};
                        if (DialogMessage.showDialog(msgs, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_WARNING, DialogMessage.OPTS_YESNO, 1) == 0) {
                            super.approveSelection();
                        }
                    } else {
                        super.approveSelection();
                    }
                } else {
                    super.approveSelection();
                }
            }
        };
        if (this.m_param.hasFilter()) {
            final List<String> lExt = this.m_param.getFileFilterExtList();
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f != null) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        String extension = CnfgUtils.getFileExtension(f);
                        if (extension != null && lExt.contains(extension)) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return EditorPathParameter.this.m_param.getFileFilterDesc();
                }
            };
            browseDlg.setFileFilter(filter);
        }
        this.setCurrentBrowseLocation(browseDlg, this.m_param.isFilePath());
        if (this.m_param.isFilePath()) {
            browseDlg.setFileSelectionMode(0);
            browseDlg.setDialogTitle(CnfgResource.getMessage("Label.DialogFileBrowser.file.Title"));
        } else {
            browseDlg.setFileSelectionMode(2);
            browseDlg.setDialogTitle(CnfgResource.getMessage("Label.DialogFileBrowser.folder.Title"));
        }
        String sApproveButtonText = CnfgResource.getMessage("Label.DialogFileBrowser.approveButton");
        browseDlg.setApproveButtonMnemonic(CnfgResource.getLastAccelerator());
        browseDlg.setApproveButtonText(sApproveButtonText);
        browseDlg.setApproveButtonToolTipText(CnfgResource.getMessage("Label.DialogFileBrowser.approveButtonToolTip"));
        int returnVal = Frame.class.isInstance(this.m_parent) ? browseDlg.showDialog((Frame)this.m_parent, sApproveButtonText) : (Dialog.class.isInstance(this.m_parent) ? browseDlg.showDialog((Dialog)this.m_parent, sApproveButtonText) : 1);
        if (returnVal == 0) {
            File selectedFile = browseDlg.getSelectedFile();
            try {
                String sPath = selectedFile.getCanonicalPath();
                this.setPathEditorValue(this.normalizePath(sPath));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_parent.requestFocus();
        this.stopCellEditing();
    }

    private String normalizePath(String path) {
        String res = path;
        if (path != null) {
            if (path.startsWith("\\\\") && CnfgUtils.isWindowsPlatform()) {
                return path;
            }
            res = path.replace('\\', '/');
        }
        return res;
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_textField.getText();
    }

    public void setPathEditorValue(String sValue) {
        this.m_textField.setText(sValue);
    }

    public void setButtonSize(int width, int height) {
        this.m_button.setDim(new Dimension(width, height));
    }
}

