/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.editors;

import com.cognos.crconfig.CnfgButton;
import com.cognos.crconfig.CnfgComboBox;
import com.cognos.crconfig.CnfgField;
import com.cognos.crconfig.CnfgFontSetting;
import com.cognos.crconfig.CnfgLabel;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.tenancy.ProviderType;
import com.cognos.crconfig.data.tenancy.TenancyInfoProvider;
import com.cognos.crconfig.data.tenancy.TenancyInfoProviderParameter;
import com.cognos.crconfig.editors.EditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class EditorTenancyInfo
extends EditorDialog {
    private static final long serialVersionUID = 2517687798179617278L;
    private TenancyInfoProvider provider;
    private String dialogTitle;

    public EditorTenancyInfo(Container owner, JTextField textField, CnfgButton button, TenancyInfoProviderParameter param) {
        super(owner, textField, false, button);
        this.provider = (TenancyInfoProvider)param.getValue();
        this.dialogTitle = param.getLabel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TenancyInfoDialog dlg = Frame.class.isInstance(this.m_parent) ? new TenancyInfoDialog((Frame)this.m_parent, this.provider, this.dialogTitle) : (Dialog.class.isInstance(this.m_parent) ? new TenancyInfoDialog((Dialog)this.m_parent, this.provider, this.dialogTitle) : null);
        if (dlg != null && dlg.m_bOK) {
            this.m_parent.requestFocus();
            this.stopCellEditing();
            return;
        }
        this.m_parent.requestFocus();
        this.cancelCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.provider;
    }

    class TenancyInfoDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = -3871707278682471244L;
        public boolean m_bOK;
        private CnfgButton m_buttonOK;
        private CnfgButton m_buttonCancel;
        private CnfgField tenancyInfoValue;
        private CnfgComboBox tenancyInfoType;
        private TenancyInfoProvider provider;

        public TenancyInfoDialog(Frame owner, TenancyInfoProvider provider, String title) {
            super(owner, title, true);
            this.commonInit(provider);
        }

        public TenancyInfoDialog(Dialog owner, TenancyInfoProvider provider, String title) {
            super(owner, title, true);
            this.commonInit(provider);
        }

        private void commonInit(TenancyInfoProvider provider) {
            this.provider = provider;
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            Insets ins1 = new Insets(10, 10, 0, 10);
            Insets ins2 = new Insets(2, 10, 0, 10);
            this.getContentPane().setLayout(new BorderLayout());
            this.setResizable(false);
            JPanel panel = new JPanel();
            this.getContentPane().add((Component)panel, "Center");
            panel.setLayout(gridbag);
            this.tenancyInfoValue = new CnfgField(1, 1, 300, provider.getValue(), false);
            c.gridx = 1;
            c.gridy = 4;
            c.gridwidth = 8;
            c.insets = ins2;
            c.fill = 2;
            gridbag.setConstraints(this.tenancyInfoValue, c);
            panel.add(this.tenancyInfoValue);
            c.gridwidth = 1;
            c.fill = 0;
            c.fill = 2;
            c.anchor = 18;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.insets = ins1;
            c.gridx = 1;
            c.gridwidth = 8;
            this.tenancyInfoType = new CnfgComboBox(){
                private static final long serialVersionUID = -4809870746181792194L;
                Dimension d = new Dimension(230, CnfgFontSetting.getControlHeight() + 1);

                @Override
                public Dimension getPreferredSize() {
                    return this.d;
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.d;
                }
            };
            this.tenancyInfoType.setEditable(false);
            this.tenancyInfoType.initUIandEditor();
            this.tenancyInfoType.setMaximumRowCount(3);
            for (ProviderType type : provider.getTypeChoices()) {
                this.tenancyInfoType.addItem(type);
            }
            ProviderType type = provider.getType();
            this.tenancyInfoType.setSelectedItem(type);
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 6;
            c.insets = ins2;
            c.fill = 2;
            gridbag.setConstraints(this.tenancyInfoType, c);
            panel.add(this.tenancyInfoType);
            c.gridwidth = 1;
            c.fill = 0;
            CnfgLabel xcLabelTemplateType = new CnfgLabel(300, CnfgResource.getMessage("Label.DialogCreateNew.type"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.tenancyInfoType);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 8;
            c.insets = ins1;
            c.fill = 2;
            gridbag.setConstraints(xcLabelTemplateType, c);
            panel.add(xcLabelTemplateType);
            c.gridwidth = 1;
            c.fill = 0;
            CnfgLabel xcLabelInstanceName = new CnfgLabel(300, CnfgResource.getMessage("Label.DialogEditEncrypted.value"), CnfgResource.getLastAccelerator(), CnfgResource.getLastAcceleratorIndex(), this.tenancyInfoValue);
            c.gridx = 1;
            c.gridy = 3;
            c.gridwidth = 8;
            c.insets = ins1;
            c.fill = 2;
            gridbag.setConstraints(xcLabelInstanceName, c);
            panel.add(xcLabelInstanceName);
            Box p2 = this.getButtonBox(gridbag, c);
            panel.add(p2);
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TenancyInfoDialog.this.terminate();
                }
            };
            this.addWindowListener(l);
            CnfgUtils.pack(this);
            this.setLocationRelativeTo(EditorTenancyInfo.this.m_parent);
            FontUIResource titleFont = (FontUIResource)UIManager.get("InternalFrame.titleFont");
            FontMetrics fm = this.getFontMetrics(titleFont);
            int width = fm.stringWidth(this.getTitle()) + 50;
            width = Math.max(width, this.getPreferredSize().width);
            this.setSize(new Dimension(width, this.getPreferredSize().height));
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TenancyInfoDialog.this.tenancyInfoValue.requestFocus();
                }
            });
            this.setVisible(true);
        }

        private Box getButtonBox(GridBagLayout gridbag, GridBagConstraints c) {
            c.gridwidth = 1;
            c.fill = 0;
            Box p2 = new Box(0);
            c.gridy = 9;
            c.insets = new Insets(20, 10, 6, 10);
            c.anchor = 11;
            gridbag.setConstraints(p2, c);
            this.m_buttonOK = new CnfgButton(CnfgResource.getMessage("Label.ButtonOK.NoAccelerator"));
            this.getRootPane().setDefaultButton(this.m_buttonOK);
            p2.add(Box.createGlue());
            p2.add(this.m_buttonOK);
            p2.add(Box.createHorizontalStrut(6));
            this.m_buttonCancel = new CnfgButton(CnfgResource.getMessage("Label.ButtonCancel.NoAccelerator"));
            p2.add(this.m_buttonCancel);
            p2.add(Box.createHorizontalStrut(6));
            this.m_buttonOK.addActionListener(this);
            this.m_buttonCancel.addActionListener(this);
            return p2;
        }

        @Override
        protected JRootPane createRootPane() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TenancyInfoDialog.this.dispose();
                }
            };
            JRootPane rootPane = new JRootPane();
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            rootPane.registerKeyboardAction(actionListener, stroke, 2);
            return rootPane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.getRootPane()) {
                this.terminate();
            } else if (e.getSource() == this.m_buttonOK) {
                this.action_OK();
            } else if (e.getSource() == this.m_buttonCancel) {
                this.terminate();
            }
        }

        private void action_OK() {
            ProviderType type = (ProviderType)this.tenancyInfoType.getSelectedItem();
            this.provider.setType(type);
            this.provider.setValue(this.tenancyInfoValue.getText().trim());
            this.m_bOK = true;
            EditorTenancyInfo.this.m_textField.setText(this.provider.getDisplayValue());
            this.dispose();
        }

        private void terminate() {
            this.dispose();
        }
    }
}

