/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.test;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.service.ServiceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Element;

public class CBSTest
implements ICnfgTest {
    private ICCLConfiguration m_cfgapi = null;
    private ArrayList<String> m_btsvServices = new ArrayList();

    public boolean initialize(ICCLConfiguration cfgapi, ICnfgFeedback feedback) {
        this.m_cfgapi = cfgapi;
        if (this.m_cfgapi != null) {
            try {
                this.addBTSVService(this.m_btsvServices, "CBS");
                this.addBTSVService(this.m_btsvServices, "SGW");
            }
            catch (CCLConfigurationException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void addBTSVService(ArrayList<String> list, String name) throws CCLConfigurationException {
        Element elem = this.m_cfgapi.getValueElement(name, true);
        if (elem != null) {
            this.m_btsvServices.add(name);
        }
    }

    public ICnfgTask[] getTasks(String parameter, ICnfgFeedback feedback) {
        if (parameter == null || parameter.length() == 0 || parameter.equalsIgnoreCase("environment") || parameter.equalsIgnoreCase("null")) {
            if (this.m_btsvServices.size() > 0) {
                return this.addTasks(this.m_btsvServices, null);
            }
        } else {
            StringTokenizer st = new StringTokenizer(parameter, "/");
            if (st.countTokens() >= 2) {
                st.nextToken();
                String nodeName = st.nextToken();
                if (nodeName.length() > 0) {
                    return this.addTasks(null, nodeName);
                }
            }
        }
        return this.addTasks(null, "CBS");
    }

    private ICnfgTask[] addTasks(ArrayList<String> serviceList, String name) {
        if (serviceList != null) {
            ICnfgTask[] tasks = new ICnfgTask[serviceList.size()];
            int i = 0;
            for (String serviceName : serviceList) {
                CnfgTask task = this.addBTSVTestTask(serviceName);
                if (task == null) continue;
                tasks[i] = task;
                ++i;
            }
            return tasks;
        }
        if (name == null || name.length() == 0) {
            name = "CBS";
        }
        ICnfgTask[] tasks = new ICnfgTask[]{this.addBTSVTestTask(name)};
        return tasks;
    }

    public void terminate(ICnfgFeedback feedback) {
    }

    private CnfgTask addBTSVTestTask(String nodeName) {
        if (nodeName == null || nodeName.length() == 0) {
            return null;
        }
        final String svrName = nodeName;
        CnfgTask btsvTask = new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.testcbs.label");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.testcbs.label");
            }

            @Override
            public boolean isMandatory() {
                return true;
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                if (CBSTest.this.m_cfgapi != null) {
                    Element instanceElement;
                    Element instancesElement;
                    String sDispatcherMaxMemoryValue = null;
                    String serviceClass = "";
                    ArrayList<String> additionArgList = new ArrayList<String>();
                    Element cbsElement = CBSTest.this.m_cfgapi.getValueElement(svrName, true);
                    if (cbsElement != null && (instancesElement = cbsElement.element("instances")) != null && (instanceElement = instancesElement.element("instance")) != null) {
                        serviceClass = instanceElement.attributeValue("class");
                        List parameterList = instanceElement.elements("parameter");
                        for (Element parameterElement : parameterList) {
                            String sDispatcherMaxMemoryAttribute = parameterElement.attributeValue("name");
                            String DISPATCHERMAXMEMORY = "dispatcherMaxMemory";
                            if (sDispatcherMaxMemoryAttribute == null || sDispatcherMaxMemoryAttribute.compareTo("dispatcherMaxMemory") != 0) continue;
                            Element valueElement = parameterElement.element("value");
                            sDispatcherMaxMemoryValue = valueElement.getTextTrim();
                            additionArgList.add(new String("$$dispatcherMaxMemory=" + sDispatcherMaxMemoryValue));
                            break;
                        }
                    }
                    additionArgList.add("-output");
                    ServiceManager.testCBS(additionArgList, serviceClass != null ? serviceClass : "");
                    if (sDispatcherMaxMemoryValue != null) {
                        Object[] msgArgs = new Object[]{sDispatcherMaxMemoryValue};
                        feedback.showInformational(CnfgResource.getMessage("Message.testcbs.success", msgArgs));
                    }
                    return true;
                }
                return false;
            }
        };
        return btsvTask;
    }

    public static void main(String[] args) {
    }
}

