/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.test;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigComparator {
    private static final String CRYPTO_COGNOS_INSTANCE_XPATH = "./*[local-name()='parameter'][@name=\"CRYPTO\"]/*[local-name()='value']";

    public static boolean isCryptoSectionIsDirty(ICCLConfiguration config) {
        ICCLConfiguration savedConfig = CCLConfigurationFactory.createConfiguration();
        org.dom4j.Element savedCrypto = null;
        org.dom4j.Element currentCrypto = null;
        boolean result = true;
        try {
            savedConfig.init();
            savedCrypto = ConfigComparator.getCryptoParameter(savedConfig);
            currentCrypto = ConfigComparator.getCryptoParameter(config);
            result = ConfigComparator.compareCryptoInstances(currentCrypto, savedCrypto);
        }
        catch (CCLConfigurationException e) {
            return result;
        }
        catch (Exception e) {
            return result;
        }
        return !result;
    }

    private static String toStringW3C(String xmlstr) throws Exception {
        return ConfigComparator.serializeToString(ConfigComparator.xmlStringToDocument(xmlstr));
    }

    public static Element xmlStringToDocument(String xmlString) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xmlString));
        Document dom = builder.parse(is);
        return dom.getDocumentElement();
    }

    public static String serializeToString(Element param) {
        DOMImplementationLS lsImpl = (DOMImplementationLS)param.getOwnerDocument().getImplementation().getFeature("ls", "3.0");
        LSSerializer serializer = lsImpl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        serializer.getDomConfig().setParameter("comments", false);
        String serialized = serializer.writeToString(param);
        serialized = serialized.replace("\n", "").replace("\r", "");
        return serialized;
    }

    private static boolean compareCryptoInstances(org.dom4j.Element currentCrypto, org.dom4j.Element savedCrypto) throws Exception {
        if (currentCrypto == null || savedCrypto == null) {
            return true;
        }
        org.dom4j.Element currentCryptoCopy = (org.dom4j.Element)currentCrypto.clone();
        org.dom4j.Element savedCryptoCopy = (org.dom4j.Element)savedCrypto.clone();
        ConfigComparator.removeTextElements(savedCryptoCopy);
        ConfigComparator.removeTextElements(currentCryptoCopy);
        currentCryptoCopy.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        savedCryptoCopy.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        String currentStrnew = ConfigComparator.asXML(currentCryptoCopy);
        String savedStrnew = ConfigComparator.asXML(savedCryptoCopy);
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("compareCryptoInstances - saved crypto - BEFORE: \n");
            CnfgLog.debug(savedStrnew + " \n");
            CnfgLog.debug("compareCryptoInstances - current crypto - BEFORE: \n");
            CnfgLog.debug(currentStrnew + " \n");
        }
        String savedStr = ConfigComparator.toStringW3C(savedStrnew);
        String currentStr = ConfigComparator.toStringW3C(currentStrnew);
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("compareCryptoInstances - Reparsing saved crypto: \n");
            CnfgLog.debug(savedStr + " \n");
            CnfgLog.debug("compareCryptoInstances - Reparsing current crypto: \n");
            CnfgLog.debug(currentStr + " \n");
        }
        boolean result = currentStr.equals(savedStr);
        return result;
    }

    public static String asXML(org.dom4j.Element element) throws IOException {
        StringWriter out = new StringWriter();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setExpandEmptyElements(true);
        XMLWriter writer = new XMLWriter((Writer)out, outputFormat);
        writer.write(element);
        writer.flush();
        return out.toString();
    }

    private static void removeTextElements(org.dom4j.Element element) {
        Iterator it = element.nodeIterator();
        ArrayList<Node> textNodeList = new ArrayList<Node>();
        while (it.hasNext()) {
            org.dom4j.Element childElement;
            Node childNode = (Node)it.next();
            short type = childNode.getNodeType();
            if (type != 1) {
                textNodeList.add(childNode);
                continue;
            }
            if (!(childNode instanceof org.dom4j.Element) || (childElement = (org.dom4j.Element)childNode).elements().size() <= 0) continue;
            ConfigComparator.removeTextElements(childElement);
        }
        for (Node node : textNodeList) {
            element.remove(node);
        }
    }

    public static org.dom4j.Element getCryptoParameter(ICCLConfiguration config) throws CCLConfigurationException {
        org.dom4j.Element root = config.getValueElement("", false);
        List cryptoInstanceList = DocumentHelper.selectNodes((String)CRYPTO_COGNOS_INSTANCE_XPATH, (Node)root);
        if (cryptoInstanceList.size() < 1) {
            return null;
        }
        return (org.dom4j.Element)cryptoInstanceList.get(0);
    }
}

