/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.test;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgActionClient;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.crconfig.data.CnfgActionTest;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.test.ConfigComparator;
import com.ibm.cognos.conformance.CNFMConfiguration;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestTaskManager {
    private static boolean m_bTestPerformedOnce = false;
    private static boolean m_bIgnoreCheckingSaveConfig = false;

    public static void setTestPerformed(boolean b) {
        m_bTestPerformedOnce = b;
    }

    public static void setIgnoreCheckingSaveConfig(boolean bIgnore) {
        m_bIgnoreCheckingSaveConfig = bIgnore;
    }

    public static Map<String, ICnfgTest> getTestTasks(DataManager.ITaskCollector taskCollector, Object obj, List<ICnfgTask> taskList, boolean bCheckConditions, boolean bAddCryptoTask, boolean bStartAction, ICnfgFeedback feedback) {
        return TestTaskManager.getTestTasks(taskCollector, obj, taskList, bCheckConditions, bAddCryptoTask, bStartAction, feedback, true);
    }

    public static Map<String, ICnfgTest> getTestTasks(DataManager.ITaskCollector taskCollector, Object obj, List<ICnfgTask> taskList, boolean bCheckConditions, boolean bAddCryptoTask, boolean bStartAction, ICnfgFeedback feedback, boolean bValidateConfig) {
        if (obj == null || !Folder.class.isAssignableFrom(obj.getClass()) && !Parameter.class.isAssignableFrom(obj.getClass())) {
            return null;
        }
        if (bCheckConditions && m_bTestPerformedOnce && !DataManager.getInstance().isDirty()) {
            return null;
        }
        if (bAddCryptoTask) {
            taskList.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.crypto");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Label.DialogSave.cryptoTask");
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    try {
                        DataManager.getInstance().generateCryptoKeys(feedback);
                        return true;
                    }
                    catch (DataManagerException e) {
                        CnfgLog.error(e);
                        throw e;
                    }
                }
            });
        }
        return TestTaskManager.collectTestTasks(taskCollector, taskList, obj, DataManager.buildPath(obj), bStartAction, feedback, bValidateConfig);
    }

    private static Map<String, ICnfgTest> collectTestTasks(DataManager.ITaskCollector taskCollector, List<ICnfgTask> taskList, Object obj, String selectedParamFolderName, boolean bStartAction, ICnfgFeedback feedback, boolean bValidateConfig) {
        ICCLConfiguration cclconfig;
        if (obj == null || !Folder.class.isAssignableFrom(obj.getClass()) && !Parameter.class.isAssignableFrom(obj.getClass())) {
            return null;
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("collectTestTasks - get test tasks for param path: '" + selectedParamFolderName + "'.");
        }
        if ((cclconfig = DataManager.validateConfiguration(taskCollector, obj, bValidateConfig)) == null) {
            return null;
        }
        CNFMConfiguration cnfmConfig = CNFMConfiguration.getInstance();
        if (bStartAction) {
            cnfmConfig.setCNFMCheckingDisabled(true);
        } else {
            cnfmConfig.setCNFMCheckingDisabled(!DataManager.getInstance().getIsCNFMCheckingViaTestActionEnabled());
        }
        List<CnfgActionTest> testActions = TestTaskManager.getTestActions(obj);
        HashMap<String, ICnfgTest> initializedClasses = null;
        if (testActions.size() > 0) {
            initializedClasses = new HashMap<String, ICnfgTest>();
            for (CnfgActionTest action : testActions) {
                boolean bAlreadyQueriedForTasks = false;
                Class testClass = TestTaskManager.getTestClass(action);
                if (testClass == null) {
                    String refID = action.getRefID();
                    action = DataManager.getInstance().findTestAction(refID);
                    if (action == null) {
                        if (!CnfgLog.isDebugEnabled()) continue;
                        CnfgLog.debug("Could not locate test action with refid " + refID);
                        continue;
                    }
                    testClass = TestTaskManager.getTestClass(action);
                    if (testClass == null) {
                        if (!CnfgLog.isDebugEnabled()) continue;
                        CnfgLog.debug("Could not load test class for action with refid " + action.getRefID());
                        continue;
                    }
                }
                if (!m_bIgnoreCheckingSaveConfig && action.isSavedCryptoRequired() && action.matchSavedCryptoRequiredBy(selectedParamFolderName) && TestTaskManager.askAndSaveConfig(cclconfig)) {
                    cclconfig = DataManager.validateConfiguration(taskCollector, obj, bValidateConfig);
                }
                if (bStartAction && !TestTaskManager.checkActionPrerequisites(action)) continue;
                ICnfgTest testInstance = (ICnfgTest)initializedClasses.get(testClass.getName());
                if (null == testInstance) {
                    try {
                        testInstance = (ICnfgTest)testClass.newInstance();
                    }
                    catch (Throwable t) {
                        CnfgLog.error("An error was encountered when attempting to instantiate the test module for the '" + action.getProvider() + "'. Exception : " + t.getLocalizedMessage());
                        continue;
                    }
                    boolean initResult = false;
                    try {
                        initResult = testInstance.initialize(cclconfig, feedback);
                    }
                    catch (Throwable t) {
                        CnfgLog.error("An error was encountered when attempting to initialize the test module for the '" + action.getProvider() + "'. Exception : " + t.getLocalizedMessage());
                        continue;
                    }
                    if (!initResult) continue;
                    initializedClasses.put(testClass.getName(), testInstance);
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("collectTestTasks - initialize test class : '" + testClass.getName() + "' succeed.");
                    }
                } else {
                    bAlreadyQueriedForTasks = true;
                }
                if (bAlreadyQueriedForTasks) continue;
                ICnfgTask[] tasks = testInstance.getTasks(selectedParamFolderName, feedback);
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("collectTestTasks - get '" + (tasks != null ? tasks.length : 0) + "' number of  test tasks succeed.");
                }
                if (tasks == null) continue;
                for (int i = 0; i < tasks.length; ++i) {
                    CnfgTask t = new CnfgTask(tasks[i]);
                    t.setMandatory(false);
                    taskList.add(t);
                }
            }
        }
        return initializedClasses;
    }

    public static List<CnfgActionTest> getTestActions(Object obj) {
        List<CnfgActionTest> testActions = null;
        if (Parameter.class.isAssignableFrom(obj.getClass())) {
            testActions = ((Parameter)obj).getTestActions();
        } else if (Folder.class.isAssignableFrom(obj.getClass())) {
            testActions = ((Folder)obj).getTestActions();
        }
        return testActions;
    }

    public static boolean askAndSaveConfig(ICCLConfiguration cclconfig) {
        if (DataManager.getInstance().getCryptoDirtyFlag() || ConfigComparator.isCryptoSectionIsDirty(cclconfig)) {
            Object[] message = new Object[]{CnfgResource.getMessage("Message.crypto.dirty.notification"), CnfgResource.getMessage("Message.crypto.dirty.explanation")};
            CRConfigFrame frameInstance = CRConfigFrame.getInstance();
            int result = frameInstance.askToSaveOK(message);
            if (result != 2) {
                frameInstance.action_SaveAndAutoClose();
                return true;
            }
        }
        return false;
    }

    public static boolean checkActionPrerequisites(CnfgActionTest action) {
        Map<String, String> prereqServices;
        Map<String, String> prereqParams = action.getPrerequisiteParams();
        if (prereqParams != null) {
            Set<String> es = prereqParams.keySet();
            Iterator<String> esIterator = es.iterator();
            boolean prerequsiteParamSatisfied = false;
            while (esIterator.hasNext()) {
                Boolean actualValue;
                Object valueObj;
                String paramName = esIterator.next();
                String expectedValue = prereqParams.get(paramName);
                Parameter param = DataManager.getInstance().getRootFolder().findParm(paramName);
                if (param == null || !((valueObj = param.getValue()) instanceof Boolean) || (actualValue = (Boolean)valueObj).booleanValue() != Boolean.valueOf(expectedValue).booleanValue()) continue;
                prerequsiteParamSatisfied = true;
                break;
            }
            if (!prerequsiteParamSatisfied) {
                return false;
            }
        }
        if ((prereqServices = action.getPrerequisiteServices()) != null) {
            Set<String> es = prereqServices.keySet();
            Iterator<String> esIterator = es.iterator();
            boolean prerequsiteServicesSatisfied = true;
            while (esIterator.hasNext()) {
                boolean isRunning;
                String serviceName = esIterator.next();
                String expectedValue = prereqServices.get(serviceName);
                Folder service = DataManager.getInstance().getRootFolder().findFolder(serviceName, true);
                if (service == null || service.getDisabled() || !(service instanceof ServiceFolder) || (isRunning = ((ServiceFolder)service).isRunning()) == Boolean.valueOf(expectedValue)) continue;
                prerequsiteServicesSatisfied = false;
                break;
            }
            if (!prerequsiteServicesSatisfied) {
                return false;
            }
        }
        return true;
    }

    public static void terminateTestProviders(Map<?, ?> initializedClasses, ICnfgFeedback feedback) {
        for (ICnfgTest testInstance : initializedClasses.values()) {
            testInstance.terminate(feedback);
        }
    }

    public static Class getTestClass(CnfgActionTest action) {
        URL[] urls = action.getURLs();
        String className = action.getClassName();
        if (urls == null || className == null) {
            return null;
        }
        Class<?> testClass = null;
        DataManager.TestClassLoader classLoader = DataManager.getInstance().getClassLoader(urls);
        try {
            testClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            StringBuffer msg = new StringBuffer();
            msg.append("The Java class name specified for action '");
            msg.append("test");
            msg.append("' with provider '");
            msg.append(action.getProvider());
            msg.append("' could not be found in the specified locations:\n");
            URL[] clurls = classLoader.getURLs();
            for (int i = 0; i < clurls.length; ++i) {
                msg.append("\t").append(clurls[i].toString()).append("\n");
            }
            CnfgLog.error(msg.toString());
        }
        return testClass;
    }

    public static class TestActionPauseTask
    extends CnfgTask {
        CnfgActionClient m_client;
        String m_msgLabelResource = "Message.checkTestResults.label";
        String m_msgDescResource = "Message.checkTestResults.label";
        String m_msgPrmpResource = "Message.checkTestResults.prompt";

        public TestActionPauseTask(CnfgActionClient client) {
            this.m_client = client;
        }

        public TestActionPauseTask(CnfgActionClient client, String sMsgLabelRs, String sMsgDescRs, String sMsgPrmpRs) {
            this.m_client = client;
            this.m_msgLabelResource = sMsgLabelRs;
            this.m_msgDescResource = sMsgDescRs;
            this.m_msgPrmpResource = sMsgPrmpRs;
        }

        @Override
        public String getLabel() {
            return CnfgResource.getMessage(this.m_msgLabelResource);
        }

        @Override
        public String getDescription() {
            return CnfgResource.getMessage(this.m_msgDescResource);
        }

        @Override
        public boolean isMandatory() {
            return true;
        }

        public void continueTask() {
        }

        @Override
        public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
            if (this.m_client.getNumberOfFailedTasks() > 0) {
                String sPromptSpec = "<prompt><default>0</default><confirmation>" + CnfgResource.getMessage(this.m_msgPrmpResource) + "</confirmation><type>information</type><dialogType>ok</dialogType></prompt>";
                feedback.prompt(sPromptSpec);
                this.m_client.setEnginePaused(true);
            } else {
                TestTaskManager.setTestPerformed(true);
            }
            return true;
        }
    }
}

