/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.test;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.crconfig.data.CnfgActionInstallEAR;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.ExternalProcess;
import com.cognos.crconfig.websphere.WebSphereAdmin;
import com.ibm.cognos.conformance.CNFMCheckResult;
import com.ibm.cognos.conformance.CNFMConfiguration;
import com.ibm.cognos.conformance.CNFMWASChecking;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.dom4j.Element;

public class WASTest
implements ICnfgTest {
    private ICCLConfiguration m_cfgapi = null;

    public boolean initialize(ICCLConfiguration cfgapi, ICnfgFeedback feedback) {
        this.m_cfgapi = cfgapi;
        return true;
    }

    public ICnfgTask[] getTasks(String parameter, ICnfgFeedback feedback) {
        String sWASPathValue = null;
        String sWASServerProfileValue = null;
        String sWASServerInstanceValue = null;
        String sDispatcherUri = null;
        String sDispatcherPath = null;
        if (this.m_cfgapi != null) {
            int indDisp;
            Element instanceElement;
            Element instancesElement;
            Element cbsElement = null;
            try {
                cbsElement = this.m_cfgapi.getValueElement("CBS", true);
                sDispatcherUri = this.m_cfgapi.getValue("internalDispatcher", false);
            }
            catch (CCLConfigurationException e) {
                CnfgLog.error(e);
                return new ICnfgTask[0];
            }
            if (cbsElement != null && (instancesElement = cbsElement.element("instances")) != null && (instanceElement = instancesElement.element("instance")) != null) {
                List parameterList = instanceElement.elements("parameter");
                for (Element parameterElement : parameterList) {
                    Element valueElement;
                    String sWASAttribute = parameterElement.attributeValue("name");
                    if (sWASAttribute != null && sWASAttribute.compareTo("WAS_path") == 0) {
                        valueElement = parameterElement.element("value");
                        sWASPathValue = valueElement.getTextTrim();
                    }
                    if (sWASAttribute != null && sWASAttribute.compareTo("WAS_serverProfile") == 0) {
                        valueElement = parameterElement.element("value");
                        sWASServerProfileValue = valueElement.getTextTrim();
                    }
                    if (sWASAttribute == null || sWASAttribute.compareTo("WAS_serverInstance") != 0) continue;
                    valueElement = parameterElement.element("value");
                    sWASServerInstanceValue = valueElement.getTextTrim();
                }
            }
            if ((indDisp = sDispatcherUri.indexOf("dispatch")) >= 0) {
                sDispatcherPath = sDispatcherUri.substring(0, indDisp) + "gc";
            }
        }
        return this.getTasksHelper(sWASPathValue, sWASServerProfileValue, sWASServerInstanceValue, sDispatcherPath);
    }

    private ICnfgTask[] getTasksHelper(String sWASPathValue, String sWASServerProfileValue, String sWASServerInstanceValue, String sDispatcherPath) {
        int arraySize = 6;
        boolean cnfmDisabled = CNFMConfiguration.getInstance().getCNFMCheckingDisabled();
        if (cnfmDisabled) {
            arraySize = 5;
        }
        ICnfgTask[] tasks = new ICnfgTask[arraySize];
        if (!cnfmDisabled) {
            tasks[0] = this.getWASVersionTestTask(sWASPathValue);
        }
        tasks[arraySize - 5] = this.getWASPathTestTask(sWASPathValue);
        tasks[arraySize - 4] = this.getWASProfileTestTask(sWASPathValue, sWASServerProfileValue);
        tasks[arraySize - 3] = this.getWASServerTestTask(sWASPathValue, sWASServerProfileValue, sWASServerInstanceValue);
        tasks[arraySize - 2] = this.getJVMTest(sWASPathValue, sWASServerProfileValue, sWASServerInstanceValue);
        tasks[arraySize - 1] = this.getCognosInstallInfo(sWASPathValue, sWASServerProfileValue, sWASServerInstanceValue, sDispatcherPath);
        return tasks;
    }

    private ICnfgTask getJVMTest(String sWASPathValue, String sWASProfileValue, String sWASServerValue) {
        final String fsWASPathValue = sWASPathValue;
        final String fsWASProfileValue = sWASProfileValue;
        final String fsWASServerValue = sWASServerValue;
        CnfgTask task = new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.test.jvm");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.test.jvm");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                boolean ableToTestJVM = false;
                WebSphereAdmin wasAdmin = new WebSphereAdmin(fsWASPathValue);
                String[] pArgs = wasAdmin.getServerInfo(fsWASProfileValue, fsWASServerValue);
                ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                int retValue = p.executeExternalProcess();
                if (retValue == 0) {
                    String sNodeName;
                    int endIdx;
                    String sRetValue = p.getErrorMsg();
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(p.toString() + " returned " + sRetValue);
                    }
                    String NODE_NAME_PREFIX = "{node ";
                    int idx = sRetValue.indexOf("{node ");
                    if (idx != -1 && (endIdx = sRetValue.indexOf("}", idx)) != -1 && (retValue = (p = new ExternalProcess((pArgs = wasAdmin.getJavaHome(fsWASProfileValue, sNodeName = sRetValue.substring(idx + "{node ".length(), endIdx).trim(), fsWASServerValue))[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries())).executeExternalProcess()) == 0) {
                        int javaHomeIdx;
                        sRetValue = p.getErrorMsg();
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug(p.toString() + " returned " + sRetValue);
                        }
                        if ((javaHomeIdx = sRetValue.indexOf("JavaHome:")) == -1) {
                            feedback.showError(CnfgResource.getMessage("Message.was.test.jvm.error.unableToTest"));
                            return false;
                        }
                        String sJavaHome = sRetValue.substring(javaHomeIdx + "JavaHome:".length()).trim();
                        String wasServerJavaHomeResolved = CCLConfigurationFactory.getInstance().resolveEffectivePath(sJavaHome);
                        String configToolJavaHome = DataManager.getCurrentJavaHome();
                        if (!configToolJavaHome.startsWith(wasServerJavaHomeResolved)) {
                            Object[] msgArgs = new String[]{wasServerJavaHomeResolved};
                            feedback.showError(CnfgResource.getMessage("Message.was.test.jvm.error.mismatch", msgArgs));
                            feedback.showError(CnfgResource.getMessage("Message.was.test.jvm.error.mismatch.resolution"));
                            return false;
                        }
                        Object[] msgArgs = new String[]{wasServerJavaHomeResolved};
                        feedback.showInformational(CnfgResource.getMessage("Message.was.test.jvm.success", msgArgs));
                        ableToTestJVM = true;
                    }
                }
                if (!ableToTestJVM) {
                    feedback.showError(CnfgResource.getMessage("Message.was.test.jvm.error.unableToTest"));
                }
                return true;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        };
        return task;
    }

    private ICnfgTask getCognosInstallInfo(String sWASPathValue, String sWASServerProfileValue, String sWASServerInstanceValue, String dispatcherURI) {
        final String fsWASPathValue = sWASPathValue;
        final String fsWASServerProfileValue = sWASServerProfileValue;
        final String fDispatcherPath = dispatcherURI;
        final String fsWASServerInstanceValue = sWASServerInstanceValue;
        CnfgTask task = new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.test.app.detail");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.test.app.detail");
            }

            @Override
            public boolean isMandatory() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                boolean bRetValue;
                block12: {
                    bRetValue = true;
                    WebSphereAdmin wasAdmin = new WebSphereAdmin(fsWASPathValue);
                    String[] pArgs = wasAdmin.isAppInstalled(fsWASServerProfileValue, "IBM Cognos");
                    ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                    p.executeExternalProcess();
                    String output = p.getErrorMsg();
                    if (output.indexOf("IBM Cognos") == -1) {
                        feedback.showError(CnfgResource.getMessage("Message.was.test.app.error.notinst"));
                        return false;
                    }
                    feedback.showInformational(CnfgResource.getMessage("Message.was.test.app.isinst"));
                    pArgs = wasAdmin.getMaxMemoryForCognos(fsWASServerProfileValue, fsWASServerInstanceValue);
                    p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                    p.executeExternalProcess();
                    output = p.getErrorMsg();
                    String MEM_VALUE_TAG = "Maximum Java heap size:";
                    int idx = output.indexOf("Maximum Java heap size:");
                    if (idx != -1) {
                        String sValue = output.substring(idx + "Maximum Java heap size:".length()).trim();
                        Object[] msgArgs2 = new Object[]{sValue};
                        feedback.showInformational(CnfgResource.getMessage("Message.was.install.info2", msgArgs2));
                    }
                    String variableName = CnfgActionInstallEAR.getLibPathEnvVarName();
                    String pathToCogInstall = DataManager.getPathToBinDir();
                    pArgs = wasAdmin.checkEnvForCognos(fsWASServerProfileValue, fsWASServerInstanceValue, variableName, pathToCogInstall);
                    p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                    p.executeExternalProcess();
                    output = p.getErrorMsg();
                    idx = output.indexOf("The environment is set correctly.");
                    if (idx == -1) {
                        Object[] msgArgs1 = new Object[]{variableName};
                        feedback.showError(CnfgResource.getMessage("Message.was.test.app.error.var", msgArgs1));
                        return false;
                    }
                    Object[] msgArgs1 = new Object[]{variableName, pathToCogInstall};
                    feedback.showInformational(CnfgResource.getMessage("Message.was.install.info1", msgArgs1));
                    feedback.showInformational(CnfgResource.getMessage("Message.was.test.app.varcorrect"));
                    if (fDispatcherPath != null) {
                        URL url = new URL(fDispatcherPath);
                        HttpClient client = DataManager.getInstance().getHttpClient(url);
                        GetMethod method = new GetMethod(url.getFile());
                        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
                        try {
                            int statusCode = client.executeMethod((HttpMethod)method);
                            if (statusCode != 200) {
                                Object[] msgArgs12 = new Object[]{method.getStatusLine()};
                                feedback.showError(CnfgResource.getMessage("Message.was.test.app.error.connect", msgArgs12));
                                boolean bl = false;
                                return bl;
                            }
                            break block12;
                        }
                        catch (HttpException e) {
                            Object[] msgArgs13 = new Object[]{e.getMessage()};
                            feedback.showError(CnfgResource.getMessage("Message.was.test.app.error.connect", msgArgs13));
                            boolean bl = false;
                            return bl;
                        }
                        catch (IOException e) {
                            Object[] msgArgs14 = new Object[]{e.getMessage()};
                            feedback.showError(CnfgResource.getMessage("Message.was.test.app.error.connect", msgArgs14));
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            method.releaseConnection();
                        }
                    }
                    String parameterLabel = DataManager.getInstance().findParm("internalDispatcher").getLabel();
                    Object[] msgArgs15 = new Object[]{parameterLabel};
                    feedback.showError(CnfgResource.getMessage("Message.was.test.app.error.dispuri", msgArgs15));
                    return false;
                }
                feedback.showInformational(CnfgResource.getMessage("Message.was.test.app.success"));
                return bRetValue;
            }
        };
        return task;
    }

    private CnfgTask getWASPathTestTask(String sWASPathValue) {
        final String fsWASPathValue = sWASPathValue;
        CnfgTask task = new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.test.path");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.test.path");
            }

            @Override
            public boolean isMandatory() {
                return true;
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                WebSphereAdmin wasAdmin = new WebSphereAdmin(fsWASPathValue);
                if (!wasAdmin.isValid()) {
                    feedback.showError(CnfgResource.getMessage("Message.was.test.path.error"));
                    return false;
                }
                return true;
            }
        };
        return task;
    }

    private CnfgTask getWASProfileTestTask(String sWASPathValue, String sWASServerProfileValue) {
        final String fsWASPathValue = sWASPathValue;
        final String fsWASServerProfileValue = sWASServerProfileValue;
        CnfgTask task = new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.test.profile");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.test.profile");
            }

            @Override
            public boolean isMandatory() {
                return true;
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                String sExceptionMsg;
                StringBuffer aboutThisProfile;
                block13: {
                    if (fsWASServerProfileValue == null || fsWASServerProfileValue.length() == 0) {
                        feedback.showError(CnfgResource.getMessage("Message.was.test.profile.error.notset"));
                        return false;
                    }
                    WebSphereAdmin wasAdmin = new WebSphereAdmin(fsWASPathValue);
                    String[] pArgs = wasAdmin.listProfiles();
                    ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                    p.executeExternalProcess();
                    String output = p.getErrorMsg();
                    int indOpBr = output.indexOf("[");
                    if (indOpBr < 0) {
                        feedback.showError(CnfgResource.getMessage("Message.was.test.profile.error.retrieve"));
                        feedback.showError(output);
                        return false;
                    }
                    int indClBr = output.indexOf("]", indOpBr + 1);
                    if (indClBr < 0) {
                        feedback.showError(CnfgResource.getMessage("Message.was.test.profile.error.retrieve"));
                        feedback.showError(output);
                        return false;
                    }
                    String[] profiles = output.substring(indOpBr + 1, indClBr).split(",");
                    boolean profileExists = false;
                    for (int i = 0; i < profiles.length; ++i) {
                        String profile = profiles[i].trim();
                        if (!profile.equals(fsWASServerProfileValue)) continue;
                        profileExists = true;
                        break;
                    }
                    if (!profileExists) {
                        Object[] msgArgs = new Object[]{fsWASServerProfileValue};
                        feedback.showError(CnfgResource.getMessage("Message.was.test.profile.prompt.text", msgArgs));
                        return false;
                    }
                    pArgs = wasAdmin.getProfilePath(fsWASServerProfileValue);
                    p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                    int retValue = p.executeExternalProcess();
                    aboutThisProfile = new StringBuffer();
                    File aboutThisProfileFile = new File(p.getErrorMsg().trim() + "/logs/AboutThisProfile.txt");
                    Object[] msgArgs = new Object[]{aboutThisProfileFile.getCanonicalPath()};
                    feedback.showInformational(CnfgResource.getMessage("Message.was.test.profile.details", msgArgs));
                    sExceptionMsg = "";
                    if (retValue == 0) {
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(aboutThisProfileFile)));
                            String sLine = reader.readLine();
                            while (sLine != null) {
                                aboutThisProfile.append(sLine).append("\n");
                                sLine = reader.readLine();
                            }
                            reader.close();
                        }
                        catch (FileNotFoundException e) {
                            sExceptionMsg = e.getLocalizedMessage();
                            if (CnfgLog.isDebugEnabled()) {
                                CnfgLog.debug(e);
                            }
                        }
                        catch (IOException e) {
                            sExceptionMsg = e.getLocalizedMessage();
                            if (!CnfgLog.isDebugEnabled()) break block13;
                            CnfgLog.debug(e);
                        }
                    }
                }
                if (aboutThisProfile.length() > 0) {
                    feedback.showInformational(aboutThisProfile.toString());
                } else {
                    feedback.showInformational(CnfgResource.getMessage("Message.was.test.profile.details.error"));
                    feedback.showInformational(sExceptionMsg);
                }
                return true;
            }
        };
        return task;
    }

    private CnfgTask getWASServerTestTask(String sWASPathValue, String sWASServerProfileValue, String sWASServerInstanceValue) {
        final String fsWASPathValue = sWASPathValue;
        final String fsWASServerProfileValue = sWASServerProfileValue;
        final String fsWASServerInstanceValue = sWASServerInstanceValue;
        CnfgTask task = new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.test.server");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.test.server");
            }

            @Override
            public boolean isMandatory() {
                return true;
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                if (fsWASServerInstanceValue == null || fsWASServerInstanceValue.length() == 0) {
                    feedback.showError(CnfgResource.getMessage("Message.was.test.server.error.notset"));
                    return false;
                }
                WebSphereAdmin wasAdmin = new WebSphereAdmin(fsWASPathValue);
                String[] pArgs = wasAdmin.getServer(fsWASServerInstanceValue, fsWASServerProfileValue);
                ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                p.executeExternalProcess();
                String output = p.getErrorMsg();
                int indServName = output.indexOf(fsWASServerInstanceValue);
                if (indServName == -1) {
                    Object[] msgArgs = new Object[]{fsWASServerInstanceValue};
                    feedback.showError(CnfgResource.getMessage("Message.was.test.server.error.invalid", msgArgs));
                    return false;
                }
                return true;
            }
        };
        return task;
    }

    private CnfgTask getWASVersionTestTask(String sWASPathValue) {
        final String fsWASPathValue = sWASPathValue;
        CnfgTask task = new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.test.server.version");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.test.server.version");
            }

            @Override
            public boolean isMandatory() {
                return false;
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                boolean result = false;
                try {
                    WebSphereAdmin wasAdmin = new WebSphereAdmin(fsWASPathValue);
                    String[] pArgs = wasAdmin.getVersionInfo();
                    ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                    p.executeExternalProcess();
                    String output = p.getErrorMsg();
                    CNFMWASChecking wasChecking = new CNFMWASChecking();
                    wasChecking.setVersionInfo(output);
                    CNFMCheckResult checkResult = wasChecking.validate();
                    if (checkResult != null) {
                        result = checkResult.isCheckingOk();
                        if (result) {
                            feedback.showInformational(checkResult.buildOutput());
                        } else {
                            feedback.showWarning(checkResult.buildOutput());
                        }
                    } else {
                        feedback.showWarning(CnfgResource.getMessage("Message.was.test.server.version.error"));
                        result = false;
                    }
                }
                catch (Exception e) {
                    Object[] msgArgs1 = new Object[]{e.getMessage()};
                    feedback.showError(CnfgResource.getMessage("Message.was.test.server.version.error", msgArgs1));
                    result = false;
                }
                return result;
            }
        };
        return task;
    }

    public void terminate(ICnfgFeedback feedback) {
    }
}

