/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.websphere;

import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.websphere.WebSphereAdminScript;
import com.cognos.crconfig.websphere.WebSphereProfileScript;
import com.cognos.crconfig.websphere.WebSphereScript;
import com.cognos.crconfig.websphere.WebSphereVersionInfoScript;

public class WebSphereAdmin {
    private WebSphereAdminScript adminScript;
    private WebSphereProfileScript profileScript;
    private WebSphereVersionInfoScript versionInfoScript;
    public static final String INSTCONFSUCCESS = "INSTCONFSUCCESS";
    public static final String INSTCONFPARTIALSUCCESS = "INSTCONFPARTIALSUCCESS";
    public static final String JAVA_HOME_PREFIX = "JavaHome:";
    private Integer m_waitInterval;
    private Integer m_maxTries;

    public WebSphereAdmin(String installPath) {
        this.adminScript = new WebSphereAdminScript(installPath);
        this.profileScript = new WebSphereProfileScript(installPath);
        this.versionInfoScript = new WebSphereVersionInfoScript(installPath);
        this.initialize();
    }

    public WebSphereAdmin(WebSphereAdminScript adminScript, WebSphereProfileScript profileScript) {
        this.adminScript = adminScript;
        this.profileScript = profileScript;
        this.initialize();
    }

    private void initialize() {
        this.m_waitInterval = (Integer)CnfgPreferences.getInstance().getProperty("ExternalProcessWaitInterval.WAS", "1000", Integer.class);
        this.m_maxTries = (Integer)CnfgPreferences.getInstance().getProperty("ExternalProcessMaxTries.WAS", "7200", Integer.class);
    }

    public boolean isValid() {
        return this.adminScript.isValid() && this.profileScript.isValid();
    }

    public String[] listProfiles() {
        return this.profileScript.listProfiles();
    }

    public String[] createProfile(String profile) {
        return this.profileScript.createProfile(profile);
    }

    public String[] getServer(String serverName, String profile) {
        return this.adminScript.getServer(serverName, profile);
    }

    public String[] getServers(String profile) {
        return this.adminScript.getServers(profile);
    }

    public String[] isAppInstalled(String profile, String appName) {
        return this.adminScript.isAppInstalled(profile, appName);
    }

    public String[] install(String profile, String server, String appName, String earPath, String warFileName, boolean uninstallFirst) {
        return this.adminScript.install(profile, server, appName, earPath, warFileName, uninstallFirst);
    }

    WebSphereScript getAdminScript() {
        return this.adminScript;
    }

    WebSphereProfileScript getProfileScript() {
        return this.profileScript;
    }

    public String[] updateEnvForCognos(String profile, String server, String libPathName, String libPathValue, int maxMemoryValue) {
        return this.adminScript.updateEnvForCognos(profile, server, libPathName, libPathValue, maxMemoryValue);
    }

    public String[] getProfilePath(String profile) {
        return this.profileScript.getProfilePath(profile);
    }

    public String[] checkEnvForCognos(String profile, String server, String variableName, String pathToCogInstall) {
        return this.adminScript.checkEnvForCognos(profile, server, variableName, pathToCogInstall);
    }

    public String[] getMaxMemoryForCognos(String profile, String server) {
        return this.adminScript.getMaxMemoryValue(profile, server);
    }

    public String[] uninstall(String profile, String appName) {
        return this.adminScript.uninstall(profile, appName);
    }

    public String[] getContextRoot(String profile, String appName) {
        return this.adminScript.getContextRoot(profile, appName);
    }

    public String[] getServerInfo(String profile, String server) {
        return this.adminScript.getServerInfo(profile, server);
    }

    public String[] getJavaHome(String profile, String node, String server) {
        return this.adminScript.getJavaHome(profile, node, server);
    }

    public Integer getWaitInterval() {
        return this.m_waitInterval;
    }

    public Integer getMaxTries() {
        return this.m_maxTries;
    }

    public String[] getVersionInfo() {
        return this.versionInfoScript.getVersionInfo();
    }
}

