/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.websphere;

import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.websphere.WebSphereScript;
import java.io.File;

public class WebSphereAdminScript
extends WebSphereScript {
    private static final String SCRIPT_NAME_UNIX = "wsadmin.sh";
    private static final String SCRIPT_NAME_WIN = "wsadmin.bat";

    public WebSphereAdminScript(String path) {
        if (path == null) {
            return;
        }
        this.path = path;
        this.scriptPath = path + "/bin/" + this.getScriptName();
    }

    @Override
    protected String getScriptName() {
        return CnfgUtils.isWindowsPlatform() ? SCRIPT_NAME_WIN : SCRIPT_NAME_UNIX;
    }

    private String getCmdEscape() {
        String empty = "";
        String escChar = "\\";
        return CnfgUtils.isWindowsPlatform() ? "\\" : "";
    }

    String[] getServer(String serverName, String profile) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-c", "$AdminConfig getid /Cell:/Node:/Server:" + serverName, "-connType", "NONE", "-profileName", profile};
        }
        return args;
    }

    String[] getServers(String profile) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-c", "$AdminConfig list Server", "-connType", "NONE", "-profileName", profile};
        }
        return args;
    }

    public String[] isAppInstalled(String profile, String appName) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-profileName", profile, "-c", "set name " + this.getCmdEscape() + "\"" + appName + this.getCmdEscape() + "\"; $AdminConfig getid /Deployment:$name/", "-connType", "NONE"};
        }
        return args;
    }

    public String[] install(String profile, String server, String appName, String earPath, String warFileName, boolean uninstallFirst) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-profileName", profile, "-c", uninstallFirst ? "$AdminApp install " + this.getCmdEscape() + "\"" + earPath + this.getCmdEscape() + "\" {-update -appname " + this.getCmdEscape() + "\"" + appName + this.getCmdEscape() + "\" -server " + server + "}; $AdminConfig save" : "$AdminApp install " + this.getCmdEscape() + "\"" + earPath + this.getCmdEscape() + "\" {-server " + server + " -MapWebModToVH {{" + this.getCmdEscape() + "\"" + appName + this.getCmdEscape() + "\" " + warFileName + ",WEB-INF/web.xml default_host }}}; $AdminConfig save", "-connType", "NONE"};
        }
        return args;
    }

    public String[] updateEnvForCognos(String profile, String server, String libPathName, String libPathValue, int maxMemoryValue) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-profileName", profile, "-c", "set propertyId [$AdminConfig getid /Server:" + server + "/JavaProcessDef:/Property:" + libPathName + "/]; " + "set scopeId [$AdminConfig getid /Server:" + server + "]; " + "if {$propertyId == " + this.getCmdEscape() + "\"" + this.getCmdEscape() + "\"} { " + "$AdminConfig create Property [$AdminConfig list JavaProcessDef $scopeId] { {name " + libPathName + "} {required false} {value " + this.getCmdEscape() + "\"" + libPathValue + this.getCmdEscape() + "\"} }; " + "} else { " + "set currentPathValue [$AdminConfig showAttribute $propertyId value]; " + "if {[string first " + this.getCmdEscape() + "\"" + libPathValue + this.getCmdEscape() + "\" $currentPathValue] == -1} { " + "set newPathValue " + this.getCmdEscape() + "\"" + libPathValue + this.getCmdEscape() + "\"; " + "append newPathValue " + this.getCmdEscape() + "\"" + File.pathSeparator + this.getCmdEscape() + "\" $currentPathValue; " + "$AdminConfig modify $propertyId [list [list value $newPathValue]]; " + "}; " + "}; " + "$AdminConfig modify [$AdminConfig list JavaVirtualMachine $scopeId] {{maximumHeapSize " + maxMemoryValue + "}}; " + "puts " + this.getCmdEscape() + "\"Status Success" + this.getCmdEscape() + "\"; ", "-connType", "NONE"};
        }
        return args;
    }

    public String[] checkEnvForCognos(String profile, String server, String variableName, String pathToCogInstall) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-profileName", profile, "-c", "set propertyId [$AdminConfig getid /Server:" + server + "/JavaProcessDef:/Property:" + variableName + "/]; " + "if {$propertyId != " + this.getCmdEscape() + "\"" + this.getCmdEscape() + "\"} { " + "set currentPathValue [$AdminConfig showAttribute $propertyId value]; " + "if {[string first " + this.getCmdEscape() + "\"" + pathToCogInstall + this.getCmdEscape() + "\" $currentPathValue] != -1} { " + "puts " + this.getCmdEscape() + "\"The environment is set correctly." + this.getCmdEscape() + "\"; " + "}; " + "}; ", "-connType", "NONE"};
        }
        return args;
    }

    public String[] getMaxMemoryValue(String profile, String server) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-profileName", profile, "-c", "set maxMem [$AdminConfig showAttribute [set scopeId [$AdminConfig getid /Server:" + server + "]; $AdminConfig list JavaVirtualMachine $scopeId] maximumHeapSize]; " + "puts " + this.getCmdEscape() + "\"Maximum Java heap size:$maxMem" + this.getCmdEscape() + "\";", "-connType", "NONE"};
        }
        return args;
    }

    public String[] uninstall(String profile, String appName) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-profileName", profile, "-c", "$AdminApp uninstall " + this.getCmdEscape() + "\"" + appName + this.getCmdEscape() + "\"; $AdminConfig save", "-connType", "NONE"};
        }
        return args;
    }

    public String[] getContextRoot(String profile, String appName) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-profileName", profile, "-c", "$AdminApp view " + this.getCmdEscape() + "\"" + appName + this.getCmdEscape() + "\"", "-connType", "NONE"};
        }
        return args;
    }

    public String[] getServerInfo(String profile, String server) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-profileName", profile, "-c", "set s1 [$AdminConfig getid /Server:" + server + "]; $AdminTask showServerInfo $s1", "-connType", "NONE"};
        }
        return args;
    }

    public String[] getJavaHome(String profile, String node, String server) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-profileName", profile, "-c", "set jvmHome [$AdminTask getJavaHome {-serverName " + server + " -nodeName " + node + "}]; " + "puts " + this.getCmdEscape() + "\"JavaHome:$jvmHome" + this.getCmdEscape() + "\";", "-connType", "NONE"};
        }
        return args;
    }
}

