/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.websphere;

import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.websphere.WebSphereScript;
import java.io.File;

public class WebSphereProfileScript
extends WebSphereScript {
    private static final String SCRIPT_NAME_UNIX = "manageprofiles.sh";
    private static final String SCRIPT_NAME_WIN = "manageprofiles.bat";

    public WebSphereProfileScript(String path) {
        if (path == null) {
            return;
        }
        this.path = path;
        this.scriptPath = path + "/bin/" + this.getScriptName();
    }

    @Override
    protected String getScriptName() {
        return CnfgUtils.isWindowsPlatform() ? SCRIPT_NAME_WIN : SCRIPT_NAME_UNIX;
    }

    public String[] listProfiles() {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-listProfiles"};
        }
        return args;
    }

    public String[] createProfile(String profile) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-create", "-templatePath", this.getWasPath() + File.separator + "profileTemplates" + File.separator + "default", "-profileName", profile};
        }
        return args;
    }

    public String[] getProfilePath(String profile) {
        String[] args = new String[]{""};
        if (this.isValid()) {
            args = new String[]{this.getScriptPath(), "-getPath", "-profileName", profile};
        }
        return args;
    }
}

