/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.conformance;

import com.ibm.cognos.conformance.CNFMCheckResult;
import com.ibm.cognos.conformance.CNFMChecking;
import com.ibm.cognos.conformance.CNFMItemInfo;
import com.ibm.cognos.conformance.os.IOSCheck;
import com.ibm.cognos.conformance.os.OSCheckImplAIX;
import com.ibm.cognos.conformance.os.OSCheckImplLinux;
import com.ibm.cognos.conformance.os.OSCheckImplWin;
import java.util.ArrayList;

public class CNFMOSChecking
extends CNFMChecking {
    protected String sysprop_osname;
    protected IOSCheck osCheck = null;
    private final String typeUnchecked = "unChecked type";

    public String getCategory() {
        return "os";
    }

    public CNFMItemInfo getVersionInfo() {
        CNFMItemInfo itemInfo = new CNFMItemInfo();
        this.sysprop_osname = this.getOSNameFromSysProp().toLowerCase();
        this.osCheck = this.getOSCheckInstance(this.sysprop_osname);
        if (this.osCheck != null) {
            itemInfo = this.osCheck.getVersionInfo();
        } else {
            itemInfo = new CNFMItemInfo();
            itemInfo.setType("unChecked type");
        }
        return itemInfo;
    }

    protected IOSCheck getOSCheckInstance(String osName) {
        if (osName.contains("windows")) {
            this.osCheck = new OSCheckImplWin();
        } else if (osName.contains("aix")) {
            this.osCheck = new OSCheckImplAIX();
        } else if (osName.contains("linux")) {
            this.osCheck = new OSCheckImplLinux();
        }
        return this.osCheck;
    }

    protected String getOSNameFromSysProp() {
        return System.getProperty("os.name");
    }

    public CNFMCheckResult validate(CNFMItemInfo curItemObj, ArrayList<CNFMItemInfo> confList) {
        if (curItemObj == null || confList == null || confList.size() <= 0) {
            throw new IllegalArgumentException("In CNFMOSChecking.validate(), input arguments should not be null or empty.");
        }
        CNFMCheckResult cnfmCheckRes = new CNFMCheckResult();
        if (curItemObj.getType().equals("unChecked type")) {
            cnfmCheckRes.setStatus("NotAvaliable");
        } else {
            String status = this.osCheck.getStatus(curItemObj, confList);
            cnfmCheckRes.setStatus(status);
            if (status.equals("Unknown")) {
                curItemObj.setVersionRelease(this.osCheck.getUnparsedVersionInfo());
            }
            cnfmCheckRes.setCurrentItemInfo(curItemObj);
            cnfmCheckRes.setCandidateItemList(this.osCheck.getCandidateItemList(confList, curItemObj.getVersionRelease()));
        }
        return cnfmCheckRes;
    }
}

