/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.conformance;

import com.ibm.cognos.conformance.CNFMCheckResult;
import com.ibm.cognos.conformance.CNFMItemInfo;
import com.ibm.cognos.conformance.CNFMJDBCDatabaseChecking;
import com.ibm.cognos.conformance.CNFMOSChecking;

public class CNFMTest {
    public static void main(String[] args) {
        System.out.println("This is to test conformance checking.");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-os")) {
                CNFMTest.testOSChecking();
                continue;
            }
            if (args[i].equalsIgnoreCase("-jdbc")) {
                CNFMTest.testJDBCChecking();
                continue;
            }
            CNFMTest.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: To run this test driver, you need a supported JRE, and 3 jar files from cognos install.");
        System.out.println("Copy the 3 jars, bin/cogcnfm.jar; bin/configcnfm.jar; bin/dom4j-1.6.1.jar to one directory, and change directory to it.");
        System.out.println("Under the directory, run full path of java -classpath cogcnfm.jar;configcnfm.jar;dom4j-1.6.1.jar com.ibm.cognos.conformance.CNFMTest [-options], For example, on Windows:");
        System.out.println("\"C:\\Program Files (x86)\\IBM\\cognos\\10.1.7007.5_win32\\bin\\jre\\6.0\\bin\"\\java -classpath cogcnfm.jar;configcnfm.jar;dom4j-1.6.1.jar com.ibm.cognos.conformance.CNFMTest");
        System.out.println("\r\n");
        System.out.println("where options include:");
        System.out.println("\t-os\tOS Conformance Check");
        System.out.println("\t-jdbc\tJDBC Conformance Check");
    }

    private static void testJDBCChecking() {
        CNFMJDBCDatabaseChecking checkJDBC = new CNFMJDBCDatabaseChecking();
        CNFMItemInfo dbver = new CNFMItemInfo();
        dbver.setType("DB2zOS");
        dbver.setVersionRelease("10");
        checkJDBC.setVersionInfo(dbver);
        String result = "";
        System.out.println(result);
    }

    private static void testOSChecking() {
        CNFMOSChecking osCheck = new CNFMOSChecking();
        CNFMCheckResult result = osCheck.validate("BI", "10.1.1");
        CNFMTest.verifyResult(result);
    }

    private static void verifyResult(CNFMCheckResult result) {
        CNFMItemInfo item = result.getCurrentItemInfo();
        System.out.println("Printing current info...");
        System.out.println("category\tosType\t\trelease\t\tpatchLevel\tedition");
        System.out.println(item.getCategoryName() + "\t\t" + item.getType() + "\t\t" + item.getVersionRelease() + "\t\t" + item.getVersionPatchLevel() + "\t\t" + item.getCurrentEdition());
        System.out.println("\n********Check result********");
        System.out.println(result.getStatus());
    }
}

