/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.conformance;

import com.ibm.cognos.conformance.CNFMApplicationServerChecking;
import com.ibm.cognos.conformance.CNFMCheckResult;
import com.ibm.cognos.conformance.CNFMItemInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CNFMWASChecking
extends CNFMApplicationServerChecking {
    private String WAS_APP_SVR_NAME = "IBM WebSphere Application Server";
    private String WAS_TYPE = "WAS";
    private String WAS_INSTALLED_PRODUCT = "Installed Product";
    private String WAS_LINE_SEP = "-----";
    private String WAS_ATTR_NAME = "Name";
    private String WAS_ATTR_VERSION = "Version";

    @Override
    public CNFMCheckResult validate(CNFMItemInfo curItemObj, ArrayList<CNFMItemInfo> confList) {
        ArrayList<CNFMItemInfo> candidateList = new ArrayList<CNFMItemInfo>();
        CNFMCheckResult result = null;
        CNFMItemInfo floorItem = null;
        CNFMItemInfo ceilingItem = null;
        if (curItemObj != null && confList != null && confList.size() > 0) {
            for (int i = 0; i < confList.size(); ++i) {
                CNFMItemInfo item = confList.get(i);
                String type = item.getType();
                if (type == null || !type.equalsIgnoreCase(curItemObj.getType())) continue;
                candidateList.add(item);
                if (item.isCeilingValue()) {
                    ceilingItem = item;
                }
                if (item.isFloorValue()) {
                    floorItem = item;
                }
                if (!this.matchConformance(curItemObj, item)) continue;
                ArrayList<CNFMItemInfo> ilist = new ArrayList<CNFMItemInfo>();
                ilist.add(item);
                result = new CNFMCheckResult(curItemObj, ilist, item.getStatus());
                String status = item.getStatus();
                if (status == null || !status.equalsIgnoreCase("Active") && !status.equalsIgnoreCase("Compatible")) continue;
                return result;
            }
            if ((ceilingItem != null || floorItem != null) && this.verifyVersionOutOfRange(curItemObj, ceilingItem, floorItem)) {
                result = new CNFMCheckResult(curItemObj, candidateList, "Not Supported");
            }
        }
        if (result != null) {
            return result;
        }
        if (confList == null || confList.size() == 0 || candidateList.size() == 0) {
            return new CNFMCheckResult(curItemObj, candidateList, "NotAvaliable");
        }
        return new CNFMCheckResult(curItemObj, candidateList, "Unknown");
    }

    private String parseVersionInfo(String versionInfo) {
        String wasVersion = "";
        BufferedReader reader = new BufferedReader(new StringReader(versionInfo));
        try {
            String sLine = reader.readLine();
            boolean bStartParse = false;
            boolean bFinishParse = false;
            while (sLine != null && !bFinishParse) {
                if (!bStartParse) {
                    if (sLine.startsWith(this.WAS_INSTALLED_PRODUCT)) {
                        bStartParse = true;
                    }
                    sLine = reader.readLine();
                    continue;
                }
                if (sLine.startsWith(this.WAS_LINE_SEP)) {
                    sLine = reader.readLine();
                    continue;
                }
                StringTokenizer tokens = new StringTokenizer(sLine, " ");
                String token = tokens.nextToken();
                if (token.equals(this.WAS_ATTR_NAME)) {
                    StringBuffer wasName = new StringBuffer();
                    while (tokens.hasMoreTokens()) {
                        wasName.append(tokens.nextToken()).append(" ");
                    }
                    if (wasName.toString().startsWith(this.WAS_APP_SVR_NAME) && (token = (tokens = new StringTokenizer(sLine = reader.readLine(), " ")).nextToken()).equals(this.WAS_ATTR_VERSION)) {
                        wasVersion = token = tokens.nextToken();
                        bFinishParse = true;
                    }
                }
                sLine = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            wasVersion = "";
        }
        return wasVersion;
    }

    public void setVersionInfo(String versionInfo) {
        CNFMItemInfo item = new CNFMItemInfo();
        String wasVersion = this.parseVersionInfo(versionInfo);
        item.setVersionRelease(wasVersion);
        item.setType(this.WAS_TYPE);
        item.setDescription(this.WAS_APP_SVR_NAME);
        this.m_AppServerVersionInfo = item;
    }

    private boolean matchConformance(CNFMItemInfo localInfo, CNFMItemInfo confInfo) {
        String localType = localInfo.getType();
        String confType = confInfo.getType();
        if (localType != null && confType != null && localType.equalsIgnoreCase(confType)) {
            String localRelease = localInfo.getVersionRelease();
            String confRelease = confInfo.getVersionRelease();
            if (localRelease != null && confRelease != null && localRelease.startsWith(confRelease)) {
                return true;
            }
        }
        return false;
    }
}

