/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.conformance.os;

import com.ibm.cognos.conformance.CNFMItemInfo;
import com.ibm.cognos.conformance.os.IOSCheck;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OSCheckImplLinux
implements IOSCheck {
    private final String DIST_ID = "Distributor ID:";
    private final String REL = "Release:";
    private static final String ARCH = "Architecture";
    String command1 = "lsb_release -a";
    String command2 = "uname -p";

    @Override
    public CNFMItemInfo getVersionInfo() {
        CNFMItemInfo itemInfo = new CNFMItemInfo();
        itemInfo.setCategoryName("os");
        itemInfo.setType("Linux");
        this.setItemInfoFromCommand(itemInfo);
        return itemInfo;
    }

    private void setItemInfoFromCommand(CNFMItemInfo itemInfo) {
        Map<String, String> lines = this.getInfoFromCommand(this.command1, ":");
        itemInfo.setCurrentEdition(lines.get("Distributor ID:"));
        itemInfo.setVersionRelease(lines.get("Release:"));
        lines = this.getInfoFromCommand(this.command2, null);
        itemInfo.setCurrentArch(lines.get(ARCH));
    }

    @Override
    public String getStatus(CNFMItemInfo curItemObj, ArrayList<CNFMItemInfo> confList) {
        String status = "Unknown";
        ArrayList<CNFMItemInfo> sameReleaseItems = this.getCandidateItemList(confList);
        for (CNFMItemInfo item : sameReleaseItems) {
            boolean match = this.findMatchItem(curItemObj, item);
            if (!match) continue;
            status = item.getStatus();
            break;
        }
        return status;
    }

    private boolean findMatchItem(CNFMItemInfo curItemObj, CNFMItemInfo item) {
        boolean bMatch = this.matchRelease(curItemObj, item) && this.matchArchitecture(curItemObj, item) && this.matchEdition(curItemObj, item);
        return bMatch;
    }

    private boolean matchRelease(CNFMItemInfo curItemObj, CNFMItemInfo item) {
        return curItemObj.getVersionRelease().equalsIgnoreCase(item.getVersionRelease());
    }

    private boolean matchEdition(CNFMItemInfo curItemObj, CNFMItemInfo item) {
        ArrayList editions = item.getVersionEditions();
        return editions.size() == 0 || editions.contains(curItemObj.getCurrentEdition());
    }

    private boolean matchArchitecture(CNFMItemInfo curItemObj, CNFMItemInfo item) {
        ArrayList archs = item.getPlatforArchs();
        return archs.size() == 0 || archs.contains(curItemObj.getCurrentArch());
    }

    @Override
    public ArrayList<CNFMItemInfo> getCandidateItemList(ArrayList<CNFMItemInfo> confList, String release) {
        return this.getCandidateItemList(confList);
    }

    private ArrayList<CNFMItemInfo> getCandidateItemList(ArrayList<CNFMItemInfo> confList) {
        ArrayList<CNFMItemInfo> retList = new ArrayList<CNFMItemInfo>();
        for (CNFMItemInfo item : confList) {
            if (item.getType().equals("Linux")) {
                // empty if block
            }
            retList.add(item);
        }
        return retList;
    }

    @Override
    public String getUnparsedVersionInfo() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getInfoFromCommand(String command, String delimiter) {
        HashMap<String, String> lines = new HashMap<String, String>();
        BufferedReader in = null;
        try {
            Process proc = null;
            proc = Runtime.getRuntime().exec(command);
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                OSCheckImplLinux.collectInfoByLine(line, lines, delimiter);
            }
            proc.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return lines;
    }

    public static void collectInfoByLine(String line, HashMap<String, String> lines, String delimiter) {
        if (lines == null) {
            lines = new HashMap();
        }
        if (delimiter != null) {
            int pos = line.indexOf(delimiter);
            if (pos != -1) {
                String key = line.substring(0, pos).trim();
                String value = line.substring(pos + 1).trim();
                lines.put(key, value);
            }
        } else {
            lines.put(ARCH, line.trim());
        }
    }
}

