/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.conformance.os;

import com.ibm.cognos.conformance.CNFMItemInfo;
import com.ibm.cognos.conformance.os.IOSCheck;
import com.ibm.cognos.conformance.os.OSConstants;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

public class OSCheckImplWin
implements IOSCheck {
    private String command = "cmd /c  systeminfo";
    private String unParsedVersion = "";
    public static HashSet<String> editions = new HashSet();
    public static HashMap<String, String> releases;
    public static HashSet<String> updates;
    String DILIMETER = " ";

    @Override
    public CNFMItemInfo getVersionInfo() {
        CNFMItemInfo itemInfo = new CNFMItemInfo();
        itemInfo.setCategoryName("os");
        itemInfo.setType("Windows");
        itemInfo.setVersionPatchLevel(this.getPatchLevel());
        this.setInfoFromCommand(itemInfo);
        return itemInfo;
    }

    private void setInfoFromCommand(CNFMItemInfo itemInfo) {
        this.unParsedVersion = this.getOSNameFromCommand();
        if (this.unParsedVersion != null || this.unParsedVersion.length() > 0) {
            this.parseOSName1(this.unParsedVersion, itemInfo);
        }
    }

    private void parseOSName1(String osNameFromCommand, CNFMItemInfo itemInfo) {
        StringTokenizer toker = new StringTokenizer(osNameFromCommand, this.DILIMETER);
        boolean bFoundWindows = false;
        while (toker.hasMoreTokens()) {
            String next = toker.nextToken();
            if (bFoundWindows) {
                this.setInfo(next, itemInfo);
            }
            if (!next.toLowerCase().contains("wind")) continue;
            bFoundWindows = true;
        }
    }

    private void setInfo(String toker, CNFMItemInfo itemInfo) {
        if (editions.contains(toker)) {
            this.setCurrentEdition(toker, itemInfo);
        } else if (updates.contains(toker)) {
            this.setVersionUpdate(toker, itemInfo);
        } else if (releases.containsKey(toker)) {
            this.setVersionRelease(toker, itemInfo);
        }
    }

    private void setVersionUpdate(String toker, CNFMItemInfo itemInfo) {
        itemInfo.setVersionUpdate(toker);
    }

    private void setCurrentEdition(String toker, CNFMItemInfo itemInfo) {
        itemInfo.setCurrentEdition(toker);
    }

    private void setVersionRelease(String toker, CNFMItemInfo itemInfo) {
        itemInfo.setVersionRelease(releases.get(toker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getOSNameFromCommand() {
        String osName = null;
        BufferedReader in = null;
        try {
            Process proc = null;
            proc = Runtime.getRuntime().exec(this.command);
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("OS Name:") <= -1) continue;
                in.close();
                osName = line.substring(8).trim();
                System.out.println("Found OS Name info from command: " + osName);
                break;
            }
            proc.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return osName;
    }

    private String getPatchLevel() {
        String remainingStr;
        String servicePack;
        String patchLevel = "unknown";
        String osVersion = this.getVersionFromJava();
        int pos = osVersion.indexOf(servicePack = "Service Pack ");
        if (pos > -1 && (remainingStr = osVersion.substring(pos)).length() > servicePack.length()) {
            String patchStr = remainingStr.substring(0, servicePack.length() + 1);
            patchLevel = OSConstants.patchMap.get(patchStr);
        }
        return patchLevel;
    }

    protected String getVersionFromJava() {
        return System.getProperty("os.version");
    }

    @Override
    public String getStatus(CNFMItemInfo curItemObj, ArrayList<CNFMItemInfo> confList) {
        String status = "Unknown";
        ArrayList<CNFMItemInfo> sameReleaseItems = this.getCandidateItemList(confList, curItemObj.getVersionRelease());
        for (CNFMItemInfo item : sameReleaseItems) {
            boolean match = this.findMatchItem(curItemObj, item);
            if (!match) continue;
            status = item.getStatus();
            break;
        }
        return status;
    }

    private boolean findMatchItem(CNFMItemInfo curItemObj, CNFMItemInfo item) {
        boolean bMatch = true;
        bMatch = this.matchPatchLevel(curItemObj.getVersionPatchLevel(), item.getVersionPatchLevel()) && this.matchUpdate(curItemObj.getVersionUpdate(), item.getVersionUpdate()) && this.matchEdition(curItemObj.getCurrentEdition(), item.getVersionEditions());
        return bMatch;
    }

    private boolean matchEdition(String currentEdition, ArrayList<String> versionEditions) {
        return versionEditions.size() == 0 || versionEditions.contains(currentEdition);
    }

    private boolean matchUpdate(String curVersionUpdate, String cnfmVersionUpdate) {
        return cnfmVersionUpdate.length() == 0 || curVersionUpdate.equalsIgnoreCase(cnfmVersionUpdate);
    }

    private boolean matchPatchLevel(String curVersionPatchLevel, String cnfmVersionPatchLevel) {
        return cnfmVersionPatchLevel.length() == 0 || curVersionPatchLevel.equalsIgnoreCase(cnfmVersionPatchLevel);
    }

    @Override
    public ArrayList<CNFMItemInfo> getCandidateItemList(ArrayList<CNFMItemInfo> confList, String release) {
        ArrayList<CNFMItemInfo> retList = new ArrayList<CNFMItemInfo>();
        for (CNFMItemInfo item : confList) {
            if (!item.getType().equals("Windows") || !item.getVersionRelease().equals(release)) continue;
            retList.add(item);
        }
        return retList;
    }

    @Override
    public String getUnparsedVersionInfo() {
        return this.unParsedVersion;
    }

    static {
        editions.add("Professional");
        editions.add("Ultimate");
        editions.add("Standard");
        editions.add("Enterprise");
        editions.add("Datacenter");
        editions.add("Web");
        editions.add("HPC");
        releases = new HashMap();
        releases.put("7", "7");
        releases.put("XP", "XP");
        releases.put("Vista", "Vista");
        releases.put("2003", "Server 2003");
        releases.put("2003,", "Server 2003");
        releases.put("2008", "Server 2008");
        updates = new HashSet();
        updates.add("R2");
    }
}

