/*
 * Decompiled with CFR 0.152.
 */
package jd.io;

import java.io.CharConversionException;
import jd.io.CharToByteConverter;
import jd.io.ConversionBufferFullException;

public class CharToByteUtf8
extends CharToByteConverter {
    private char highHalfZoneCode_;

    @Override
    public int flush(byte[] byArray, int n, int n2) throws CharConversionException {
        if (this.highHalfZoneCode_ != '\u0000') {
            this.highHalfZoneCode_ = '\u0000';
            this.badInputLength_ = 0;
            throw new CharConversionException("malformed input");
        }
        this.charOff_ = 0;
        this.byteOff_ = 0;
        return 0;
    }

    @Override
    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws ConversionBufferFullException, CharConversionException {
        int n5;
        char c;
        this.charOff_ = n;
        this.byteOff_ = n3;
        if (this.highHalfZoneCode_ != '\u0000') {
            c = this.highHalfZoneCode_;
            this.highHalfZoneCode_ = '\u0000';
            if (cArray[n] >= '\udc00' && cArray[n] <= '\udfff') {
                n5 = (this.highHalfZoneCode_ - 55296) * 1024 + (cArray[n] - 56320) + 65536;
                byArray[0] = (byte)(0xF0 | n5 >> 18 & 7);
                byArray[1] = (byte)(0x80 | n5 >> 12 & 0x3F);
                byArray[2] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[3] = (byte)(0x80 | n5 & 0x3F);
                ++this.charOff_;
                this.highHalfZoneCode_ = '\u0000';
            } else {
                this.badInputLength_ = 0;
                throw new CharConversionException("malformed input");
            }
        }
        while (this.charOff_ < n2) {
            c = cArray[this.charOff_];
            if (c < '\u0080') {
                if (this.byteOff_ + 1 > n4) {
                    throw ConversionBufferFullException.INSTANCE;
                }
                byArray[this.byteOff_++] = (byte)c;
                ++this.charOff_;
                continue;
            }
            if (c < '\u0800') {
                if (this.byteOff_ + 2 > n4) {
                    throw ConversionBufferFullException.INSTANCE;
                }
                byArray[this.byteOff_++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[this.byteOff_++] = (byte)(0x80 | c & 0x3F);
                ++this.charOff_;
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (this.byteOff_ + 4 > n4) {
                    throw ConversionBufferFullException.INSTANCE;
                }
                if (this.charOff_ + 1 >= n2) {
                    this.highHalfZoneCode_ = c;
                    break;
                }
                n5 = cArray[this.charOff_ + 1];
                if (n5 < 56320 || n5 > 57343) {
                    this.badInputLength_ = 1;
                    throw new CharConversionException("malformed input");
                }
                int n6 = (c - 55296) * 1024 + (n5 - 56320) + 65536;
                byArray[this.byteOff_++] = (byte)(0xF0 | n6 >> 18 & 7);
                byArray[this.byteOff_++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                byArray[this.byteOff_++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                byArray[this.byteOff_++] = (byte)(0x80 | n6 & 0x3F);
                this.charOff_ += 2;
                continue;
            }
            if (this.byteOff_ + 3 > n4) {
                throw ConversionBufferFullException.INSTANCE;
            }
            byArray[this.byteOff_++] = (byte)(0xE0 | c >> 12 & 0xF);
            byArray[this.byteOff_++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray[this.byteOff_++] = (byte)(0x80 | c & 0x3F);
            ++this.charOff_;
        }
        return this.byteOff_ - n3;
    }

    public boolean canConvert(char c) {
        return true;
    }

    @Override
    public int getMaxBytesPerChar() {
        return 4;
    }

    @Override
    public void reset() {
        this.charOff_ = 0;
        this.byteOff_ = 0;
        this.highHalfZoneCode_ = '\u0000';
    }

    @Override
    public String getCharacterEncoding() {
        return "UTF8";
    }
}

