/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassUtil {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static Method getContextClassLoaderMethod_;

    public static Class classForName(String string) throws ClassNotFoundException {
        if (getContextClassLoaderMethod_ != null) {
            try {
                ClassLoader classLoader = (ClassLoader)getContextClassLoaderMethod_.invoke((Object)Thread.currentThread(), EMPTY_ARGS);
                return classLoader.loadClass(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Class.forName(string);
    }

    public static Object newInstance(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return ClassUtil.classForName(string).newInstance();
    }

    public static Object newInstance(Class clazz, Object object) throws InvocationTargetException, InstantiationException {
        return ClassUtil.newInstance(clazz, new Object[]{object});
    }

    public static Object newInstance(Class clazz, Object[] objectArray) throws InstantiationException, InvocationTargetException {
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (Exception exception) {
            String string = "cannot call constructor " + clazz.getName() + '(';
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + classArray[i].getName();
            }
            string = string + ')';
            throw new InstantiationException(string);
        }
    }

    public static String getClassName(Object object) {
        return ClassUtil.getClassName(object.getClass());
    }

    public static String getClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String getPackageName(Object object) {
        return ClassUtil.getPackageName(object.getClass());
    }

    public static String getPackageName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(0, n);
    }

    static {
        try {
            getContextClassLoaderMethod_ = Thread.class.getMethod("getContextClassLoader", new Class[0]);
        }
        catch (Exception exception) {
            getContextClassLoaderMethod_ = null;
        }
    }
}

