/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.util.Vector;
import jd.util.KeyList;

public class SimpleKeyList
implements KeyList {
    private String[] texts_;
    private Object[] values_;

    public SimpleKeyList() {
        this(new Object[0], new String[0]);
    }

    public SimpleKeyList(Object object, String string) {
        this(new Object[]{object}, new String[]{string});
    }

    public SimpleKeyList(Object[] objectArray, String[] stringArray) {
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException();
        }
        this.values_ = objectArray;
        this.texts_ = stringArray;
    }

    public SimpleKeyList(String[] stringArray) {
        this(stringArray, stringArray);
    }

    public SimpleKeyList(Vector vector) {
        int n = vector.size() / 2;
        this.texts_ = new String[n];
        this.values_ = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.values_[i] = vector.elementAt(n2++);
            this.texts_[i] = vector.elementAt(n2++).toString();
        }
    }

    @Override
    public final int size() {
        return this.texts_.length;
    }

    @Override
    public int indexOf(Object object) {
        int n = this.values_.length;
        for (int i = 0; i < n; ++i) {
            if (!this.values_[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getValue(int n) {
        try {
            return this.values_[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
    }

    @Override
    public String getText(int n) {
        try {
            return this.texts_[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
    }

    public String toString() {
        return "KeyList[" + this.size() + "]";
    }
}

