/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.build.normal;

import jd.xml.xpath.XPathException;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.model.build.normal.Node;
import jd.xml.xpath.model.build.normal.TreeNode;

abstract class CompositeNode
extends TreeNode {
    protected TreeNode firstChild_;
    private int childCount_;

    CompositeNode() {
    }

    boolean isComplexElement() {
        return false;
    }

    @Override
    public int getChildCount() {
        return this.childCount_;
    }

    void increaseChildCount() {
        if (++this.childCount_ == Integer.MAX_VALUE) {
            throw new IllegalStateException("max value of children reached!");
        }
    }

    @Override
    public final XPathNode getFirstChild() {
        return this.firstChild_;
    }

    @Override
    Node getFirstChildImpl() {
        return this.firstChild_;
    }

    void setFirstChild(TreeNode treeNode) {
        if (this.firstChild_ != null) {
            throw new XPathException("already has a first child");
        }
        this.firstChild_ = treeNode;
        this.childCount_ = 1;
        treeNode.parent_ = this;
    }

    public String getTextValue() {
        StringBuffer stringBuffer = new StringBuffer();
        XPathNode xPathNode = this.firstChild_;
        block0: while (xPathNode != null) {
            XPathNode xPathNode2;
            if (xPathNode.getType() == 1) {
                stringBuffer.append(xPathNode.getValue());
                xPathNode2 = null;
            } else {
                xPathNode2 = xPathNode.getFirstChild();
            }
            if (xPathNode2 != null) {
                xPathNode = xPathNode2;
                continue;
            }
            while (xPathNode2 == null) {
                xPathNode2 = xPathNode.getNextSibling();
                if (xPathNode2 != null) {
                    xPathNode = xPathNode2;
                    continue;
                }
                if ((xPathNode = xPathNode.getParent()) != this) continue;
                xPathNode = null;
                continue block0;
            }
        }
        return stringBuffer.toString();
    }

    public abstract boolean preserveSpace();

    @Override
    Node copy(CompositeNode compositeNode) {
        CompositeNode compositeNode2 = (CompositeNode)super.copy(compositeNode);
        if (this.firstChild_ != null) {
            TreeNode treeNode = compositeNode2.firstChild_ = (TreeNode)this.firstChild_.copy(compositeNode2);
            TreeNode treeNode2 = this.firstChild_.next_;
            compositeNode2.increaseChildCount();
            while (treeNode2 != null) {
                TreeNode treeNode3;
                treeNode.next_ = treeNode3 = (TreeNode)treeNode2.copy(compositeNode2);
                treeNode3.previous_ = treeNode;
                treeNode2 = treeNode2.next_;
                compositeNode2.increaseChildCount();
            }
        }
        return compositeNode2;
    }
}

