/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.build.normal;

import java.util.Hashtable;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.NodeVisitor;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xpath.model.build.normal.CompositeNode;
import jd.xml.xpath.model.build.normal.ElementNode;
import jd.xml.xpath.model.build.normal.LineNumberMap;
import jd.xml.xpath.model.build.normal.Node;
import jd.xml.xpath.model.build.normal.TreeNode;

final class RootNode
extends CompositeNode
implements XPathRootNode {
    public static final String MODEL_NAME = "normal";
    private Hashtable unparsedEntities_;
    private Hashtable idElements_;
    private String baseUri_;
    private NodeNamePool nodeNamePool_;
    private String idPrefix_;
    private int documentId_;
    private LineNumberMap lineNumberMap_;

    public RootNode(String string, NodeNamePool nodeNamePool, int n) {
        if (string == null) {
            throw new IllegalArgumentException("base uri is null");
        }
        this.baseUri_ = string;
        this.nodeNamePool_ = nodeNamePool;
        this.documentId_ = n;
        this.idPrefix_ = "d" + this.documentId_ + "n";
    }

    private RootNode(RootNode rootNode, String string, Node node) {
        this(rootNode.baseUri_ + '#' + string, rootNode.nodeNamePool_, rootNode.documentId_);
        this.lineNumberMap_ = rootNode.lineNumberMap_;
        this.firstChild_ = (TreeNode)node.copy(this);
        this.increaseChildCount();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public XPathRootNode getRoot() {
        return this;
    }

    @Override
    public String getValue() {
        return this.getTextValue();
    }

    @Override
    public XPathNode getElementForId(String string) {
        return this.idElements_ != null ? (ElementNode)this.idElements_.get(string) : null;
    }

    void setIdElement(String string, ElementNode elementNode) {
        ElementNode elementNode2;
        if (this.idElements_ == null) {
            this.idElements_ = new Hashtable(10);
        }
        if ((elementNode2 = this.idElements_.put(string, elementNode)) != null) {
            this.idElements_.put(string, elementNode2);
        }
    }

    @Override
    public String getUnparsedEntityUri(String string) {
        return this.unparsedEntities_ != null ? (String)this.unparsedEntities_.get(string) : null;
    }

    void addUnparsedEntity(String string, String string2) {
        if (this.unparsedEntities_ == null) {
            this.unparsedEntities_ = new Hashtable(3);
        }
        this.unparsedEntities_.put(string, string2);
    }

    @Override
    public int getDocumentId() {
        return this.documentId_;
    }

    public String getGlobalId(int n) {
        int n2 = this.idPrefix_.length();
        int n3 = n2 + 11;
        char[] cArray = new char[n3];
        int n4 = n;
        int n5 = n3;
        do {
            cArray[--n5] = (char)(48 + n4 % 10);
        } while ((n4 /= 10) > 0);
        for (n4 = n2 - 1; n4 >= 0; --n4) {
            cArray[--n5] = this.idPrefix_.charAt(n4);
        }
        return new String(cArray, n5, n3 - n5);
    }

    @Override
    public String getDocumentBaseUri() {
        return this.baseUri_;
    }

    @Override
    public boolean preserveSpace() {
        return true;
    }

    @Override
    public NodeNamePool getNodeNamePool() {
        return this.nodeNamePool_;
    }

    int getLineNumber(Node node) {
        return this.lineNumberMap_ == null ? -1 : this.lineNumberMap_.getLineNumber(node.serialNumber_);
    }

    void setLineNumberMap(LineNumberMap lineNumberMap) {
        this.lineNumberMap_ = lineNumberMap;
    }

    @Override
    public XPathRootNode getFragment(String string) {
        Node node = (Node)this.getElementForId(string);
        return node == null ? null : new RootNode(this, string, node);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void accept(NodeVisitor nodeVisitor) {
        nodeVisitor.root(this);
    }

    @Override
    public String getModelName() {
        return MODEL_NAME;
    }

    @Override
    public String toString() {
        int n = this.baseUri_.lastIndexOf(47);
        return this.toString(n == -1 ? this.baseUri_ : this.baseUri_.substring(n + 1));
    }
}

