/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.object;

import java.math.BigDecimal;
import jd.xml.xpath.object.Equality;
import jd.xml.xpath.object.XObject;
import jd.xml.xpath.object.XString;

public class XNumber
extends XObject {
    private double value_;
    private static String[] SIMPLE_NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};

    public XNumber(double d) {
        this.value_ = d;
    }

    @Override
    public Object toValue() {
        return new Double(this.value_);
    }

    @Override
    public Object toValue(Class clazz) {
        if (XObject.class.isAssignableFrom(clazz)) {
            return this;
        }
        Object object = XNumber.toNumberValue(this.value_, clazz);
        if (object != null) {
            return object;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return this.toBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz == String.class) {
            return this.toStringValue();
        }
        return null;
    }

    public static Object toNumberValue(double d, Class clazz) {
        if (clazz == Double.TYPE || clazz == Double.class || clazz == Object.class) {
            return new Double(d);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return new Integer((int)d);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float((float)d);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return new Long((long)d);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return new Short((short)d);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return new Character((char)d);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return new Byte((byte)d);
        }
        return null;
    }

    @Override
    public int canConvertTo(Class clazz) {
        if (XObject.class.isAssignableFrom(clazz)) {
            return 19;
        }
        if (clazz == Double.TYPE) {
            return 18;
        }
        if (clazz == Double.class) {
            return 17;
        }
        if (clazz == Float.TYPE) {
            return 16;
        }
        if (clazz == Float.class) {
            return 15;
        }
        if (clazz == Long.TYPE) {
            return 14;
        }
        if (clazz == Long.class) {
            return 13;
        }
        if (clazz == Integer.TYPE) {
            return 12;
        }
        if (clazz == Integer.class) {
            return 11;
        }
        if (clazz == Short.TYPE) {
            return 10;
        }
        if (clazz == Short.class) {
            return 9;
        }
        if (clazz == Character.TYPE) {
            return 8;
        }
        if (clazz == Character.class) {
            return 7;
        }
        if (clazz == Byte.TYPE) {
            return 6;
        }
        if (clazz == Byte.class) {
            return 5;
        }
        if (clazz == Boolean.TYPE) {
            return 4;
        }
        if (clazz == Boolean.class) {
            return 3;
        }
        if (clazz == String.class) {
            return 2;
        }
        if (clazz == Object.class) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean toBooleanValue() {
        return XNumber.toBooleanValue(this.value_);
    }

    public static boolean toBooleanValue(double d) {
        return d != 0.0 && !Double.isNaN(d);
    }

    @Override
    public double toNumberValue() {
        return this.value_;
    }

    @Override
    public String toStringValue() {
        return XNumber.toStringValue(this.value_);
    }

    public static String toStringValue(int n) {
        if (n >= 0 && n <= 10) {
            return SIMPLE_NUMBERS[n];
        }
        return Integer.toString(n);
    }

    public static String toStringValue(double d) {
        int n;
        int n2;
        if (!Double.isInfinite(d) && (d >= 9.007199254740992E15 || -d >= 9.007199254740992E15)) {
            return new BigDecimal(d).toString();
        }
        int n3 = (int)d;
        if ((double)n3 == d) {
            return XNumber.toStringValue(n3);
        }
        String string = Double.toString(d);
        if (string.charAt((n2 = string.length()) - 2) == '.' && string.charAt(n2 - 1) == '0') {
            return (string = string.substring(0, n2 - 2)).equals("-0") ? "0" : string;
        }
        int n4 = string.indexOf(69);
        if (n4 < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n5 = Integer.parseInt(string.substring(n4 + 1));
        if (string.charAt(0) == '-') {
            stringBuffer.append('-');
            string = string.substring(1);
            --n4;
        }
        if (n5 >= (n = n4 - 2)) {
            stringBuffer.append(string.charAt(0));
            stringBuffer.append(string.substring(2, n4));
            XNumber.appendZeros(stringBuffer, n5 - n);
        } else if (n5 > 0) {
            stringBuffer.append(string.charAt(0));
            stringBuffer.append(string.substring(2, 2 + n5));
            stringBuffer.append('.');
            stringBuffer.append(string.substring(2 + n5, n4));
        } else {
            stringBuffer.append("0.");
            XNumber.appendZeros(stringBuffer, -1 - n5);
            stringBuffer.append(string.charAt(0));
            stringBuffer.append(string.substring(2, n4));
        }
        return stringBuffer.toString();
    }

    private static void appendZeros(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('0');
        }
    }

    @Override
    public boolean compare(Equality equality, String string) {
        return equality.compare(this.value_, XString.toNumberValue(string));
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.value_);
        return (int)(l ^ l >> 32);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof XNumber)) {
            return false;
        }
        return this.value_ == ((XNumber)object).value_;
    }
}

