/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.parser;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.StringTokenizer;
import java.util.Vector;
import jd.xml.util.UriResolver;
import jd.xml.util.UriUtil;
import jd.xml.util.XmlSource;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.model.ModelReader;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xpath.object.XString;
import jd.xml.xslt.XsltContext;
import jd.xml.xslt.XsltSecurityManager;
import jd.xml.xslt.extension.ExtensionHandler;
import jd.xml.xslt.extension.JavaExtensionHandler;
import jd.xml.xslt.extension.ScriptExtensionHandler;
import jd.xml.xslt.parser.AttributeIterator;
import jd.xml.xslt.parser.AttributeSetInfo;
import jd.xml.xslt.parser.NamespaceAlias;
import jd.xml.xslt.parser.ParseListener;
import jd.xml.xslt.parser.Parser;
import jd.xml.xslt.parser.PatternParser;
import jd.xml.xslt.parser.StylesheetData;
import jd.xml.xslt.parser.TemplateParser;
import jd.xml.xslt.parser.WhitespaceTest;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.pattern.OrPattern;
import jd.xml.xslt.pattern.Pattern;
import jd.xml.xslt.pattern.RootPattern;
import jd.xml.xslt.result.pipe.Dom2ResultPipe;
import jd.xml.xslt.template.AttributeSet;
import jd.xml.xslt.template.Template;
import jd.xml.xslt.template.TemplateRule;
import jd.xml.xslt.template.TemplateRuleList;
import jd.xml.xslt.template.Variable;
import jd.xml.xslt.util.VerboseLog;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class StylesheetParser
extends Parser {
    private StylesheetData stylesheetData_;
    private TemplateParser templateParser_;
    private ModelReader modelReader_;
    private NodeNamePool nodeNamePool_;
    private UriResolver uriResolver_;
    private EntityResolver entityResolver_;
    private ParseListener parseListener_;
    private XsltSecurityManager securityManager_;
    private VerboseLog verboseLog_;
    private boolean needsContextReset_;

    public StylesheetParser() {
        this((XsltSecurityManager)null);
    }

    public StylesheetParser(XsltSecurityManager xsltSecurityManager) {
        super(new PatternParser());
        this.templateParser_ = new TemplateParser(this.patternParser_);
        this.securityManager_ = xsltSecurityManager == null ? XsltSecurityManager.getGlobalInstance() : xsltSecurityManager;
    }

    public void setUriResolver(UriResolver uriResolver) {
        this.uriResolver_ = uriResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver_ = entityResolver;
    }

    public synchronized StylesheetData parseStylesheet(XmlSource xmlSource) throws XsltParseException, IOException, SAXException {
        if (xmlSource == null) {
            throw new IllegalArgumentException("stylesheet source is null");
        }
        try {
            if (this.verboseLog_ != null) {
                this.verboseLog_.prepareTiming.startTimer();
            }
            if (this.needsContextReset_) {
                this.context_.reset();
            }
            this.context_.setDocumentBaseUri(xmlSource.getUri());
            this.stylesheetData_ = new StylesheetData();
            XPathRootNode xPathRootNode = this.initModelReader(xmlSource);
            this.context_.initXsltNamePattern(this.nodeNamePool_);
            this.context_.setDefaultCurrentTemplateRules();
            this.parse(xPathRootNode);
            this.context_.finish(this.stylesheetData_);
            if (this.verboseLog_ != null) {
                this.verboseLog_.prepareTiming.stopTimer();
            }
            StylesheetData stylesheetData = this.stylesheetData_;
            return stylesheetData;
        }
        catch (XsltParseException xsltParseException) {
            throw xsltParseException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw this.context_.createException("parsing aborted", exception);
        }
        finally {
            this.modelReader_ = null;
            this.stylesheetData_ = null;
            this.needsContextReset_ = true;
        }
    }

    private XPathRootNode initModelReader(XmlSource xmlSource) throws SAXException, IOException {
        this.modelReader_ = new ModelReader(xmlSource.getParser());
        this.modelReader_.collectLineNumbers(true);
        this.modelReader_.getParseHandler().setEntityResolver(this.entityResolver_);
        if (xmlSource.getDocument() instanceof XPathRootNode) {
            XPathRootNode xPathRootNode = (XPathRootNode)xmlSource.getDocument();
            this.nodeNamePool_ = xPathRootNode.getNodeNamePool();
            return xPathRootNode;
        }
        this.nodeNamePool_ = StylesheetParser.createNodeNamePool();
        XPathRootNode xPathRootNode = this.readDocument(xmlSource);
        this.context_.setStylesheetNamePool(xPathRootNode.getNodeNamePool());
        return xPathRootNode;
    }

    public static NodeNamePool createNodeNamePool() {
        NodeNamePool nodeNamePool = new NodeNamePool(false);
        nodeNamePool.setPreserveSpace("http://www.w3.org/1999/XSL/Transform", "text", "xsl:text", true);
        return nodeNamePool;
    }

    private XPathRootNode readDocument(XmlSource xmlSource) throws IOException, SAXException {
        XPathRootNode xPathRootNode;
        if (this.verboseLog_ != null) {
            this.verboseLog_.printMessage("read stylesheet", xmlSource.getUri());
        }
        if (xmlSource.getDocument() != null) {
            Object object = xmlSource.getDocument();
            if (!(object instanceof Node)) {
                throw new IOException("unknown document class: " + object);
            }
            xPathRootNode = Dom2ResultPipe.getRoot(xmlSource.getUri(), (Node)object, this.nodeNamePool_);
        } else {
            xPathRootNode = this.modelReader_.read(xmlSource, this.nodeNamePool_);
        }
        return xPathRootNode;
    }

    public void setParseListener(ParseListener parseListener) {
        this.parseListener_ = parseListener;
        this.templateParser_.setParseListener(parseListener);
        this.patternParser_.setParseListener(parseListener);
    }

    public void setVerboseLog(VerboseLog verboseLog) {
        this.verboseLog_ = verboseLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(XPathRootNode xPathRootNode) throws Exception {
        try {
            XPathNode xPathNode;
            if (this.parseListener_ != null) {
                this.parseListener_.startParseStylesheet(this.context_, xPathRootNode);
            }
            for (xPathNode = xPathRootNode.getFirstChild(); xPathNode != null && xPathNode.getType() != 0; xPathNode = xPathNode.getNextSibling()) {
            }
            if (xPathNode == null) {
                throw this.context_.createException("no document element found", xPathRootNode);
            }
            NamespaceContext namespaceContext = xPathNode.getNamespaceContext();
            boolean bl = false;
            boolean bl2 = false;
            if (namespaceContext != null) {
                bl = true;
                boolean bl3 = bl2 = namespaceContext.getPrefix("http://www.w3.org/1999/XSL/Transform") != null;
            }
            if (!bl2) {
                String string;
                if (!bl && xPathNode.getNamespaceUri() != null) {
                    Class<?> clazz = this.modelReader_.getParseHandler().getParser().getClass();
                    string = "The Parser '" + clazz.getName() + "' does not report namespace declarations as attributes";
                } else {
                    string = "the input does not seem to be a stylesheet (the document element does not declare the xslt namespace)";
                }
                throw this.context_.createException(string, xPathNode);
            }
            if (this.isStylesheetElement(xPathNode) && (xPathNode.getLocalName().equals("stylesheet") || xPathNode.getLocalName().equals("transform"))) {
                AttributeIterator attributeIterator = this.setCurrentElement(xPathNode);
                this.parseStylesheetAttributes(attributeIterator, false);
                this.parseTopLevelElements(xPathNode);
            } else {
                this.parseSimplified(xPathNode);
            }
            if (this.parseListener_ != null) {
                this.parseListener_.endParseStylesheet(this.context_, xPathRootNode);
            }
        }
        finally {
            xPathRootNode.cleanup();
        }
    }

    private void parseSimplified(XPathNode xPathNode) throws XsltParseException {
        Object object;
        this.context_.setCurrentElement(xPathNode);
        Vector<Object> vector = new Vector<Object>();
        XPathNode[] xPathNodeArray = xPathNode.getAttributes();
        if (xPathNodeArray != null) {
            for (int i = xPathNodeArray.length - 1; i >= 0; --i) {
                object = xPathNodeArray[i];
                if (!this.context_.isStylesheetNode((XPathNode)object)) continue;
                vector.addElement(object);
            }
        }
        Object[] objectArray = new XPathNode[vector.size()];
        vector.copyInto(objectArray);
        object = new AttributeIterator(this.patternParser_, this.context_, (XPathNode[])objectArray, true);
        this.parseStylesheetAttributes((AttributeIterator)object, true);
        Template template = this.templateParser_.parse(xPathNode);
        Pattern pattern = RootPattern.INSTANCE;
        if (this.parseListener_ != null) {
            pattern = this.parseListener_.patternParsed(this.context_, pattern, pattern.toString());
        }
        TemplateRule templateRule = new TemplateRule(this.context_.getImportPrecedence(), 0.5, 0, template, null, this.context_.hasLocalVariables(), pattern, pattern, null);
        if (this.parseListener_ != null) {
            templateRule = this.parseListener_.templateRuleParsed(this.context_, templateRule);
        }
        this.context_.getRuleList(null).addTemplateRule(templateRule);
    }

    private void parseStylesheetAttributes(AttributeIterator attributeIterator, boolean bl) throws XsltParseException {
        String string = null;
        String string2 = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("version")) {
                string = attributeIterator.getValue();
                continue;
            }
            if (attributeIterator.match("id")) {
                string2 = attributeIterator.getValue();
                continue;
            }
            if (attributeIterator.match("extension-element-prefixes")) {
                this.parseExtensionElementPrefixes(attributeIterator.getAttribute());
                continue;
            }
            if (attributeIterator.match("exclude-result-prefixes")) {
                this.parseExcludeResultPrefixes(attributeIterator.getAttribute());
                continue;
            }
            if (bl) continue;
            attributeIterator.reportInvalidAttribute();
        }
        if (string == null) {
            this.reportMissingAttribute("version");
        }
        this.context_.setVersion(string);
    }

    private void parseTopLevelElements(XPathNode xPathNode) throws Exception {
        Object object;
        XPathNode xPathNode2;
        for (xPathNode2 = xPathNode.getFirstChild(); xPathNode2 != null; xPathNode2 = xPathNode2.getNextSibling()) {
            if (!this.isStylesheetElement(xPathNode2)) continue;
            if (!xPathNode2.getLocalName().equals("import")) break;
            object = this.setCurrentElement(xPathNode2);
            this.parseImport(xPathNode2, (AttributeIterator)object);
        }
        object = xPathNode2;
        this.parseNamespaceAlias((XPathNode)object);
        for (xPathNode2 = object; xPathNode2 != null; xPathNode2 = xPathNode2.getNextSibling()) {
            if (this.isStylesheetElement(xPathNode2)) {
                XPathNode xPathNode3 = xPathNode2;
                String string = xPathNode3.getLocalName();
                AttributeIterator attributeIterator = this.setCurrentElement(xPathNode3);
                if (string.equals("template")) {
                    this.parseTemplateRule(xPathNode3, attributeIterator);
                    continue;
                }
                if (string.equals("variable")) {
                    this.parseVariable(xPathNode3, attributeIterator, 0);
                    continue;
                }
                if (string.equals("param")) {
                    this.parseVariable(xPathNode3, attributeIterator, 1);
                    continue;
                }
                if (string.equals("output")) {
                    this.templateParser_.parseOutputFormat(attributeIterator, this.stylesheetData_.getOutputFormatTemplate(), true);
                    continue;
                }
                if (string.equals("include")) {
                    this.parseInclude(xPathNode3, attributeIterator);
                    continue;
                }
                if (string.equals("strip-space")) {
                    this.parseStripSpace(xPathNode3, attributeIterator);
                    continue;
                }
                if (string.equals("preserve-space")) {
                    this.parsePreserveSpace(xPathNode3, attributeIterator);
                    continue;
                }
                if (string.equals("key")) {
                    this.parseKey(xPathNode3, attributeIterator);
                    continue;
                }
                if (string.equals("decimal-format")) {
                    this.parseDecimalFormat(xPathNode3, attributeIterator);
                    continue;
                }
                if (string.equals("namespace-alias")) continue;
                if (string.equals("attribute-set")) {
                    this.parseAttributeSet(xPathNode2, attributeIterator);
                    continue;
                }
                if (string.equals("script")) {
                    this.parseScript(xPathNode3, attributeIterator);
                    continue;
                }
                if (string.equals("import")) {
                    this.throwException("import elements must precede all other top-level elements");
                    continue;
                }
                if (this.context_.processForwardsCompatible()) continue;
                this.throwException("unknown top level element type " + xPathNode3.getName());
                continue;
            }
            if (xPathNode2.getType() != 0 || xPathNode2.getNamespaceUri() != null) continue;
            throw this.context_.createException("element has no namespace URI", xPathNode2);
        }
    }

    private void parseVariable(XPathNode xPathNode, AttributeIterator attributeIterator, int n) throws XsltParseException {
        Variable variable = this.templateParser_.parseVariable(xPathNode, n, attributeIterator, true);
        this.context_.addGlobalVariable(variable);
    }

    private void parseTemplateRule(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        Pattern pattern = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("match")) {
                pattern = attributeIterator.getPattern();
                continue;
            }
            if (attributeIterator.match("priority")) {
                string2 = attributeIterator.getValue();
                continue;
            }
            if (attributeIterator.match("name")) {
                string3 = attributeIterator.getExpandedName();
                continue;
            }
            if (attributeIterator.match("mode")) {
                string = attributeIterator.getExpandedName();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (pattern == null) {
            if (string3 == null) {
                this.throwException("match or name attribute must be set");
            }
            if (string != null) {
                this.throwException("mode attribute requires match attribute");
            }
        }
        double d = 0.0;
        if (string2 != null) {
            d = XString.toNumberValue(string2);
        }
        int n = 0;
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        while (xPathNode2 != null && this.isStylesheetElement(xPathNode2, "param")) {
            ++n;
            xPathNode2 = this.getNextStylesheetSibling(xPathNode2);
        }
        TemplateRuleList templateRuleList = this.context_.getRuleList(string);
        this.context_.setCurrentTemplateRules(templateRuleList);
        this.context_.startParseTemplate(string3, n);
        Vector vector = null;
        xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        while (xPathNode2 != null && this.isStylesheetElement(xPathNode2, "param")) {
            vector = this.templateParser_.parseVariable(xPathNode2, 1, vector);
            xPathNode2 = this.getNextStylesheetSibling(xPathNode2);
        }
        Template template = this.templateParser_.parse(xPathNode2);
        Variable[] variableArray = this.templateParser_.getVariableArray(vector);
        if (variableArray != null) {
            for (int i = 0; i < variableArray.length; ++i) {
                int n2 = variableArray[i].getVariableName().getIndex();
                if (i == n2) continue;
                this.throwException("internal error: " + variableArray[i].getVariableName() + " has wrong variable index " + n2 + ", expected " + i);
            }
            this.context_.templateParametersParsed(variableArray);
        }
        if (string3 != null) {
            TemplateRule templateRule = new TemplateRule(this.context_.getImportPrecedence(), d, this.context_.getNextTemplateRuleIndex(), template, variableArray, this.context_.hasLocalVariables(), string3);
            if (this.parseListener_ != null) {
                templateRule = this.parseListener_.templateRuleParsed(this.context_, templateRule);
            }
            this.context_.addNamedTemplateRule(string3, templateRule);
        }
        if (pattern != null) {
            this.addTemplateRule(pattern, pattern, template, variableArray, d, string2 == null, templateRuleList);
        }
        this.context_.endParseTemplate();
        this.context_.setDefaultCurrentTemplateRules();
    }

    private void addTemplateRule(Pattern pattern, Pattern pattern2, Template template, Variable[] variableArray, double d, boolean bl, TemplateRuleList templateRuleList) {
        if (pattern instanceof OrPattern) {
            Pattern[] patternArray = ((OrPattern)pattern).getPatterns();
            for (int i = 0; i < patternArray.length; ++i) {
                this.addTemplateRule(patternArray[i], pattern, template, variableArray, d, bl, templateRuleList);
            }
        } else {
            TemplateRule templateRule = new TemplateRule(this.context_.getImportPrecedence(), bl ? pattern.calculatePriority() : d, this.context_.getNextTemplateRuleIndex(), template, variableArray, this.context_.hasLocalVariables(), pattern, pattern2, templateRuleList.getMode());
            if (this.parseListener_ != null) {
                templateRule = this.parseListener_.templateRuleParsed(this.context_, templateRule);
            }
            templateRuleList.addTemplateRule(templateRule);
        }
    }

    private void parseInclude(XPathNode xPathNode, AttributeIterator attributeIterator) throws Exception {
        this.parseInclusion(xPathNode, attributeIterator);
    }

    private void parseImport(XPathNode xPathNode, AttributeIterator attributeIterator) throws Exception {
        this.parseInclusion(xPathNode, attributeIterator);
        this.context_.increaseImportPrecedence();
    }

    private void parseInclusion(XPathNode xPathNode, AttributeIterator attributeIterator) throws Exception {
        XPathRootNode xPathRootNode;
        String string = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("href")) {
                string = attributeIterator.getValue();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (string == null) {
            this.reportMissingAttribute("href");
        }
        XmlSource xmlSource = null;
        try {
            xmlSource = UriUtil.resolveUri(string, this.context_.getBaseUri(), this.uriResolver_);
            xPathRootNode = this.readDocument(xmlSource);
        }
        catch (Exception exception) {
            String string2 = "cannot include '" + string + "'";
            if (xmlSource != null) {
                string2 = string2 + "(tried uri " + xmlSource.getUri() + ")";
            }
            throw this.context_.createException(string2, exception);
        }
        finally {
            if (xmlSource != null) {
                xmlSource.cleanup();
            }
        }
        this.context_.beginInclude(xmlSource.getUri());
        this.parse(xPathRootNode);
        this.context_.endInclude();
    }

    private void parseKey(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        String string = null;
        Pattern pattern = null;
        Expression expression = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("name")) {
                string = attributeIterator.getExpandedName();
                continue;
            }
            if (attributeIterator.match("match")) {
                pattern = attributeIterator.getPattern();
                continue;
            }
            if (attributeIterator.match("use")) {
                expression = attributeIterator.getExpression();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (string == null) {
            this.reportMissingAttribute("name");
        }
        if (pattern == null) {
            this.reportMissingAttribute("match");
        }
        if (expression == null) {
            this.reportMissingAttribute("use");
        }
        this.context_.addKey(string, pattern, expression);
    }

    private void parseDecimalFormat(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        DecimalFormatSymbols decimalFormatSymbols = XsltContext.createDefaultSymbols();
        String string = "";
        XPathNode xPathNode2 = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("name")) {
                xPathNode2 = attributeIterator.getAttribute();
                string = attributeIterator.getExpandedName();
                continue;
            }
            if (attributeIterator.match("decimal-separator")) {
                decimalFormatSymbols.setDecimalSeparator(attributeIterator.getChar());
                continue;
            }
            if (attributeIterator.match("grouping-separator")) {
                decimalFormatSymbols.setGroupingSeparator(attributeIterator.getChar());
                continue;
            }
            if (attributeIterator.match("percent")) {
                decimalFormatSymbols.setPercent(attributeIterator.getChar());
                continue;
            }
            if (attributeIterator.match("per-mille")) {
                decimalFormatSymbols.setPerMill(attributeIterator.getChar());
                continue;
            }
            if (attributeIterator.match("zero-digit")) {
                decimalFormatSymbols.setZeroDigit(attributeIterator.getChar());
                continue;
            }
            if (attributeIterator.match("digit")) {
                decimalFormatSymbols.setDigit(attributeIterator.getChar());
                continue;
            }
            if (attributeIterator.match("pattern-separator")) {
                decimalFormatSymbols.setPatternSeparator(attributeIterator.getChar());
                continue;
            }
            if (attributeIterator.match("infinity")) {
                decimalFormatSymbols.setInfinity(attributeIterator.getValue());
                continue;
            }
            if (attributeIterator.match("NaN")) {
                decimalFormatSymbols.setNaN(attributeIterator.getValue());
                continue;
            }
            if (attributeIterator.match("minus-sign")) {
                decimalFormatSymbols.setMinusSign(attributeIterator.getChar());
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (!this.stylesheetData_.addDecimalFormatSymbols(string, decimalFormatSymbols)) {
            throw this.context_.createException("decimal format already declared", xPathNode2);
        }
    }

    private void parseNamespaceAlias(XPathNode xPathNode) throws XsltParseException {
        NamespaceAlias namespaceAlias = null;
        while (xPathNode != null) {
            if (this.isStylesheetElement(xPathNode, "namespace-alias")) {
                namespaceAlias = this.parseNamespaceAlias(xPathNode, namespaceAlias);
            }
            xPathNode = xPathNode.getNextSibling();
        }
        while (namespaceAlias != null) {
            for (NamespaceContext namespaceContext = this.context_.getResultNamespaceContext(); namespaceContext != null; namespaceContext = namespaceContext.next()) {
                if (!namespaceContext.getUri().equals(namespaceAlias.getStylesheetUri())) continue;
                namespaceContext.setUri(namespaceAlias.getResultUri());
                break;
            }
            namespaceAlias = namespaceAlias.next();
        }
    }

    private NamespaceAlias parseNamespaceAlias(XPathNode xPathNode, NamespaceAlias namespaceAlias) throws XsltParseException {
        AttributeIterator attributeIterator = this.setCurrentElement(xPathNode);
        String string = null;
        String string2 = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("stylesheet-prefix")) {
                string = this.parseNamespacePrefix(attributeIterator.getValue());
                continue;
            }
            if (attributeIterator.match("result-prefix")) {
                string2 = this.parseNamespacePrefix(attributeIterator.getValue());
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (string == null) {
            this.reportMissingAttribute("stylesheet-prefix");
        }
        if (string2 == null) {
            this.reportMissingAttribute("result-prefix");
        }
        String string3 = this.context_.getCheckedNamespaceUri(string);
        String string4 = this.context_.getCheckedNamespaceUri(string2);
        return NamespaceAlias.addAlias(string3, string4, namespaceAlias);
    }

    private void parseAttributeSet(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        String string = null;
        String[] stringArray = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("name")) {
                string = attributeIterator.getExpandedName();
                continue;
            }
            if (attributeIterator.match("use-attribute-sets")) {
                stringArray = attributeIterator.getExpandedNames();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (string == null) {
            this.reportMissingAttribute("name");
        }
        AttributeSetInfo attributeSetInfo = this.context_.getAttributeSetInfo(string);
        attributeSetInfo.hasDefinition = true;
        if (stringArray != null) {
            attributeSetInfo.useAttributeSets(stringArray);
        }
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        while (xPathNode2 != null) {
            if (this.isStylesheetElement(xPathNode2, "attribute")) {
                AttributeIterator attributeIterator2 = this.setCurrentElement(xPathNode2);
                attributeSetInfo.attributeSet.add(this.templateParser_.parseAttribute(xPathNode2, attributeIterator2));
            } else {
                this.reportInvalidChild(xPathNode2, true);
            }
            xPathNode2 = this.getNextStylesheetSibling(xPathNode2);
        }
    }

    private void parsePreserveSpace(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        this.parseWhitespaceNameTests(attributeIterator, true);
    }

    private void parseScript(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("implements-prefix")) {
                string = this.context_.getCheckedNamespaceUri(attributeIterator.getValue());
                continue;
            }
            if (attributeIterator.match("language")) {
                string2 = attributeIterator.getValue();
                continue;
            }
            if (attributeIterator.match("src")) {
                string3 = attributeIterator.getValue();
                continue;
            }
            if (attributeIterator.match("archive")) {
                string4 = attributeIterator.getValue();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (string == null) {
            this.reportMissingAttribute("implements-prefix");
        }
        if (string2 == null) {
            this.reportMissingAttribute("language");
        }
        String string5 = null;
        XPathNode xPathNode2 = this.getFirstStylesheetChild(xPathNode);
        if (xPathNode2 != null) {
            string5 = xPathNode2.getValue();
        }
        if (this.securityManager_ != null) {
            this.securityManager_.checkExecuteScript(this.context_.getBaseUri(), string2, string3, string5);
        }
        if (string2.equals("java")) {
            this.createJavaExtensionHandler(string, string3, string5);
        } else {
            this.createScriptExtensionHandler(string, string2, string3, string5);
        }
    }

    private void createJavaExtensionHandler(String string, String string2, String string3) throws XsltParseException {
        if (string3 != null) {
            this.throwException("inline java extension not supported");
        }
        if (string2 == null) {
            this.reportMissingAttribute("src");
        }
        Class<?> clazz = null;
        if (string2.startsWith("java:")) {
            string2 = string2.substring(5);
        }
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string4 = "cannot load extension function class '" + string2 + "' (please check if it is included in the class path)";
            throw this.context_.createException(string4, classNotFoundException);
        }
        JavaExtensionHandler javaExtensionHandler = new JavaExtensionHandler(string, clazz);
        this.stylesheetData_.addExtensionHandler(javaExtensionHandler);
    }

    private void createScriptExtensionHandler(String string, String string2, String string3, String string4) throws XsltParseException {
        Object object;
        if (string3 == null && string4 == null) {
            this.reportMissingAttribute("source");
        }
        if (string3 != null && string4 != null) {
            this.throwException("source reference with inline definition not allowed");
        }
        if (string2.equals("ecmascript")) {
            string2 = "javascript";
        }
        String string5 = string4;
        if (string3 != null) {
            object = null;
            try {
                object = UriUtil.resolveUri(string3, this.context_.getBaseUri(), this.uriResolver_);
                string5 = ((XmlSource)object).getDocumentContent();
            }
            catch (IOException iOException) {
                throw this.context_.createException("cannot read script source '" + string3 + "'", iOException);
            }
            finally {
                if (object != null) {
                    ((XmlSource)object).cleanup();
                }
            }
        }
        object = null;
        ExtensionHandler extensionHandler = this.stylesheetData_.getExtensionHandler(string);
        if (extensionHandler != null) {
            boolean bl = false;
            if (extensionHandler instanceof ScriptExtensionHandler && ((ScriptExtensionHandler)(object = (ScriptExtensionHandler)extensionHandler)).getLanguage().equals(string2)) {
                bl = true;
            }
            if (!bl) {
                this.throwException("extension namespace '" + string + "' used by different script extensions");
            }
        } else {
            object = new ScriptExtensionHandler(string, string2);
            this.stylesheetData_.addExtensionHandler((ExtensionHandler)object);
        }
        try {
            ((ScriptExtensionHandler)object).addScript(string5);
        }
        catch (Exception exception) {
            String string6 = "cannot create script (please check if the library bsf.jar of the beans scripting framework and additional libraries are included in the class path)";
            throw this.context_.createException(string6, exception);
        }
    }

    private void parseStripSpace(XPathNode xPathNode, AttributeIterator attributeIterator) throws XsltParseException {
        this.parseWhitespaceNameTests(attributeIterator, false);
    }

    private void parseWhitespaceNameTests(AttributeIterator attributeIterator, boolean bl) throws XsltParseException {
        String string = null;
        while (attributeIterator.next()) {
            if (attributeIterator.match("elements")) {
                string = attributeIterator.getValue();
                continue;
            }
            attributeIterator.reportInvalidAttribute();
        }
        if (string == null) {
            this.reportMissingAttribute("elements");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            WhitespaceTest whitespaceTest = WhitespaceTest.parse(this.context_, string2, bl);
            this.context_.addWhitespaceTest(whitespaceTest);
        }
    }

    private static class SetLink {
        AttributeSet set;
        String[] linkedSets;
        boolean isNewSet;

        private SetLink() {
        }
    }
}

