/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.trax;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Transformation;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.trax.TraxUtil;

public class TransformerImpl
extends Transformer {
    private Transformation transformation_;
    private Hashtable parameters_;
    private URIResolver uriResolver_;
    private ErrorListener errorListener_;
    private Properties cachedOutputProperties_;
    private static Properties defaultXmlProperties_;
    private static Properties defaultHtmlProperties_;
    private static Properties defaultTextProperties_;

    public TransformerImpl(Transformation transformation) {
        this.transformation_ = transformation;
    }

    public Transformation getTransformation() {
        return this.transformation_;
    }

    @Override
    public void transform(Source source, Result result) throws TransformerException {
        try {
            XmlSource xmlSource = TraxUtil.getXmlSource(source);
            XsltResult xsltResult = TraxUtil.getXsltResult(result);
            this.transformation_.transform(xmlSource, xsltResult);
        }
        catch (TransformerException transformerException) {
            throw transformerException;
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }

    @Override
    public void clearParameters() {
        if (this.parameters_ != null) {
            this.parameters_.clear();
        }
        this.transformation_.clearParameters();
    }

    @Override
    public void setParameter(String string, Object object) {
        string = TraxUtil.convertQualifiedName(string);
        if (this.parameters_ == null) {
            this.parameters_ = new Hashtable(10);
        }
        if (object != null) {
            this.parameters_.put(string, object);
        } else {
            this.parameters_.remove(string);
        }
        this.transformation_.setParameter(string, object);
    }

    @Override
    public Object getParameter(String string) {
        return this.parameters_ == null ? null : this.parameters_.get(TraxUtil.convertQualifiedName(string));
    }

    @Override
    public URIResolver getURIResolver() {
        return this.uriResolver_;
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver_ = uRIResolver;
        this.transformation_.setUriResolver(TraxUtil.getUriResolver(uRIResolver));
    }

    @Override
    public String getOutputProperty(String string) {
        if (this.cachedOutputProperties_ == null) {
            this.cachedOutputProperties_ = this.getOutputProperties();
        }
        return this.cachedOutputProperties_.getProperty(string);
    }

    @Override
    public Properties getOutputProperties() {
        OutputFormat outputFormat = this.transformation_.getOutputFormat();
        Properties properties = this.getDefaultOutputProperties(outputFormat.getMethod());
        Properties properties2 = new Properties(properties);
        for (int i = 0; i < 9; ++i) {
            String string = outputFormat.getOption(i);
            if (string == null) continue;
            properties2.put(OutputFormat.getOptionName(i), string);
        }
        return properties2;
    }

    private Properties getDefaultOutputProperties(String string) {
        if (string == "text") {
            if (defaultTextProperties_ == null) {
                defaultTextProperties_ = new Properties();
                defaultTextProperties_.put("method", "text");
                defaultTextProperties_.put("media-type", "text/plain");
            }
            return defaultTextProperties_;
        }
        if (string == "html") {
            if (defaultHtmlProperties_ == null) {
                defaultHtmlProperties_ = new Properties();
                defaultHtmlProperties_.put("method", "html");
                defaultHtmlProperties_.put("media-type", "text/html");
                defaultHtmlProperties_.put("indent", "yes");
                defaultHtmlProperties_.put("version", "4.0");
            }
            return defaultHtmlProperties_;
        }
        if (defaultXmlProperties_ == null) {
            defaultXmlProperties_ = new Properties();
            defaultXmlProperties_.put("method", "xml");
            defaultXmlProperties_.put("media-type", "text/xml");
            defaultXmlProperties_.put("version", "1.0");
            defaultXmlProperties_.put("encoding", "UTF-8");
            defaultXmlProperties_.put("indent", "no");
            defaultXmlProperties_.put("omit-xml-declaration", "no");
            defaultXmlProperties_.put("standalone", "no");
        }
        return defaultXmlProperties_;
    }

    @Override
    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.setOutputProperty(string, string2);
        }
    }

    @Override
    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.cachedOutputProperties_ = null;
        this.transformation_.getOutputFormat().setOption(string, string2);
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.errorListener_ = errorListener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.errorListener_;
    }
}

